/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import java.io.IOException;
import java.util.Properties;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.game.control.handler.physic.Physic;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShootableWithWarheadObject;

public class PhysicHandler
implements GameControlHandler {
    private static final String OBJECT_PHYSICS = "/properties/objectPhysics.properties";
    private Properties objectPhysics = new Properties();

    public PhysicHandler() {
        try {
            this.objectPhysics.load(this.getClass().getResourceAsStream(OBJECT_PHYSICS));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading '/properties/objectPhysics.properties'", e);
        }
    }

    public void update(GameControlImpl gameControl, long elapsedTime) {
        this.updateObject(gameControl.getPlayer(), gameControl, elapsedTime);
        for (Sprite sprite : gameControl.getProjectilesSpriteGroup().getSprites()) {
            if (!(sprite instanceof ShootableWithWarheadObject)) continue;
            this.updateObject((MoaggGameObject)sprite, gameControl, elapsedTime);
        }
    }

    protected void updateObject(MoaggGameObject object, GameControlImpl gameControl, long elapsedTime) {
        if (!((Sprite)object).isActive()) {
            return;
        }
        try {
            Class<?> physicClass = Class.forName(this.objectPhysics.getProperty(object.getClass().getName()));
            Physic physic = (Physic)physicClass.newInstance();
            physic.update(object, gameControl, elapsedTime);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Physic for '" + object.getClass().getName() + "'", e);
        }
    }
}

