/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.ControllableObject;
import moagg.model.object.LandableObject;
import moagg.util.math.AngleUtil;

public class UpdateAngleHandler
implements GameControlHandler {
    public void update(GameControlImpl gameControl, long elapsedTime) {
        this.updateAngle(gameControl.getPlayer(), elapsedTime);
        for (Sprite sprite : gameControl.getProjectilesSpriteGroup().getSprites()) {
            if (!(sprite instanceof ControllableObject)) continue;
            this.updateAngle((ControllableObject)sprite, elapsedTime);
        }
    }

    protected void updateAngle(ControllableObject object, long elapsedTime) {
        if (!((Sprite)object).isActive()) {
            return;
        }
        if (object instanceof LandableObject && ((LandableObject)((Object)object)).isLanded()) {
            return;
        }
        double angle = object.getAngle();
        double increment = object.getRotationSpeed() * (double)elapsedTime;
        switch (object.getRotation()) {
            case LEFT: {
                angle += increment;
                break;
            }
            case RIGHT: {
                angle -= increment;
                break;
            }
            case ALIGN: {
                if (!object.isAligned()) {
                    if (angle < 180.0) {
                        angle += increment;
                        break;
                    }
                    if (!(angle > 180.0)) break;
                    angle -= increment;
                    break;
                }
                angle = 180.0;
                break;
            }
        }
        object.setAngle(AngleUtil.normalize(angle));
    }
}

