/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import java.io.IOException;
import java.util.Properties;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.ShootableWithWarheadObject;
import moagg.model.warhead.Warhead;

public class WarheadHandler
implements GameControlHandler {
    private static final String WARHEAD_HANDLERS = "/properties/warheadHandlers.properties";
    private Properties warheadHandlers = new Properties();

    public WarheadHandler() {
        try {
            this.warheadHandlers.load(this.getClass().getResourceAsStream(WARHEAD_HANDLERS));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading '/properties/warheadHandlers.properties'", e);
        }
    }

    public void update(GameControlImpl gameControl, long elapsedTime) {
        for (Sprite sprite : gameControl.getProjectilesSpriteGroup().getSprites()) {
            if (!(sprite instanceof ShootableWithWarheadObject)) continue;
            this.updateObject((ShootableWithWarheadObject)sprite, gameControl, elapsedTime);
        }
    }

    protected void updateObject(ShootableWithWarheadObject object, GameControlImpl gameControl, long elapsedTime) {
        if (!((Sprite)object).isActive()) {
            return;
        }
        Warhead warhead = object.getWarhead();
        moagg.game.control.warhead.WarheadHandler warheadHandler = this.getWarheadHandler(warhead);
        warheadHandler.update(warhead, gameControl, elapsedTime);
    }

    protected moagg.game.control.warhead.WarheadHandler getWarheadHandler(Warhead warhead) {
        try {
            Class<?> factoryClass = Class.forName(this.warheadHandlers.getProperty(warhead.getClass().getName()));
            return (moagg.game.control.warhead.WarheadHandler)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating WarheadHandler for '" + warhead.getClass().getName() + "'", e);
        }
    }
}

