/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler.explosion;

import moagg.game.control.GameControl;
import moagg.game.control.handler.explosion.Explosion;
import moagg.model.object.DestroyableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.OrientationObject;
import moagg.model.object.sprite.Particle;
import moagg.types.Orientation;
import moagg.types.math.Vector;
import moagg.util.RandomTool;

public class OrientationExplosionImpl
implements Explosion {
    private static int NUMBER_OF_PARTICLES = 64;
    public static final double PARTICLE_SPEED = 0.08;
    public static final int PARTICLE_LIFETIME = 600;
    public static final int PARTICLE_LIFETIME_FUZZ = 400;

    public void update(DestroyableObject destroyable, GameControl gameControl) {
        for (int i = 0; i < NUMBER_OF_PARTICLES; ++i) {
            Particle particle = this.createExplosionParticle(destroyable, ((OrientationObject)((Object)destroyable)).getOrientation());
            gameControl.addParticle(particle);
        }
    }

    protected Particle createExplosionParticle(MoaggGameObject object, Orientation orientation) {
        int x = (int)object.getX() + object.getWidth() / 2;
        int y = (int)object.getY() + object.getHeight() / 2;
        int r = object.getHeight() / 3;
        Vector offset = Vector.exp((double)r * Math.random(), Math.random() * 360.0);
        Particle particle = new Particle();
        particle.setGradient(true);
        particle.setX((double)x + offset.getX());
        particle.setY((double)y + offset.getY());
        double vx = Math.random() * 0.08;
        double vy = Math.random() * 0.08;
        double vo = Math.random() * 0.08 / 2.0;
        switch (orientation) {
            case BOTTOM: {
                vy *= -1.0;
            }
            case TOP: {
                vx -= vo;
                break;
            }
            case RIGHT: {
                vx *= -1.0;
            }
            case LEFT: {
                vy -= vo;
            }
        }
        particle.setSpeed(Vector.add(object.getSpeed(), new Vector(vx, vy)));
        particle.setLifeTime(RandomTool.getRandom(600, 400));
        return particle;
    }
}

