/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler.explosion;

import moagg.game.control.GameControl;
import moagg.game.control.handler.explosion.Explosion;
import moagg.model.object.DestroyableObject;
import moagg.model.object.sprite.GhostShip;
import moagg.model.object.sprite.Particle;
import moagg.model.object.sprite.Ship;
import moagg.types.math.Vector;
import moagg.util.RandomTool;

public class ShipExplosionImpl
implements Explosion {
    private static int NUMBER_OF_PARTICLES = 128;
    public static final double PARTICLE_SPEED = 0.03;
    public static final double PARTICLE_SPEED_FUZZ = 0.03;
    public static final int PARTICLE_LIFETIME = 1000;
    public static final int PARTICLE_LIFETIME_FUZZ = 200;

    public void update(DestroyableObject destroyable, GameControl gameControl) {
        Ship ship = (Ship)destroyable;
        boolean ghost = ship instanceof GhostShip;
        for (int i = 0; i < NUMBER_OF_PARTICLES; ++i) {
            Particle particle = this.createExplosionParticle(ship);
            particle.setGhost(ghost);
            gameControl.addParticle(particle);
        }
    }

    protected Particle createExplosionParticle(Ship ship) {
        int x = (int)ship.getX() + ship.getWidth() / 2;
        int y = (int)ship.getY() + ship.getHeight() / 2;
        int r = ship.getHeight() / 3;
        Vector offset = Vector.exp((double)r * Math.random(), Math.random() * 360.0);
        Particle particle = new Particle();
        particle.setGradient(true);
        particle.setX((double)x + offset.getX());
        particle.setY((double)y + offset.getY());
        offset = Vector.exp(RandomTool.getRandom(0.03, 0.03), Math.random() * 360.0);
        particle.setSpeed(Vector.add(ship.getSpeed(), offset));
        particle.setLifeTime(RandomTool.getRandom(1000, 200));
        return particle;
    }
}

