/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler.explosion;

import moagg.game.control.GameControl;
import moagg.game.control.handler.explosion.Explosion;
import moagg.model.object.DestroyableObject;
import moagg.model.object.sprite.Particle;
import moagg.model.object.sprite.Tank;
import moagg.util.RandomTool;

public class TankExplosionImpl
implements Explosion {
    private static int NUMBER_OF_PARTICLES = 128;
    public static final double PARTICLE_SPEED = 0.08;
    public static final int PARTICLE_LIFETIME = 600;
    public static final int PARTICLE_LIFETIME_FUZZ = 400;

    public void update(DestroyableObject destroyable, GameControl gameControl) {
        Tank tank = (Tank)destroyable;
        for (int i = 0; i < NUMBER_OF_PARTICLES; ++i) {
            Particle particle = this.createExplosionParticle(tank);
            gameControl.addParticle(particle);
        }
    }

    protected Particle createExplosionParticle(Tank tank) {
        int x = (int)tank.getX() + tank.getWidth() / 2;
        int y = (int)tank.getY() + tank.getHeight() / 2;
        int xo = (int)((Math.random() - 0.5) * (double)tank.getWidth());
        int yo = (int)((Math.random() - 0.5) * (double)tank.getHeight());
        Particle particle = new Particle();
        particle.setGradient(true);
        particle.setX(x + xo);
        particle.setY(y + yo);
        particle.setSpeed((Math.random() - 0.5) * 0.08, -Math.random() * 0.08);
        particle.setLifeTime(RandomTool.getRandom(600, 400));
        return particle;
    }
}

