/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler.explosion;

import moagg.game.control.GameControl;
import moagg.game.control.handler.explosion.Explosion;
import moagg.model.object.DestroyableObject;
import moagg.model.object.sprite.DestroyableTile;
import moagg.model.object.sprite.Particle;
import moagg.types.math.Vector;
import moagg.util.RandomTool;

public class TileExplosionImpl
implements Explosion {
    private static int NUMBER_OF_PARTICLES = 64;
    public static final double PARTICLE_SPEED = 0.03;
    public static final double PARTICLE_SPEED_FUZZ = 0.03;
    public static final int PARTICLE_LIFETIME = 1000;
    public static final int PARTICLE_LIFETIME_FUZZ = 200;

    public void update(DestroyableObject destroyable, GameControl gameControl) {
        DestroyableTile tile = (DestroyableTile)destroyable;
        for (int i = 0; i < NUMBER_OF_PARTICLES; ++i) {
            Particle particle = this.createExplosionParticle(tile);
            gameControl.addParticle(particle);
        }
    }

    protected Particle createExplosionParticle(DestroyableTile tile) {
        int x = (int)tile.getX() + tile.getWidth() / 2;
        int y = (int)tile.getY() + tile.getHeight() / 2;
        int r = tile.getHeight() / 3;
        Vector offset = Vector.exp((double)r * Math.random(), Math.random() * 360.0);
        Particle particle = new Particle();
        particle.setGradient(true);
        particle.setX((double)x + offset.getX());
        particle.setY((double)y + offset.getY());
        offset = Vector.exp(RandomTool.getRandom(0.03, 0.03), Math.random() * 360.0);
        particle.setSpeed(Vector.add(tile.getSpeed(), offset));
        particle.setLifeTime(RandomTool.getRandom(1000, 200));
        return particle;
    }
}

