/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler.physic;

import moagg.game.control.GameControl;
import moagg.game.control.handler.physic.AbstractPhysicImpl;
import moagg.model.object.ControllableObject;
import moagg.model.object.MoaggGameObject;
import moagg.prefs.player.PlayerPrefs;
import moagg.types.math.Vector;

public class ComplexPhysicImpl
extends AbstractPhysicImpl {
    private PlayerPrefs prefs = PlayerPrefs.getInstance();

    public void update(MoaggGameObject object, GameControl gameControl, long elapsedTime) {
        double elapsed = this.prefs.getDifficulty().getStretchFactor() * (double)elapsedTime;
        double friction = gameControl.getFrictionFor(object);
        if (friction == 0.0) {
            this.updateWithoutFriction(object, gameControl, elapsedTime);
            return;
        }
        friction *= (double)(object.getWidth() * object.getHeight());
        Vector a = gameControl.getGravityFor(object);
        Vector streamSpeed = gameControl.getStreamSpeedFor(object);
        ControllableObject co = (ControllableObject)object;
        a = Vector.add(a, this.getThrustAcceleration(co, elapsedTime));
        Vector maf = Vector.mul(a, (double)co.getMass() / (friction /= 1024.0));
        Vector v = co.getSpeed();
        v.sub(streamSpeed);
        v.sub(maf);
        v.mul(Math.exp(-friction * elapsed / (double)co.getMass()));
        v.add(maf);
        v.add(streamSpeed);
        co.setSpeed(v);
    }

    protected void updateWithoutFriction(MoaggGameObject object, GameControl gameControl, long elapsedTime) {
        ControllableObject co = (ControllableObject)object;
        Vector a = gameControl.getGravityFor(object);
        a.add(this.getThrustAcceleration(co, elapsedTime));
        Vector v = co.getSpeed();
        v.add(Vector.mul(a, elapsedTime));
        co.setSpeed(v);
    }
}

