/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.mortar;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.artwork.object.TurretImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.model.object.sprite.Grenade;
import moagg.model.object.sprite.Mortar;
import moagg.model.weapon.mortar.AbstractBarrel;
import moagg.types.math.Vector;

public abstract class AbstractProjectileFactoryImpl
implements ProjectileFactory {
    protected int getCenterAngle(Mortar mortar) {
        switch (mortar.getOrientation()) {
            case TOP: {
                return 180;
            }
            case BOTTOM: {
                return 0;
            }
            case LEFT: {
                return 90;
            }
            case RIGHT: {
                return 270;
            }
        }
        return 0;
    }

    protected void createProjectile(Mortar mortar, AbstractBarrel barrel, int angle, GameControl gameControl) {
        Grenade grenade = new Grenade();
        grenade.setImage(ProjectileImageFactory.getInstance().getGrenadeImage());
        int x = (int)mortar.getX();
        int y = (int)mortar.getY();
        switch (mortar.getOrientation()) {
            case TOP: {
                x += mortar.getWidth() / 2 - grenade.getWidth() / 2;
                y += TurretImageFactory.getInstance().getTurretHeight(mortar.getType());
                break;
            }
            case BOTTOM: {
                x += mortar.getWidth() / 2 - grenade.getWidth() / 2;
                y += mortar.getHeight() - TurretImageFactory.getInstance().getTurretHeight(mortar.getType());
                y -= grenade.getHeight();
                break;
            }
            case LEFT: {
                x += TurretImageFactory.getInstance().getTurretHeight(mortar.getType());
                y += mortar.getHeight() / 2 - grenade.getHeight() / 2;
                break;
            }
            case RIGHT: {
                x += mortar.getWidth() - TurretImageFactory.getInstance().getTurretHeight(mortar.getType());
                x -= grenade.getWidth();
                y += mortar.getHeight() / 2 - grenade.getHeight() / 2;
            }
        }
        grenade.setX(x);
        grenade.setY(y);
        Vector v = Vector.exp(barrel.getSpeed(), angle);
        grenade.setSpeed(v.getX(), v.getY());
        grenade.setWarhead(barrel.getWarhead(), barrel.getExploderDelay());
        grenade.setHealth(5);
        grenade.setShooter(mortar);
        gameControl.addProjectile(grenade);
    }
}

