/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.level.applet;

import java.awt.Color;
import java.awt.Graphics2D;
import moagg.game.level.applet.Applet;
import moagg.types.math.Rectangle;

public abstract class AbstractApplet
implements Applet {
    private static final int EDGE_SIZE = 4;
    private Rectangle position = new Rectangle();

    protected AbstractApplet() {
    }

    protected AbstractApplet(int w) {
        this.setWidth(w);
    }

    protected void setWidth(int w) {
        this.position.setW(w + 8);
        this.position.setH(64);
    }

    public Rectangle getPosition() {
        return this.position;
    }

    public void setPosition(int x, int y) {
        this.position.setX(x);
        this.position.setY(y);
    }

    public void render(Graphics2D g) {
        g.translate(this.position.getX(), this.position.getY());
        g.setColor(Color.DARK_GRAY);
        g.draw3DRect(0, 0, this.position.getW(), this.position.getH(), true);
        for (int i = 1; i < 4; ++i) {
            g.draw3DRect(i, i, this.position.getW() - 2 * i, this.position.getH() - 2 * i, true);
        }
        g.translate(4, 4);
        this.renderContent(g);
        g.translate(-4, -4);
        g.translate(-this.position.getX(), -this.position.getY());
    }

    protected abstract void renderContent(Graphics2D var1);
}

