/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.level.applet;

import com.golden.gamedev.object.GameFont;
import java.awt.Color;
import java.awt.Graphics2D;
import moagg.artwork.font.FontFactory;
import moagg.game.Strings;
import moagg.game.level.applet.AbstractApplet;
import moagg.model.object.ControllableObject;

public class FuelApplet
extends AbstractApplet {
    private static final int MARGIN = 6;
    private String LABEL = Strings.getString("game.panel.fuel.label");
    private static final Color[] FUEL_COLOR;
    private GameFont font = FontFactory.getInstance().getNarrowFont();
    private ControllableObject controllable = null;

    public FuelApplet() {
        int width = 48;
        width = Math.max(width, this.font.getWidth(this.LABEL));
        this.setWidth(width += 12);
    }

    public void setControllable(ControllableObject controllable) {
        this.controllable = controllable;
    }

    public void update(long elapsedTime) {
    }

    protected void renderContent(Graphics2D g) {
        this.font.drawString(g, this.LABEL, 6, 2);
        int x = 6;
        int y = 22;
        g.setColor(Color.GRAY);
        g.drawRect(x, y, 49, 16);
        g.setColor(Color.BLACK);
        g.fillRect(x + 1, y + 1, 47, 14);
        int w = (int)(48L * this.controllable.getFuel() / this.controllable.getFuelCapacity());
        for (int xOff = 0; xOff < w; ++xOff) {
            g.setColor(FUEL_COLOR[xOff]);
            g.drawLine(x + 1 + xOff, y + 1, x + 1 + xOff, y + 16 - 1);
        }
    }

    static {
        int i;
        FUEL_COLOR = new Color[48];
        for (i = 0; i < 4; ++i) {
            FuelApplet.FUEL_COLOR[i] = Color.RED;
        }
        for (i = 0; i < 12; ++i) {
            FuelApplet.FUEL_COLOR[4 + i] = new Color(255, i * 255 * 4 / 16 / 3, 0);
        }
        for (i = 0; i < 16; ++i) {
            FuelApplet.FUEL_COLOR[16 + i] = new Color(255 * (16 - i) / 16, 255, 0);
        }
        for (i = 32; i < 48; ++i) {
            FuelApplet.FUEL_COLOR[i] = Color.GREEN;
        }
    }
}

