/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.level.applet;

import com.golden.gamedev.GameObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import moagg.game.level.applet.Applet;
import moagg.types.math.Rectangle;

public class Panel {
    public static final int PANEL_HEIGHT = 64;
    private Rectangle position = new Rectangle();
    private List<Applet> left = new LinkedList<Applet>();
    private List<Applet> right = new LinkedList<Applet>();

    public Panel(GameObject parent) {
        this.position.setX(0);
        this.position.setY(parent.getHeight() - 64);
        this.position.setW(parent.getWidth());
        this.position.setH(64);
    }

    public void addAppletToLeft(Applet applet) {
        this.left.add(applet);
        this.updateAppletPosition();
    }

    public void addAppletToRight(Applet applet) {
        this.right.add(applet);
        this.updateAppletPosition();
    }

    protected void updateAppletPosition() {
        int x = this.position.getW();
        int y = this.position.getY();
        for (Applet applet : this.right) {
            applet.setPosition(x -= applet.getPosition().getW(), y);
        }
        x = 0;
        for (Applet applet : this.left) {
            applet.setPosition(x, y);
            x += applet.getPosition().getW();
        }
    }

    public void update(long elapsedTime) {
        for (Applet applet : this.left) {
            applet.update(elapsedTime);
        }
        for (Applet applet : this.right) {
            applet.update(elapsedTime);
        }
    }

    public void render(Graphics2D g) {
        g.setColor(Color.DARK_GRAY);
        g.fillRect(this.position.getX(), this.position.getY(), this.position.getW(), this.position.getH());
        for (Applet applet : this.left) {
            applet.render(g);
        }
        for (Applet applet : this.right) {
            applet.render(g);
        }
    }
}

