/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import moagg.game.MissionGameObject;
import moagg.game.Strings;
import moagg.game.level.LevelStrings;
import moagg.game.menu.AbstractMenu;
import moagg.level.MissionReader;
import org.apache.log4j.Logger;

public class MissionMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(MissionMenu.class);
    private static final String KEY_BACK = "menu.back";
    private List<MissionReader.MissionEntry> missionEntries = new ArrayList<MissionReader.MissionEntry>();

    public MissionMenu(GameEngine parent, BufferedImage background) {
        super(parent, background);
    }

    public void initResources() {
        log.trace("");
        super.initResources();
    }

    protected void initMenuItems() {
        this.menuItems.clear();
        this.missionEntries.clear();
        int x = 100;
        int y = 100;
        for (MissionReader.MissionEntry entry : MissionReader.getInstance().getMissions()) {
            this.menuItems.add(new AbstractMenu.MenuItem(x, y, LevelStrings.getMissionTitle(entry.directory)));
            this.missionEntries.add(entry);
            y += 20;
        }
        this.menuItems.add(new AbstractMenu.MenuItem(x, y, Strings.getString(KEY_BACK)));
    }

    public void enter() {
        if (this.selectedItemIndex < this.missionEntries.size()) {
            MissionGameObject game = new MissionGameObject(this.parent, this.background, this.missionEntries.get(this.selectedItemIndex));
            game.start();
            this.initMenuItems();
        } else {
            this.finish();
        }
    }
}

