/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import moagg.artwork.sound.MusicClips;
import moagg.game.Strings;
import moagg.game.level.LevelStrings;
import moagg.game.menu.AbstractMenu;
import moagg.prefs.system.SystemPrefs;
import moagg.types.prefs.Language;
import moagg.types.prefs.ScreenResolution;
import moagg.types.prefs.TimerType;
import org.apache.log4j.Logger;

public class SystemMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(SystemMenu.class);
    private static final int INDEX_LANGUAGE = 0;
    private static final int INDEX_RESOLUTION = 1;
    private static final int INDEX_FULLSCREEN = 2;
    private static final int INDEX_MUSIC = 3;
    private static final int INDEX_TIMER = 4;
    private static final int INDEX_BACK = 5;
    private static final String KEY_LANGUAGE = "menu.system.language";
    private static final String KEY_RESOLUTION = "menu.system.resolution";
    private static final String KEY_FULLSCREEN = "menu.system.fullscreen";
    private static final String KEY_MUSIC = "menu.system.music";
    private static final String KEY_TIMER = "menu.system.timer";
    private static final String KEY_BACK = "menu.back";
    private static final String KEY_RESTART = "menu.system.restart";
    private SystemPrefs prefs = SystemPrefs.getInstance();
    private boolean selectLanguage = false;
    private int selectedLanguage = 0;
    private boolean selectResolution = false;
    private int selectedResolution = 0;
    private boolean selectFullscreen = false;
    private boolean selectMusic = false;
    private boolean selectTimer = false;
    private int selectedTimer = 0;
    private TimerType timer = null;
    private boolean modified = false;

    public SystemMenu(GameEngine parent, BufferedImage background) {
        super(parent, background);
    }

    public void initResources() {
        log.trace("");
        super.initResources();
        this.initMenuItems();
        this.selectedLanguage = this.prefs.getLanguage().ordinal();
        this.selectedResolution = this.prefs.getScreenResolution().ordinal();
        this.timer = this.prefs.getTimer();
        this.selectedTimer = this.timer.ordinal();
    }

    protected void initMenuItems() {
        this.maxTextWidth = 0;
        this.updateMaxTextWidth(Strings.getString(KEY_LANGUAGE));
        this.updateMaxTextWidth(Strings.getString(KEY_RESOLUTION));
        this.updateMaxTextWidth(Strings.getString(KEY_FULLSCREEN));
        this.updateMaxTextWidth(Strings.getString(KEY_MUSIC));
        this.updateMaxTextWidth(Strings.getString(KEY_TIMER));
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(100, 100, Strings.getString(KEY_LANGUAGE)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 120, Strings.getString(KEY_RESOLUTION)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 140, Strings.getString(KEY_FULLSCREEN)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 160, Strings.getString(KEY_MUSIC)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 180, Strings.getString(KEY_TIMER)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 200, Strings.getString(KEY_BACK)));
    }

    public void update(long elapsedTime) {
        if (this.selectLanguage) {
            this.selectedLanguage = (this.selectedLanguage + 1) % Language.values().length;
            this.prefs.setLanguage(Language.values()[this.selectedLanguage]);
            this.switchLanguage();
            this.selectLanguage = false;
        } else if (this.selectResolution) {
            this.selectedResolution = (this.selectedResolution + 1) % ScreenResolution.values().length;
            this.prefs.setScreenResolution(ScreenResolution.values()[this.selectedResolution]);
            this.modified = true;
            this.selectResolution = false;
        } else if (this.selectFullscreen) {
            this.prefs.setFullScreen(!this.prefs.isFullScreen());
            this.modified = true;
            this.selectFullscreen = false;
        } else if (this.selectMusic) {
            this.prefs.setMusic(!this.prefs.isMusic());
            if (this.prefs.isMusic()) {
                MusicClips.getInstance().play();
            } else {
                MusicClips.getInstance().stop();
            }
            this.selectMusic = false;
        } else if (this.selectTimer) {
            this.selectedTimer = (this.selectedTimer + 1) % TimerType.values().length;
            this.timer = TimerType.values()[this.selectedTimer];
            this.prefs.setTimerType(this.timer);
            this.modified = true;
            this.selectTimer = false;
        } else {
            super.update(elapsedTime);
        }
    }

    protected void switchLanguage() {
        this.prefs.getLanguage().setDefaultLocale();
        Strings.init();
        LevelStrings.init();
        this.initMenuItems();
    }

    public void enter() {
        switch (this.selectedItemIndex) {
            case 0: {
                this.selectLanguage = true;
                break;
            }
            case 1: {
                this.selectResolution = true;
                break;
            }
            case 2: {
                this.selectFullscreen = true;
                break;
            }
            case 3: {
                this.selectMusic = true;
                break;
            }
            case 4: {
                this.selectTimer = true;
                break;
            }
            case 5: {
                this.finish();
            }
        }
    }

    public void render(Graphics2D g) {
        super.render(g);
        int x = 100 + this.maxTextWidth + 32;
        this.renderText(g, this.prefs.getLanguage().getDescription(), x, 100, false);
        this.renderText(g, this.prefs.getScreenResolution().toString(), x, 120, false);
        this.renderText(g, Strings.getString("menu.switch." + this.prefs.isFullScreen()), x, 140, false);
        this.renderText(g, Strings.getString("menu.switch." + this.prefs.isMusic()), x, 160, false);
        this.renderText(g, this.timer.toString(), x, 180, false);
        if (this.modified) {
            this.font.drawText(g, Strings.getString(KEY_RESTART), 1, 100, 250, this.getWidth() - 200, 0, 0);
        }
    }
}

