/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.PlatformImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.PlatformData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Platform;
import moagg.types.PlatformEdge;
import org.apache.log4j.Logger;

public class PlatformFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(PlatformFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        PlatformData data = (PlatformData)abstractData;
        Platform platform = new Platform();
        platform.setID(data.getId());
        platform.setImages(PlatformImageFactory.getInstance().getImages(data.getLeftEdge(), data.getRightEdge(), data.getSize()));
        platform.setRGB(PlatformImageFactory.getInstance().getRGB(data.getLeftEdge(), data.getRightEdge(), data.getSize()));
        platform.setLocation(data.getX() * 16, data.getY() * 16);
        platform.setAnimate(true);
        platform.setLoopAnim(true);
        platform.getAnimationTimer().setDelay(500L);
        if (data.getLeftEdge() == PlatformEdge.FUEL || data.getRightEdge() == PlatformEdge.FUEL) {
            platform.setFuelPlatform(true);
        }
        return platform;
    }
}

