/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.ThornImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.ThornData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Thorn;
import org.apache.log4j.Logger;

public class ThornFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(ThornFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        ThornData data = (ThornData)abstractData;
        Thorn thorn = new Thorn();
        thorn.setID(data.getId());
        thorn.setImages(ThornImageFactory.getInstance().getImages(data.getOrientation(), data.getSize()));
        thorn.setRGB(ThornImageFactory.getInstance().getRGB(data.getOrientation(), data.getSize()));
        int x = data.getX();
        int y = data.getY();
        switch (data.getOrientation()) {
            case BOTTOM: {
                y -= data.getSize() - 1;
                break;
            }
            case RIGHT: {
                x -= data.getSize() - 1;
                break;
            }
        }
        thorn.setLocation(x * 16, y * 16);
        thorn.setVisible(data.isVisible());
        thorn.setOrientation(data.getOrientation());
        thorn.setAnimate(true);
        thorn.setLoopAnim(true);
        thorn.getAnimationTimer().setDelay(20L);
        return thorn;
    }
}

