/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.object;

import moagg.level.IllegalAttributeXmlHandlerException;
import moagg.level.xml.AbstractHandler;
import moagg.level.xml.Handler;
import moagg.level.xml.data.object.TurretData;
import moagg.types.TurretBarrelType;
import moagg.types.WeaponType;
import org.xml.sax.Attributes;

public class TurretBarrelHandler
extends AbstractHandler
implements Handler {
    public static final String NAME = "barrel";
    private TurretData.BarrelData data = new TurretData.BarrelData();

    public TurretData.BarrelData getTurretBarrelData() {
        return this.data;
    }

    protected TurretBarrelHandler(Attributes attrs) {
        this.data.setWeaponType(this.parseWeaponType(this.getStringAttribute(NAME, "weapon", attrs, "blaster")));
        this.data.setType(this.parseType(this.getStringAttribute(NAME, "type", attrs)));
        this.data.setAngle(this.getIntAttribute(NAME, "angle", attrs, 0));
        this.data.setStep(this.getIntAttribute(NAME, "step", attrs, 0));
        this.data.setSpeed(this.getIntAttribute(NAME, "speed", attrs, this.getDefaultSpeed(this.data.getWeaponType())));
        this.data.setDelay(this.getIntAttribute(NAME, "delay", attrs, 20));
    }

    public Handler createSubHandler(String name, Attributes attrs) {
        return null;
    }

    public void handleTag(String name, String value) {
    }

    public void finishSubHandler(String name, Handler subHandler) {
    }

    protected WeaponType parseWeaponType(String value) {
        if ("blaster".equals(value)) {
            return WeaponType.BLASTER;
        }
        if ("laser".equals(value)) {
            return WeaponType.LASER;
        }
        throw new IllegalAttributeXmlHandlerException(NAME, "weapon", value);
    }

    protected TurretBarrelType parseType(String value) {
        if ("fixed".equals(value)) {
            return TurretBarrelType.FIXED;
        }
        if ("random".equals(value)) {
            return TurretBarrelType.RANDOM;
        }
        if ("sweep".equals(value)) {
            return TurretBarrelType.SWEEP;
        }
        if ("smart".equals(value)) {
            return TurretBarrelType.SMART;
        }
        throw new IllegalAttributeXmlHandlerException(NAME, "type", value);
    }

    protected int getDefaultSpeed(WeaponType weaponType) {
        switch (weaponType) {
            case LASER: {
                return 300;
            }
            case BLASTER: {
                return 200;
            }
        }
        return 200;
    }
}

