/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.level;

import java.awt.image.BufferedImage;

public class Map {
    private int w;
    private int h;
    private BufferedImage image = null;
    private int[] rgb = null;
    private boolean[][] foreground = null;

    public Map(int w, int h) {
        this.w = w;
        this.h = h;
        this.foreground = new boolean[w][h];
        for (int y = 0; y < h; y = (int)((short)(y + 1))) {
            for (int x = 0; x < w; x = (int)((short)(x + 1))) {
                this.foreground[x][y] = false;
            }
        }
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setRGB(int[] rgb) {
        this.rgb = rgb;
    }

    public int[] getRGB() {
        return this.rgb;
    }

    public void markAsForegroundTile(int x, int y) {
        this.foreground[x][y] = true;
    }

    public boolean isBackgroundTile(int x, int y) {
        if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
            return false;
        }
        return !this.foreground[x][y];
    }

    public boolean isBackgroundBetween(int x1, int y1, int x2, int y2) {
        int diffX = x1 - x2;
        int diffY = y1 - y2;
        if (diffX == 0 && diffY == 0) {
            return this.isBackgroundTile(x1, y1);
        }
        if (Math.abs(diffX) > Math.abs(diffY)) {
            if (x1 < x2) {
                return this.do_isBackgroundBetweenX(x1, y1, x2, y2);
            }
            return this.do_isBackgroundBetweenX(x2, y2, x1, y1);
        }
        if (y1 < y2) {
            return this.do_isBackgroundBetweenY(x1, y1, x2, y2);
        }
        return this.do_isBackgroundBetweenY(x2, y2, x1, y1);
    }

    private boolean do_isBackgroundBetweenX(int x1, int y1, int x2, int y2) {
        double k = 1.0 * (double)(y2 - y1) / (1.0 * (double)(x2 - x1));
        double y = 1.0 * (double)y1;
        for (int x = x1; x <= x2; ++x) {
            if (!this.isBackgroundTile(x, (int)Math.round(y))) {
                return false;
            }
            y += k;
        }
        return true;
    }

    private boolean do_isBackgroundBetweenY(int x1, int y1, int x2, int y2) {
        double k = 1.0 * (double)(x2 - x1) / (1.0 * (double)(y2 - y1));
        double x = 1.0 * (double)x1;
        for (int y = y1; y <= y2; ++y) {
            if (!this.isBackgroundTile((int)Math.round(x), y)) {
                return false;
            }
            x += k;
        }
        return true;
    }
}

