/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import com.golden.gamedev.object.Timer;
import moagg.model.Activatable;
import moagg.model.object.ActivatableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.OrientationObject;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;
import moagg.types.Orientation;

public class Magnet
extends AbstractMoaggAnimatedSprite
implements MoaggGameObject,
OrientationObject,
ActivatableObject {
    private static final long serialVersionUID = 1L;
    private Activatable activatable = null;
    private State state = new Initial();
    private Timer onOffTimer = new Timer(0);
    private Orientation orientation = null;
    private int strength = 0;
    private int distance = 0;

    public void setActivatable(Activatable activatable) {
        this.activatable = activatable;
    }

    public boolean isActivated() {
        return this.state.isActivated();
    }

    public void activate() {
        this.setState(new Activated());
    }

    public void deactivate() {
        this.setState(new Deactivated());
    }

    public void toggle() {
        if (this.isActivated()) {
            this.deactivate();
        } else {
            this.activate();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    protected void setState(State state) {
        this.state = state;
        this.state.onEntry();
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        this.state.update(elapsedTime);
    }

    private class Deactivated
    implements State {
        private Deactivated() {
        }

        public void onEntry() {
            Magnet.this.setAnimate(false);
            if (Magnet.this.activatable.hasActivation()) {
                Magnet.this.onOffTimer.setActive(false);
            } else if (Magnet.this.activatable.getOffInterval() > 0) {
                Magnet.this.onOffTimer.setActive(true);
                Magnet.this.onOffTimer.setDelay((long)Magnet.this.activatable.getOffInterval());
            } else {
                Magnet.this.onOffTimer.setActive(false);
            }
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Magnet.this.onOffTimer.action(elapsedTime)) {
                Magnet.this.activate();
            }
        }
    }

    private class Activated
    implements State {
        private Activated() {
        }

        public void onEntry() {
            Magnet.this.setAnimate(true);
            if (Magnet.this.activatable.hasActivation()) {
                Magnet.this.onOffTimer.setActive(false);
            } else if (Magnet.this.activatable.getOnInterval() > 0) {
                Magnet.this.onOffTimer.setActive(true);
                Magnet.this.onOffTimer.setDelay((long)Magnet.this.activatable.getOnInterval());
            } else {
                Magnet.this.onOffTimer.setActive(false);
            }
        }

        public boolean isActivated() {
            return true;
        }

        public void update(long elapsedTime) {
            if (Magnet.this.onOffTimer.action(elapsedTime)) {
                Magnet.this.deactivate();
            }
        }
    }

    private class InitialDelay
    implements State {
        private InitialDelay() {
        }

        public void onEntry() {
            Magnet.this.onOffTimer.setDelay((long)Magnet.this.activatable.getInitialDelay());
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Magnet.this.onOffTimer.action(elapsedTime)) {
                Magnet.this.activate();
            }
        }
    }

    private class Initial
    implements State {
        private Initial() {
        }

        public void onEntry() {
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Magnet.this.activatable.hasActivation()) {
                if (Magnet.this.activatable.getActivation()) {
                    Magnet.this.activate();
                } else {
                    Magnet.this.deactivate();
                }
            } else if (Magnet.this.activatable.getInitialDelay() > 0) {
                Magnet.this.setState(new InitialDelay());
            } else {
                Magnet.this.activate();
            }
        }
    }

    private static interface State {
        public void onEntry();

        public boolean isActivated();

        public void update(long var1);
    }
}

