/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import moagg.model.Controllable;
import moagg.model.Destroyable;
import moagg.model.object.ControllableObject;
import moagg.model.object.DestroyableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShootableWithWarheadObject;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;
import moagg.model.warhead.NullWarhead;
import moagg.model.warhead.Warhead;
import moagg.model.warhead.missile.ConeBurstWarhead;
import moagg.model.warhead.missile.StarBurstWarhead;
import moagg.types.MissileHeading;
import moagg.types.MissileWarhead;
import moagg.types.Rotation;
import moagg.types.math.Vector;
import moagg.util.math.AngleUtil;

public class Missile
extends AbstractMoaggAnimatedSprite
implements MoaggGameObject,
ShootableWithWarheadObject,
ControllableObject,
DestroyableObject {
    private static final long serialVersionUID = 1L;
    private static final int ALIGNED_FRAME = 30;
    private ShooterObject shooter;
    private Controllable controllable = null;
    private Destroyable destroyable = null;
    private int damage = 5;
    private Heading heading = null;
    private Warhead warhead = new NullWarhead();

    public Missile() {
        this.setFrame(30);
    }

    public ShooterObject getShooter() {
        return this.shooter;
    }

    public void setShooter(ShooterObject shooter) {
        this.shooter = shooter;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public boolean isDestroyableByProjectile() {
        return true;
    }

    public void setControllable(Controllable controllable) {
        this.controllable = controllable;
    }

    public double getAngle() {
        return this.controllable.getAngle();
    }

    public void setAngle(double angle) {
        this.controllable.setAngle(angle);
        this.setFrame((int)angle / 6);
    }

    public boolean isThrust() {
        return this.controllable.isThrust();
    }

    public void setThrust(boolean thrust) {
        this.controllable.setThrust(thrust);
    }

    public double getThrustForce() {
        return this.controllable.getThrustForce();
    }

    public void setThrustForce(double thrustForce) {
        this.controllable.setThrustForce(thrustForce);
    }

    public long getMass() {
        return this.controllable.getMass();
    }

    public void setMass(long mass) {
        this.controllable.setMass(mass);
    }

    public long getFuelCapacity() {
        return this.controllable.getFuelCapacity();
    }

    public void setFuelCapacity(long fuelCapacity) {
        this.controllable.setFuelCapacity(fuelCapacity);
    }

    public long getFuel() {
        return this.controllable.getFuel();
    }

    public void setFuel(long fuel) {
        this.controllable.setFuel(fuel);
    }

    public long getFuelPerMilliSecond() {
        return this.controllable.getFuelPerMilliSecond();
    }

    public void setFuelPerMilliSecond(long fuelPerMilliSecond) {
        this.controllable.setFuel(fuelPerMilliSecond);
    }

    public Rotation getRotation() {
        return this.controllable.getRotation();
    }

    public void setRotation(Rotation rotation) {
        this.controllable.setRotation(rotation);
    }

    public boolean isAligned() {
        return this.getFrame() == 30;
    }

    public double getRotationSpeed() {
        return this.controllable.getRotationSpeed();
    }

    public void setRotationSpeed(double rotationSpeed) {
        this.controllable.setRotationSpeed(rotationSpeed);
    }

    public void setDestroyable(Destroyable destroyable) {
        this.destroyable = destroyable;
    }

    public int getHealth() {
        return this.destroyable.getHealth();
    }

    public void setHealth(int health) {
        this.destroyable.setHealth(health);
    }

    public void destroy() {
        this.setHealth(0);
    }

    public int getScorePoints() {
        return 0;
    }

    public void setHeading(MissileHeading heading) {
        switch (heading) {
            case DIRECT: {
                this.heading = new DirectHeading();
                break;
            }
            case SMART: {
                this.heading = new SmartHeading();
            }
        }
    }

    public double getTargetAngle(double targetAngle, Vector g) {
        return this.heading.getTargetAngle(targetAngle, g);
    }

    public void setWarhead(MissileWarhead warhead) {
        switch (warhead) {
            case NORMAL: {
                break;
            }
            case STARBURST: {
                this.warhead = new StarBurstWarhead(this);
                break;
            }
            case CONEBURST: {
                this.warhead = new ConeBurstWarhead(this);
            }
        }
    }

    public Warhead getWarhead() {
        return this.warhead;
    }

    public void update(long elapsedTime) {
        this.warhead.update(elapsedTime);
        this.updateMovement(elapsedTime);
    }

    private class SmartHeading
    implements Heading {
        private SmartHeading() {
        }

        public double getTargetAngle(double targetAngle, Vector g) {
            double aabs = Missile.this.getThrustForce() / (double)Missile.this.getMass();
            Vector a = Vector.exp(aabs, targetAngle);
            double aa = aabs * aabs;
            double axgy_m_aygx = a.getX() * g.getY() - a.getY() * g.getX();
            double sqrtTerm = 1.0 - axgy_m_aygx * axgy_m_aygx / (aa * aa);
            if (sqrtTerm <= 0.0) {
                return AngleUtil.getAngle(-g.getX(), -g.getY());
            }
            double term1 = (a.getX() * g.getX() + a.getY() * g.getY()) / aa;
            double term2 = Math.sqrt(sqrtTerm);
            double t = term1 + term2;
            double bx = -g.getX() + t * a.getX();
            double by = -g.getY() + t * a.getY();
            return AngleUtil.getAngle(bx, by);
        }
    }

    private class DirectHeading
    implements Heading {
        private DirectHeading() {
        }

        public double getTargetAngle(double targetAngle, Vector g) {
            return targetAngle;
        }
    }

    private static interface Heading {
        public double getTargetAngle(double var1, Vector var3);
    }
}

