/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.Timer;
import java.awt.Color;
import java.awt.Graphics2D;
import moagg.artwork.object.FountainImageFactory;
import moagg.model.object.sprite.AbstractMoaggSprite;

public class Particle
extends AbstractMoaggSprite {
    private static final long serialVersionUID = 1L;
    private static Color[] COLORS;
    private static Color[] COLORS_GHOST;
    private boolean ghost = false;
    private boolean collision = false;
    private boolean gradient = false;
    private long totalLifeTime = 0L;
    private Timer timer = new Timer(0);

    public Particle() {
        this.setImage(FountainImageFactory.getInstance().getParticle());
        this.setRGB(new int[]{0xFFFFFF});
    }

    public void setGhost(boolean ghost) {
        this.ghost = ghost;
    }

    public void setCollision(boolean collision) {
        this.collision = collision;
    }

    public boolean isCollision() {
        return this.collision;
    }

    public void setGradient(boolean gradient) {
        this.gradient = gradient;
    }

    public void setLifeTime(long lifeTime) {
        this.totalLifeTime = lifeTime;
        this.timer.setDelay(lifeTime);
    }

    public void render(Graphics2D g) {
        int x = 0;
        int y = 0;
        Background bg = this.getBackground();
        if (bg != null) {
            x = (int)(this.getX() - bg.getX() + bg.getClip().getX());
            y = (int)(this.getY() - bg.getY() + bg.getClip().getY());
        } else {
            x = (int)this.getX();
            y = (int)this.getY();
        }
        if (this.gradient) {
            long i = (long)COLORS.length * this.timer.getCurrentTick() / this.totalLifeTime;
            g.setColor(this.ghost ? COLORS_GHOST[(int)i] : COLORS[(int)i]);
        } else {
            g.setColor(this.ghost ? Color.GRAY : Color.WHITE);
        }
        g.drawLine(x, y, x, y);
    }

    public void update(long elapsedTime) {
        this.updateMovement(elapsedTime);
        if (this.timer.action(elapsedTime)) {
            this.setActive(false);
        }
    }

    static {
        int i;
        COLORS = new Color[768];
        COLORS_GHOST = new Color[768];
        for (i = 0; i < 256; ++i) {
            Particle.COLORS[i] = new Color(255, 255, 255 - i);
            Particle.COLORS_GHOST[i] = new Color(128, 128, 128 - i / 2);
        }
        for (i = 0; i < 256; ++i) {
            Particle.COLORS[256 + i] = new Color(255, 255 - i, 0);
            Particle.COLORS_GHOST[256 + i] = new Color(128, 128 - i / 2, 0);
        }
        for (i = 0; i < 256; ++i) {
            Particle.COLORS[512 + i] = new Color(255 - i, 0, 0);
            Particle.COLORS_GHOST[512 + i] = new Color(128 - i / 2, 0, 0);
        }
    }
}

