/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import java.util.LinkedList;
import java.util.List;
import moagg.model.Controllable;
import moagg.model.Destroyable;
import moagg.model.object.ControllableObject;
import moagg.model.object.DestroyableObject;
import moagg.model.object.LandableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;
import moagg.model.object.sprite.Crate;
import moagg.model.object.sprite.Platform;
import moagg.model.weapon.NullWeapon;
import moagg.model.weapon.Weapon;
import moagg.types.Rotation;
import moagg.types.math.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ship
extends AbstractMoaggAnimatedSprite
implements MoaggGameObject,
ControllableObject,
ShooterObject,
LandableObject,
DestroyableObject {
    private static final long serialVersionUID = 1L;
    private static final int ALIGNED_FRAME = 30;
    private Controllable controllable = null;
    private Destroyable destroyable = null;
    private Rectangle landingZone = null;
    private Platform landedPlatform = null;
    private Weapon weapon = new NullWeapon();
    private List<Crate> crates = new LinkedList<Crate>();

    public Ship() {
        this.setFrame(30);
    }

    public void setControllable(Controllable controllable) {
        this.controllable = controllable;
    }

    @Override
    public double getAngle() {
        return this.controllable.getAngle();
    }

    @Override
    public void setAngle(double angle) {
        this.controllable.setAngle(angle);
        this.setFrame((int)angle / 6);
    }

    @Override
    public boolean isThrust() {
        return this.controllable.isThrust();
    }

    @Override
    public void setThrust(boolean thrust) {
        this.controllable.setThrust(thrust);
    }

    @Override
    public double getThrustForce() {
        return this.controllable.getThrustForce();
    }

    @Override
    public void setThrustForce(double thrustForce) {
        this.controllable.setThrustForce(thrustForce);
    }

    @Override
    public long getMass() {
        return this.controllable.getMass();
    }

    @Override
    public void setMass(long mass) {
        this.controllable.setMass(mass);
    }

    @Override
    public long getFuelCapacity() {
        return this.controllable.getFuelCapacity();
    }

    @Override
    public void setFuelCapacity(long fuelCapacity) {
        this.controllable.setFuelCapacity(fuelCapacity);
    }

    @Override
    public long getFuel() {
        return this.controllable.getFuel();
    }

    @Override
    public void setFuel(long fuel) {
        this.controllable.setFuel(fuel);
    }

    @Override
    public long getFuelPerMilliSecond() {
        return this.controllable.getFuelPerMilliSecond();
    }

    @Override
    public void setFuelPerMilliSecond(long fuelPerMilliSecond) {
        this.controllable.setFuel(fuelPerMilliSecond);
    }

    @Override
    public Rotation getRotation() {
        return this.controllable.getRotation();
    }

    @Override
    public void setRotation(Rotation rotation) {
        this.controllable.setRotation(rotation);
    }

    @Override
    public boolean isAligned() {
        return this.getFrame() == 30;
    }

    @Override
    public double getRotationSpeed() {
        return this.controllable.getRotationSpeed();
    }

    @Override
    public void setRotationSpeed(double rotationSpeed) {
        this.controllable.setRotationSpeed(rotationSpeed);
    }

    @Override
    public boolean isLanded() {
        return this.landedPlatform != null;
    }

    public void setLandedPlatform(Platform landedPlatform) {
        this.landedPlatform = landedPlatform;
    }

    @Override
    public Platform getLandedPlatform() {
        return this.landedPlatform;
    }

    public void setLandingZone(Rectangle landingZone) {
        this.landingZone = landingZone;
    }

    public Rectangle getLandingZone() {
        return this.landingZone;
    }

    public void setDestroyable(Destroyable destroyable) {
        this.destroyable = destroyable;
    }

    @Override
    public int getHealth() {
        return this.destroyable.getHealth();
    }

    @Override
    public void setHealth(int health) {
        this.destroyable.setHealth(health);
    }

    @Override
    public void destroy() {
        this.setHealth(0);
    }

    @Override
    public int getScorePoints() {
        return 0;
    }

    @Override
    public void setWeapon(Weapon weapon) {
        this.weapon = weapon;
    }

    @Override
    public Weapon getWeapon() {
        return this.weapon;
    }

    public boolean hasCrates() {
        return !this.crates.isEmpty();
    }

    public List<Crate> getCrates() {
        return this.crates;
    }

    public boolean hasCapacityForCrate(Crate crate) {
        return this.getMass() + (long)crate.getMass() <= 1600L;
    }

    public boolean hasCrate(Crate crate) {
        return this.crates.contains(crate);
    }

    public void pickupCrate(Crate crate) {
        crate.setVisible(false);
        this.crates.add(crate);
        this.controllable.setMass(this.controllable.getMass() + (long)crate.getMass());
    }

    public void dropCrate(Crate crate) {
        this.controllable.setMass(this.controllable.getMass() - (long)crate.getMass());
        crate.setVisible(true);
        this.crates.remove(crate);
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        this.weapon.update(elapsedTime);
    }
}

