/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import com.golden.gamedev.object.Timer;
import moagg.model.Destroyable;
import moagg.model.object.DestroyableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShooterObject;
import moagg.model.object.sprite.AbstractMoaggSprite;
import moagg.model.weapon.Weapon;
import moagg.types.TankType;

public class Tank
extends AbstractMoaggSprite
implements MoaggGameObject,
ShooterObject,
DestroyableObject {
    private static final long serialVersionUID = 1L;
    private static final long AIMING_DELAY_TIME = 500L;
    private static final long WAITING_DELAY_TIME = 500L;
    private static final double TANK_SPEED = 0.05;
    private Destroyable destroyable = null;
    private State state = new Initial();
    private Timer timer = new Timer(0);
    private Weapon weapon = null;
    private int minX = 0;
    private int maxX = 0;
    private TankType type = null;
    private int targetX = 0;
    private Direction direction = null;

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setType(TankType type) {
        this.type = type;
    }

    public TankType getTankType() {
        return this.type;
    }

    public void setWeapon(Weapon weapon) {
        this.weapon = weapon;
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public void update(long elapsedTime) {
        this.weapon.update(elapsedTime);
        this.state.update(elapsedTime);
    }

    public void setDestroyable(Destroyable destroyable) {
        this.destroyable = destroyable;
    }

    public int getHealth() {
        return this.destroyable.getHealth();
    }

    public void setHealth(int health) {
        this.destroyable.setHealth(health);
    }

    public void destroy() {
        this.setHealth(0);
    }

    public int getScorePoints() {
        return 1;
    }

    protected void setState(State state) {
        this.state = state;
        this.state.onEntry();
    }

    private class Waiting
    implements State {
        private Waiting() {
        }

        public void onEntry() {
            Tank.this.weapon.setShoot(false);
            Tank.this.timer.setDelay(500L);
        }

        public void update(long elapsedTime) {
            if (Tank.this.timer.action(elapsedTime)) {
                Tank.this.setState(new Moving());
            }
        }
    }

    private class Shooting
    implements State {
        private Shooting() {
        }

        public void onEntry() {
            Tank.this.weapon.setShoot(true);
        }

        public void update(long elapsedTime) {
            Tank.this.setState(new Waiting());
        }
    }

    private class Aiming
    implements State {
        private Aiming() {
        }

        public void onEntry() {
            Tank.this.direction = null;
            Tank.this.timer.setDelay(500L);
        }

        public void update(long elapsedTime) {
            if (Tank.this.timer.action(elapsedTime)) {
                Tank.this.setState(new Shooting());
            }
        }
    }

    private class Moving
    implements State {
        private Moving() {
        }

        public void onEntry() {
            Tank.this.targetX = (int)((double)(Tank.this.maxX - Tank.this.minX) * Math.random()) + Tank.this.minX;
            if (Tank.this.getX() < (double)Tank.this.targetX) {
                Tank.this.direction = Direction.RIGHT;
                Tank.this.setHorizontalSpeed(0.05);
            } else {
                Tank.this.direction = Direction.LEFT;
                Tank.this.setHorizontalSpeed(-0.05);
            }
        }

        public void update(long elapsedTime) {
            Tank.this.updateMovement(elapsedTime);
            switch (Tank.this.direction) {
                case LEFT: {
                    if (!(Tank.this.getX() <= (double)Tank.this.targetX)) break;
                    Tank.this.setState(new Aiming());
                    break;
                }
                case RIGHT: {
                    if (!(Tank.this.getX() >= (double)Tank.this.targetX)) break;
                    Tank.this.setState(new Aiming());
                }
            }
        }
    }

    private class Initial
    implements State {
        private Initial() {
        }

        public void onEntry() {
        }

        public void update(long elapsedTime) {
            Tank.this.setState(new Moving());
        }
    }

    private static interface State {
        public void onEntry();

        public void update(long var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Direction {
        LEFT,
        RIGHT;

    }
}

