/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.weapon;

import com.golden.gamedev.object.Timer;
import moagg.model.weapon.FireStrategy;

public class ContinuousFireStrategy
implements FireStrategy {
    private boolean shoot = false;
    private long reloadTime = 0L;
    private State state = new Ready();
    private Timer reloadTimer = new Timer(0);

    public long getReloadTime() {
        return this.reloadTime;
    }

    public void setReloadTime(long reloadTime) {
        this.reloadTime = reloadTime;
    }

    protected void setState(State state) {
        this.state = state;
        this.state.onEntry();
    }

    public void update(long elapsedTime) {
        this.state.update(elapsedTime);
    }

    public boolean isShoot() {
        return this.state.isShoot();
    }

    public void setShoot(boolean shoot) {
        this.state.setShoot(shoot);
        this.shoot = shoot;
    }

    private class Reloading
    implements State {
        private Reloading() {
        }

        public void onEntry() {
            ContinuousFireStrategy.this.reloadTimer.setActive(true);
            ContinuousFireStrategy.this.reloadTimer.setDelay(ContinuousFireStrategy.this.reloadTime);
        }

        public void update(long elapsedTime) {
            if (ContinuousFireStrategy.this.reloadTimer.action(elapsedTime)) {
                ContinuousFireStrategy.this.setState(ContinuousFireStrategy.this.shoot ? new Shooting() : new Ready());
            }
        }

        public boolean isShoot() {
            return false;
        }

        public void setShoot(boolean shoot) {
        }
    }

    private class Shooting
    implements State {
        private Shooting() {
        }

        public void onEntry() {
        }

        public void update(long elapsedTime) {
            ContinuousFireStrategy.this.setState(new Reloading());
        }

        public boolean isShoot() {
            return true;
        }

        public void setShoot(boolean shoot) {
        }
    }

    private class Ready
    implements State {
        private Ready() {
        }

        public void onEntry() {
            ContinuousFireStrategy.this.reloadTimer.setActive(false);
        }

        public void update(long elapsedTime) {
        }

        public boolean isShoot() {
            return false;
        }

        public void setShoot(boolean shoot) {
            if (shoot) {
                ContinuousFireStrategy.this.setState(new Shooting());
            }
        }
    }

    private static interface State {
        public void onEntry();

        public void update(long var1);

        public boolean isShoot();

        public void setShoot(boolean var1);
    }
}

