/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.control;

import java.util.prefs.Preferences;
import moagg.prefs.AbstractPrefs;

public class ControlPrefs
extends AbstractPrefs {
    private static final String PREF_THRUST = "thrust";
    private static final String PREF_ALIGN = "align";
    private static final String PREF_LEFT = "left";
    private static final String PREF_RIGHT = "right";
    private static final String PREF_SHOOT = "shoot";
    private static final String PREF_SCREENSHOT = "screenshot";
    private static final int DEFAULT_THRUST = 38;
    private static final int DEFAULT_ALIGN = 40;
    private static final int DEFAULT_LEFT = 37;
    private static final int DEFAULT_RIGHT = 39;
    private static final int DEFAULT_SHOOT = 32;
    private static final int DEFAULT_SCREENSHOT = 154;
    private int thrust = Integer.MIN_VALUE;
    private int align = Integer.MIN_VALUE;
    private int left = Integer.MIN_VALUE;
    private int right = Integer.MIN_VALUE;
    private int shoot = Integer.MIN_VALUE;
    private int screenShot = Integer.MIN_VALUE;
    private static ControlPrefs instance = new ControlPrefs();

    public static ControlPrefs getInstance() {
        return instance;
    }

    protected ControlPrefs() {
        this.prefs = Preferences.userNodeForPackage(ControlPrefs.class);
        this.thrust = this.prefs.getInt(PREF_THRUST, 38);
        this.align = this.prefs.getInt(PREF_ALIGN, 40);
        this.left = this.prefs.getInt(PREF_LEFT, 37);
        this.right = this.prefs.getInt(PREF_RIGHT, 39);
        this.shoot = this.prefs.getInt(PREF_SHOOT, 32);
        this.screenShot = this.prefs.getInt(PREF_SCREENSHOT, 154);
    }

    public int getThrust() {
        return this.thrust;
    }

    public void setThrust(int thrust) {
        this.thrust = thrust;
        this.prefs.putInt(PREF_THRUST, thrust);
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
        this.prefs.putInt(PREF_ALIGN, align);
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
        this.prefs.putInt(PREF_LEFT, left);
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
        this.prefs.putInt(PREF_RIGHT, right);
    }

    public int getShoot() {
        return this.shoot;
    }

    public void setShoot(int shoot) {
        this.shoot = shoot;
        this.prefs.putInt(PREF_SHOOT, shoot);
    }

    public int getScreenShot() {
        return this.screenShot;
    }

    public void setScreenShot(int screenShot) {
        this.screenShot = screenShot;
        this.prefs.putInt(PREF_SCREENSHOT, screenShot);
    }
}

