/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.score;

import java.io.Serializable;
import java.util.Date;
import moagg.prefs.score.Score;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreEntry
implements Serializable,
Comparable<ScoreEntry> {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ScoreEntry.class);
    private String name;
    private Date date;
    private Score score;

    public ScoreEntry() {
    }

    public ScoreEntry(String name, Score score) {
        this.name = name;
        this.date = new Date();
        this.score = score;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public Score getScore() {
        return this.score;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.name).append(this.date).append(this.score).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScoreEntry)) {
            return false;
        }
        ScoreEntry other = (ScoreEntry)obj;
        return new EqualsBuilder().append(this.name, other.getName()).append(this.date, other.getDate()).append(this.score, other.getScore()).isEquals();
    }

    @Override
    public int compareTo(ScoreEntry other) {
        return new CompareToBuilder().append(this.score, other.getScore()).toComparison();
    }

    public String toString() {
        return this.name + "," + this.date.getTime() + "," + this.score.getWrecks() + "," + this.score.getPoints() + "," + this.score.getElapsedTime();
    }

    public static ScoreEntry fromString(String value) {
        String[] tokens = value.split(",");
        if (tokens.length != 5) {
            log.warn("Ignoring illegal score entry '" + value + "'");
            return null;
        }
        ScoreEntry entry = new ScoreEntry();
        entry.setName(tokens[0]);
        entry.setDate(new Date(Long.parseLong(tokens[1])));
        Score score = new Score();
        score.setWrecks(Integer.parseInt(tokens[2]));
        score.setPoints(Integer.parseInt(tokens[3]));
        score.setElapsedTime(Long.parseLong(tokens[4]));
        entry.setScore(score);
        return entry;
    }
}

