/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBanked;

public final class Cartridge16K_E7
extends CartridgeBanked {
    private byte[] extraRAM = new byte[2048];
    private boolean extraRAMSlice0Active = false;
    private int extraRAMSlice1Offset = 1024;
    private static final int SIZE = 16384;
    private static final int BANK_SIZE = 2048;
    private static final int ROM_FIXED_SLICE_START = 2048;
    private static final int ROM_FIXED_SLICE_OFFSET = 12288;
    private static final int EXTRA_RAM_SLICE1_START = 1024;
    private static final int EXTRA_RAM_SLICE1_BANK_SIZE = 256;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("E7", "16K M-Network"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge16K_E7(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 16384) {
                return null;
            }
            return new CartridgeFormatOption(102, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge16K_E7(ROM rom) {
        super(rom, FORMAT);
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress >= 2304 && this.maskedAddress <= 2559) {
            return this.extraRAM[this.extraRAMSlice1Offset + this.maskedAddress - 2304];
        }
        if (this.extraRAMSlice0Active && this.maskedAddress >= 1024 && this.maskedAddress <= 2047) {
            return this.extraRAM[this.maskedAddress - 1024];
        }
        if (this.maskedAddress < 2048) {
            return this.bytes[this.bankAddressOffset + this.maskedAddress];
        }
        return this.bytes[12288 + this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
        if (this.maskedAddress >= 2048 && this.maskedAddress <= 2303) {
            this.extraRAM[this.extraRAMSlice1Offset + this.maskedAddress - 2048] = b;
        } else if (this.extraRAMSlice0Active && this.maskedAddress <= 1023) {
            this.extraRAM[this.maskedAddress] = b;
        }
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
        if (this.maskedAddress < 4064 || this.maskedAddress > 4075) {
            return;
        }
        if (this.maskedAddress <= 4070) {
            this.bankAddressOffset = 2048 * (this.maskedAddress - 4064);
        } else if (this.maskedAddress == 4071) {
            this.extraRAMSlice0Active = true;
        } else if (this.maskedAddress <= 4075) {
            this.extraRAMSlice1Offset = 1024 + 256 * (this.maskedAddress - 4072);
        }
    }

    @Override
    public Cartridge16K_E7 clone() {
        Cartridge16K_E7 clone = (Cartridge16K_E7)super.clone();
        if (this.extraRAM != null) {
            clone.extraRAM = (byte[])this.extraRAM.clone();
        }
        return clone;
    }

    /* synthetic */ Cartridge16K_E7(ROM rOM, Cartridge16K_E7 cartridge16K_E7) {
        this(rOM);
    }
}

