/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;

public class Cartridge64K_X07
extends CartridgeBankedByBusMonitoring {
    protected static final int BANK_SIZE = 4096;
    protected static final int BANK_14_ADDRESS = 57344;
    protected static final int SIZE = 65536;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("X07", "64K AtariAge"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge64K_X07(rom);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 65536) {
                return null;
            }
            return new CartridgeFormatOption(102, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge64K_X07(ROM rom) {
        super(rom, FORMAT);
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        if ((address & 0x180F) == 2061) {
            this.bankAddressOffset = ((address & 0xF0) >> 4) * 4096;
        } else if (this.bankAddressOffset >= 57344 && (address & 0x1880) == 0) {
            this.bankAddressOffset = ((address & 0x40) == 0 ? 14 : 15) * 4096;
        }
    }
}

