/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;

public class Cartridge8K_0840
extends CartridgeBankedByBusMonitoring {
    protected static final int BANK_SIZE = 4096;
    protected static final int SIZE = 8192;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("0840", "8K Econobanking"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_0840(rom);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 8192) {
                return null;
            }
            return new CartridgeFormatOption(116, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge8K_0840(ROM rom) {
        super(rom, FORMAT);
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        int addrBank = address & 0x1840;
        if (addrBank == 2048) {
            if (this.bankAddressOffset != 0) {
                this.bankAddressOffset = 0;
            }
        } else if (addrBank == 2112 && this.bankAddressOffset != 4096) {
            this.bankAddressOffset = 4096;
        }
    }
}

