/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;

public class Cartridge8K_512K_SB
extends CartridgeBankedByBusMonitoring {
    private final int maxBank;
    protected static final int BANK_SIZE = 4096;
    protected static final int MIN_SIZE = 8192;
    protected static final int MAX_SIZE = 262144;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("SB", "8K-512K Superbanking"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_512K_SB(rom);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length % 4096 != 0 || rom.content.length < 8192 || rom.content.length > 262144) {
                return null;
            }
            return new CartridgeFormatOption(113, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge8K_512K_SB(ROM rom) {
        super(rom, FORMAT);
        this.maxBank = this.bytes.length / 4096 - 1;
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        if ((address & 0x1800) != 2048) {
            return;
        }
        int bank = address & 0x7F;
        if (bank > this.maxBank) {
            return;
        }
        this.bankAddressOffset = bank * 4096;
    }
}

