/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBankedByMaskedRange;

public final class Cartridge8K_64K_EF
extends CartridgeBankedByMaskedRange {
    private static final int MIN_SIZE = 8192;
    private static final int MAX_SIZE = 65536;
    private static final int BANK_SIZE = 4096;
    private static final int BASE_BANKSW_ADDRESS = 4064;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("EF", "8K-64K H. Runner (+RAM)"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_64K_EF(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length % 4096 != 0 || rom.content.length < 8192 || rom.content.length > 65536) {
                return null;
            }
            return new CartridgeFormatOption(114, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_64K_EF(ROM rom) {
        super(rom, FORMAT, 4064, null, 128);
    }

    /* synthetic */ Cartridge8K_64K_EF(ROM rOM, Cartridge8K_64K_EF cartridge8K_64K_EF) {
        this(rOM);
    }
}

