/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.pia;

import java.io.Serializable;
import org.javatari.general.board.BUS16Bits;
import org.javatari.parameters.Parameters;
import org.javatari.utils.Randomizer;

public final class RAM
implements BUS16Bits {
    private final byte[] bytes = new byte[128];
    private static final int ADDRESS_MASK = 127;
    private static final int FRY_ZERO_BITS = Parameters.RAM_FRY_ZERO_BITS;
    private static final int FRY_ONE_BITS = Parameters.RAM_FRY_ONE_BITS;
    private static final float FRY_VARIANCE = Parameters.RAM_FRY_VARIANCE;

    public RAM() {
        Randomizer.instance.nextBytes(this.bytes);
    }

    public void powerOn() {
    }

    public void powerOff() {
    }

    @Override
    public byte readByte(int address) {
        return this.bytes[address & 0x7F];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.bytes[address & 0x7F] = b;
    }

    public void dump() {
        System.out.println("RAM DUMP:");
        int i = 0;
        while (i < this.bytes.length) {
            System.out.printf("%02x ", this.bytes[i]);
            ++i;
        }
        System.out.println();
    }

    public RAMState saveState() {
        RAMState state = new RAMState();
        state.bytes = (byte[])this.bytes.clone();
        return state;
    }

    public void loadState(RAMState state) {
        System.arraycopy(state.bytes, 0, this.bytes, 0, this.bytes.length);
    }

    public void powerFry() {
        int fryOneBits;
        int fryZeroBits;
        float var = 1.0f - FRY_VARIANCE + 2.0f * Randomizer.instance.nextFloat() * FRY_VARIANCE;
        int i = fryZeroBits = (int)(var * (float)FRY_ZERO_BITS);
        while (i > 0) {
            int n = Randomizer.instance.nextInt(128);
            this.bytes[n] = (byte)(this.bytes[n] & (byte)Randomizer.instance.nextInt(256));
            --i;
        }
        int i2 = fryOneBits = (int)(var * (float)FRY_ONE_BITS);
        while (i2 > 0) {
            int n = Randomizer.instance.nextInt(128);
            this.bytes[n] = (byte)(this.bytes[n] | (byte)(1 << Randomizer.instance.nextInt(8)));
            --i2;
        }
    }

    public static class RAMState
    implements Serializable {
        byte[] bytes;
        public static final long serialVersionUID = 2L;
    }
}

