/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.tia.audio;

import org.javatari.atari.tia.audio.AudioGenerator;
import org.javatari.parameters.Parameters;

public final class AudioMonoGenerator
extends AudioGenerator {
    private float lastSample;
    private static final float MAX_AMPLITUDE = Parameters.TIA_AUDIO_MAX_AMPLITUDE;

    @Override
    protected void generateNextSamples(int quant) {
        int i = quant;
        while (i > 0) {
            float mixedSample = this.channel0.nextSample() - this.channel1.nextSample();
            if (mixedSample != this.lastSample) {
                this.lastSample = mixedSample = (mixedSample * 9.0f + this.lastSample) / 10.0f;
            }
            this.samples[this.generatedSamples++] = (byte)(mixedSample * MAX_AMPLITUDE * 127.0f);
            --i;
        }
    }
}

