/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class SBC
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public SBC(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 1) {
            this.ea = this.cpu.fetchImmediateAddress();
            return 2;
        }
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 4;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 4 + (this.cpu.pageCrossed ? 1 : 0);
        }
        if (this.type == 12) {
            this.ea = this.cpu.fetchAbsoluteYAddress();
            return 4 + (this.cpu.pageCrossed ? 1 : 0);
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchIndirectXAddress();
            return 6;
        }
        if (this.type == 32) {
            this.ea = this.cpu.fetchIndirectYAddress();
            return 5 + (this.cpu.pageCrossed ? 1 : 0);
        }
        throw new IllegalStateException("SBC Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        byte b = this.cpu.bus.readByte(this.ea);
        int uB = M6502.toUnsignedByte((int)b);
        byte oldA = this.cpu.A;
        int uOldA = M6502.toUnsignedByte((int)oldA);
        boolean oldCarry = this.cpu.CARRY;
        int aux = oldA - b - (!oldCarry ? 1 : 0);
        int uAux = uOldA - uB - (!oldCarry ? 1 : 0);
        byte newA = (byte)M6502.toUnsignedByte(uAux);
        this.cpu.ZERO = newA == 0;
        this.cpu.NEGATIVE = newA < 0;
        this.cpu.OVERFLOW = aux > 127 || aux < -128;
        boolean bl = this.cpu.CARRY = uAux >= 0;
        if (!this.cpu.DECIMAL_MODE) {
            this.cpu.A = newA;
            return;
        }
        uAux = (uOldA & 0xF) - (uB & 0xF) - (!oldCarry ? 1 : 0);
        if (uAux < 0) {
            uAux = (uAux - 6 & 0xF) - 16;
        }
        if ((uAux = (uOldA & 0xF0) - (uB & 0xF0) + uAux) < 0) {
            uAux -= 96;
        }
        this.cpu.A = (byte)M6502.toUnsignedByte(uAux);
    }
}

