/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class uLAX
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uLAX(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 3;
        }
        if (this.type == 22) {
            this.ea = this.cpu.fetchZeroPageYAddress();
            return 4;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 4;
        }
        if (this.type == 12) {
            this.ea = this.cpu.fetchAbsoluteYAddress();
            return 4 + (this.cpu.pageCrossed ? 1 : 0);
        }
        if (this.type == 31) {
            this.ea = this.cpu.fetchIndirectXAddress();
            return 6;
        }
        if (this.type == 32) {
            this.ea = this.cpu.fetchIndirectYAddress();
            return 5 + (this.cpu.pageCrossed ? 1 : 0);
        }
        throw new IllegalStateException("uLAX Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        byte val;
        this.cpu.A = val = this.cpu.bus.readByte(this.ea);
        this.cpu.X = val;
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

