/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.cartridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.javatari.utils.Terminator;

public class BuiltInROM {
    public final String label;
    public final String labelColors;
    public final URL url;
    private static final String ROMS_FOLDER = "roms";
    private static final String ROMS_LIST_FILE = "roms.txt";

    public BuiltInROM(String label, String labelColors, URL romURL) {
        this.label = label;
        this.labelColors = labelColors;
        this.url = romURL;
    }

    public static ArrayList<BuiltInROM> all() {
        ArrayList<BuiltInROM> result = new ArrayList<BuiltInROM>();
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("roms/roms.txt");
        if (stream == null) {
            return result;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] labelSpecs;
                    String location;
                    String[] specs;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || (specs = line.split("@")).length == 0 || (location = specs[specs.length - 1].trim()).isEmpty()) continue;
                    URL url = BuiltInROM.fileNameAsResourceURL(location);
                    if (url == null) {
                        try {
                            url = new URL(location);
                        }
                        catch (Exception e) {
                            BuiltInROM.errorMessage(location);
                            Terminator.terminate();
                        }
                    }
                    String label = null;
                    String labelColors = null;
                    if (specs.length > 1 && !specs[0].trim().isEmpty() && (labelSpecs = specs[0].trim().split("%")).length != 0) {
                        label = labelSpecs[0].trim();
                        if (labelSpecs.length > 1 && !labelSpecs[1].trim().isEmpty()) {
                            labelColors = labelSpecs[1].trim();
                        }
                    }
                    result.add(new BuiltInROM(label, labelColors, url));
                }
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static URL fileNameAsResourceURL(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResource("roms/" + fileName);
    }

    private static void errorMessage(String location) {
        String tLoc;
        System.out.println("Invalid Built-in ROM location (file not found or invalid external URL): " + location);
        String string = tLoc = location == null ? "" : location.trim();
        if (tLoc.length() > 80) {
            tLoc = String.valueOf(tLoc.substring(0, 79)) + "...";
        }
        JOptionPane.showMessageDialog(null, "Invalid Built-in ROM location.\nFile not found or invalid external URL:\n\n" + tLoc, "Error in Built-in ROMs", 0);
    }
}

