/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.geom.PgBndConstraint;
import jv.geom.PgElementEdge;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgBndPolygon
extends PgPolygon {
    protected static double MAX_PASTE_ANGLE = 50.0;
    protected static double MAX_LOGIC_ANGLE = 20.0;
    protected PgElementSet m_triang;
    protected PiVector m_vertexInd = new PiVector();
    protected PiVector m_elementInd = new PiVector();
    protected PiVector m_neighbourLocInd = new PiVector();
    protected boolean m_bConforming = true;
    protected PgBndConstraint m_bndConstraint;
    private static /* synthetic */ Class class$jv$geom$PgBndPolygon;

    public int bndcmp(PgBndPolygon pgBndPolygon, double d) {
        if (pgBndPolygon == null) {
            PsDebug.warning("missing argument");
            return 0;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.warning("bnd's associated to different elementSets");
            return 0;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return 0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.warning("bnd with less than 2 points");
            return 0;
        }
        int n = this.m_numVertices;
        PdVector[] pdVectorArray = this.m_triang.m_vertex;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        if (PdVector.dist(pdVectorArray[nArray[0]], pdVectorArray[nArray2[0]]) < d && PdVector.dist(pdVectorArray[nArray[n - 1]], pdVectorArray[nArray2[n - 1]]) < d && PdVector.dist(pdVectorArray[nArray[1]], pdVectorArray[nArray2[1]]) < d) {
            return 1;
        }
        if (PdVector.dist(pdVectorArray[nArray[0]], pdVectorArray[nArray2[n - 1]]) < d && PdVector.dist(pdVectorArray[nArray[n - 1]], pdVectorArray[nArray2[0]]) < d && PdVector.dist(pdVectorArray[nArray[1]], pdVectorArray[nArray2[n - 2]]) < d) {
            return -1;
        }
        return 0;
    }

    public int getNumElements() {
        int n = this.getNumVertices() - 1;
        if (!this.isConforming()) {
            ++n;
        }
        return n;
    }

    public boolean merge(PgBndPolygon pgBndPolygon) {
        if (pgBndPolygon == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.warning("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.warning("bnd's less than 2 points", this);
            return false;
        }
        int n = this.m_numVertices;
        int n2 = this.m_numVertices + pgBndPolygon.m_numVertices;
        super.merge(pgBndPolygon);
        this.setNumVertices(n2 - 1);
        this.m_vertexInd.copy(n, pgBndPolygon.m_vertexInd, 1, pgBndPolygon.m_numVertices - 1);
        this.m_elementInd.copy(n - 1, pgBndPolygon.m_elementInd, 0, pgBndPolygon.m_numVertices - 1);
        this.m_neighbourLocInd.copy(n - 1, pgBndPolygon.m_neighbourLocInd, 0, pgBndPolygon.m_numVertices - 1);
        return true;
    }

    public boolean constrain() {
        if (this.m_bndConstraint == null) {
            return true;
        }
        if (this.m_triang == null) {
            PsDebug.warning("missing element set.");
            return true;
        }
        PdVector pdVector = this.m_bndConstraint.m_start;
        PdVector pdVector2 = this.m_bndConstraint.m_dir;
        PdVector pdVector3 = this.m_bndConstraint.m_vec1;
        PdVector pdVector4 = this.m_bndConstraint.m_vec2;
        PdVector[] pdVectorArray = this.m_triang.getVertices();
        if (this.m_bndConstraint.hasShape(4)) {
            int n = 0;
            while (n < this.m_numVertices) {
                PuVectorGeom.projectPointToLine(pdVectorArray[this.m_vertexInd.m_data[n]], pdVectorArray[this.m_vertexInd.m_data[n]], pdVector, pdVector2);
                ++n;
            }
        } else if (this.m_bndConstraint.hasShape(5)) {
            int n = 0;
            while (n < this.m_numVertices) {
                PuVectorGeom.projectPointToPlane(pdVectorArray[this.m_vertexInd.m_data[n]], pdVectorArray[this.m_vertexInd.m_data[n]], pdVector, pdVector2);
                ++n;
            }
        } else if (this.m_bndConstraint.hasShape(11)) {
            double d = pdVector3.dist(pdVector);
            int n = 0;
            while (n < this.m_numVertices) {
                PuVectorGeom.projectPointToCircle(pdVectorArray[this.m_vertexInd.m_data[n]], pdVectorArray[this.m_vertexInd.m_data[n]], pdVector3, pdVector4, d);
                ++n;
            }
        } else {
            PsDebug.warning("not implemented for this shape");
            return false;
        }
        this.assignVertices();
        return true;
    }

    public boolean bnd_paste(PgBndPolygon pgBndPolygon, int n) {
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return false;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return false;
        }
        if (!(n == 11 || n == 12 || n == 21 || n == 22)) {
            PsDebug.error("type must be 11, 12, 21 or 22", this);
            return false;
        }
        if (n == 11 || n == 12) {
            this.invert();
        }
        if (n == 12 || n == 22) {
            pgBndPolygon.invert();
        }
        return this.merge(pgBndPolygon);
    }

    public boolean bnd_id(PgBndPolygon pgBndPolygon, int n) {
        int n2;
        int n3;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return false;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return false;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return false;
        }
        int n4 = this.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        if (n < 0) {
            pgBndPolygon.invert();
        }
        int n5 = 0;
        while (n5 < n4 - 1) {
            int n6 = this.m_elementInd.m_data[n5];
            int n7 = pgBndPolygon.m_elementInd.m_data[n5];
            n3 = this.m_triang.getNeighbourLocInd(n7, nArray2[n5], nArray2[n5 + 1]);
            this.m_triang.m_neighbour[n7].m_data[n3] = this.m_elementInd.m_data[n5];
            n3 = this.m_triang.getNeighbourLocInd(n6, nArray[n5], nArray[n5 + 1]);
            this.m_triang.m_neighbour[n6].m_data[n3] = pgBndPolygon.m_elementInd.m_data[n5];
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            n2 = 0;
            while (n2 < this.m_triang.m_numElements) {
                this.m_triang.m_element[n2].changeValue(nArray2[n5], nArray[n5]);
                ++n2;
            }
            this.m_triang.m_vertex[nArray2[n5]].setTag(2);
            ++n5;
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_triang.m_bndList;
        n2 = 0;
        while (n2 < pgBndPolygonArray.length) {
            PgBndPolygon pgBndPolygon2 = pgBndPolygonArray[n2];
            if (pgBndPolygon2 != null && pgBndPolygon2 != this && pgBndPolygon2 != pgBndPolygon && !pgBndPolygon2.hasTag(2)) {
                n3 = pgBndPolygon2.getNumVertices();
                n5 = 0;
                while (n5 < n4) {
                    pgBndPolygon2.m_vertexInd.changeValue(n3, nArray2[n5], nArray[n5]);
                    ++n5;
                }
            }
            ++n2;
        }
        this.setTag(2);
        pgBndPolygon.setTag(2);
        return true;
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public void makeConforming() {
        if (this.isConforming()) {
            return;
        }
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return;
        }
        this.setNumVertices(this.m_numVertices + 1);
        PiVector piVector = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices - 1) {
            int n3 = this.m_elementInd.m_data[n2];
            piVector = this.m_triang.m_element[n3];
            n = this.m_neighbourLocInd.m_data[n2];
            this.m_vertexInd.m_data[n2] = piVector.m_data[(n + 1) % piVector.getSize()];
            if (this.m_triang.m_neighbour[n3].m_data[n] > -1) {
                PsDebug.warning("neighbourLocInd wrong");
            }
            ++n2;
        }
        this.m_vertexInd.m_data[this.m_numVertices - 1] = piVector.m_data[(n + 2) % piVector.getSize()];
        this.m_bConforming = true;
        this.assignVertices();
    }

    public static void bndcpy(int n, int n2, int n3, PgBndPolygon pgBndPolygon, PgBndPolygon pgBndPolygon2) {
        int n4 = 0;
        while (n4 < n3) {
            pgBndPolygon2.m_vertexInd.m_data[n2 + n4] = pgBndPolygon.m_vertexInd.m_data[n + n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            pgBndPolygon2.m_elementInd.m_data[n2 + n4] = pgBndPolygon.m_elementInd.m_data[n + n4];
            ++n4;
        }
    }

    public static void bndcp(int n, int n2, int n3, PgBndPolygon pgBndPolygon, PgBndPolygon pgBndPolygon2) {
        int n4 = 0;
        while (n4 < n3 + 1) {
            pgBndPolygon2.m_vertexInd.m_data[n2 + n4] = pgBndPolygon.m_vertexInd.m_data[n + n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            pgBndPolygon2.m_elementInd.m_data[n2 + n4] = pgBndPolygon.m_elementInd.m_data[n + n4];
            ++n4;
        }
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexInd.setSize(n);
        if (n > 0) {
            this.m_elementInd.setSize(n - 1);
            this.m_neighbourLocInd.setSize(n - 1);
        }
    }

    public int bndtst(double d) {
        if (this.m_triang == null) {
            PsDebug.error("missing associated elementSet", this);
            return -1;
        }
        if (this.m_numVertices < 2) {
            PsDebug.error("bnd has less than 2 points", this);
            return -1;
        }
        int n = this.m_numVertices;
        int n2 = 0;
        PdVector[] pdVectorArray = this.m_triang.m_vertex;
        int[] nArray = this.m_vertexInd.m_data;
        int n3 = 1;
        while (n3 < n) {
            if (PdVector.dist(pdVectorArray[nArray[0]], pdVectorArray[nArray[n3]]) < d) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == n - 1) {
            return 1;
        }
        return 0;
    }

    public double bnd_dist(PgBndPolygon pgBndPolygon) {
        double d;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return 1000.0;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 1000.0;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return 1000.0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 1000.0;
        }
        int n = this.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        double d2 = PdVector.sqrDist(this.m_triang.m_vertex[nArray[0]], this.m_triang.m_vertex[nArray2[0]]);
        if (d2 <= (d = PdVector.sqrDist(this.m_triang.m_vertex[nArray[0]], this.m_triang.m_vertex[nArray2[n - 1]]))) {
            int n2 = 1;
            while (n2 < n) {
                d = PdVector.sqrDist(this.m_triang.m_vertex[nArray[n2]], this.m_triang.m_vertex[nArray2[n2]]);
                d2 = Math.max(d2, d);
                ++n2;
            }
            d = Math.sqrt(d2);
        } else {
            d2 = d;
            int n3 = 1;
            while (n3 < n) {
                d = PdVector.sqrDist(this.m_triang.m_vertex[nArray[n3]], this.m_triang.m_vertex[nArray2[n - 1 - n3]]);
                d2 = Math.max(d2, d);
                ++n3;
            }
            d = -Math.sqrt(d2);
        }
        return d;
    }

    public int bnd_cmp_logic(PgBndPolygon pgBndPolygon, double d) {
        PdVector pdVector;
        PdVector pdVector2;
        PdVector pdVector3;
        double d2;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return 0;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 0;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return 0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 0;
        }
        int n = this.m_numVertices;
        int n2 = pgBndPolygon.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        if (PdVector.sqrDist(this.m_triang.m_vertex[nArray[0]], this.m_triang.m_vertex[nArray2[0]]) < d && PdVector.sqrDist(this.m_triang.m_vertex[nArray[n - 1]], this.m_triang.m_vertex[nArray2[n2 - 1]]) < d) {
            PdVector pdVector4 = this.m_triang.m_vertex[nArray[0]];
            PdVector pdVector5 = this.m_triang.m_vertex[nArray[1]];
            PdVector pdVector6 = this.m_triang.m_vertex[nArray2[1]];
            double d3 = PdVector.angle(pdVector4, pdVector5, pdVector6);
            if (Math.abs(d3) < MAX_LOGIC_ANGLE) {
                return 1;
            }
        } else if (PdVector.sqrDist(this.m_triang.m_vertex[nArray[0]], this.m_triang.m_vertex[nArray2[n2 - 1]]) < d && PdVector.sqrDist(this.m_triang.m_vertex[nArray[n - 1]], this.m_triang.m_vertex[nArray2[0]]) < d && Math.abs(d2 = PdVector.angle(pdVector3 = this.m_triang.m_vertex[nArray[0]], pdVector2 = this.m_triang.m_vertex[nArray[1]], pdVector = this.m_triang.m_vertex[nArray2[n2 - 2]])) < MAX_LOGIC_ANGLE) {
            return -1;
        }
        return 0;
    }

    public boolean makeElementInd() {
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return false;
        }
        int n = 0;
        while (n < this.m_numVertices - 1) {
            PgElementEdge pgElementEdge = this.m_triang.getEdge(this.m_vertexInd.m_data[n], this.m_vertexInd.m_data[n + 1]);
            if (pgElementEdge == null) {
                PsDebug.warning("edge not found between vertices v0=" + this.m_vertexInd.m_data[n] + " and v1=" + this.m_vertexInd.m_data[n + 1]);
                return false;
            }
            this.m_elementInd.m_data[n] = pgElementEdge.getElementInd(0);
            this.m_neighbourLocInd.m_data[n] = pgElementEdge.getNeighbourLocInd(0);
            ++n;
        }
        this.assignVertices();
        return true;
    }

    public boolean invert() {
        if (this.m_numVertices < 2) {
            PsDebug.error("invert: bnd has less than 2 points", this);
            return false;
        }
        this.m_vertexInd.invert(this.m_numVertices);
        this.m_elementInd.invert(this.m_numVertices - 1);
        return true;
    }

    public Object clone() {
        PgBndPolygon pgBndPolygon = (PgBndPolygon)super.clone();
        if (pgBndPolygon == null) {
            return null;
        }
        pgBndPolygon.m_triang = null;
        if (this.m_vertexInd != null) {
            pgBndPolygon.m_vertexInd = (PiVector)this.m_vertexInd.clone();
        }
        if (this.m_elementInd != null) {
            pgBndPolygon.m_elementInd = (PiVector)this.m_elementInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            pgBndPolygon.m_neighbourLocInd = (PiVector)this.m_neighbourLocInd.clone();
        }
        if (this.m_bndConstraint != null) {
            pgBndPolygon.m_bndConstraint = (PgBndConstraint)this.m_bndConstraint.clone();
        }
        return pgBndPolygon;
    }

    public static boolean bndinv(int n, int n2, int n3, PgBndPolygon pgBndPolygon, PgBndPolygon pgBndPolygon2) {
        if (n + n3 > pgBndPolygon.m_numVertices || n2 < n3 - 1) {
            PsDebug.error("bndinv: invalid offsets", pgBndPolygon);
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            pgBndPolygon2.m_vertexInd.m_data[n2 - n4] = pgBndPolygon.m_vertexInd.m_data[n + n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n3 - 1) {
            pgBndPolygon2.m_elementInd.m_data[n2 - 1 - n4] = pgBndPolygon.m_elementInd.m_data[n + n4];
            ++n4;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgBndPolygon *********\n");
        stringBuffer.append("\t MAX_PASTE_ANGLE = " + MAX_PASTE_ANGLE + "\n");
        stringBuffer.append("\t MAX_LOGIC_ANGLE = " + MAX_LOGIC_ANGLE + "\n");
        stringBuffer.append("\t is conforming = " + this.isConforming() + "\n");
        stringBuffer.append("\t ******* m_vertexInd *******\n");
        if (this.m_vertexInd == null) {
            stringBuffer.append("\t m_vertexInd = null\n");
        } else {
            stringBuffer.append("\t m_vertexInd" + this.m_vertexInd.toShortString());
        }
        stringBuffer.append("\t ******* m_elementInd *******\n");
        if (this.m_elementInd == null) {
            stringBuffer.append("\t m_elementInd = null\n");
        } else {
            stringBuffer.append("\t m_elementInd = " + this.m_elementInd.toShortString());
        }
        stringBuffer.append("\t ******* m_neighbourLocInd *******\n");
        if (this.m_neighbourLocInd == null) {
            stringBuffer.append("\t m_neighbourLocInd = null\n");
        } else {
            stringBuffer.append("\t m_neighbourLocInd = " + this.m_neighbourLocInd.toShortString());
        }
        stringBuffer.append("\t ******* m_bndConstraint *******\n");
        if (this.m_bndConstraint == null) {
            stringBuffer.append("\t m_bndConstraint = null\n");
        } else {
            stringBuffer.append("\t " + this.m_bndConstraint.toString());
        }
        return stringBuffer.toString();
    }

    public PgBndPolygon(int n) {
        super(n);
        if (this.getClass() == (class$jv$geom$PgBndPolygon != null ? class$jv$geom$PgBndPolygon : (class$jv$geom$PgBndPolygon = PgBndPolygon.class$("jv.geom.PgBndPolygon")))) {
            this.init();
        }
    }

    public PiVector getVertexInd() {
        return this.m_vertexInd;
    }

    public PiVector getElementInd() {
        return this.m_elementInd;
    }

    public PgBndConstraint getBndConstraint() {
        return this.m_bndConstraint;
    }

    public void setBndConstraint(PgBndConstraint pgBndConstraint) {
        this.m_bndConstraint = pgBndConstraint;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygon)) {
            return false;
        }
        PgBndPolygon pgBndPolygon = (PgBndPolygon)pgGeometry;
        PgBndPolygon pgBndPolygon2 = (PgBndPolygon)pgGeometry2;
        PgBndPolygon pgBndPolygon3 = d > 0.5 ? pgBndPolygon : pgBndPolygon2;
        this.m_vertexInd.copy(pgBndPolygon3.m_vertexInd);
        this.m_elementInd.copy(pgBndPolygon3.m_elementInd);
        this.m_neighbourLocInd.copy(pgBndPolygon3.m_neighbourLocInd);
        if (pgBndPolygon.m_bndConstraint == null || pgBndPolygon2.m_bndConstraint != null) {
            // empty if block
        }
        return true;
    }

    public PgElementSet getElementSet() {
        return this.m_triang;
    }

    public void setElementSet(PgElementSet pgElementSet) {
        this.m_triang = pgElementSet;
    }

    public int bnd_cmp_paste(PgBndPolygon pgBndPolygon, double d) {
        PdVector pdVector;
        PdVector pdVector2;
        PdVector pdVector3;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return 0;
        }
        if (this.m_triang != pgBndPolygon.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 0;
        }
        int n = this.m_numVertices;
        int n2 = pgBndPolygon.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        int n3 = 0;
        if (PdVector.dist(this.m_triang.m_vertex[nArray[0]], this.m_triang.m_vertex[nArray2[0]]) < d) {
            n3 = 11;
            pdVector3 = this.m_triang.m_vertex[nArray[0]];
            pdVector2 = this.m_triang.m_vertex[nArray[1]];
            pdVector = this.m_triang.m_vertex[nArray2[1]];
        } else if (PdVector.dist(this.m_triang.m_vertex[nArray[0]], this.m_triang.m_vertex[nArray2[n2 - 1]]) < d) {
            n3 = 12;
            pdVector3 = this.m_triang.m_vertex[nArray[0]];
            pdVector2 = this.m_triang.m_vertex[nArray[1]];
            pdVector = this.m_triang.m_vertex[nArray2[n2 - 2]];
        } else if (PdVector.dist(this.m_triang.m_vertex[nArray[n - 1]], this.m_triang.m_vertex[nArray2[0]]) < d) {
            n3 = 21;
            pdVector3 = this.m_triang.m_vertex[nArray[n - 1]];
            pdVector2 = this.m_triang.m_vertex[nArray[n - 2]];
            pdVector = this.m_triang.m_vertex[nArray2[1]];
        } else if (PdVector.dist(this.m_triang.m_vertex[nArray[n - 1]], this.m_triang.m_vertex[nArray2[n2 - 1]]) < d) {
            n3 = 22;
            pdVector3 = this.m_triang.m_vertex[nArray[n - 1]];
            pdVector2 = this.m_triang.m_vertex[nArray[n - 2]];
            pdVector = this.m_triang.m_vertex[nArray2[n2 - 2]];
        } else {
            return 0;
        }
        double d2 = PdVector.angle(pdVector3, pdVector, pdVector2);
        if (Math.abs(d2 - 180.0) > MAX_PASTE_ANGLE) {
            return 0;
        }
        return n3;
    }

    public void makeNonConforming() {
        if (!this.isConforming()) {
            return;
        }
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return;
        }
        this.setNumVertices(this.m_numVertices - 1);
        int n = 0;
        while (n < this.m_numVertices) {
            int n2 = this.m_elementInd.m_data[n];
            PiVector piVector = this.m_triang.m_element[n2];
            int n3 = this.m_neighbourLocInd.m_data[n];
            this.m_vertexInd.m_data[n] = piVector.m_data[n3];
            if (this.m_triang.m_neighbour[n2].m_data[n3] > -1) {
                PsDebug.warning("neighbourLocInd wrong");
            }
            ++n;
        }
        this.m_bConforming = false;
        this.assignVertices();
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgBndPolygon)) {
            return;
        }
        PgBndPolygon pgBndPolygon = (PgBndPolygon)psObject;
        this.m_vertexInd.copy(0, pgBndPolygon.getVertexInd(), 0, this.m_numVertices);
        this.m_elementInd.copy(0, pgBndPolygon.getElementInd(), 0, this.m_numVertices - 1);
        this.m_neighbourLocInd.copy(0, pgBndPolygon.getNeighbourLocInd(), 0, this.m_numVertices - 1);
        this.m_bConforming = pgBndPolygon.isConforming();
        PgBndConstraint pgBndConstraint = pgBndPolygon.getBndConstraint();
        if (pgBndConstraint != null) {
            if (this.m_bndConstraint == null) {
                this.m_bndConstraint = new PgBndConstraint(pgBndConstraint.m_dim);
            }
            this.m_bndConstraint.copy(pgBndConstraint);
        } else {
            this.m_bndConstraint = null;
        }
        this.assignVertices();
    }

    public boolean applyModelingMatrix() {
        if (this.m_bndConstraint == null) {
            return true;
        }
        if (!this.hasModelMatrix()) {
            return false;
        }
        return this.m_bndConstraint.applyModelingMatrix(this.m_modelMatrix);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean assignVertices() {
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return false;
        }
        int n = this.m_triang.getNumVertices();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertexInd.m_data[n2] == -1 || this.m_vertexInd.m_data[n2] >= n) {
                this.setTag(2);
                return false;
            }
            this.m_vertex[n2].copy(this.m_triang.m_vertex[this.m_vertexInd.m_data[n2]]);
            ++n2;
        }
        return true;
    }

    public void init() {
        super.init();
        this.clearTag(2);
        this.m_bndConstraint = null;
    }

    public PiVector getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public boolean bndsh(int n) {
        if (this.m_numVertices < 2) {
            PsDebug.error("bndsh: bnd has less than 2 points", this);
            return false;
        }
        int n2 = this.m_numVertices;
        int n3 = n2 - 1 - n;
        int n4 = 0;
        while (n4 <= n3) {
            this.m_vertexInd.m_data[n2 - 1 - n4] = this.m_vertexInd.m_data[n3 - n4];
            ++n4;
        }
        n4 = 1;
        while (n4 <= n3) {
            this.m_elementInd.m_data[n2 - 1 - n4] = this.m_elementInd.m_data[n3 - n4];
            ++n4;
        }
        n4 = n - 1;
        while (n4 >= 0) {
            this.m_elementInd.m_data[n4] = -1;
            --n4;
        }
        return true;
    }

    public boolean bnd_shrink() {
        int n;
        PgBndPolygon[] pgBndPolygonArray;
        int n2;
        if (this.m_triang == null) {
            PsDebug.error("missing associated elementSet", this);
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.error("bnd has less than 2 points", this);
            return false;
        }
        int n3 = this.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3 - 1) {
            int n5;
            n2 = this.m_elementInd.m_data[n4];
            pgBndPolygonArray = this.m_triang.getElement(n2);
            PiVector piVector = this.m_triang.getNeighbour(n2);
            int n6 = pgBndPolygonArray.getSize();
            if (n6 < 3) {
                PsDebug.error("elementSet corrupt with element size < 3", this);
                return false;
            }
            int n7 = pgBndPolygonArray.getIndexOf(nArray[n4]);
            int n8 = pgBndPolygonArray.getIndexOf(nArray[n4 + 1]);
            if (n6 == 3) {
                n5 = piVector.m_data[n7];
                int n9 = piVector.m_data[n8];
                if (n5 != -1) {
                    this.m_triang.m_neighbour[n5].changeValue(n2, n9);
                }
                if (n9 != -1) {
                    this.m_triang.m_neighbour[n9].changeValue(n2, n5);
                }
                pgBndPolygonArray.setConstant(nArray[0]);
                pgBndPolygonArray.setTag(2);
                piVector.setConstant(-1);
                piVector.setTag(2);
                bl = true;
            } else {
                n5 = (n7 + 1) % n6 == n8 ? n7 : n8;
                piVector.m_data[(n5 - 1 + n6) % n6] = piVector.m_data[n5];
                n = n5;
                while (n < n6 - 1) {
                    pgBndPolygonArray.m_data[n] = pgBndPolygonArray.m_data[n + 1];
                    piVector.m_data[n] = piVector.m_data[n + 1];
                    ++n;
                }
                int[] nArray2 = piVector.getEntries();
                this.m_triang.setDimOfElement(n2, n6 - 1);
                n = 0;
                while (n < n6 - 1) {
                    piVector.m_data[n] = nArray2[n];
                    ++n;
                }
            }
            ++n4;
        }
        n2 = this.m_triang.getNumElements();
        n = 1;
        while (n < n3) {
            n4 = 0;
            while (n4 < n2) {
                this.m_triang.m_element[n4].changeValue(nArray[n], nArray[0]);
                ++n4;
            }
            this.m_triang.m_vertex[nArray[n]].setTag(2);
            ++n;
        }
        pgBndPolygonArray = this.m_triang.m_bndList;
        n4 = 0;
        while (n4 < pgBndPolygonArray.length) {
            if (pgBndPolygonArray[n4] != null && pgBndPolygonArray[n4] != this && !pgBndPolygonArray[n4].hasTag(2)) {
                n = 1;
                while (n < n3) {
                    pgBndPolygonArray[n4].m_vertexInd.changeValue(pgBndPolygonArray[n4].m_numVertices, nArray[n], nArray[0]);
                    ++n;
                }
            }
            ++n4;
        }
        this.setTag(2);
        if (bl) {
            this.m_triang.removeMarkedElements();
        }
        return true;
    }
}

