/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuProj;
import jv.vecmath.PuVectorGeom;

public class PgPointSet
extends PgGeometry {
    protected boolean m_bEnabledIndexLabels;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected int m_dimOfColors;
    protected PgTexture m_texture;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected PdVector[] m_vertexTexture;
    protected PuDouble m_shininess;
    protected PdColor m_specularColor;
    protected PuDouble m_transparency;
    protected boolean m_bShowTransparency;
    protected PdVector[] m_vertex;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected PdVector m_vertexSize;
    protected boolean m_bShowVertexSizes;
    protected int m_dimOfVectors;
    protected int m_numVectorFields;
    protected Vector m_vectorField;
    protected PgVectorField m_selectedVectorField;
    protected boolean m_bShowSingleVectorField;
    protected boolean m_bShowVectorFields;
    protected boolean m_bShowVectorArrows;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected boolean m_bShowVertexOutline;
    protected PuDouble m_globalVertexSize;
    protected boolean m_bShowVertexColors;
    protected PdColor m_globalVertexColor;
    protected PdColor m_globalVertexTagColor;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected PuDouble m_globalVertexNormalLength;
    protected PuDouble m_globalVertexNormalSize;
    protected PdColor m_globalVertexNormalColor;
    protected Vector m_geomItem;
    protected boolean m_bUpdateSender = false;
    private static /* synthetic */ Class class$jv$geom$PgPointSet;

    public Image getTextureImage() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImage();
    }

    public void setTextureImage(Image image) {
        if (image == null) {
            PsDebug.warning("missing texture image");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImage(image);
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 50: {
                this.showVertices(bl);
                return;
            }
        }
        super.setState(n, bl);
    }

    public void computePlane(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d5 = (d3 - d) / (-1.0 + (double)n);
        double d6 = (d4 - d2) / (-1.0 + (double)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d7 = d5 * (double)n4;
            int n5 = 0;
            while (n5 < n2) {
                double d8 = d6 * (double)n5;
                if (this.m_dim > 2) {
                    this.m_vertex[n3].setConstant(0.0);
                }
                this.m_vertex[n3].m_data[0] = d + d7;
                this.m_vertex[n3].m_data[1] = d2 + d8;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
            return;
        }
        this.setVertexNormals(null);
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        int n = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector3 = new PdVector(3);
        pdVector2.normalize();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_dim != 3) {
                pdVector3.copyArray(this.m_vertex[n2]);
            } else {
                pdVector3 = this.m_vertex[n2];
            }
            d = PuVectorGeom.distOfPointToLine(pdVector3, pdVector, pdVector2);
            if (!(d >= d2)) {
                d2 = d;
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(this.m_vertex[n]);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(d2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        return pvPickEvent;
    }

    public boolean makeVertexNormals() {
        this.assureVertexNormals();
        if (this.getClass() != (class$jv$geom$PgPointSet != null ? class$jv$geom$PgPointSet : (class$jv$geom$PgPointSet = PgPointSet.class$("jv.geom.PgPointSet")))) {
            return true;
        }
        return true;
    }

    public boolean hasVertexNormals() {
        return this.m_vertexNormal != null && this.m_vertexNormal.length == this.m_maxNumVertices;
    }

    public void removeVertexNormals() {
        this.setVertexNormals(null);
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n = 0;
            while (n < pgVectorFieldArray.length) {
                if (!pgVectorFieldArray[n].isShowingIndividualMaterial()) {
                    pgVectorFieldArray[n].setGlobalVectorColor(color);
                }
                ++n;
            }
        }
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > 1) {
            d2 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d3 = Math.PI / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d4 = d2 * (double)n4;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            int n5 = 0;
            while (n5 < n2) {
                double d7 = -1.5707963267948966 + d3 * (double)n5;
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                this.m_vertex[n3].m_data[0] = d * d6 * d9;
                this.m_vertex[n3].m_data[1] = d * d5 * d9;
                this.m_vertex[n3].m_data[2] = d * d8;
                this.m_vertexNormal[n3].m_data[0] = d6 * d9;
                this.m_vertexNormal[n3].m_data[1] = d5 * d9;
                this.m_vertexNormal[n3].m_data[2] = d8;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public boolean hasTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_vertex[n].hasTag(n2);
    }

    public int addVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return -1;
        }
        int n = this.m_numVertices;
        if (n == this.m_maxNumVertices) {
            this.setMaxNumVertices((int)((double)(n + 1) * 1.2));
        }
        this.setNumVertices(n + 1);
        this.setVertex(n, pdVector);
        return n;
    }

    public Object clone() {
        PgPointSet pgPointSet = (PgPointSet)super.clone();
        if (pgPointSet == null) {
            return null;
        }
        pgPointSet.m_globalVertexSize = (PuDouble)this.m_globalVertexSize.clone();
        pgPointSet.m_globalVertexSize.setParent(pgPointSet);
        pgPointSet.m_globalVertexColor = (PdColor)this.m_globalVertexColor.clone();
        pgPointSet.m_globalVertexColor.setParent(pgPointSet);
        pgPointSet.m_globalVertexTagColor = (PdColor)this.m_globalVertexTagColor.clone();
        pgPointSet.m_globalVertexTagColor.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalLength = (PuDouble)this.m_globalVertexNormalLength.clone();
        pgPointSet.m_globalVertexNormalLength.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalSize = (PuDouble)this.m_globalVertexNormalSize.clone();
        pgPointSet.m_globalVertexNormalSize.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalColor = (PdColor)this.m_globalVertexNormalColor.clone();
        pgPointSet.m_globalVertexNormalColor.setParent(pgPointSet);
        pgPointSet.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        pgPointSet.m_globalVectorSize.setParent(pgPointSet);
        pgPointSet.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        pgPointSet.m_globalVectorLength.setParent(pgPointSet);
        pgPointSet.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        pgPointSet.m_globalVectorColor.setParent(pgPointSet);
        pgPointSet.m_shininess = (PuDouble)this.m_shininess.clone();
        pgPointSet.m_shininess.setParent(pgPointSet);
        pgPointSet.m_specularColor = (PdColor)this.m_specularColor.clone();
        pgPointSet.m_specularColor.setParent(pgPointSet);
        pgPointSet.m_transparency = (PuDouble)this.m_transparency.clone();
        pgPointSet.m_transparency.setParent(pgPointSet);
        if (this.m_texture != null) {
            pgPointSet.m_texture = (PgTexture)this.m_texture.clone();
            pgPointSet.m_texture.setParent(pgPointSet);
        }
        if (this.m_vertexTexture != null) {
            pgPointSet.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_vertex != null) {
            pgPointSet.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            pgPointSet.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexNormal != null) {
            pgPointSet.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vertexSize != null) {
            pgPointSet.m_vertexSize = (PdVector)this.m_vertexSize.clone();
        }
        if (this.m_vectorField != null) {
            pgPointSet.m_vectorField = null;
            pgPointSet.m_numVectorFields = 0;
            pgPointSet.m_selectedVectorField = null;
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField != null) {
                    PgVectorField pgVectorField2 = (PgVectorField)pgVectorField.clone();
                    pgPointSet.addVectorField(pgVectorField2);
                    pgVectorField2.setGeometry(pgPointSet);
                    if (this.m_selectedVectorField != pgVectorField) continue;
                    pgPointSet.selectVectorField(pgVectorField2);
                    continue;
                }
                PsDebug.warning("missing vector field encountered during cloneing.");
            }
        }
        return pgPointSet;
    }

    public int addVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning("missing argument");
            return -1;
        }
        if (this.m_vectorField == null) {
            this.m_vectorField = new Vector();
            this.m_numVectorFields = 0;
        }
        if (this.m_vectorField.contains(pgVectorField)) {
            return this.m_vectorField.indexOf(pgVectorField);
        }
        this.m_vectorField.addElement(pgVectorField);
        pgVectorField.setParent(this);
        if (!pgVectorField.isShowingIndividualMaterial()) {
            pgVectorField.showVectorArrows(this.isShowingVectorArrows());
        }
        if (this.m_numVectorFields == 0 && this.m_selectedVectorField == null) {
            this.m_selectedVectorField = pgVectorField;
        }
        return this.m_numVectorFields++;
    }

    public final int getNumVertices() {
        return this.m_numVertices;
    }

    public boolean isShowingTaggedVertices() {
        return this.m_bShowTaggedVertices;
    }

    public void showTaggedVertices(boolean bl) {
        this.m_bShowTaggedVertices = bl;
    }

    public void setNumVertices(int n) {
        if (this.m_numVertices == n) {
            return;
        }
        if (n > this.m_maxNumVertices || n < this.m_maxNumVertices / 2 && n < this.m_maxNumVertices - 100) {
            this.setMaxNumVertices(n);
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numVertices = n;
            return;
        }
        int n2 = this.getNumVectorFields();
        if (n2 > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n3 = 0;
            while (n3 < n2) {
                if (pgVectorFieldArray[n3].getBasedOn() == 0) {
                    pgVectorFieldArray[n3].setNumVectors(n);
                }
                ++n3;
            }
        }
        this.m_numVertices = n;
    }

    public int[] getMarkedVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(1)) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.m_numVertices) {
            if (this.m_vertex[n4].hasTag(1)) {
                nArray[n3++] = n4;
            }
            ++n4;
        }
        return nArray;
    }

    public void setDefaultLabelEnabled(boolean bl) {
        this.setEnabledIndexLabels(bl);
    }

    public PdVector[] getAmbientBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getAmbientBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        return pdVectorArray;
    }

    public void computeSnail(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > 1) {
            d2 = (1.0 + d * Math.PI) / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d3 = Math.PI / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d4 = 2.141592653589793 + d2 * (double)n4;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            int n5 = 0;
            while (n5 < n2) {
                double d7 = d3 * (double)n5;
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                double d10 = Math.exp(d4 * Math.log(1.3)) * d8;
                this.m_vertex[n3].m_data[0] = d10 * d6 * d8;
                this.m_vertex[n3].m_data[1] = d10 * d5 * d8;
                this.m_vertex[n3].m_data[2] = d10 * d9;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        Object object;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgPointSet pgPointSet = (PgPointSet)super.reflect(pdMatrix, bl, bl2);
        PdVector[] pdVectorArray = this.getVertices();
        PdVector[] pdVectorArray2 = pgPointSet.getVertices();
        int n = 0;
        while (n < this.m_numVertices) {
            pdVectorArray2[n].leftMultAffin(pdMatrix, pdVectorArray[n], true);
            ++n;
        }
        if (this.hasVertexNormals()) {
            PdVector[] pdVectorArray3 = this.getVertexNormals();
            object = pgPointSet.getVertexNormals();
            int n2 = 0;
            while (n2 < this.m_numVertices) {
                object[n2].leftMultAffin(pdMatrix, pdVectorArray3[n2], false);
                if (!bl2) {
                    object[n2].multScalar(-1.0);
                }
                object[n2].normalize();
                ++n2;
            }
        }
        if (this.m_vectorField != null) {
            pgPointSet.m_vectorField = null;
            pgPointSet.m_numVectorFields = 0;
            pgPointSet.m_selectedVectorField = null;
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                object = (PgVectorField)enumeration.nextElement();
                if (object != null) {
                    PgVectorField pgVectorField = (PgVectorField)((PgVectorField)object).reflect(pdMatrix, bl, bl2);
                    pgPointSet.addVectorField(pgVectorField);
                    pgVectorField.setGeometry(pgPointSet);
                    if (this.m_selectedVectorField != object) continue;
                    pgPointSet.selectVectorField(pgVectorField);
                    continue;
                }
                PsDebug.warning("missing vector field encountered during cloneing.");
            }
        }
        return pgPointSet;
    }

    public boolean hasVertexTextures() {
        return this.m_vertexTexture != null && this.m_vertexTexture.length == this.m_maxNumVertices;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void init() {
        super.init();
        this.m_dimOfColors = 3;
        this.m_vertexColor = null;
        this.m_bShowVertexColors = false;
        this.m_vertexTexture = null;
        this.m_texture = null;
        this.m_bEnabledIndexLabels = true;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.setMaxNumVertices(0);
        this.m_globalVertexColor.setColor(Color.red);
        this.m_globalVertexTagColor.setColor(Color.magenta);
        this.m_bShowVertices = true;
        this.m_bShowTaggedVertices = true;
        this.m_bShowVertexOutline = true;
        this.m_vertexSize = null;
        this.m_bShowVertexSizes = false;
        this.m_globalVertexSize.setDefBounds(0.0, 50.0, 1.0, 5.0);
        this.m_globalVertexSize.setDefValue(2.0);
        this.m_globalVertexSize.init();
        this.m_vertexNormal = null;
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_globalVertexNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalVertexNormalSize.setDefValue(1.0);
        this.m_globalVertexNormalSize.init();
        this.m_globalVertexNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalVertexNormalLength.setDefValue(0.5);
        this.m_globalVertexNormalLength.init();
        this.m_globalVertexNormalColor.setColor(Color.yellow);
        this.m_shininess.setDefBounds(0.0, 50.0, 0.1, 1.0);
        this.m_shininess.setDefValue(10.0);
        this.m_shininess.init();
        this.m_specularColor.setColor(Color.white);
        this.m_bShowTransparency = false;
        this.m_transparency.setDefBounds(0.0, 1.0, 0.05, 0.1);
        this.m_transparency.setDefValue(0.4);
        this.m_transparency.init();
        this.m_numVectorFields = 0;
        this.m_vectorField = null;
        this.m_selectedVectorField = null;
        this.m_bShowSingleVectorField = false;
        this.m_bShowVectorFields = true;
        this.m_bShowVectorArrows = false;
        this.m_globalVectorSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.init();
        this.m_globalVectorLength.setDefValue(1.0);
        this.m_globalVectorLength.setDefBounds(0.0, 50.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_bShowVertexTexture = false;
        this.m_dimOfTextures = 2;
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public void showVertexColors(boolean bl) {
        this.m_bShowVertexColors = bl;
    }

    public int getDimOfColors() {
        return this.m_dimOfColors;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        if (this.m_dimOfColors == n) {
            return;
        }
        this.m_dimOfColors = n;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        this.m_dimOfVectors = n;
        int n2 = 0;
        while (n2 < this.m_numVectorFields) {
            PgVectorField pgVectorField = (PgVectorField)this.m_vectorField.elementAt(n2);
            pgVectorField.setDimOfVectors(n);
            ++n2;
        }
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_maxNumVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_maxNumVertices);
        }
    }

    public void setVertexColors(Color[] colorArray) {
        if (this.m_bInstanceSharing) {
            this.m_vertexColor = colorArray;
            return;
        }
        if (colorArray == null) {
            this.m_vertexColor = null;
            return;
        }
        if (colorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, colorArray, 0, this.m_numVertices);
    }

    public boolean makeVertexTextureFromUV(int n, int n2, int n3) {
        if (this.m_numVertices != n * n2) {
            PsDebug.warning("Product of u- and v-lines does not match numVertices.");
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            double d = (double)n5 / ((double)n - 1.0);
            int n6 = 0;
            while (n6 < n2) {
                double d2 = (double)n6 / ((double)n2 - 1.0);
                if (n3 == 0) {
                    pdVectorArray[n4].m_data[0] = d;
                    pdVectorArray[n4].m_data[1] = d2;
                } else if (n3 == 1) {
                    pdVectorArray[n4].m_data[0] = d2;
                    pdVectorArray[n4].m_data[1] = d;
                }
                ++n4;
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    public void setTexture(PgTexture pgTexture) {
        if (pgTexture == null) {
            this.m_texture = null;
            return;
        }
        if (this.m_texture == null) {
            this.m_texture = new PgTexture();
            this.m_texture.setName(PsConfig.getMessage(15005) + " " + this.getName());
            this.m_texture.setParent(this);
        }
        this.m_texture.copy(pgTexture);
    }

    public PdVector getVertexTexture(int n) {
        if (this.m_vertexTexture == null || n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexTexture[n];
    }

    public PgTexture getTexture() {
        return this.m_texture;
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public void showVertexTexture(boolean bl) {
        this.m_bShowVertexTexture = bl;
    }

    public void setVertexTexture(int n, PdVector pdVector) {
        if (n < 0 || pdVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexTexture == null || n >= this.m_vertexTexture.length) {
            this.assureVertexTextures();
        }
        this.m_vertexTexture[n].copy(pdVector);
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public void setGlobalVectorSize(double d) {
        this.m_globalVectorSize.setValue(d);
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n = 0;
            while (n < pgVectorFieldArray.length) {
                if (!pgVectorFieldArray[n].isShowingIndividualMaterial()) {
                    pgVectorFieldArray[n].setGlobalVectorSize(d);
                }
                ++n;
            }
        }
    }

    public boolean isShowingVectorArrow() {
        return this.isShowingVectorArrows();
    }

    public boolean isShowingVectorFields() {
        return this.m_bShowVectorFields;
    }

    public void showVectorFields(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public void showVectorArrow(boolean bl) {
        this.showVectorArrows(bl);
    }

    protected PgVectorField[] getVectorFields() {
        if (this.m_vectorField == null) {
            return null;
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[this.m_vectorField.size()];
        int n = 0;
        if (this.m_selectedVectorField != null) {
            pgVectorFieldArray[n++] = this.m_selectedVectorField;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
            if (pgVectorField == this.m_selectedVectorField) continue;
            pgVectorFieldArray[n++] = pgVectorField;
        }
        return pgVectorFieldArray;
    }

    public void removeAllVectorFields() {
        if (this.m_vectorField == null) {
            return;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            ((PsObject)enumeration.nextElement()).setParent(null);
        }
        this.m_vectorField.removeAllElements();
        this.m_vectorField = null;
        this.m_numVectorFields = 0;
        this.m_selectedVectorField = null;
    }

    public int removeHiddenVectorFields() {
        PgVectorField[] pgVectorFieldArray = this.getVectorFields();
        if (pgVectorFieldArray == null || pgVectorFieldArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < pgVectorFieldArray.length) {
            if (!pgVectorFieldArray[n2].isVisible()) {
                ++n;
                this.removeVectorField(pgVectorFieldArray[n2]);
            }
            ++n2;
        }
        return n;
    }

    public boolean isDefaultLabelEnabled() {
        return this.isEnabledIndexLabels();
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength.getValue();
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalVertexNormalLength.setValue(d);
    }

    public boolean makeColorFromVectorLength() {
        PgVectorField pgVectorField = this.getVectorField(0);
        if (pgVectorField == null) {
            PsDebug.warning("missing vector field.");
            return false;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("missing vectors.");
            return false;
        }
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector pdVector = new PdVector(this.m_numVertices);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector.m_data[n] = pdVectorArray[n].length();
            ++n;
        }
        float f = (float)pdVector.min();
        float f2 = (float)pdVector.max() - f;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            float f3 = ((float)pdVector.m_data[n2] - f) / f2;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            colorArray[n2] = Color.getHSBColor(f3, 1.0f, 1.0f);
            ++n2;
        }
        this.setVertexColors(colorArray);
        return true;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public boolean isEnabledIndexLabels() {
        return this.m_bEnabledIndexLabels;
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public void showVertexNormals(boolean bl) {
        this.m_bShowVertexNormals = bl;
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_maxNumVertices) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_vertexNormal = pdVectorArray;
            return;
        }
        if (pdVectorArray == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public int getEulerCharacteristic() {
        int[] nArray = this.getFVector();
        int n = nArray[0];
        int n2 = -1;
        int n3 = 1;
        while (n3 < nArray.length) {
            n += n2 * nArray[n3];
            n2 = -n2;
            ++n3;
        }
        return n;
    }

    public PgPointSet() {
        this(3);
    }

    public PgPointSet(int n) {
        super(n);
        this.setType(30);
        this.setTag(4);
        this.setTag(5);
        this.setTag(8);
        this.setTag(9);
        this.setTag(20);
        this.m_geomItem = new Vector();
        this.m_geomItem.addElement("Name");
        this.m_geomItem.addElement("Vertex");
        this.m_dimOfSimplex = 0;
        this.m_dimOfVectors = n;
        this.m_vertex = new PdVector[0];
        this.m_globalVertexSize = new PuDouble(PsConfig.getMessage(24043), this);
        this.m_globalVertexColor = new PdColor(PsConfig.getMessage(24036), this);
        this.m_globalVertexTagColor = new PdColor(PsConfig.getMessage(24044), this);
        this.m_globalVertexNormalLength = new PuDouble(PsConfig.getMessage(24045), this);
        this.m_globalVertexNormalSize = new PuDouble(PsConfig.getMessage(24046), this);
        this.m_globalVertexNormalColor = new PdColor(PsConfig.getMessage(24047), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage(24048), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage(24049), this);
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage(24050), this);
        this.m_shininess = new PuDouble(PsConfig.getMessage(24368), this);
        this.m_specularColor = new PdColor(PsConfig.getMessage(24369), this);
        this.m_transparency = new PuDouble(PsConfig.getMessage(24034), this);
        this.m_bShowVectorColors = false;
        if (this.getClass() == (class$jv$geom$PgPointSet != null ? class$jv$geom$PgPointSet : (class$jv$geom$PgPointSet = PgPointSet.class$("jv.geom.PgPointSet")))) {
            this.init();
        }
    }

    public void removeTexture() {
        this.setTexture(null);
        this.setVertexTextures(null);
        this.showVertexTexture(false);
    }

    public PdVector getVertex(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vertex[n];
    }

    public Color getVertexColor(int n) {
        if (this.m_vertexColor == null || n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexColor[n];
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        int n;
        super.paint(pvGeometryIf);
        ((PgJvxSrc)((Object)pvGeometryIf)).setEnabledInstanceSharing(PsJavaView.m_bInstanceSharing);
        pvGeometryIf.setState(80, this.isShowingIndices());
        pvGeometryIf.setState(81, this.isShowingVertexLabels());
        pvGeometryIf.setState(85, this.isEnabledIndexLabels());
        pvGeometryIf.setState(50, this.m_bShowVertices);
        pvGeometryIf.setState(51, this.m_bShowTaggedVertices);
        pvGeometryIf.setState(97, this.m_bShowVertexOutline);
        pvGeometryIf.setNumVertices(this.m_numVertices);
        pvGeometryIf.setVertices(this.m_vertex);
        pvGeometryIf.setState(91, this.m_bShowVertexColors);
        if (this.m_globalVertexColor != null) {
            pvGeometryIf.setGlobalVertexColor(this.m_globalVertexColor.getColor());
        }
        if (this.m_globalVertexTagColor != null) {
            pvGeometryIf.setGlobalVertexTagColor(this.m_globalVertexTagColor.getColor());
        }
        pvGeometryIf.setVertexColors(this.m_vertexColor);
        pvGeometryIf.setState(60, this.m_bShowVertexNormals);
        pvGeometryIf.setState(61, this.m_bShowVertexNormalArrow);
        pvGeometryIf.setVertexNormals(this.m_vertexNormal);
        if (this.m_globalVertexNormalSize != null) {
            pvGeometryIf.setGlobalVertexNormalSize(this.m_globalVertexNormalSize.getValue());
        }
        if (this.m_globalVertexNormalLength != null) {
            pvGeometryIf.setGlobalVertexNormalLength(this.m_globalVertexNormalLength.getValue());
        }
        if (this.m_globalVertexNormalColor != null) {
            pvGeometryIf.setGlobalVertexNormalColor(this.m_globalVertexNormalColor.getColor());
        }
        pvGeometryIf.setState(74, this.m_bShowVertexSizes);
        pvGeometryIf.setVertexSizes(this.m_vertexSize);
        if (this.m_globalVertexSize != null) {
            pvGeometryIf.setGlobalVertexSize(this.m_globalVertexSize.getValue());
        }
        pvGeometryIf.setState(71, this.m_bShowVertexTexture);
        if (this.m_texture != null && this.m_texture.getImage() != null) {
            n = this.m_texture.getWidth();
            int n2 = this.m_texture.getHeight();
            pvGeometryIf.setTexture(this.m_texture.getPixels(), n, n2, this.m_texture.getBlendingMode(), this.m_texture.getFilterType());
        } else {
            pvGeometryIf.setTexture(null, -1, -1, 0, 0);
        }
        pvGeometryIf.setVertexTextures(this.m_vertexTexture);
        pvGeometryIf.setShininess(this.m_shininess.getValue());
        pvGeometryIf.setSpecularColor(this.m_specularColor.getColor());
        pvGeometryIf.setState(73, this.m_bShowTransparency);
        pvGeometryIf.setTransparency(this.m_transparency.getValue());
        pvGeometryIf.setNumVectorFields(this.m_numVectorFields);
        pvGeometryIf.showVectorFields(this.m_bShowVectorFields);
        n = 0;
        while (n < this.m_numVectorFields) {
            PgVectorField pgVectorField = this.getVectorField(n);
            pgVectorField.setIndex(n);
            pgVectorField.paint(pvGeometryIf);
            if (!pgVectorField.m_bShowIndividualMaterial) {
                pvGeometryIf.showVectorColors(n, this.m_bShowVectorColors);
                pvGeometryIf.showVectorArrows(n, this.m_bShowVectorArrows);
                pvGeometryIf.setGlobalVectorColor(n, this.m_globalVectorColor.getColor());
                pvGeometryIf.setGlobalVectorLength(n, this.m_globalVectorLength.getValue());
                pvGeometryIf.setGlobalVectorSize(n, this.m_globalVectorSize.getValue());
            }
            ++n;
        }
    }

    public boolean isShowingTransparency() {
        return this.m_bShowTransparency;
    }

    public void showTransparency(boolean bl) {
        this.m_bShowTransparency = bl;
    }

    public double getTransparency() {
        return this.m_transparency.getValue();
    }

    public void setTransparency(double d) {
        this.m_transparency.setValue(d);
    }

    public boolean isShowingVectorField() {
        return this.m_bShowVectorFields;
    }

    public boolean isShowingSingleVectorField() {
        return this.m_bShowSingleVectorField;
    }

    public void showVectorField(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public void showSingleVectorField(boolean bl) {
        this.m_bShowSingleVectorField = bl;
        if (!bl) {
            return;
        }
        if (this.getNumVectorFields() == 0) {
            return;
        }
        if (this.m_selectedVectorField == null) {
            return;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField;
            pgVectorField.setVisible((pgVectorField = (PgVectorField)enumeration.nextElement()) == this.m_selectedVectorField);
        }
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public void showVertexNormalArrow(boolean bl) {
        this.m_bShowVertexNormalArrow = bl;
    }

    public void clearTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].clearTag(n2);
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (n >= this.m_numVertices) {
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].copy(pdVector);
        return true;
    }

    public void setVertex(int n, double d) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 1) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d);
    }

    public PdVector getVertexNormal(int n) {
        if (this.m_vertexNormal == null || n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexNormal[n];
    }

    public void setVertex(int n, double d, double d2) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 2) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d, d2);
    }

    public void setVertex(int n, double d, double d2, double d3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 3) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d, d2, d3);
    }

    public void setVertexColor(int n, Color color) {
        if (n < 0 || color == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexColor == null || n >= this.m_vertexColor.length) {
            this.assureVertexColors();
        }
        this.m_vertexColor[n] = color;
    }

    public void setVertexNormal(int n, PdVector pdVector) {
        if (n < 0 || pdVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexNormal == null || n >= this.m_vertexNormal.length) {
            this.assureVertexNormals();
        }
        this.m_vertexNormal[n].copy(pdVector);
    }

    public int getIndexOfVectorField(PgVectorField pgVectorField) {
        if (this.m_vectorField == null) {
            return -1;
        }
        return this.m_vectorField.indexOf(pgVectorField);
    }

    public PgVectorField getVectorField(String string) {
        if (this.m_vectorField == null) {
            return null;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
            if (!string.equals(pgVectorField.getName())) continue;
            return pgVectorField;
        }
        PsDebug.warning("vector field = " + string + " not found");
        return null;
    }

    public PgVectorField getVectorField(int n) {
        if (this.m_vectorField == null || n >= this.m_numVectorFields) {
            return null;
        }
        return (PgVectorField)this.m_vectorField.elementAt(n);
    }

    protected Vector getVectorField() {
        return this.m_vectorField;
    }

    public int selectVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning("Missing argument");
            return -1;
        }
        int n = this.getIndexOfVectorField(pgVectorField);
        if (n < 0) {
            PsDebug.warning("Missing vector field = " + pgVectorField.getName());
            return n;
        }
        if (pgVectorField == this.m_selectedVectorField) {
            return n;
        }
        if (this.isShowingSingleVectorField() && this.m_selectedVectorField != null) {
            this.m_selectedVectorField.setVisible(false);
            pgVectorField.setVisible(true);
        }
        this.m_selectedVectorField = pgVectorField;
        return n;
    }

    public void computeCone(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = d2 / (-1.0 + (double)n2);
            d5 = d / (-1.0 + (double)n2);
        }
        int n3 = 0;
        double d6 = 0.0;
        double d7 = Math.sqrt(d * d + d2 * d2);
        double d8 = d2 / d7;
        double d9 = d / d7;
        int n4 = 0;
        while (n4 < n) {
            double d10 = Math.sin(d6);
            double d11 = Math.cos(d6);
            double d12 = -d2 / 2.0;
            double d13 = d;
            int n5 = 0;
            while (n5 < n2) {
                this.m_vertex[n3].m_data[0] = d13 * d11;
                this.m_vertex[n3].m_data[1] = d13 * d10;
                this.m_vertex[n3].m_data[2] = d12;
                d12 += d4;
                d13 -= d5;
                this.m_vertexNormal[n3].m_data[0] = d11 * d8;
                this.m_vertexNormal[n3].m_data[1] = d10 * d8;
                this.m_vertexNormal[n3].m_data[2] = d9;
                ++n3;
                ++n5;
            }
            d6 += d3;
            ++n4;
        }
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public void showIndices(boolean bl) {
        this.m_bShowIndices = bl;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setEnabledInstanceSharing(PsJavaView.m_bInstanceSharing);
        pgJvxSrc.setType(30);
        pgJvxSrc.showIndices(this.isShowingIndices());
        pgJvxSrc.setEnabledIndexLabels(this.isEnabledIndexLabels());
        pgJvxSrc.showVertexLabels(this.isShowingVertexLabels());
        pgJvxSrc.showTaggedVertices(this.isShowingTaggedVertices());
        pgJvxSrc.showVertices(this.isShowingVertices());
        pgJvxSrc.showVertexOutline(this.isShowingVertexOutline());
        pgJvxSrc.setDimOfVertices(this.getDimOfVertices());
        pgJvxSrc.setNumVertices(this.getNumVertices());
        pgJvxSrc.setVertices(this.getVertices());
        if (this.hasVertexColors()) {
            pgJvxSrc.showVertexColors(this.isShowingVertexColors());
            pgJvxSrc.setVertexColors(this.getVertexColors());
        } else {
            pgJvxSrc.showVertexColors(false);
        }
        pgJvxSrc.setGlobalVertexColor(this.getGlobalVertexColor());
        pgJvxSrc.setGlobalVertexTagColor(this.getGlobalVertexTagColor());
        if (this.hasVertexNormals()) {
            pgJvxSrc.showVertexNormals(this.isShowingVertexNormals());
            pgJvxSrc.setVertexNormals(this.getVertexNormals());
        } else {
            pgJvxSrc.showVertexNormals(false);
        }
        pgJvxSrc.showVertexNormalArrow(this.isShowingVertexNormalArrow());
        pgJvxSrc.setGlobalVertexNormalColor(this.getGlobalVertexNormalColor());
        pgJvxSrc.setGlobalVertexNormalLength(this.getGlobalVertexNormalLength());
        pgJvxSrc.setGlobalVertexNormalSize(this.getGlobalVertexNormalSize());
        if (this.getGlobalVertexNormalColor() != null) {
            pgJvxSrc.setGlobalElementNormalColor(this.getGlobalVertexNormalColor());
        }
        pgJvxSrc.setGlobalElementNormalLength(this.getGlobalVertexNormalLength());
        pgJvxSrc.setGlobalElementNormalSize(this.getGlobalVertexNormalSize());
        if (this.hasVertexSizes()) {
            pgJvxSrc.showVertexSizes(this.isShowingVertexSizes());
            pgJvxSrc.setVertexSizes(this.getVertexSizes());
        } else {
            pgJvxSrc.showVertexSizes(false);
        }
        pgJvxSrc.setGlobalVertexSize(this.getGlobalVertexSize());
        pgJvxSrc.setShininess(this.getShininess());
        if (this.getSpecularColor() != null) {
            pgJvxSrc.setSpecularColor(this.getSpecularColor());
        }
        pgJvxSrc.showTransparency(this.isShowingTransparency());
        pgJvxSrc.setTransparency(this.getTransparency());
        if (this.m_texture != null) {
            pgJvxSrc.setTextureImage(this.m_texture.getImage());
            pgJvxSrc.setTextureImageName(this.m_texture.getImageName());
            pgJvxSrc.setBlendingMode(this.m_texture.getBlendingMode());
            pgJvxSrc.setFilterType(this.m_texture.getFilterType());
            pgJvxSrc.setTextureImageBnd(this.m_texture.getTextureImageBnd());
        }
        if (this.hasVertexTextures()) {
            pgJvxSrc.showVertexTexture(this.isShowingVertexTexture());
            pgJvxSrc.setVertexTextures(this.getVertexTextures());
        } else {
            pgJvxSrc.showVertexTexture(false);
        }
        PgVectorField[] pgVectorFieldArray = this.getVectorFields();
        if (pgVectorFieldArray != null) {
            int n = pgVectorFieldArray.length;
            pgJvxSrc.setNumVectorFields(n);
            pgJvxSrc.showVectorFields(this.isShowingVectorFields());
            int n2 = 0;
            while (n2 < n) {
                pgJvxSrc.showVectorField(n2, pgVectorFieldArray[n2].isVisible());
                pgJvxSrc.setVectorFieldName(n2, pgVectorFieldArray[n2].getName());
                if (pgVectorFieldArray[n2].getBasedOn() == 0) {
                    pgJvxSrc.setVectorElementBased(n2, false);
                } else {
                    pgJvxSrc.setVectorElementBased(n2, true);
                }
                pgJvxSrc.setNumVectors(n2, pgVectorFieldArray[n2].getNumVectors(), pgVectorFieldArray[n2].getDimOfVertices());
                pgJvxSrc.setVectors(n2, pgVectorFieldArray[n2].getVectors());
                pgJvxSrc.setVectorColors(n2, pgVectorFieldArray[n2].getVectorColors());
                boolean bl = pgVectorFieldArray[n2].isShowingIndividualMaterial();
                pgJvxSrc.showIndividualMaterial(n2, bl);
                if (bl) {
                    pgJvxSrc.showVectorArrows(n2, pgVectorFieldArray[n2].isShowingVectorArrows());
                    pgJvxSrc.setGlobalVectorSize(n2, pgVectorFieldArray[n2].getGlobalVectorSize());
                    pgJvxSrc.setGlobalVectorLength(n2, pgVectorFieldArray[n2].getGlobalVectorLength());
                    pgJvxSrc.setGlobalVectorColor(n2, pgVectorFieldArray[n2].getGlobalVectorColor());
                    pgJvxSrc.showVectorColors(n2, pgVectorFieldArray[n2].isShowingVectorColors());
                } else {
                    pgJvxSrc.showVectorArrows(n2, this.isShowingVectorArrows());
                    pgJvxSrc.setGlobalVectorSize(n2, this.getGlobalVectorSize());
                    pgJvxSrc.setGlobalVectorLength(n2, this.getGlobalVectorLength());
                    pgJvxSrc.setGlobalVectorColor(n2, this.getGlobalVectorColor());
                    pgJvxSrc.showVectorColors(n2, this.isShowingVectorColors());
                }
                ++n2;
            }
        }
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showIndices(pgJvxSrc.isShowingIndices());
        this.setEnabledIndexLabels(pgJvxSrc.isEnabledIndexLabels());
        this.showVertexLabels(pgJvxSrc.isShowingVertexLabels());
        this.showVertexOutline(pgJvxSrc.isShowingVertexOutline());
        this.showTaggedVertices(pgJvxSrc.isShowingTaggedVertices());
        this.showVertices(pgJvxSrc.isShowingVertices());
        this.setNumVertices(pgJvxSrc.getNumVertices());
        if (this.isEnabledInstanceSharing()) {
            this.setMaxNumVertices(pgJvxSrc.getNumVertices());
        }
        this.setVertices(pgJvxSrc.getVertices());
        if (pgJvxSrc.getGlobalVertexColor() != null) {
            this.setGlobalVertexColor(pgJvxSrc.getGlobalVertexColor());
        }
        if (pgJvxSrc.getGlobalVertexTagColor() != null) {
            this.setGlobalVertexTagColor(pgJvxSrc.getGlobalVertexTagColor());
        }
        this.setVertexColors(pgJvxSrc.getVertexColors());
        this.showVertexColors(pgJvxSrc.isShowingVertexColors());
        this.showVertexNormals(pgJvxSrc.isShowingVertexNormals());
        this.showVertexNormalArrow(pgJvxSrc.isShowingVertexNormalArrow());
        this.setVertexNormals(pgJvxSrc.getVertexNormals());
        this.showVertexSizes(pgJvxSrc.isShowingVertexSizes());
        this.setVertexSizes(pgJvxSrc.getVertexSizes());
        this.setGlobalVertexSize(pgJvxSrc.getGlobalVertexSize());
        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
            this.setGlobalVertexNormalColor(pgJvxSrc.getGlobalVertexNormalColor());
        }
        this.setGlobalVertexNormalLength(pgJvxSrc.getGlobalVertexNormalLength());
        this.setGlobalVertexNormalSize(pgJvxSrc.getGlobalVertexNormalSize());
        this.setShininess(pgJvxSrc.getShininess());
        if (pgJvxSrc.getSpecularColor() != null) {
            this.setSpecularColor(pgJvxSrc.getSpecularColor());
        }
        this.showTransparency(pgJvxSrc.isShowingTransparency());
        this.setTransparency(pgJvxSrc.getTransparency());
        if (pgJvxSrc.getTextureImage() != null || pgJvxSrc.getTextureImageName() != null) {
            if (this.m_texture == null) {
                this.setTexture(new PgTexture());
            }
            if (pgJvxSrc.getTextureImage() != null) {
                this.m_texture.setImage(pgJvxSrc.getTextureImage());
            }
            if (pgJvxSrc.getTextureImageName() != null) {
                this.m_texture.setImageName(pgJvxSrc.getTextureImageName());
            }
            this.m_texture.setBlendingMode(pgJvxSrc.getBlendingMode());
            this.m_texture.setFilterType(pgJvxSrc.getFilterType());
            this.m_texture.setTextureImageBnd(pgJvxSrc.getTextureImageBnd());
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            this.assureVertexTextures();
        }
        this.setVertexTextures(pgJvxSrc.getVertexTextures());
        this.showVertexTexture(pgJvxSrc.isShowingVertexTexture());
        if (pgJvxSrc.getNumVectorFields() > 0) {
            this.removeAllVectorFields();
            int n = pgJvxSrc.getNumVectorFields();
            this.showVectorFields(pgJvxSrc.isShowingVectorFields());
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                PgVectorField pgVectorField = new PgVectorField(pgJvxSrc.getDimOfVectors(n2));
                pgVectorField.setName(pgJvxSrc.getVectorFieldName(n2));
                this.addVectorField(pgVectorField);
                pgVectorField.setVisible(pgJvxSrc.isShowingVectorField(n2));
                boolean bl2 = pgJvxSrc.isShowingIndividualMaterial(n2);
                pgVectorField.showIndividualMaterial(bl2);
                if (bl2) {
                    pgVectorField.showVectorArrows(pgJvxSrc.isShowingVectorArrows(n2));
                    pgVectorField.setGlobalVectorSize(pgJvxSrc.getGlobalVectorSize(n2));
                    pgVectorField.setGlobalVectorLength(pgJvxSrc.getGlobalVectorLength(n2));
                    if (pgJvxSrc.getGlobalVectorColor(n2) != null) {
                        pgVectorField.setGlobalVectorColor(pgJvxSrc.getGlobalVectorColor(n2));
                    }
                    pgVectorField.showVectorColors(pgJvxSrc.isShowingVectorColors(n2));
                } else {
                    if (!bl) {
                        bl = true;
                        this.showVectorArrows(pgJvxSrc.isShowingVectorArrows(n2));
                        this.setGlobalVectorSize(pgJvxSrc.getGlobalVectorSize(n2));
                        this.setGlobalVectorLength(pgJvxSrc.getGlobalVectorLength(n2));
                        if (pgJvxSrc.getGlobalVectorColor(n2) != null) {
                            this.setGlobalVectorColor(pgJvxSrc.getGlobalVectorColor(n2));
                        }
                    }
                    pgVectorField.showVectorArrows(this.isShowingVectorArrows());
                    pgVectorField.setGlobalVectorSize(this.getGlobalVectorSize());
                    pgVectorField.setGlobalVectorLength(this.getGlobalVectorLength());
                    if (this.getGlobalVectorColor() != null) {
                        pgVectorField.setGlobalVectorColor(this.getGlobalVectorColor());
                    }
                    pgVectorField.showVectorColors(this.isShowingVectorColors());
                }
                if (!pgJvxSrc.isVectorElementBased(n2)) {
                    PdVector[] pdVectorArray = pgJvxSrc.getVectors(n2);
                    if (pdVectorArray == null) {
                        PsDebug.warning("missing vectors in vector field[" + n2 + "].");
                        return;
                    }
                    int n3 = pdVectorArray.length;
                    pgVectorField.setGeometry(this);
                    pgVectorField.setBasedOn(0);
                    pgVectorField.setNumVectors(n3);
                    pgVectorField.setVectorColors(pgJvxSrc.getVectorFieldColors(n2));
                    pgVectorField.setVectors(pdVectorArray);
                }
                ++n2;
            }
        }
    }

    public boolean projectFromAmbientSpace() {
        super.projectFromAmbientSpace();
        if (this.m_numVertices == 0) {
            return true;
        }
        int n = this.m_dim;
        if (this.m_ambientProj != 0) {
            int n2 = 0;
            while (n2 < this.m_numVertices) {
                PdVector pdVector = this.m_vertex[n2];
                if (this.m_ambientSpace == 9 || this.m_ambientSpace == 6 || this.m_ambientSpace == 3 || this.m_ambientSpace == 1 || this.m_ambientSpace == 2 || this.m_ambientSpace == 4 || this.m_ambientSpace == 7 || this.m_ambientSpace == 10) {
                    if (this.m_ambientProj == 1) {
                        PuProj.stereographic(pdVector, pdVector);
                    } else {
                        PsDebug.warning("unknown projection type");
                    }
                } else if (this.m_ambientSpace == 5 || this.m_ambientSpace == 8 || this.m_ambientSpace == 11) {
                    if (this.m_ambientProj == 2) {
                        PuProj.lorentz2Klein(pdVector, pdVector);
                    } else if (this.m_ambientProj == 1) {
                        PuProj.lorentz2Poincare(pdVector, pdVector);
                    } else if (this.m_ambientProj == 3) {
                        PuProj.lorentz2Uhm(pdVector, pdVector);
                    } else {
                        PsDebug.warning("unknown projection type");
                    }
                } else {
                    PsDebug.warning("unknown ambient space");
                }
                ++n2;
            }
            this.setAmbientProjection(0);
            n = Math.min(this.m_dim - 1, 3);
        } else {
            n = Math.min(this.m_dim, 3);
        }
        if (n != this.m_dim) {
            this.setDimOfVertices(n);
        }
        if (this.m_dim == 1) {
            this.setAmbientSpace(0);
        } else if (this.m_dim == 2) {
            this.setAmbientSpace(1);
        } else {
            this.setAmbientSpace(3);
        }
        return true;
    }

    public boolean isShowingVertexOutline() {
        return this.m_bShowVertexOutline;
    }

    public void showVertexOutline(boolean bl) {
        this.m_bShowVertexOutline = bl;
    }

    public PdVector getCenterOfBndBox() {
        PdVector pdVector = new PdVector(this.m_dim);
        if (this.m_numVertices == 0) {
            return pdVector;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null || pdVectorArray.length < 2) {
            return pdVector;
        }
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        return pdVector;
    }

    public void setCenterOfBndBox(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        PdVector pdVector2 = this.getCenterOfBndBox();
        if (pdVector2 == null) {
            PsDebug.warning("missing current center");
            return;
        }
        PdVector pdVector3 = PdVector.subNew(pdVector, pdVector2);
        this.translate(pdVector3);
    }

    public boolean makeVertexTextureFromBndBox(int n, int n2) {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim < 2) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        if (n >= this.m_dim) {
            n = this.m_dim - 1;
        }
        if (n2 >= this.m_dim) {
            n2 = this.m_dim - 1;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray2 = this.getVertexTextures();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        int n3 = 0;
        while (n3 < this.m_numVertices) {
            pdVector.sub(this.m_vertex[n3], pdVectorArray[0]);
            pdVectorArray2[n3].m_data[0] = pdVector.m_data[n] / dArray[n];
            pdVectorArray2[n3].m_data[1] = pdVector.m_data[n2] / dArray[n2];
            ++n3;
        }
        return true;
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public boolean isShowingVectorColors() {
        return this.m_bShowVectorColors;
    }

    public void showVertexLabels(boolean bl) {
        this.m_bShowVertexLabels = bl;
    }

    public void showVectorColors(boolean bl) {
        this.m_bShowVectorColors = bl;
    }

    public Color getSpecularColor() {
        return this.m_specularColor.getColor();
    }

    public void setSpecularColor(Color color) {
        this.m_specularColor.setColor(color);
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor.getColor();
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor.getColor();
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor.setColor(color);
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor.setColor(color);
    }

    public boolean removeVectorField(PgGeometryIf pgGeometryIf) {
        if (this.m_vectorField == null) {
            return true;
        }
        if (!this.m_vectorField.removeElement(pgGeometryIf)) {
            return false;
        }
        pgGeometryIf.setParent(null);
        if ((this.m_numVectorFields += -1) == 0) {
            this.m_vectorField = null;
            this.m_selectedVectorField = null;
        } else if (this.m_selectedVectorField == pgGeometryIf) {
            this.selectVectorField((PgVectorField)this.m_vectorField.firstElement());
        }
        return true;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public int getDimOfTextures() {
        return this.m_dimOfTextures;
    }

    public double getVertexSize(int n) {
        if (this.m_vertexSize == null || n < 0 || n >= this.m_numVertices) {
            return 0.0;
        }
        return this.m_vertexSize.getEntry(n);
    }

    public void setDimOfTextures(int n) {
        if (n == this.m_dimOfTextures) {
            return;
        }
        this.m_dimOfTextures = n;
        this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_maxNumVertices) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
    }

    public void setVertexTextures(PdVector[] pdVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_vertexTexture = pdVectorArray;
            return;
        }
        if (pdVectorArray == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public void setVertexSize(int n, double d) {
        if (n < 0 || d < 0.0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexSize == null || n >= this.m_vertexSize.getSize()) {
            this.assureVertexSizes();
        }
        this.m_vertexSize.setEntry(n, d);
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public PgVectorField getSelectedVectorField() {
        return this.m_selectedVectorField;
    }

    public double getShininess() {
        return this.m_shininess.getValue();
    }

    public void setShininess(double d) {
        this.m_shininess.setValue(d);
    }

    public boolean hasVertexSizes() {
        return this.m_vertexSize != null && this.m_vertexSize.getSize() == this.m_maxNumVertices;
    }

    public void removeVertexSizes() {
        this.setVertexSizes(null);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPointSet ***********\n");
        stringBuffer.append("\t m_numVertices = " + this.m_numVertices + " (max = " + this.m_maxNumVertices + ")\n");
        stringBuffer.append("\t ******* m_vertex *******\n");
        if (this.m_vertex != null && this.m_numVertices > 0) {
            n = 0;
            while (n < this.m_numVertices) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertex[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vertex = null\n");
        }
        stringBuffer.append("\t ******* m_vertexNormal *******\n");
        if (this.m_vertexNormal != null && this.m_numVertices > 0) {
            n = 0;
            while (n < this.m_numVertices) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertexNormal[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vertexNormal = null\n");
        }
        stringBuffer.append("\t ******* m_vertexTexture *******\n");
        if (this.m_vertexTexture != null && this.m_numVertices > 0) {
            n = 0;
            while (n < this.m_numVertices) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertexTexture[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vertexTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public void translate(PdVector pdVector) {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].add(pdVector);
            ++n;
        }
        if (this.m_center != null) {
            this.m_center.add(pdVector);
        }
    }

    public boolean isShowingVectorArrows() {
        return this.m_bShowVectorArrows;
    }

    public void showVectorArrows(boolean bl) {
        if (this.m_bShowVectorArrows == bl) {
            return;
        }
        this.m_bShowVectorArrows = bl;
        if (this.getNumVectorFields() == 0) {
            return;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
            if (pgVectorField.isShowingIndividualMaterial()) continue;
            pgVectorField.showVectorArrows(bl);
        }
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = Math.PI * 2 / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d5 = d3 * (double)n4;
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            int n5 = 0;
            while (n5 < n2) {
                double d8 = Math.PI + d4 * (double)n5;
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                this.m_vertex[n3].m_data[0] = d7 * (d2 * d10 + d);
                this.m_vertex[n3].m_data[1] = d6 * (d2 * d10 + d);
                this.m_vertex[n3].m_data[2] = d2 * d9;
                this.m_vertexNormal[n3].m_data[0] = d7 * d10;
                this.m_vertexNormal[n3].m_data[1] = d6 * d10;
                this.m_vertexNormal[n3].m_data[2] = d9;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public String getTextureImageName() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImageName();
    }

    public void setTextureImageName(String string) {
        if (string == null) {
            PsDebug.warning("missing texture file name");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImageName(string);
    }

    public void setEnabledIndexLabels(boolean bl) {
        this.m_bEnabledIndexLabels = bl;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPointSet)) {
            return;
        }
        PgPointSet pgPointSet = (PgPointSet)psObject;
        this.setNumVertices(pgPointSet.getNumVertices());
        if (this.m_dim == pgPointSet.getDimOfVertices()) {
            PdVector.copy(this.m_vertex, 0, pgPointSet.getVertices(), 0, this.m_numVertices);
        }
        if (pgPointSet.m_vertexColor != null) {
            this.assureVertexColors();
            PdColor.copy(this.m_vertexColor, 0, pgPointSet.getVertexColors(), 0, this.m_numVertices);
        } else {
            this.m_vertexColor = null;
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, 0, pgPointSet.getVertexNormals(), 0, this.m_numVertices);
        } else {
            this.m_vertexNormal = null;
        }
        if (pgPointSet.m_vertexSize != null) {
            this.assureVertexSizes();
            this.m_vertexSize.copy(0, pgPointSet.getVertexSizes(), 0, this.m_numVertices);
        } else {
            this.m_vertexSize = null;
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, 0, pgPointSet.getVertexTextures(), 0, this.m_numVertices);
        } else {
            this.m_vertexTexture = null;
        }
        this.setTexture(pgPointSet.m_texture);
        this.setDimOfVectors(pgPointSet.getDimOfVectors());
        this.removeAllVectorFields();
        int n = pgPointSet.getNumVectorFields();
        int n2 = 0;
        while (n2 < n) {
            PgVectorField pgVectorField = (PgVectorField)pgPointSet.getVectorField(n2).clone();
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setGeometry(this);
            }
            this.addVectorField(pgVectorField);
            if (pgPointSet.m_selectedVectorField == pgPointSet.getVectorField(n2)) {
                this.m_selectedVectorField = pgVectorField;
            }
            ++n2;
        }
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = d2 / (-1.0 + (double)n2);
        }
        int n3 = 0;
        double d5 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            double d8 = -d2 / 2.0;
            int n5 = 0;
            while (n5 < n2) {
                this.m_vertex[n3].m_data[0] = d * d7;
                this.m_vertex[n3].m_data[1] = d * d6;
                this.m_vertex[n3].m_data[2] = d8;
                d8 += d4;
                this.m_vertexNormal[n3].m_data[0] = d7;
                this.m_vertexNormal[n3].m_data[1] = d6;
                this.m_vertexNormal[n3].m_data[2] = 0.0;
                ++n3;
                ++n5;
            }
            d5 += d3;
            ++n4;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void flipOrientation() {
        if (this.m_vertexNormal != null) {
            int n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexNormal[n].multScalar(-1.0);
                ++n;
            }
        }
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor.getColor();
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor.setColor(color);
    }

    public void projectToSphere(PdVector pdVector, double d) {
        if (pdVector == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector2.sub(this.m_vertex[n], pdVector);
            pdVector2.setLength(d);
            this.m_vertex[n].add(pdVector, pdVector2);
            ++n;
        }
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        Serializable serializable;
        int n;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPointSet)) {
            return false;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometryIf;
        if (this.m_numVectorFields == pgPointSet.m_numVectorFields) {
            n = 0;
            while (n < this.m_numVectorFields) {
                PgVectorField pgVectorField = this.getVectorField(n);
                serializable = pgPointSet.getVectorField(n);
                pgVectorField.merge((PgGeometryIf)((Object)serializable));
                ++n;
            }
        }
        n = this.m_numVertices;
        int n2 = this.m_numVertices + pgPointSet.m_numVertices;
        this.setNumVertices(n2);
        PdVector.copy(this.m_vertex, n, pgPointSet.m_vertex, 0, pgPointSet.m_numVertices);
        serializable = this.getGlobalVertexColor();
        Color color = pgPointSet.getGlobalVertexColor();
        boolean bl2 = ((Color)serializable).getRGB() != color.getRGB() || this.hasVertexColors() || pgPointSet.hasVertexColors();
        boolean bl3 = ((Color)serializable).getRGB() == color.getRGB() && !this.isShowingVertexColors() && !pgPointSet.isShowingVertexColors();
        boolean bl4 = bl2 && !this.hasVertexColors();
        boolean bl5 = bl = bl2 && !pgPointSet.hasVertexColors();
        if (!bl3) {
            this.showVertexColors(true);
        }
        if (bl2) {
            int n3;
            this.assureVertexColors();
            if (bl4) {
                n3 = 0;
                while (n3 < n) {
                    this.setVertexColor(n3, (Color)serializable);
                    ++n3;
                }
            }
            if (bl) {
                n3 = n;
                while (n3 < n2) {
                    this.setVertexColor(n3, color);
                    ++n3;
                }
            } else {
                PdColor.copy(this.m_vertexColor, n, pgPointSet.m_vertexColor, 0, pgPointSet.m_numVertices);
            }
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, n, pgPointSet.m_vertexNormal, 0, pgPointSet.m_numVertices);
        }
        if (pgPointSet.m_vertexSize != null) {
            this.assureVertexSizes();
            this.m_vertexSize.copy(n, pgPointSet.m_vertexSize, 0, pgPointSet.m_numVertices);
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, n, pgPointSet.m_vertexTexture, 0, pgPointSet.m_numVertices);
        }
        return true;
    }

    public PdVector getCenterOfGravity() {
        if (this.m_dim < 0) {
            return null;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(0.0);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector.add(this.m_vertex[n]);
            ++n;
        }
        pdVector.multScalar(1.0 / (double)this.m_numVertices);
        return pdVector;
    }

    public void computeDisk(int n, int n2, double d) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d2 = d / (-1.0 + (double)n);
        double d3 = Math.PI * 2 / (-1.0 + (double)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d4 = d2 * (double)n4;
            int n5 = 0;
            while (n5 < n2) {
                double d5 = d3 * (double)n5;
                if (this.m_dim > 2) {
                    this.m_vertex[n3].setConstant(0.0);
                }
                this.m_vertex[n3].m_data[0] = d4 * Math.cos(d5);
                this.m_vertex[n3].m_data[1] = d4 * Math.sin(d5);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
            return;
        }
        this.setVertexNormals(null);
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public void setGlobalVectorLength(double d) {
        this.m_globalVectorLength.setValue(d);
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n = 0;
            while (n < pgVectorFieldArray.length) {
                if (!pgVectorFieldArray[n].isShowingIndividualMaterial()) {
                    pgVectorFieldArray[n].setGlobalVectorLength(d);
                }
                ++n;
            }
        }
    }

    public boolean makeVertexTextureFromSphere(PdVector pdVector) {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (pdVector == null || pdVector.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector2.sub(this.m_vertex[n], pdVector);
            pdVector2.normalize();
            double[] dArray = pdVector2.m_data;
            double d = 0.0;
            double d2 = 0.0;
            if (dArray[0] > 1.0E-10) {
                d = Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[0] < -1.0E-10) {
                d = Math.PI + Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[1] > 1.0E-10) {
                d = 1.5707963267948966;
            } else if (dArray[1] < -1.0E-10) {
                d = -1.5707963267948966;
            }
            d2 = Math.asin(dArray[2]);
            pdVectorArray[n].set(0.25 + d / 2.0 / Math.PI, 0.5 + d2 / Math.PI);
            ++n;
        }
        return true;
    }

    public void setDimOfVertices(int n) {
        int n2 = 0;
        while (n2 < this.m_maxNumVertices) {
            this.m_vertex[n2].setSize(n);
            ++n2;
        }
        if (this.m_vertexNormal != null) {
            n2 = 0;
            while (n2 < this.m_maxNumVertices) {
                this.m_vertexNormal[n2].setSize(n);
                ++n2;
            }
        }
        this.setDimOfVectors(n);
        super.setDimOfVertices(n);
    }

    public final int getMaxNumVertices() {
        return this.m_maxNumVertices;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showVertices(boolean bl) {
        this.m_bShowVertices = bl;
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumVertices = n;
            return;
        }
        this.m_vertex = PdVector.realloc(this.m_vertex, n, this.m_dim);
        int n2 = 0;
        while (n2 < n) {
            this.m_vertex[n2].clearTag(2);
            ++n2;
        }
        if (this.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, n);
        }
        if (this.m_vertexNormal != null) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, n, this.m_dim);
        }
        if (this.m_vertexSize != null) {
            this.m_vertexSize.setSize(n);
        }
        if (this.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, n, this.m_dimOfTextures);
        }
        if ((n2 = this.getNumVectorFields()) > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            int n3 = 0;
            while (n3 < n2) {
                if (pgVectorFieldArray[n3].getBasedOn() == 0) {
                    pgVectorFieldArray[n3].setNumVectors(n);
                }
                ++n3;
            }
        }
        this.m_maxNumVertices = n;
        if (this.m_maxNumVertices < this.m_numVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
    }

    public void setVertices(PdVector[] pdVectorArray) {
        if (this.m_bInstanceSharing) {
            this.m_vertex = pdVectorArray;
            return;
        }
        if ((pdVectorArray == null || pdVectorArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        if (pdVectorArray[0] == null || pdVectorArray[0].getSize() != this.getDimOfVertices()) {
            PsDebug.warning("wrong dimension at least of first argument vertex.");
            return;
        }
        PdVector.copy(this.m_vertex, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public boolean update(Object object) {
        if (this.m_bUpdateSender) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalVertexSize) {
            return super.update(null);
        }
        if (object == this.m_globalVertexColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalSize) {
            return super.update(null);
        }
        if (object == this.m_globalVectorColor) {
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                int n = 0;
                while (n < pgVectorFieldArray.length) {
                    if (!pgVectorFieldArray[n].isShowingIndividualMaterial()) {
                        pgVectorFieldArray[n].setGlobalVectorColor(this.m_globalVectorColor.getColor());
                    }
                    ++n;
                }
            }
            return super.update(null);
        }
        if (object == this.m_globalVectorLength) {
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                int n = 0;
                while (n < pgVectorFieldArray.length) {
                    if (!pgVectorFieldArray[n].isShowingIndividualMaterial()) {
                        pgVectorFieldArray[n].setGlobalVectorLength(this.m_globalVectorLength.getValue());
                    }
                    ++n;
                }
            }
            return super.update(null);
        }
        if (object == this.m_globalVectorSize) {
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                int n = 0;
                while (n < pgVectorFieldArray.length) {
                    if (!pgVectorFieldArray[n].isShowingIndividualMaterial()) {
                        pgVectorFieldArray[n].setGlobalVectorSize(this.m_globalVectorSize.getValue());
                    }
                    ++n;
                }
            }
            return super.update(null);
        }
        if (object == this.m_shininess) {
            return super.update(null);
        }
        if (object == this.m_specularColor) {
            return super.update(null);
        }
        if (object == this.m_transparency) {
            return super.update(null);
        }
        if (object == this.m_texture) {
            return super.update(this);
        }
        if (object == this) {
            if (this.m_vectorField != null) {
                Enumeration enumeration = this.m_vectorField.elements();
                while (enumeration.hasMoreElements()) {
                    PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                    this.m_bUpdateSender = true;
                    pgVectorField.update(this);
                    this.m_bUpdateSender = false;
                }
            }
            if (this.m_texture != null) {
                this.m_bUpdateSender = true;
                this.m_texture.update(this.m_texture);
                this.m_bUpdateSender = false;
            }
            return super.update(this);
        }
        if (this.m_vectorField != null) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (object != pgVectorField) continue;
                this.m_bUpdateSender = true;
                super.update(this);
                this.m_bUpdateSender = false;
                return true;
            }
        }
        return super.update(object);
    }

    public int[] removeMarkedVertices() {
        int n = 1;
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[this.m_numVertices];
        int n4 = 0;
        while (n4 < this.m_numVertices) {
            nArray[n4] = this.m_vertex[n4].hasTag(2) ? n2 : n;
            ++n4;
        }
        n3 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n) {
                nArray[n4] = n3++;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n2 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]].setSize(this.m_vertex[n4].getSize());
                this.m_vertex[nArray[n4]].copy(this.m_vertex[n4]);
            }
            ++n4;
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]].setSize(this.m_vertexNormal[n4].getSize());
                    this.m_vertexNormal[nArray[n4]].copy(this.m_vertexNormal[n4]);
                }
                ++n4;
            }
        }
        if (this.m_vertexSize != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexSize.setEntry(nArray[n4], this.m_vertexSize.getEntry(n4));
                }
                ++n4;
            }
        }
        if (this.m_vertexTexture != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexTexture[nArray[n4]] = PdVector.copyNew(this.m_vertexTexture[n4]);
                }
                ++n4;
            }
        }
        int n5 = this.getNumVectorFields();
        n4 = 0;
        while (n4 < n5) {
            PgVectorField pgVectorField = this.getVectorField(n4);
            if (pgVectorField.getBasedOn() != 1) {
                int n6 = 0;
                while (n6 < this.m_numVertices) {
                    if (nArray[n6] != n2 && nArray[n6] < n6) {
                        pgVectorField.setVector(nArray[n6], pgVectorField.getVector(n6));
                    }
                    ++n6;
                }
                pgVectorField.setNumVectors(n3);
            }
            ++n4;
        }
        this.setNumVertices(n3);
        this.setMaxNumVertices(n3);
        return nArray;
    }

    public boolean applyAmbientMatrix() {
        if (!super.applyAmbientMatrix()) {
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector.leftMultAffin(this.m_ambientMatrix, this.m_vertex[n], true);
            this.m_vertex[n].copyArray(pdVector);
            ++n;
        }
        this.m_ambientMatrix.setIdentity();
        this.m_ambientInvMatrix.setIdentity();
        return true;
    }

    public boolean makeVertexColorsFromXYZ() {
        if (this.m_numVertices == 0) {
            return true;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        int n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)(pdVectorArray[1].m_data[n2] - pdVectorArray[0].m_data[n2]);
            if ((double)fArray[n2] < 1.0E-10) {
                fArray[n2] = 1.0f;
            }
            ++n2;
        }
        float[] fArray2 = new float[n];
        int n3 = 0;
        while (n3 < this.m_numVertices) {
            int n4 = 0;
            while (n4 < n) {
                float f = (float)(this.m_vertex[n3].m_data[n4] - pdVectorArray[0].m_data[n4]) / fArray[n4];
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray2[n4] = f;
                ++n4;
            }
            if (n == 1) {
                colorArray[n3] = new Color(fArray2[0], 0.0f, 0.0f);
            } else if (n == 2) {
                colorArray[n3] = new Color(fArray2[0], fArray2[1], 0.0f);
            } else if (n >= 3) {
                colorArray[n3] = new Color(fArray2[0], fArray2[1], fArray2[2]);
            }
            ++n3;
        }
        return true;
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = super.getBounds();
        if (this.m_numVertices > 0) {
            PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
            PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
            int n = this.m_dim;
            while (n < 3) {
                pdVectorArray[0].m_data[n] = 0.0;
                pdVectorArray[1].m_data[n] = 0.0;
                ++n;
            }
        }
        return pdVectorArray;
    }

    public boolean hasVertexColors() {
        return this.m_vertexColor != null && this.m_vertexColor.length == this.m_maxNumVertices;
    }

    public void removeVertexColors() {
        this.setVertexColors(null);
    }

    public boolean makeVertexColorsFromZ() {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        float f2 = (float)pdVectorArray[0].getEntry(n);
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            float f3 = (float)(this.m_vertex[n2].getEntry(n) - (double)f2) / f;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            colorArray[n2] = new Color(f3, 0.0f, 1.0f - f3);
            ++n2;
        }
        return true;
    }

    public void scale(double d) {
        if (this.m_center != null) {
            int n = 0;
            while (n < this.m_numVertices) {
                this.m_vertex[n].blend(1.0 - d, this.m_center, d, this.m_vertex[n]);
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].multScalar(d);
            ++n;
        }
    }

    public void scale(double d, PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector2.sub(this.m_vertex[n], pdVector);
            this.m_vertex[n].blendBase(pdVector, d, pdVector2);
            ++n;
        }
    }

    public boolean makeVertexTextureFromCylinder(PdVector pdVector, PdVector pdVector2) {
        double d;
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (pdVector == null || pdVector.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        if (pdVector2 == null || pdVector2.getSize() != this.m_dim) {
            PsDebug.warning("Missing axis or wrong dimension.");
            return false;
        }
        if (Math.abs(pdVector2.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("Axis direction does not have unit length.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector pdVector3 = new PdVector(this.m_dim);
        double d2 = Double.MAX_VALUE;
        double d3 = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector3.sub(this.m_vertex[n], pdVector);
            d = PdVector.dot(pdVector2, pdVector3);
            if (d < d2) {
                d2 = d;
            }
            if (d > d3) {
                d3 = d;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_numVertices) {
            pdVector3.sub(this.m_vertex[n], pdVector);
            d = PdVector.dot(pdVector2, pdVector3);
            double[] dArray = pdVector3.m_data;
            double d4 = 0.0;
            if (dArray[0] > 1.0E-10) {
                d4 = Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[0] < -1.0E-10) {
                d4 = Math.PI + Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[1] > 1.0E-10) {
                d4 = 1.5707963267948966;
            } else if (dArray[1] < -1.0E-10) {
                d4 = -1.5707963267948966;
            }
            pdVectorArray[n].set(0.25 + d4 / 2.0 / Math.PI, (d - d2) / (d3 - d2));
            ++n;
        }
        return true;
    }

    public void computeRotation(PgPolygon pgPolygon, int n) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        int n2 = pgPolygon.getNumVertices();
        this.setNumVertices(n * n2);
        double d = 0.0;
        if (n > 1) {
            d = Math.PI * 2 / (-1.0 + (double)n);
        }
        int n3 = 0;
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        int n4 = 0;
        while (n4 < n) {
            double d2 = d * (double)n4;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            int n5 = 0;
            while (n5 < n2) {
                this.m_vertex[n3].m_data[0] = pdVectorArray[n5].m_data[0];
                this.m_vertex[n3].m_data[1] = d4 * pdVectorArray[n5].m_data[1];
                this.m_vertex[n3].m_data[2] = d3 * pdVectorArray[n5].m_data[1];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        if (pgPolygon.hasVertexColors()) {
            this.assureVertexColors();
            Color[] colorArray = pgPolygon.getVertexColors();
            n3 = 0;
            int n6 = 0;
            while (n6 < n) {
                int n7 = 0;
                while (n7 < n2) {
                    this.m_vertexColor[n3] = colorArray[n7];
                    ++n3;
                    ++n7;
                }
                ++n6;
            }
        }
        if (pgPolygon.hasVertexNormals()) {
            this.assureVertexNormals();
            PdVector[] pdVectorArray2 = pgPolygon.getVertexNormals();
            n3 = 0;
            int n8 = 0;
            while (n8 < n) {
                double d5 = d * (double)n8;
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                int n9 = 0;
                while (n9 < n2) {
                    this.m_vertexNormal[n3].m_data[0] = pdVectorArray2[n9].m_data[0];
                    this.m_vertexNormal[n3].m_data[1] = d7 * pdVectorArray2[n9].m_data[1];
                    this.m_vertexNormal[n3].m_data[2] = d6 * pdVectorArray2[n9].m_data[1];
                    ++n3;
                    ++n9;
                }
                ++n8;
            }
        }
        if (pgPolygon.hasVertexSizes()) {
            this.assureVertexSizes();
            PdVector pdVector = pgPolygon.getVertexSizes();
            n3 = 0;
            int n10 = 0;
            while (n10 < n) {
                int n11 = 0;
                while (n11 < n2) {
                    this.m_vertexSize.setEntry(n3, pdVector.getEntry(n11));
                    ++n3;
                    ++n11;
                }
                ++n10;
            }
        }
    }

    public boolean makeVertexColorsFromZHue() {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        float f2 = (float)pdVectorArray[0].getEntry(n);
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            float f3 = (float)(this.m_vertex[n2].getEntry(n) - (double)f2) / f;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            colorArray[n2] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f3), 1.0f, 1.0f));
            ++n2;
        }
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPointSet) || !(pgGeometry2 instanceof PgPointSet)) {
            return false;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometry;
        PgPointSet pgPointSet2 = (PgPointSet)pgGeometry2;
        if (pgPointSet.m_numVertices == 0) {
            PsDebug.warning("missing vertices of first argument");
            return false;
        }
        if (pgPointSet.m_numVertices != pgPointSet2.m_numVertices) {
            PsDebug.warning("unequal number of vertices of a and b");
            return false;
        }
        PgPointSet pgPointSet3 = d > 0.5 ? pgPointSet : pgPointSet2;
        this.m_dimOfVectors = pgPointSet3.m_dimOfVectors;
        this.m_dimOfColors = pgPointSet3.m_dimOfColors;
        this.m_dimOfTextures = pgPointSet3.m_dimOfTextures;
        this.m_bShowIndices = pgPointSet3.m_bShowIndices;
        this.m_bShowVertexLabels = pgPointSet3.m_bShowVertexLabels;
        this.m_bShowVertexTexture = pgPointSet3.m_bShowVertexTexture;
        this.m_bShowTransparency = pgPointSet3.m_bShowTransparency;
        this.m_bShowVectorFields = pgPointSet3.m_bShowVectorFields;
        this.m_bShowVectorArrows = pgPointSet3.m_bShowVectorArrows;
        this.m_bShowVectorColors = pgPointSet3.m_bShowVectorColors;
        this.m_bShowVertices = pgPointSet3.m_bShowVertices;
        this.m_bShowTaggedVertices = pgPointSet3.m_bShowTaggedVertices;
        this.m_bShowVertexColors = pgPointSet3.m_bShowVertexColors;
        this.m_bShowVertexNormals = pgPointSet3.m_bShowVertexNormals;
        this.m_bShowVertexNormalArrow = pgPointSet3.m_bShowVertexNormalArrow;
        this.m_globalVertexColor.blend(d, pgPointSet.m_globalVertexColor, d2, pgPointSet2.m_globalVertexColor);
        this.m_globalVertexTagColor.blend(d, pgPointSet.m_globalVertexTagColor, d2, pgPointSet2.m_globalVertexTagColor);
        this.m_globalVertexSize.blend(d, pgPointSet.m_globalVertexSize, d2, pgPointSet2.m_globalVertexSize);
        this.m_globalVertexNormalColor.blend(d, pgPointSet.m_globalVertexNormalColor, d2, pgPointSet2.m_globalVertexNormalColor);
        this.m_globalVertexNormalLength.blend(d, pgPointSet.m_globalVertexNormalLength, d2, pgPointSet2.m_globalVertexNormalLength);
        this.m_globalVertexNormalSize.blend(d, pgPointSet.m_globalVertexNormalSize, d2, pgPointSet2.m_globalVertexNormalSize);
        this.m_globalVectorColor.blend(d, pgPointSet.m_globalVectorColor, d2, pgPointSet2.m_globalVectorColor);
        this.m_globalVectorLength.blend(d, pgPointSet.m_globalVectorLength, d2, pgPointSet2.m_globalVectorLength);
        this.m_globalVectorSize.blend(d, pgPointSet.m_globalVectorSize, d2, pgPointSet2.m_globalVectorSize);
        this.m_transparency.blend(d, pgPointSet.m_transparency, d2, pgPointSet2.m_transparency);
        this.setNumVertices(pgPointSet3.m_numVertices);
        if (pgPointSet.m_vertex != null && pgPointSet2.m_vertex != null) {
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertex[n].blend(d, pgPointSet.m_vertex[n], d2, pgPointSet2.m_vertex[n]);
                ++n;
            }
        }
        if (pgPointSet.m_vertexColor != null && pgPointSet2.m_vertexColor != null) {
            this.assureVertexColors();
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexColor[n] = PdColor.blend(d, pgPointSet.m_vertexColor[n], d2, pgPointSet2.m_vertexColor[n]);
                ++n;
            }
        } else {
            this.m_vertexColor = null;
        }
        if (pgPointSet.m_vertexNormal != null && pgPointSet2.m_vertexNormal != null) {
            this.assureVertexNormals();
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexNormal[n].blend(d, pgPointSet.m_vertexNormal[n], d2, pgPointSet2.m_vertexNormal[n]);
                this.m_vertexNormal[n].normalize();
                ++n;
            }
        } else {
            this.m_vertexNormal = null;
        }
        if (pgPointSet.m_vertexSize != null && pgPointSet2.m_vertexSize != null) {
            this.assureVertexSizes();
            this.m_vertexSize.blend(d, pgPointSet.m_vertexSize, d2, pgPointSet2.m_vertexSize);
        } else {
            this.m_vertexSize = null;
        }
        if (pgPointSet.m_vertexTexture != null && pgPointSet2.m_vertexTexture != null) {
            this.assureVertexTextures();
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexTexture[n].blend(d, pgPointSet.m_vertexTexture[n], d2, pgPointSet2.m_vertexTexture[n]);
                ++n;
            }
        } else {
            this.m_vertexTexture = null;
        }
        if (pgPointSet.getNumVectorFields() == pgPointSet2.getNumVectorFields()) {
            int n2 = pgPointSet.getNumVectorFields();
            if (this.getNumVectorFields() != n2) {
                this.removeAllVectorFields();
            }
            n = 0;
            while (n < n2) {
                PgVectorField pgVectorField = pgPointSet.getVectorField(n);
                PgVectorField pgVectorField2 = pgPointSet2.getVectorField(n);
                PgVectorField pgVectorField3 = this.getVectorField(n);
                if (pgVectorField3 == null) {
                    pgVectorField3 = new PgVectorField(this.m_dim, pgVectorField.getBasedOn());
                    this.addVectorField(pgVectorField3);
                }
                pgVectorField3.blend(d, pgVectorField, d2, pgVectorField2);
                ++n;
            }
        }
        return true;
    }

    public void makeQuadrVertexTexture(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.assureVertexTextures();
        double d = 1.0 / (-1.0 + (double)n);
        double d2 = 1.0 / (-1.0 + (double)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d3 = d * (double)n4;
            int n5 = 0;
            while (n5 < n2) {
                double d4 = d2 * (double)n5;
                this.m_vertexTexture[n3].m_data[0] = d3;
                this.m_vertexTexture[n3].m_data[1] = d4;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize.getValue();
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize.getValue();
    }

    public void setGlobalVertexSize(double d) {
        this.m_globalVertexSize.setValue(d);
    }

    public void setGlobalVertexSize(int n) {
        this.setGlobalVertexSize((double)n);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize.setValue(d);
    }

    public void setTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].setTag(n2);
    }

    public int hasVertex(PdVector pdVector, double d) {
        int n = 0;
        while (n < this.m_numVertices) {
            if (this.m_vertex[n].equals(pdVector, d)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int hasVertex(PdVector pdVector) {
        int n = 0;
        while (n < this.m_numVertices) {
            if (this.m_vertex[n].equals(pdVector)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int[] removeVertex(int n) {
        this.m_vertex[n].setTag(2);
        return this.removeMarkedVertices();
    }

    public boolean applyModelingMatrix() {
        if (!super.applyModelingMatrix()) {
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector.copyArray(this.m_vertex[n]);
            pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, true);
            this.m_vertex[n].copyArray(pdVector2);
            ++n;
        }
        if (this.hasVertexNormals()) {
            n = 0;
            while (n < this.m_numVertices) {
                pdVector.copyArray(this.m_vertexNormal[n]);
                pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, false);
                this.m_vertexNormal[n].copyArray(pdVector2);
                ++n;
            }
        }
        n = this.getNumVectorFields();
        int n2 = 0;
        while (n2 < n) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField != null) {
                pgVectorField.applyModelingMatrix();
            }
            ++n2;
        }
        this.m_modelMatrix.setIdentity();
        return true;
    }

    public PdVector getVertexSizes() {
        return this.m_vertexSize;
    }

    public boolean isShowingVertexSizes() {
        return this.m_bShowVertexSizes;
    }

    public void showVertexSizes(boolean bl) {
        this.m_bShowVertexSizes = bl;
    }

    public void assureVertexSizes() {
        if (this.m_vertexSize == null) {
            this.m_vertexSize = new PdVector(this.m_maxNumVertices);
            this.m_vertexSize.setConstant(this.m_globalVertexSize.getValue());
            return;
        }
        if (this.m_vertexSize.getSize() != this.m_maxNumVertices) {
            this.m_vertexSize.setSize(this.m_maxNumVertices);
        }
    }

    public void setVertexSizes(PdVector pdVector) {
        if (this.m_bInstanceSharing) {
            this.m_vertexSize = pdVector;
            return;
        }
        if (pdVector == null) {
            this.m_vertexSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexSizes();
        this.m_vertexSize.copy(0, pdVector, 0, this.m_numVertices);
    }

    public int[] getFVector() {
        return new int[]{this.getNumVertices()};
    }
}

