/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgPointSet;
import jv.number.PdArray_IP;
import jv.number.PdVector_IP;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsAuthorInfo_IP;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsGeometryInfo_IP;
import jv.vecmath.PdVector;

public class PgPointSet_IP
extends PsPanel
implements ActionListener {
    protected PgPointSet m_pointSet;
    protected TextField m_tName;
    protected TextField m_tNumVertices;
    protected PdArray_IP m_vertexPanel;
    private int m_maxVisibleVectors = 5;
    private int m_maxVisibleDim = 5;
    protected static String[] m_header = new String[]{"X", "Y", "Z", "W", "V"};
    protected Panel m_pAuthor;
    protected Panel m_pDescription;
    protected Button m_bAuthor;
    protected Button m_bDescription;
    protected PdVector m_center;
    protected PdVector_IP m_pCenter;
    private static /* synthetic */ Class class$jv$geom$PgPointSet_IP;

    public PgPointSet_IP() {
        if (this.getClass() == (class$jv$geom$PgPointSet_IP != null ? class$jv$geom$PgPointSet_IP : (class$jv$geom$PgPointSet_IP = PgPointSet_IP.class$("jv.geom.PgPointSet_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pointSet = (PgPointSet)psUpdateIf;
    }

    public boolean update(Object object) {
        if (this.m_pointSet == null) {
            PsDebug.warning("missing pointSet");
            return true;
        }
        if (object == this.m_pointSet) {
            PsPanel.setText(this.m_tName, this.m_pointSet.getName());
            int n = this.m_pointSet.getDimOfVertices();
            if (this.m_center.getSize() != n) {
                this.m_center.setSize(n);
                this.m_center.copy(this.m_pointSet.getCenter());
                this.m_pCenter.setVector(this.m_center);
            } else {
                this.m_center.copy(this.m_pointSet.getCenter());
                this.m_pCenter.update(this.m_center);
            }
            PsPanel.setText(this.m_tNumVertices, String.valueOf(this.m_pointSet.getNumVertices()));
            this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, this.m_pointSet.getNumVertices(), n);
            return true;
        }
        if (object == this.m_pCenter) {
            this.m_pointSet.setCenter(this.m_pCenter.getVector());
            return this.m_pointSet.update(null);
        }
        if (object == this.m_vertexPanel) {
            this.m_pointSet.update(this);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tNumVertices) {
            String string = this.m_tNumVertices.getText();
            if (PuString.isEmpty(string)) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    PsDebug.warning("no negative numbers = " + string, this);
                    return;
                }
                int n2 = this.m_pointSet.getNumVertices();
                if (n == n2) {
                    return;
                }
                if (n < n2) {
                    PdVector[] pdVectorArray = this.m_pointSet.getVertices();
                    int n3 = n;
                    while (n3 < n2) {
                        pdVectorArray[n3].setTag(2);
                        ++n3;
                    }
                    this.m_pointSet.removeMarkedVertices();
                } else {
                    this.m_pointSet.setNumVertices(n);
                }
                this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, n, this.m_pointSet.getDimOfVertices());
                this.m_pointSet.update(this.m_pointSet);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + string, this);
                return;
            }
        }
        if (object == this.m_tName) {
            String string = this.m_tName.getText();
            if (string == null || string.equals("")) {
                ((TextComponent)this.m_tName).setText(this.m_pointSet.getName());
                PsDebug.warning("missing name, geometry must have a non-empty name.");
                return;
            }
            this.m_pointSet.setName(string);
            this.m_pointSet.update(this);
            return;
        }
        if (object == this.m_bAuthor) {
            PsAuthorInfo psAuthorInfo = this.m_pointSet.getAuthorInfo();
            if (psAuthorInfo == null) {
                psAuthorInfo = new PsAuthorInfo();
            }
            psAuthorInfo.setProfession(PsConfig.getMessage(24218));
            PsAuthorInfo_IP psAuthorInfo_IP = (PsAuthorInfo_IP)psAuthorInfo.getInfoPanel();
            PsDialog psDialog = new PsDialog(PsConfig.getFrame(), psAuthorInfo_IP.getDialogTitle(), true);
            psDialog.setLayout(new BorderLayout());
            PsPanel psPanel = new PsPanel();
            psPanel.setInsetSize(10);
            psPanel.setBorderType(3);
            psPanel.add(new PsMultiLineLabel(psAuthorInfo_IP.getNotice()));
            if (psPanel != null) {
                psDialog.add((Component)psPanel, "North");
            }
            psDialog.add((Component)psAuthorInfo_IP, "Center");
            psDialog.add((Component)psDialog.getBottomButtons(psAuthorInfo_IP.getDialogButtons()), "South");
            psDialog.addActionListener(psAuthorInfo_IP);
            ((Component)psDialog).setLocation(50, 50);
            ((Component)psDialog).setSize(psAuthorInfo_IP.getDialogSize());
            psDialog.validate();
            ((Component)psDialog).setVisible(true);
            if (psDialog.getUserAction() == 4) {
                psAuthorInfo.removeInspector("Info");
                this.m_pointSet.setAuthorInfo(psAuthorInfo);
                return;
            }
        } else if (object == this.m_bDescription) {
            PsGeometryInfo psGeometryInfo = this.m_pointSet.getGeometryInfo();
            if (psGeometryInfo == null) {
                psGeometryInfo = new PsGeometryInfo();
            }
            psGeometryInfo.setDetailTextOnly(true);
            PsGeometryInfo_IP psGeometryInfo_IP = (PsGeometryInfo_IP)psGeometryInfo.getInfoPanel();
            PsDialog psDialog = new PsDialog(PsConfig.getFrame(), psGeometryInfo_IP.getDialogTitle(), true);
            psDialog.setLayout(new BorderLayout());
            PsPanel psPanel = new PsPanel();
            psPanel.setInsetSize(10);
            psPanel.setBorderType(3);
            psPanel.add(new PsMultiLineLabel(psGeometryInfo_IP.getNotice()));
            if (psPanel != null) {
                psDialog.add((Component)psPanel, "North");
            }
            psDialog.add((Component)psGeometryInfo_IP, "Center");
            psDialog.add((Component)psDialog.getBottomButtons(psGeometryInfo_IP.getDialogButtons()), "South");
            ((Component)psDialog).setLocation(50, 50);
            ((Component)psDialog).setSize(psGeometryInfo_IP.getDialogSize());
            psDialog.validate();
            ((Component)psDialog).setVisible(true);
            if (psDialog.getUserAction() == 4) {
                psGeometryInfo_IP.accept();
                psGeometryInfo.removeInspector("Info");
                this.m_pointSet.setGeometryInfo(psGeometryInfo);
            }
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        PsPanel psPanel = new PsPanel(new GridLayout(1, 2));
        psPanel.addSubTitle(PsConfig.getMessage(24051));
        Panel panel = new Panel(new FlowLayout());
        this.m_bAuthor = new Button(PsConfig.getMessage(24181));
        this.m_bAuthor.addActionListener(this);
        panel.add(this.m_bAuthor);
        this.m_bDescription = new Button(PsConfig.getMessage(24186));
        this.m_bDescription.addActionListener(this);
        panel.add(this.m_bDescription);
        psPanel.add(panel);
        this.add(psPanel);
        panel = new Panel(new GridLayout(1, 2));
        Component component = new Label(PsConfig.getMessage(24052));
        panel.add(component);
        this.m_tName = new TextField("", 7);
        this.m_tName.addActionListener(this);
        panel.add(this.m_tName);
        this.add(panel);
        this.addLine(1);
        component = new Panel(new GridLayout(1, 2));
        this.add(component);
        Component component2 = new Label(PsConfig.getMessage(24053));
        ((Container)component).add(component2);
        this.m_tNumVertices = new TextField("0", 7);
        this.m_tNumVertices.addActionListener(this);
        ((Container)component).add(this.m_tNumVertices);
        this.m_vertexPanel = new PdArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_vertexPanel.setParent(this);
        this.add(this.m_vertexPanel);
        component2 = new PsPanel();
        this.add(component2);
        this.m_pCenter = new PdVector_IP();
        this.m_pCenter.setTitle(PsConfig.getMessage(true, 24000, "Center"));
        this.m_pCenter.setParent(this);
        this.m_center = new PdVector(3);
        this.m_pCenter.setVector(this.m_center);
        ((Container)component2).add(this.m_pCenter);
    }
}

