/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgUtil;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PgPolygon
extends PgPointSet {
    public static final int NORMAL = 100;
    public static final int BINORMAL = 101;
    public static final int OFFSET_NORMAL = 102;
    public static final int CURVATURE_NORMAL = 103;
    protected int m_maxNumEdges;
    protected int m_numEdges;
    private PiVector[] m_edge;
    protected Color[] m_edgeColor;
    protected PdVector[] m_edgeNormal;
    protected PdVector m_edgeSize;
    protected boolean m_bShowEdgeSizes;
    protected boolean m_bClosed;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowEdgeColors;
    protected PdColor m_globalEdgeColor;
    protected PdColor m_globalEdgeTagColor;
    protected PuDouble m_globalEdgeSize;
    protected boolean m_bShowEdgeNormals;
    protected boolean m_bShowEdgeNormalArrow;
    protected PuDouble m_globalEdgeNormalLength;
    protected PuDouble m_globalEdgeNormalSize;
    protected PdColor m_globalEdgeNormalColor;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bInduceEdgeFromVertexColors;
    private static /* synthetic */ Class class$jv$geom$PgPolygon;

    public PiVector[] triangulate() {
        if (this.m_numVertices < 3) {
            PsDebug.warning("number of vertices < 3");
            return null;
        }
        PiVector[] piVectorArray = PgUtil.triangulate(this.m_vertex, this.m_numVertices);
        if (piVectorArray == null) {
            PsDebug.warning("triangulation failed");
            return null;
        }
        return piVectorArray;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = this.m_dim == 2 ? new PdVector(2) : pdVector5;
        PdVector pdVector7 = new PdVector(3);
        PdBary pdBary = new PdBary(2);
        PdBary pdBary2 = new PdBary(2);
        PdVector pdVector8 = null;
        PdVector pdVector9 = null;
        if (this.m_dim == 2) {
            pdVector8 = new PdVector(3);
            pdVector9 = new PdVector(3);
        }
        PdVector pdVector10 = null;
        if (this.m_dim == 2) {
            pdVector10 = new PdVector(3);
        }
        pdVector2.normalize();
        PdVector[] pdVectorArray = this.m_vertex;
        int n4 = 1;
        while (n4 < this.m_numVertices) {
            pdVector3.sub(pdVectorArray[n4], pdVectorArray[n4 - 1]);
            if (!(pdVector3.sqrLength() < 1.0E-10)) {
                if (this.m_dim == 2) {
                    pdVector8.copyArray(pdVectorArray[n4 - 1]);
                    pdVector9.copyArray(pdVectorArray[n4]);
                    pdVector10.copyArray(pdVector3);
                } else {
                    pdVector8 = pdVectorArray[n4 - 1];
                    pdVector9 = pdVectorArray[n4];
                    pdVector10 = pdVector3;
                }
                pdVector10.normalize();
                d3 = PuVectorGeom.distOfLineToLine(pdVector, pdVector2, pdVector8, pdVector10);
                if (!(d3 > d4)) {
                    d = PuVectorGeom.intersectionOfLineAndLine(pdVector5, pdVector, pdVector2, pdVector8, pdVector10);
                    if (this.m_dim == 2) {
                        pdVector6.m_data[0] = pdVector5.m_data[0];
                        pdVector6.m_data[1] = pdVector5.m_data[1];
                    }
                    PdBary.getBary(pdBary, pdVector5, pdVector8, pdVector9);
                    boolean bl = pdBary.isInside();
                    if (bl || Math.abs(1.0 - pdBary.getEntry(0)) < 0.1 || Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                        d4 = d3;
                        d2 = d;
                        n2 = n4;
                        pdVector4.copyArray(pdVector3);
                        n = -1;
                        if (bl) {
                            pdBary2.copy(pdBary);
                            pdVector7.blend(pdBary.getEntry(0), pdVector8, pdBary.getEntry(1), pdVector9);
                        } else if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                            pdBary2.setEntry(0, 1.0);
                            pdBary2.setEntry(1, 0.0);
                            pdVector7.copyArray(pdVector8);
                            n = n4 - 1;
                        } else if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                            pdBary2.setEntry(0, 0.0);
                            pdBary2.setEntry(1, 1.0);
                            pdVector7.copyArray(pdVector9);
                            n = n4;
                        }
                    }
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(pdVector7);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(d4);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public boolean hasEdgeNormals() {
        if (this.m_edgeNormal == null || this.m_edgeNormal.length != this.m_maxNumVertices) {
            return false;
        }
        return this.m_edgeNormal.length <= 0 || !(Math.abs(this.m_edgeNormal[0].sqrLength() - 1.0) > 1.0E-10);
    }

    public void removeEdgeNormals() {
        this.setEdgeNormals(null);
    }

    public boolean makeVertexNormals() {
        this.makeNormals(100, 1.0);
        return true;
    }

    public void makeNormals() {
        this.makeVertexNormals();
    }

    public void makeNormals(int n, double d) {
        int n2;
        int n3;
        int n4;
        PdVector pdVector;
        if (this.m_numVertices < 2 || this.m_numEdges == 0) {
            return;
        }
        if (n == 101 && this.m_dim != 3) {
            PsDebug.warning("dim!=3, cannot compute binormal.");
            return;
        }
        PdVector pdVector2 = null;
        if (this.hasVertexNormals() && (pdVector = this.getVertexNormal(0)).length() > 1.0E-10) {
            pdVector2 = (PdVector)pdVector.clone();
        }
        this.assureVertexNormals();
        pdVector = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        PdVector pdVector5 = new PdVector(this.m_dim);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        boolean bl = this.isClosed();
        int n5 = this.getNumVertices();
        int n6 = 0;
        int n7 = 1;
        int n8 = this.getVertexInd(n6);
        do {
            n4 = this.getVertexInd(n7);
            pdVector.sub(this.m_vertex[n4], this.m_vertex[n8]);
        } while (pdVector.sqrLength() < 1.0E-10 && ++n7 < n5);
        if (n7 >= n5) {
            if (pdVector2 != null) {
                pdVector4.copyArray(pdVector2);
            } else {
                pdVector4.setEntry(this.m_dim - 1, 1.0);
            }
            PdVector.setConstant(this.m_vertexNormal, pdVector4);
            return;
        }
        int n9 = n5 - 1;
        if (bl) {
            n9 = n7;
        }
        pdVector.normalize();
        if (this.m_dim == 2) {
            pdVector4.set(-pdVector.getEntry(1), pdVector.getEntry(0));
            if (pdVector2 == null) {
                pdVector2 = (PdVector)pdVector4.clone();
            } else {
                pdVector2.copy(pdVector4);
            }
        } else if (pdVector2 != null && PdVector.dot(pdVector2, pdVector) > 1.0E-10) {
            pdVector2.orthogonalPart(pdVector4, pdVector);
            pdVector4.normalize();
        } else {
            pdVector4.normalToVector(pdVector);
        }
        if (n7 >= n5 - 1) {
            PdVector.setConstant(this.m_vertexNormal, pdVector4);
            return;
        }
        pdVector5.copy(pdVector4);
        pdVector7.cross(pdVector, pdVector4);
        pdVector4.setLength(d);
        int n10 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            bl3 = true;
        }
        int n11 = n7;
        int n12 = n4;
        boolean bl4 = false;
        boolean bl5 = true;
        while (bl5 || n11 != n9) {
            double d2;
            bl5 = false;
            n7 = n11;
            n11 = (n11 + 1) % n5;
            n4 = n12;
            n12 = this.getVertexInd(n11);
            pdVector3.sub(this.m_vertex[n12], this.m_vertex[n4]);
            if (pdVector3.sqrLength() < 1.0E-10) {
                bl2 = true;
                if (n10 != -1) continue;
                n10 = n7;
                continue;
            }
            pdVector3.normalize();
            pdVector4.sub(pdVector3, pdVector);
            if (!pdVector4.normalize()) {
                n10 = -1;
                bl3 = true;
                continue;
            }
            if (!bl4) {
                if (pdVector2 != null && PdVector.dot(pdVector2, pdVector4) < 0.0) {
                    pdVector4.multScalar(-1.0);
                }
                bl4 = true;
            }
            pdVector6.cross(pdVector, pdVector4);
            if (n == 100) {
                pdVector4.setLength(d);
            } else if (n == 101) {
                pdVector4.copy(pdVector6);
                pdVector4.setLength(d);
            } else if (n == 102) {
                double d3 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                d2 = d / Math.cos(d3 / 2.0);
                pdVector4.setLength(d2);
            } else if (n == 103) {
                double d4 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                d2 = d * d4;
                pdVector4.setLength(d2);
            }
            if (PdVector.dot(pdVector6, pdVector7) < 0.0) {
                pdVector4.multScalar(-1.0);
                pdVector6.multScalar(-1.0);
            }
            if (bl3) {
                int n13 = (n6 + 1) % n5;
                if (!bl && n6 == 0) {
                    n13 = 0;
                }
                bl3 = false;
                if (n == 100) {
                    pdVector5.setSize(3);
                    pdVector5.cross(pdVector6, pdVector);
                    pdVector5.setSize(this.m_dim);
                    pdVector5.setLength(d);
                } else if (n == 101) {
                    pdVector5.copy(pdVector6);
                    pdVector5.setLength(d);
                } else if (n == 102) {
                    pdVector5.setSize(3);
                    pdVector5.cross(pdVector6, pdVector);
                    pdVector5.setSize(this.m_dim);
                    pdVector5.setLength(d);
                } else if (n == 103) {
                    pdVector5.setConstant(0.0);
                }
                n3 = n13;
                while (n3 != n7) {
                    this.m_vertexNormal[this.getVertexInd(n3)].copy(pdVector5);
                    n3 = (n3 + 1) % n5;
                }
            }
            pdVector5.copy(pdVector4);
            if (n == 100) {
                pdVector5.setLength(d);
            } else if (n == 101) {
                pdVector5.copy(pdVector6);
                pdVector5.setLength(d);
            } else if (n == 102) {
                double d5 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                d2 = d / Math.cos(d5 / 2.0);
                pdVector5.setLength(d2);
            } else if (n == 103) {
                double d6 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                d2 = d * d6;
                pdVector5.setLength(d2);
            }
            if (bl2) {
                bl2 = false;
                n3 = n10;
                n10 = -1;
                while (n3 != n7) {
                    this.m_vertexNormal[this.getVertexInd(n3)].copy(pdVector5);
                    n3 = (n3 + 1) % n5;
                }
            }
            this.m_vertexNormal[this.getVertexInd(n7)].copy(pdVector5);
            pdVector.copy(pdVector3);
            pdVector5.copy(pdVector4);
            pdVector7.copy(pdVector6);
            n8 = n4;
            n6 = n7;
        }
        if (!bl && (n2 = n6 + 1) < n5) {
            if (n == 100) {
                pdVector5.setSize(3);
                pdVector5.cross(pdVector7, pdVector);
                pdVector5.setSize(this.m_dim);
                pdVector5.setLength(d);
            } else if (n == 101) {
                pdVector5.copy(pdVector6);
                pdVector5.setLength(d);
            } else if (n == 102) {
                pdVector5.setSize(3);
                pdVector5.cross(pdVector7, pdVector);
                pdVector5.setSize(this.m_dim);
                pdVector5.setLength(d);
            } else if (n == 103) {
                pdVector5.setConstant(0.0);
            }
            n3 = n2;
            while (n3 < n5) {
                this.m_vertexNormal[this.getVertexInd(n3)].copy(pdVector5);
                ++n3;
            }
        }
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public Color getGlobalEdgeNormalColor() {
        return this.m_globalEdgeNormalColor.getColor();
    }

    public void setGlobalEdgeNormalColor(Color color) {
        this.m_globalEdgeNormalColor.setColor(color);
    }

    public boolean isShowingEdgeFromVertexColors() {
        return this.m_bInduceEdgeFromVertexColors;
    }

    public void showEdgeFromVertexColors(boolean bl) {
        this.m_bInduceEdgeFromVertexColors = bl;
    }

    public Object clone() {
        PgPolygon pgPolygon = (PgPolygon)super.clone();
        if (pgPolygon == null) {
            return null;
        }
        pgPolygon.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        pgPolygon.m_globalEdgeColor.setParent(pgPolygon);
        pgPolygon.m_globalEdgeTagColor = (PdColor)this.m_globalEdgeTagColor.clone();
        pgPolygon.m_globalEdgeTagColor.setParent(pgPolygon);
        pgPolygon.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        pgPolygon.m_globalEdgeSize.setParent(pgPolygon);
        pgPolygon.m_globalEdgeNormalLength = (PuDouble)this.m_globalEdgeNormalLength.clone();
        pgPolygon.m_globalEdgeNormalLength.setParent(pgPolygon);
        pgPolygon.m_globalEdgeNormalSize = (PuDouble)this.m_globalEdgeNormalSize.clone();
        pgPolygon.m_globalEdgeNormalSize.setParent(pgPolygon);
        pgPolygon.m_globalEdgeNormalColor = (PdColor)this.m_globalEdgeNormalColor.clone();
        pgPolygon.m_globalEdgeNormalColor.setParent(pgPolygon);
        if (this.m_edge != null) {
            pgPolygon.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_edgeColor != null) {
            pgPolygon.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        if (this.m_edgeNormal != null) {
            pgPolygon.m_edgeNormal = (PdVector[])P_Vector.clone(this.m_edgeNormal);
        }
        if (this.m_edgeSize != null) {
            pgPolygon.m_edgeSize = (PdVector)this.m_edgeSize.clone();
        }
        return pgPolygon;
    }

    public double getLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numEdges) {
            d += PdVector.dist(this.m_vertex[this.m_edge[n].m_data[0]], this.m_vertex[this.m_edge[n].m_data[1]]);
            ++n;
        }
        return d;
    }

    public void setNumVertices(int n) {
        if (this.m_numVertices == n) {
            return;
        }
        super.setNumVertices(n);
        this.setNumEdgesImplicitly(this.m_numVertices);
    }

    protected void setNumEdges(int n) {
        if (n == this.m_numEdges) {
            return;
        }
        if (n > this.m_maxNumEdges) {
            this.setMaxNumEdges(n);
        }
        if (this.m_bClosed && this.m_numVertices > 0) {
            this.m_edge[n - 1].set(this.m_numVertices - 1, 0);
        }
        if (this.m_numEdges > 0) {
            this.m_edge[this.m_numEdges - 1].set(this.m_numEdges - 1, this.m_numEdges);
        }
        this.m_numEdges = n;
    }

    public int getNumEdges() {
        return this.m_numEdges;
    }

    public void removeEdgeSizes() {
        this.setEdgeSizes(null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygon ***********\n");
        stringBuffer.append("\t m_bClosed = " + this.m_bClosed + "\n");
        return stringBuffer.toString();
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    private int getVertexInd(int n) {
        return n % this.m_numVertices;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public void setClosed(boolean bl) {
        if (this.m_bClosed == bl) {
            return;
        }
        this.m_bClosed = bl;
        this.setNumEdgesImplicitly(this.m_numVertices);
    }

    public void makeBiNormals() {
        this.makeNormals(101, 1.0);
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPolygon)) {
            return;
        }
        PgPolygon pgPolygon = (PgPolygon)psObject;
        this.setNumEdges(pgPolygon.getNumEdges());
        this.setClosed(pgPolygon.m_bClosed);
        PiVector.copy(this.m_edge, 0, pgPolygon.m_edge, 0, this.m_numEdges);
        if (pgPolygon.m_edgeColor != null) {
            this.assureEdgeColors();
            PdColor.copy(this.m_edgeColor, 0, pgPolygon.getEdgeColors(), 0, this.m_numEdges);
        } else {
            this.m_edgeColor = null;
        }
        if (pgPolygon.m_edgeNormal != null) {
            this.assureEdgeNormals();
            PdVector.copy(this.m_edgeNormal, 0, pgPolygon.getEdgeNormals(), 0, this.m_numEdges);
        } else {
            this.m_edgeNormal = null;
        }
        if (pgPolygon.m_edgeSize != null) {
            this.assureEdgeSizes();
            this.m_edgeSize.copy(0, pgPolygon.getEdgeSizes(), 0, this.m_numEdges);
            return;
        }
        this.m_edgeSize = null;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void flipOrientation() {
        super.flipOrientation();
        if (this.m_vertex != null) {
            P_Vector.invert(this.m_vertex, this.m_numVertices);
        }
        if (this.m_vertexColor != null) {
            P_Vector.invert(this.m_vertexColor, this.m_numVertices);
        }
        if (this.m_vertexNormal != null) {
            P_Vector.invert(this.m_vertexNormal, this.m_numVertices);
        }
        if (this.m_vertexTexture != null) {
            P_Vector.invert(this.m_vertexTexture, this.m_numVertices);
        }
    }

    public double getLengthOfEdge(int n) {
        double d = PdVector.dist(this.m_vertex[this.m_edge[n].m_data[0]], this.m_vertex[this.m_edge[n].m_data[1]]);
        return d;
    }

    public void computeEight(int n) {
        this.setNumVertices(n);
        if (this.m_dim > 2) {
            PdVector.setConstant(this.m_vertex, 0.0);
            if (this.m_vertexNormal != null) {
                PdVector.setConstant(this.m_vertexNormal, 0.0);
            }
        }
        double d = Math.PI * 2 / (double)this.m_numVertices;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            this.m_vertex[n2].m_data[0] = 2.0 * Math.cos(d * (double)n2);
            this.m_vertex[n2].m_data[1] = 2.0 * Math.sin(2.0 * d * (double)n2);
            ++n2;
        }
        if (this.m_vertexNormal != null) {
            n2 = 0;
            while (n2 < this.m_numVertices) {
                this.m_vertexNormal[n2].m_data[0] = -Math.sin(d * (double)n2);
                this.m_vertexNormal[n2].m_data[1] = 2.0 * Math.cos(2.0 * d * (double)n2);
                this.m_vertexNormal[n2].normalize();
                ++n2;
            }
        }
        this.setClosed(true);
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_maxNumVertices) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_maxNumVertices);
        }
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void init() {
        super.init();
        this.setClosed(false);
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = true;
        this.m_bShowEdgeNormals = false;
        this.m_bShowEdgeColors = false;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_bShowEdgeNormals = false;
        this.m_bShowEdgeNormalArrow = false;
        this.m_globalEdgeNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeNormalSize.setDefValue(1.0);
        this.m_globalEdgeNormalSize.init();
        this.m_globalEdgeNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalEdgeNormalLength.setDefValue(0.5);
        this.m_globalEdgeNormalLength.init();
        this.m_globalEdgeNormalColor.setColor(Color.yellow);
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeTagColor.setColor(Color.magenta);
        this.m_globalEdgeSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_edgeSize = null;
        this.m_bShowEdgeSizes = false;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public void setEdgeColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_edgeColor = null;
            return;
        }
        int n = this.getNumEdges();
        if (colorArray.length < n) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_edgeColor == null || n > this.m_edgeColor.length) {
            this.assureEdgeColors();
        }
        PdColor.copy(this.m_edgeColor, 0, colorArray, 0, n);
    }

    public boolean makeEdgeFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numEdges == 0) {
            return true;
        }
        this.assureEdgeColors();
        int n = 0;
        while (n < this.m_numEdges) {
            this.m_edgeColor[n] = PdColor.blend(0.5, this.m_vertexColor[this.m_edge[n].m_data[0]], 0.5, this.m_vertexColor[this.m_edge[n].m_data[1]]);
            ++n;
        }
        return true;
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor.getColor();
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor.setColor(color);
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public boolean makeVertexFromEdgeColors() {
        if (!this.hasEdgeColors()) {
            PsDebug.warning("missing edge colors");
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        int n = 0;
        while (n < this.m_numEdges) {
            int n2 = 0;
            do {
                int n3 = this.m_edge[n].m_data[n2];
                int[] nArray3 = nArray[n3];
                nArray3[0] = nArray3[0] + this.m_edgeColor[n].getRed();
                int[] nArray4 = nArray[n3];
                nArray4[1] = nArray4[1] + this.m_edgeColor[n].getGreen();
                int[] nArray5 = nArray[n3];
                nArray5[2] = nArray5[2] + this.m_edgeColor[n].getBlue();
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
            } while (++n2 < 2);
            ++n;
        }
        this.assureVertexColors();
        n = 0;
        while (n < this.m_numVertices) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
            } else {
                this.setVertexColor(n, Color.black);
            }
            ++n;
        }
        return true;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public void computeCircle(int n, double d) {
        this.setNumVertices(n);
        this.assureVertexNormals();
        if (this.m_dim > 2) {
            PdVector.setConstant(this.m_vertex, 0.0);
            if (this.m_vertexNormal != null) {
                PdVector.setConstant(this.m_vertexNormal, 0.0);
            }
        }
        double d2 = Math.PI * 2 / (double)this.m_numVertices;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            this.m_vertex[n2].m_data[0] = d * Math.cos(d2 * (double)n2);
            this.m_vertex[n2].m_data[1] = d * Math.sin(d2 * (double)n2);
            ++n2;
        }
        if (this.m_vertexNormal != null) {
            n2 = 0;
            while (n2 < this.m_numVertices) {
                this.m_vertexNormal[n2].m_data[0] = Math.cos(d2 * (double)n2);
                this.m_vertexNormal[n2].m_data[1] = Math.sin(d2 * (double)n2);
                ++n2;
            }
        }
        this.setClosed(true);
    }

    protected void setMaxNumEdges(int n) {
        if (this.m_maxNumEdges == n) {
            return;
        }
        this.m_edge = PiVector.realloc(this.m_edge, n, 2);
        if (this.m_edgeNormal != null) {
            this.m_edgeNormal = PdVector.realloc(this.m_edgeNormal, n, this.m_dim);
        }
        if (this.m_edgeColor != null) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, n);
        }
        int n2 = this.m_maxNumEdges;
        while (n2 < n) {
            this.m_edge[n2].set(n2, n2 + 1);
            ++n2;
        }
        this.m_maxNumEdges = n;
        if (this.m_maxNumEdges < this.m_numEdges) {
            this.m_numEdges = this.m_maxNumEdges;
        }
    }

    public void setDimOfVertices(int n) {
        if (this.m_edgeNormal != null) {
            int n2 = 0;
            while (n2 < this.m_maxNumEdges) {
                this.m_edgeNormal[n2].setSize(n);
                ++n2;
            }
        }
        super.setDimOfVertices(n);
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeTagColor) {
            return super.update(null);
        }
        return super.update(object);
    }

    public double getGlobalEdgeNormalLength() {
        return this.m_globalEdgeNormalLength.getValue();
    }

    public void setGlobalEdgeNormalLength(double d) {
        this.m_globalEdgeNormalLength.setValue(d);
    }

    public boolean makeEdgeColorsFromLength() {
        if (this.m_dim == 0) {
            return false;
        }
        int n = this.getNumEdges();
        if (n == 0) {
            return true;
        }
        this.assureEdgeColors();
        double d = this.getLength();
        if (!this.isClosed()) {
            d /= 0.8;
        }
        double d2 = 0.0;
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            if (d > 1.0E-10) {
                f = (float)(d2 / d);
            }
            this.setEdgeColor(n2, new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
            d2 += this.getLengthOfEdge(n2);
            ++n2;
        }
        return true;
    }

    public boolean makeVertexColorsFromLength() {
        if (this.m_dim == 0) {
            return false;
        }
        int n = this.getNumEdges();
        if (n == 0) {
            return true;
        }
        this.assureVertexColors();
        double d = this.getLength();
        if (!this.isClosed()) {
            d /= 0.8;
        }
        double d2 = 0.0;
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            if (d > 1.0E-10) {
                f = (float)(d2 / d);
            }
            this.setVertexColor(this.m_edge[n2].m_data[0], new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
            d2 += this.getLengthOfEdge(n2);
            ++n2;
        }
        if (!this.isClosed()) {
            if (d > 1.0E-10) {
                f = (float)(d2 / d);
            }
            this.setVertexColor(this.m_edge[n - 1].m_data[1], new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
        }
        return true;
    }

    public boolean makeEdgeColorsFromXYZ() {
        int n = this.getNumEdges();
        if (n == 0) {
            return true;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureEdgeColors();
        Color[] colorArray = this.getEdgeColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n2 = 0;
        while (n2 < this.m_dim) {
            if (dArray[n2] < 1.0E-10) {
                dArray[n2] = 1.0;
            }
            ++n2;
        }
        n2 = Math.min(3, this.m_dim);
        float[] fArray = new float[n2];
        int n3 = 0;
        while (n3 < n) {
            pdVector2.blend(0.5, this.m_vertex[this.m_edge[n3].m_data[0]], 0.5, this.m_vertex[this.m_edge[n3].m_data[1]]);
            pdVector.sub(pdVector2, pdVectorArray[0]);
            int n4 = 0;
            while (n4 < n2) {
                fArray[n4] = (float)(pdVector.m_data[n4] / dArray[n4]);
                ++n4;
            }
            if (n2 == 1) {
                colorArray[n3] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n2 == 2) {
                colorArray[n3] = new Color(fArray[0], fArray[1], 0.0f);
            } else if (n2 == 3) {
                colorArray[n3] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n3;
        }
        return true;
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    public void showPolygonColors(boolean bl) {
        this.showEdgeColors(bl);
    }

    public boolean isShowingEdgeNormals() {
        return this.m_bShowEdgeNormals;
    }

    public boolean isShowingPolygonColors() {
        return this.isShowingEdgeColors();
    }

    public void showEdgeNormals(boolean bl) {
        this.m_bShowEdgeNormals = bl;
    }

    public boolean hasEdgeColors() {
        return this.m_edgeColor != null && this.m_edgeColor.length == this.m_maxNumVertices;
    }

    public void removeEdgeColors() {
        this.setEdgeColors(null);
    }

    public PdVector[] getEdgeNormals() {
        return this.m_edgeNormal;
    }

    public void setEdgeNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_edgeNormal = null;
            return;
        }
        int n = this.getNumEdges();
        if (pdVectorArray.length < n) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_edgeNormal == null || n > this.m_edgeNormal.length) {
            this.assureEdgeNormals();
        }
        PdVector.copy(this.m_edgeNormal, 0, pdVectorArray, 0, n);
    }

    public void assureEdgeNormals() {
        if (this.m_edgeNormal == null || this.m_edgeNormal.length != this.m_maxNumVertices) {
            this.m_edgeNormal = PdVector.realloc(this.m_edgeNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void makeOffsetNormals() {
        this.makeNormals(102, 1.0);
    }

    public void makeCurvatureNormals() {
        this.makeNormals(103, 1.0);
    }

    public boolean makeEdgeColorsFromZ() {
        if (this.m_dim == 0) {
            return false;
        }
        int n = this.getNumEdges();
        if (n == 0) {
            return true;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n2 = Math.min(2, this.m_dim - 1);
        this.assureEdgeColors();
        Color[] colorArray = this.getEdgeColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n2] - pdVectorArray[0].m_data[n2]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n3 = 0;
        while (n3 < n) {
            pdVector2.blend(0.5, this.m_vertex[this.m_edge[n3].m_data[0]], 0.5, this.m_vertex[this.m_edge[n3].m_data[1]]);
            pdVector.sub(pdVector2, pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n2] / f;
            colorArray[n3] = new Color(f2, 0.0f, 1.0f - f2);
            ++n3;
        }
        return true;
    }

    public boolean checkTriangleCut(int n, PdVector pdVector) {
        PdVector[] pdVectorArray = new PdVector[3];
        PdVector[] pdVectorArray2 = new PdVector[3];
        PdVector[] pdVectorArray3 = new PdVector[3];
        double[] dArray = new double[3];
        n = (n + this.m_numVertices - 1) % this.m_numVertices;
        int n2 = 0;
        do {
            pdVectorArray[n2] = this.m_vertex[(n + n2) % this.m_numVertices];
        } while (++n2 < 3);
        n2 = 0;
        do {
            pdVectorArray2[n2] = PdVector.subNew(pdVectorArray[(n + n2 + 1) % this.m_numVertices], pdVectorArray[(n + n2) % this.m_numVertices]);
            pdVectorArray3[n2] = PdVector.crossNew(pdVector, pdVectorArray2[n2]);
            boolean bl = pdVectorArray3[n2].normalize();
            if (!bl) {
                PsDebug.warning("two vertices may be identical");
                return false;
            }
            dArray[n2] = -PdVector.dot(pdVectorArray3[n2], pdVectorArray[n2]);
        } while (++n2 < 3);
        int n3 = (n + 2) % n;
        while (n3 != n) {
            if (PdVector.dot(this.m_vertex[n3], pdVectorArray3[0]) + dArray[0] > 0.0 && PdVector.dot(this.m_vertex[n3], pdVectorArray3[1]) + dArray[1] > 0.0 && PdVector.dot(this.m_vertex[n3], pdVectorArray3[2]) + dArray[2] > 0.0) {
                return false;
            }
            n3 = n3++ % n;
        }
        return true;
    }

    public boolean makeEdgeColorsFromZHue() {
        if (this.m_dim == 0) {
            return false;
        }
        int n = this.getNumEdges();
        if (n == 0) {
            return true;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n2 = Math.min(2, this.m_dim - 1);
        this.assureEdgeColors();
        Color[] colorArray = this.getEdgeColors();
        float f = (float)(pdVectorArray[1].m_data[n2] - pdVectorArray[0].m_data[n2]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n3 = 0;
        while (n3 < n) {
            pdVector2.blend(0.5, this.m_vertex[this.m_edge[n3].m_data[0]], 0.5, this.m_vertex[this.m_edge[n3].m_data[1]]);
            pdVector.sub(pdVector2, pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n2] / f;
            colorArray[n3] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
            ++n3;
        }
        return true;
    }

    public PgPolygon() {
        this(3);
    }

    public PgPolygon(int n) {
        super(n);
        this.setType(31);
        this.m_geomItem.addElement("Polygon");
        this.setDimOfSimplex(1);
        this.m_edge = new PiVector[0];
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage(24023), this);
        this.m_globalEdgeTagColor = new PdColor(PsConfig.getMessage(24024), this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage(24025), this);
        this.m_globalEdgeNormalLength = new PuDouble(PsConfig.getMessage(24045), this);
        this.m_globalEdgeNormalSize = new PuDouble(PsConfig.getMessage(24046), this);
        this.m_globalEdgeNormalColor = new PdColor(PsConfig.getMessage(24323), this);
        this.m_bClosed = false;
        if (this.getClass() == (class$jv$geom$PgPolygon != null ? class$jv$geom$PgPolygon : (class$jv$geom$PgPolygon = PgPolygon.class$("jv.geom.PgPolygon")))) {
            this.init();
        }
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalEdgeTagColor.getColor();
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalEdgeTagColor.setColor(color);
    }

    public void useGlobalPolygonColor(boolean bl) {
        this.showPolygonColors(!bl);
    }

    public boolean setEdgeColor(int n, Color color) {
        if (n < 0 || n >= this.m_numEdges) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_edgeColor == null || this.m_numEdges > this.m_edgeColor.length) {
            this.assureEdgeColors();
        }
        this.m_edgeColor[n] = color;
        return true;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(82, this.isShowingEdgeLabels());
        pvGeometryIf.setState(83, false);
        pvGeometryIf.setState(54, this.m_bShowEdges);
        pvGeometryIf.setState(55, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(89, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(90, this.m_bShowPolygonEndArrow);
        if (this.m_globalEdgeSize != null) {
            pvGeometryIf.setGlobalPolygonSize(this.m_globalEdgeSize.getValue());
        }
        if (this.m_globalEdgeColor != null) {
            pvGeometryIf.setGlobalPolygonColor(this.m_globalEdgeColor.getColor());
        }
        if (this.m_globalEdgeTagColor != null) {
            pvGeometryIf.setGlobalPolygonTagColor(this.m_globalEdgeTagColor.getColor());
        }
        pvGeometryIf.setDimOfPolygons(2);
        pvGeometryIf.setNumPolygons(this.getNumEdges());
        pvGeometryIf.setPolygons(this.getEdges());
        pvGeometryIf.setPolygonColors(this.m_edgeColor);
        pvGeometryIf.setState(93, this.m_bShowEdgeColors);
        pvGeometryIf.setState(101, this.isShowingSmoothLighting());
        pvGeometryIf.setState(102, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(103, this.isShowingEdgeFromVertexColors());
        pvGeometryIf.setPolygonNormals(this.m_edgeNormal);
        pvGeometryIf.setState(64, this.m_bShowEdgeNormals);
        pvGeometryIf.setState(65, this.m_bShowEdgeNormalArrow);
        if (this.m_globalEdgeNormalSize != null) {
            pvGeometryIf.setGlobalPolygonNormalSize(this.m_globalEdgeNormalSize.getValue());
        }
        if (this.m_globalEdgeNormalLength != null) {
            pvGeometryIf.setGlobalPolygonNormalLength(this.m_globalEdgeNormalLength.getValue());
        }
        if (this.m_globalEdgeNormalColor != null) {
            pvGeometryIf.setGlobalPolygonNormalColor(this.m_globalEdgeNormalColor.getColor());
        }
        pvGeometryIf.setPolygonSizes(this.m_edgeSize);
        pvGeometryIf.setState(105, this.m_bShowEdgeSizes);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygon) || !(pgGeometry2 instanceof PgPolygon)) {
            return false;
        }
        PgPolygon pgPolygon = (PgPolygon)pgGeometry;
        PgPolygon pgPolygon2 = (PgPolygon)pgGeometry2;
        PgPolygon pgPolygon3 = d > 0.5 ? pgPolygon : pgPolygon2;
        this.m_bShowEdges = pgPolygon3.m_bShowEdges;
        this.m_bShowTaggedEdges = pgPolygon3.m_bShowTaggedEdges;
        this.m_bShowEdgeColors = pgPolygon3.m_bShowEdgeColors;
        this.m_bShowEdgeLabels = pgPolygon3.m_bShowEdgeLabels;
        this.m_bShowEdgeNormals = pgPolygon3.m_bShowEdgeNormals;
        this.m_bShowEdgeNormalArrow = pgPolygon3.m_bShowEdgeNormalArrow;
        this.setClosed(pgPolygon.isClosed() && pgPolygon2.isClosed());
        this.m_bShowPolygonStartArrow = pgPolygon3.m_bShowPolygonStartArrow;
        this.m_bShowPolygonEndArrow = pgPolygon3.m_bShowPolygonEndArrow;
        this.m_globalEdgeColor.blend(d, pgPolygon.m_globalEdgeColor, d2, pgPolygon2.m_globalEdgeColor);
        this.m_globalEdgeTagColor.blend(d, pgPolygon.m_globalEdgeTagColor, d2, pgPolygon2.m_globalEdgeTagColor);
        this.m_globalEdgeSize.blend(d, pgPolygon.m_globalEdgeSize, d2, pgPolygon2.m_globalEdgeSize);
        this.m_globalEdgeNormalColor.blend(d, pgPolygon.m_globalEdgeNormalColor, d2, pgPolygon2.m_globalEdgeNormalColor);
        this.m_globalEdgeNormalLength.blend(d, pgPolygon.m_globalEdgeNormalLength, d2, pgPolygon2.m_globalEdgeNormalLength);
        this.m_globalEdgeNormalSize.blend(d, pgPolygon.m_globalEdgeNormalSize, d2, pgPolygon2.m_globalEdgeNormalSize);
        return true;
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public double getGlobalEdgeNormalSize() {
        return this.m_globalEdgeNormalSize.getValue();
    }

    public void setGlobalEdgeNormalSize(double d) {
        this.m_globalEdgeNormalSize.setValue(d);
    }

    public boolean isShowingEdgeNormalArrow() {
        return this.m_bShowEdgeNormalArrow;
    }

    public void showEdgeNormalArrow(boolean bl) {
        this.m_bShowEdgeNormalArrow = bl;
    }

    public boolean setEdgeNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numEdges) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_edgeNormal == null || this.m_numEdges > this.m_edgeNormal.length) {
            this.assureEdgeNormals();
        }
        this.m_edgeNormal[n].copy(pdVector);
        return true;
    }

    protected void setNumEdgesImplicitly(int n) {
        int n2 = this.m_bClosed ? this.m_numVertices : this.m_numVertices - 1;
        this.setNumEdges(n2);
    }

    public double getGlobalPolygonSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(31);
        pgJvxSrc.showPolygonLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showEdgeLabels(false);
        pgJvxSrc.showPolygons(this.m_bShowEdges);
        pgJvxSrc.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        pgJvxSrc.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        pgJvxSrc.setDimOfPolygons(this.getNumEdges());
        pgJvxSrc.setNumPolygons(this.getNumEdges());
        pgJvxSrc.setPolygons(this.getEdges());
        pgJvxSrc.showPolygonColors(this.isShowingEdgeColors());
        pgJvxSrc.setPolygonColors(this.getEdgeColors());
        pgJvxSrc.setGlobalPolygonColor(this.getGlobalPolygonColor());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothEdgeColors());
        pgJvxSrc.showElementFromVertexColors(this.isShowingEdgeFromVertexColors());
        pgJvxSrc.setGlobalPolygonColor(this.getGlobalEdgeColor());
        pgJvxSrc.setGlobalPolygonTagColor(this.getGlobalEdgeTagColor());
        pgJvxSrc.showPolygonNormals(this.isShowingEdgeNormals());
        pgJvxSrc.setPolygonNormals(this.getEdgeNormals());
        pgJvxSrc.setGlobalPolygonNormalColor(this.getGlobalEdgeNormalColor());
        pgJvxSrc.setGlobalPolygonNormalLength(this.getGlobalEdgeNormalLength());
        pgJvxSrc.setGlobalPolygonNormalSize(this.getGlobalEdgeNormalSize());
        pgJvxSrc.showPolygonSizes(this.isShowingEdgeSizes());
        pgJvxSrc.setPolygonSizes(this.getEdgeSizes());
        pgJvxSrc.setGlobalPolygonSize(this.getGlobalEdgeSize());
        return pgJvxSrc;
    }

    public PdVector getEdgeSizes() {
        return this.m_edgeSize;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showEdges(pgJvxSrc.isShowingPolygons());
        this.showEdgeLabels(pgJvxSrc.isShowingPolygonLabels());
        this.showPolygonStartArrow(pgJvxSrc.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(pgJvxSrc.isShowingPolygonEndArrow());
        this.setEdgeColors(pgJvxSrc.getPolygonColors());
        this.setGlobalEdgeColor(pgJvxSrc.getGlobalPolygonColor());
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothEdgeColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showEdgeFromVertexColors(pgJvxSrc.isShowingElementFromVertexColors());
        this.showEdgeColors(pgJvxSrc.isShowingPolygonColors());
        this.setGlobalEdgeColor(pgJvxSrc.getGlobalPolygonColor());
        this.setGlobalEdgeTagColor(pgJvxSrc.getGlobalPolygonTagColor());
        this.setEdgeNormals(pgJvxSrc.getPolygonNormals());
        this.setGlobalEdgeNormalColor(pgJvxSrc.getGlobalPolygonNormalColor());
        this.setGlobalEdgeNormalLength(pgJvxSrc.getGlobalPolygonNormalLength());
        this.setGlobalEdgeNormalSize(pgJvxSrc.getGlobalPolygonNormalSize());
        this.showEdgeSizes(pgJvxSrc.isShowingPolygonSizes());
        this.setEdgeSizes(pgJvxSrc.getPolygonSizes());
        this.setGlobalEdgeSize(pgJvxSrc.getGlobalPolygonSize());
    }

    public boolean isShowingEdgeSizes() {
        return this.m_bShowEdgeSizes;
    }

    public void showEdgeSizes(boolean bl) {
        this.m_bShowEdgeSizes = bl;
    }

    public void setEdgeSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_edgeSize = null;
            return;
        }
        int n = this.getNumEdges();
        if (pdVector.getSize() < n) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureEdgeSizes();
        this.m_edgeSize.copy(0, pdVector, 0, n);
    }

    public void assureEdgeSizes() {
        if (this.m_edgeSize == null) {
            this.m_edgeSize = new PdVector(this.m_maxNumVertices);
            this.m_edgeSize.setConstant(this.m_globalEdgeSize.getValue());
            return;
        }
        if (this.m_edgeSize.getSize() != this.m_maxNumVertices) {
            this.m_edgeSize.setSize(this.m_maxNumVertices);
        }
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int n = this.getNumEdges();
        int[] nArray2 = PuData.realloc(nArray, nArray.length + 1);
        nArray2[nArray.length] = n;
        return nArray2;
    }
}

