/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PgPolygonSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowPolygonLabels;
    protected int m_dimOfPolygons;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected PdVector m_polygonSize;
    protected boolean m_bShowPolygonSizes;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected PuDouble m_globalPolygonNormalLength;
    protected PuDouble m_globalPolygonNormalSize;
    protected PdColor m_globalPolygonNormalColor;
    protected boolean m_bShowPolygonColors;
    protected PdColor m_globalPolygonColor;
    protected PdColor m_globalPolygonTagColor;
    protected PuDouble m_globalPolygonSize;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bInduceEdgeFromVertexColors;
    public static final int NORMAL = 100;
    public static final int BINORMAL = 101;
    public static final int OFFSET_NORMAL = 102;
    public static final int CURVATURE_NORMAL = 103;
    private static /* synthetic */ Class class$jv$geom$PgPolygonSet;

    public int addPolygon(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 1) {
            PsDebug.warning("missing polygon, or too small.");
            return -1;
        }
        int n = this.m_numPolygons;
        if (n == this.m_maxNumPolygons) {
            this.setMaxNumPolygons((int)((double)(n + 1) * 1.2));
        }
        this.setNumPolygons(n + 1);
        this.setPolygon(n, piVector);
        return n;
    }

    public boolean hasTagPolygon(int n, int n2) {
        if (this.m_polygon == null || n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_polygon[n].hasTag(n2);
    }

    public double getLengthOfPolygon(int n) {
        PdVector[] pdVectorArray = this.getPolygonVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 2) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 1;
        while (n2 < pdVectorArray.length) {
            d += PdVector.dist(pdVectorArray[n2 - 1], pdVectorArray[n2]);
            ++n2;
        }
        return d;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = this.m_dim == 2 ? new PdVector(2) : pdVector5;
        PdVector pdVector7 = new PdVector(3);
        PdBary pdBary = new PdBary(2);
        PdBary pdBary2 = new PdBary(2);
        PdVector pdVector8 = null;
        PdVector pdVector9 = null;
        if (this.m_dim == 2) {
            pdVector8 = new PdVector(3);
            pdVector9 = new PdVector(3);
        }
        PdVector pdVector10 = null;
        if (this.m_dim == 2) {
            pdVector10 = new PdVector(3);
        }
        pdVector2.normalize();
        int n4 = 0;
        while (n4 < this.m_numPolygons) {
            PdVector[] pdVectorArray = this.getPolygonVertices(n4);
            if (pdVectorArray != null && pdVectorArray.length >= 2) {
                int n5 = 1;
                while (n5 < pdVectorArray.length) {
                    pdVector3.sub(pdVectorArray[n5], pdVectorArray[n5 - 1]);
                    if (!(pdVector3.sqrLength() < 1.0E-10)) {
                        if (this.m_dim == 2) {
                            pdVector8.copyArray(pdVectorArray[n5 - 1]);
                            pdVector9.copyArray(pdVectorArray[n5]);
                            pdVector10.copyArray(pdVector3);
                        } else {
                            pdVector8 = pdVectorArray[n5 - 1];
                            pdVector9 = pdVectorArray[n5];
                            pdVector10 = pdVector3;
                        }
                        pdVector10.normalize();
                        d3 = PuVectorGeom.distOfLineToLine(pdVector, pdVector2, pdVector8, pdVector10);
                        if (!(d3 >= d4)) {
                            d = PuVectorGeom.intersectionOfLineAndLine(pdVector5, pdVector, pdVector2, pdVector8, pdVector10);
                            if (this.m_dim == 2) {
                                pdVector6.m_data[0] = pdVector5.m_data[0];
                                pdVector6.m_data[1] = pdVector5.m_data[1];
                            }
                            PdBary.getBary(pdBary, pdVector5, pdVector8, pdVector9);
                            boolean bl = pdBary.isInside();
                            if (bl || Math.abs(1.0 - pdBary.getEntry(0)) < 0.1 || Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                                d4 = d3;
                                d2 = d;
                                n2 = n4;
                                n3 = n5;
                                pdVector4.copyArray(pdVector3);
                                n = -1;
                                if (bl) {
                                    pdBary2.copy(pdBary);
                                    pdVector7.blend(pdBary.getEntry(0), pdVector8, pdBary.getEntry(1), pdVector9);
                                } else if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                                    pdBary2.setEntry(0, 1.0);
                                    pdBary2.setEntry(1, 0.0);
                                    pdVector7.copyArray(pdVector8);
                                    n = this.m_polygon[n4].getEntry(n5 - 1);
                                } else if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                                    pdBary2.setEntry(0, 0.0);
                                    pdBary2.setEntry(1, 1.0);
                                    pdVector7.copyArray(pdVector9);
                                    n = this.m_polygon[n4].getEntry(n5);
                                }
                            }
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(pdVector7);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(d4);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public PiVector[] triangulate() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        PiVector[][] piVectorArrayArray = new PiVector[this.m_numPolygons][];
        int n5 = 0;
        while (n5 < this.m_numPolygons) {
            n3 = this.m_polygon[n5].getSize();
            if (n3 > 1 && this.m_polygon[n5].m_data[n3 - 1] == this.m_polygon[n5].m_data[0]) {
                --n3;
            }
            PdVector[] pdVectorArray = new PdVector[n3];
            n2 = 0;
            while (n2 < n3) {
                pdVectorArray[n2] = this.m_vertex[this.m_polygon[n5].m_data[n2]];
                ++n2;
            }
            piVectorArrayArray[n5] = PgUtil.triangulate(pdVectorArray, n3);
            if (piVectorArrayArray[n5] != null) {
                n2 = piVectorArrayArray[n5].length;
                n4 += n2;
                n = 0;
                while (n < n2) {
                    int n6 = piVectorArrayArray[n5][n].getSize();
                    int n7 = 0;
                    while (n7 < n6) {
                        piVectorArrayArray[n5][n].m_data[n7] = this.m_polygon[n5].m_data[piVectorArrayArray[n5][n].m_data[n7]];
                        ++n7;
                    }
                    ++n;
                }
            }
            ++n5;
        }
        PiVector[] piVectorArray = new PiVector[n4];
        n3 = 0;
        int n8 = 0;
        while (n8 < this.m_numPolygons) {
            if (piVectorArrayArray[n8] != null) {
                n2 = piVectorArrayArray[n8].length;
                n = 0;
                while (n < n2) {
                    piVectorArray[n3] = piVectorArrayArray[n8][n];
                    ++n3;
                    ++n;
                }
            }
            ++n8;
        }
        if (n4 == 0) {
            PsDebug.warning("triangulation failed");
            return null;
        }
        return piVectorArray;
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public void showPolygonNormals(boolean bl) {
        this.m_bShowPolygonNormals = bl;
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_maxNumPolygons, this.m_dim);
        }
    }

    public void setPolygonNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_polygonNormal == null || this.m_numPolygons > this.m_polygonNormal.length) {
            this.assurePolygonNormals();
        }
        PdVector.copy(this.m_polygonNormal, 0, pdVectorArray, 0, this.m_numPolygons);
    }

    public boolean makeVertexNormals() {
        this.makeNormals(100, 1.0);
        return true;
    }

    public void makeNormals() {
        this.makeVertexNormals();
    }

    public void makeNormals(int n, double d) {
        PdVector pdVector;
        if (this.m_numVertices < 2) {
            return;
        }
        if (n == 101 && this.m_dim != 3) {
            PsDebug.warning("dim!=3, cannot compute binormal.");
            return;
        }
        PdVector pdVector2 = null;
        if (this.hasVertexNormals() && (pdVector = this.getVertexNormal(0)).length() > 1.0E-10) {
            pdVector2 = (PdVector)pdVector.clone();
        }
        this.assureVertexNormals();
        pdVector = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        PdVector pdVector5 = new PdVector(this.m_dim);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            int n3 = this.m_polygon[n2].getSize();
            boolean bl = this.isClosed(n2);
            if (bl) {
                --n3;
            }
            if (this.m_polygon[n2] == null || n3 < 2) {
                PsDebug.warning("polygon[" + n2 + "] null or less than 2 vertices");
            } else {
                int n4;
                int n5;
                int n6;
                int n7 = 0;
                int n8 = 1;
                int n9 = this.m_polygon[n2].getEntry(n7);
                do {
                    n6 = this.m_polygon[n2].getEntry(n8);
                    pdVector.sub(this.m_vertex[n6], this.m_vertex[n9]);
                } while (pdVector.sqrLength() < 1.0E-10 && ++n8 < n3);
                if (n8 >= n3) {
                    PsDebug.warning("polygon[" + n2 + "] is degenerated to a point");
                    if (pdVector2 != null) {
                        pdVector4.copyArray(pdVector2);
                    } else {
                        pdVector4.setEntry(this.m_dim - 1, 1.0);
                    }
                    n5 = 0;
                    while (n5 < n3) {
                        n4 = this.m_polygon[n2].getEntry(n5);
                        this.m_vertexNormal[n4].copyArray(pdVector4);
                        ++n5;
                    }
                } else {
                    int n10 = n3 - 1;
                    if (bl) {
                        n10 = n8;
                    }
                    pdVector.normalize();
                    if (this.m_dim == 2) {
                        pdVector4.set(-pdVector.getEntry(1), pdVector.getEntry(0));
                        if (pdVector2 != null) {
                            pdVector2.copy(pdVector4);
                        } else {
                            pdVector2 = (PdVector)pdVector4.clone();
                        }
                    } else if (pdVector2 != null && PdVector.dot(pdVector2, pdVector) > 1.0E-10) {
                        pdVector2.orthogonalPart(pdVector4, pdVector);
                        pdVector4.normalize();
                    } else {
                        pdVector4.normalToVector(pdVector);
                    }
                    if (n8 >= n3 - 1) {
                        n5 = 0;
                        while (n5 < n3) {
                            n4 = this.m_polygon[n2].getEntry(n5);
                            this.m_vertexNormal[n4].copyArray(pdVector4);
                            ++n5;
                        }
                    } else {
                        int n11;
                        pdVector5.copyArray(pdVector4);
                        pdVector7.cross(pdVector, pdVector4);
                        pdVector4.setLength(d);
                        int n12 = -1;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!bl) {
                            bl3 = true;
                        }
                        int n13 = n8;
                        int n14 = n6;
                        boolean bl4 = false;
                        boolean bl5 = true;
                        while (bl5 || n13 != n10) {
                            double d2;
                            bl5 = false;
                            n8 = n13;
                            n13 = (n13 + 1) % n3;
                            n6 = n14;
                            n14 = this.m_polygon[n2].getEntry(n13);
                            pdVector3.sub(this.m_vertex[n14], this.m_vertex[n6]);
                            if (pdVector3.sqrLength() < 1.0E-10) {
                                bl2 = true;
                                if (n12 != -1) continue;
                                n12 = n8;
                                continue;
                            }
                            pdVector3.normalize();
                            pdVector4.sub(pdVector3, pdVector);
                            if (!pdVector4.normalize()) {
                                n12 = -1;
                                bl3 = true;
                                continue;
                            }
                            if (!bl4) {
                                if (pdVector2 != null && PdVector.dot(pdVector2, pdVector4) < 0.0) {
                                    pdVector4.multScalar(-1.0);
                                }
                                bl4 = true;
                            }
                            pdVector6.cross(pdVector, pdVector4);
                            if (n == 100) {
                                pdVector4.setLength(d);
                            } else if (n == 101) {
                                pdVector4.copy(pdVector6);
                                pdVector4.setLength(d);
                            } else if (n == 102) {
                                double d3 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                                d2 = d / Math.cos(d3 / 2.0);
                                pdVector4.setLength(d2);
                            } else if (n == 103) {
                                double d4 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                                d2 = d * d4;
                                pdVector4.setLength(d2);
                            }
                            if (PdVector.dot(pdVector6, pdVector7) < 0.0) {
                                pdVector4.multScalar(-1.0);
                                pdVector6.multScalar(-1.0);
                            }
                            if (bl3) {
                                int n15 = (n7 + 1) % n3;
                                if (!bl && n7 == 0) {
                                    n15 = 0;
                                }
                                bl3 = false;
                                if (n == 100) {
                                    pdVector5.setSize(3);
                                    pdVector5.cross(pdVector6, pdVector);
                                    pdVector5.setSize(this.m_dim);
                                    pdVector5.setLength(d);
                                } else if (n == 101) {
                                    pdVector5.copy(pdVector6);
                                    pdVector5.setLength(d);
                                } else if (n == 102) {
                                    pdVector5.setSize(3);
                                    pdVector5.cross(pdVector6, pdVector);
                                    pdVector5.setSize(this.m_dim);
                                    pdVector5.setLength(d);
                                } else if (n == 103) {
                                    pdVector5.setConstant(0.0);
                                }
                                n5 = n15;
                                while (n5 != n8) {
                                    this.m_vertexNormal[this.m_polygon[n2].getEntry(n5)].copy(pdVector5);
                                    n5 = (n5 + 1) % n3;
                                }
                            }
                            pdVector5.copy(pdVector4);
                            if (n == 100) {
                                pdVector5.setLength(d);
                            } else if (n == 101) {
                                pdVector5.copy(pdVector6);
                                pdVector5.setLength(d);
                            } else if (n == 102) {
                                double d5 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                                d2 = d / Math.cos(d5 / 2.0);
                                pdVector5.setLength(d2);
                            } else if (n == 103) {
                                double d6 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                                d2 = d * d6;
                                pdVector5.setLength(d2);
                            }
                            if (bl2) {
                                bl2 = false;
                                n5 = n12;
                                n12 = -1;
                                while (n5 != n8) {
                                    this.m_vertexNormal[this.m_polygon[n2].getEntry(n5)].copy(pdVector5);
                                    n5 = (n5 + 1) % n3;
                                }
                            }
                            this.m_vertexNormal[this.m_polygon[n2].getEntry(n8)].copy(pdVector5);
                            pdVector.copyArray(pdVector3);
                            pdVector5.copyArray(pdVector4);
                            pdVector7.copyArray(pdVector6);
                            n9 = n6;
                            n7 = n8;
                        }
                        if (!bl && (n11 = n7 + 1) < n3) {
                            if (n == 100) {
                                pdVector5.setSize(3);
                                pdVector5.cross(pdVector7, pdVector);
                                pdVector5.setSize(this.m_dim);
                                pdVector5.setLength(d);
                            } else if (n == 101) {
                                pdVector5.copy(pdVector6);
                                pdVector5.setLength(d);
                            } else if (n == 102) {
                                pdVector5.setSize(3);
                                pdVector5.cross(pdVector7, pdVector);
                                pdVector5.setSize(this.m_dim);
                                pdVector5.setLength(d);
                            } else if (n == 103) {
                                pdVector5.setConstant(0.0);
                            }
                            n5 = n11;
                            while (n5 < n3) {
                                this.m_vertexNormal[this.m_polygon[n2].getEntry(n5)].copy(pdVector5);
                                ++n5;
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public boolean makePolygonColorsFromZ() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector pdVector = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, this.m_vertex, this.m_polygon[n2].m_data);
            float f2 = (float)(pdVector.m_data[n] - pdVectorArray[0].m_data[n]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n2] = new Color(f2, 0.0f, 1.0f - f2);
            ++n2;
        }
        return true;
    }

    public boolean makePolygonColorsFromZHue() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector pdVector = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, this.m_vertex, this.m_polygon[n2].m_data);
            float f2 = (float)(pdVector.m_data[n] - pdVectorArray[0].m_data[n]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n2] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
            ++n2;
        }
        return true;
    }

    public Color getPolygonColor(int n) {
        if (this.m_polygonColor == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        return this.m_polygonColor[n];
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public boolean hasPolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            return false;
        }
        return this.m_polygonNormal.length <= 0 || !(Math.abs(this.m_polygonNormal[0].sqrLength() - 1.0) > 1.0E-10);
    }

    public boolean setPolygonColor(int n, Color color) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_polygonColor == null || this.m_numPolygons > this.m_polygonColor.length) {
            this.assurePolygonColors();
        }
        this.m_polygonColor[n] = color;
        return true;
    }

    public void removePolygonNormals() {
        this.setPolygonNormals(null);
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public boolean isShowingEdgeFromVertexColors() {
        return this.m_bInduceEdgeFromVertexColors;
    }

    public void showEdgeFromVertexColors(boolean bl) {
        this.m_bInduceEdgeFromVertexColors = bl;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public void showPolygonNormalArrow(boolean bl) {
        this.m_bShowPolygonNormalArrow = bl;
    }

    public int getMaxDimOfPolygons() {
        if (this.m_dimOfPolygons != -1) {
            return this.m_dimOfPolygons;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            int n3 = this.m_polygon[n2].getSize();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public Object clone() {
        PgPolygonSet pgPolygonSet = (PgPolygonSet)super.clone();
        if (pgPolygonSet == null) {
            return null;
        }
        if (this.m_polygon != null) {
            pgPolygonSet.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            pgPolygonSet.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        pgPolygonSet.m_globalPolygonColor = (PdColor)this.m_globalPolygonColor.clone();
        pgPolygonSet.m_globalPolygonColor.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonTagColor = (PdColor)this.m_globalPolygonTagColor.clone();
        pgPolygonSet.m_globalPolygonTagColor.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonSize = (PuDouble)this.m_globalPolygonSize.clone();
        pgPolygonSet.m_globalPolygonSize.setParent(pgPolygonSet);
        if (this.m_polygonNormal != null) {
            pgPolygonSet.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        pgPolygonSet.m_globalPolygonNormalLength = (PuDouble)this.m_globalPolygonNormalLength.clone();
        pgPolygonSet.m_globalPolygonNormalLength.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalSize = (PuDouble)this.m_globalPolygonNormalSize.clone();
        pgPolygonSet.m_globalPolygonNormalSize.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalColor = (PdColor)this.m_globalPolygonNormalColor.clone();
        pgPolygonSet.m_globalPolygonNormalColor.setParent(pgPolygonSet);
        if (this.m_polygonSize != null) {
            pgPolygonSet.m_polygonSize = (PdVector)this.m_polygonSize.clone();
        }
        return pgPolygonSet;
    }

    public PdVector getPolygonNormal(int n) {
        if (this.m_polygonNormal == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        return this.m_polygonNormal[n];
    }

    public boolean setPolygonNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_polygonNormal == null || this.m_numPolygons > this.m_polygonNormal.length) {
            this.assurePolygonNormals();
        }
        this.m_polygonNormal[n].copy(pdVector);
        return true;
    }

    public double getLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numPolygons) {
            d += this.getLengthOfPolygon(n);
            ++n;
        }
        return d;
    }

    public PdVector getPolygonSizes() {
        return this.m_polygonSize;
    }

    public boolean isShowingPolygonSizes() {
        return this.m_bShowPolygonSizes;
    }

    public void showPolygonSizes(boolean bl) {
        this.m_bShowPolygonSizes = bl;
    }

    public void setPolygonSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_polygonSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numPolygons) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assurePolygonSizes();
        this.m_polygonSize.copy(0, pdVector, 0, this.m_numPolygons);
    }

    public void assurePolygonSizes() {
        if (this.m_polygonSize == null) {
            this.m_polygonSize = new PdVector(this.m_maxNumPolygons);
            this.m_polygonSize.setConstant(this.m_globalPolygonSize.getValue());
            return;
        }
        if (this.m_polygonSize.getSize() != this.m_maxNumPolygons) {
            this.m_polygonSize.setSize(this.m_maxNumPolygons);
        }
    }

    public int getNumEdges() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            n += this.m_polygon[n2].getSize();
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygonSet *********\n");
        stringBuffer.append("\t m_numPolygons    = " + this.m_numPolygons + "\n");
        stringBuffer.append("\t ******* m_polygon *******\n");
        if (this.m_polygon != null) {
            int n = 0;
            while (n < this.m_numPolygons) {
                stringBuffer.append("\t [" + n + "] = " + this.m_polygon[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_polygon = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public static PgPolygonSet convert(PgPolygon pgPolygon) {
        if (pgPolygon == null) {
            return null;
        }
        PgPolygonSet pgPolygonSet = new PgPolygonSet(pgPolygon.getDimOfVertices());
        pgPolygonSet.merge(pgPolygon);
        pgPolygonSet.showPolygonLabels(pgPolygon.isShowingEdgeLabels());
        pgPolygonSet.showEdgeLabels(false);
        pgPolygonSet.showPolygons(pgPolygon.isShowingEdges());
        pgPolygonSet.showPolygonStartArrow(pgPolygonSet.isShowingPolygonStartArrow());
        pgPolygonSet.showPolygonEndArrow(pgPolygonSet.isShowingPolygonEndArrow());
        pgPolygonSet.setNumPolygons(1);
        int n = pgPolygon.getNumEdges();
        if (n > 0 && pgPolygon.isClosed()) {
            ++n;
        }
        pgPolygonSet.setDimOfPolygons(n);
        PiVector[] piVectorArray = pgPolygon.getEdges();
        PiVector piVector = new PiVector(n);
        piVector.setEntry(0, piVectorArray[0].getEntry(0));
        int n2 = 0;
        while (n2 < n) {
            piVector.setEntry(n2 + 1, piVectorArray[n2].getEntry(1));
            ++n2;
        }
        pgPolygonSet.setPolygon(0, piVector);
        pgPolygonSet.showSmoothLighting(pgPolygon.isShowingSmoothLighting());
        pgPolygonSet.showSmoothEdgeColors(pgPolygon.isShowingSmoothEdgeColors());
        pgPolygonSet.showEdgeFromVertexColors(pgPolygon.isShowingEdgeFromVertexColors());
        pgPolygonSet.setGlobalPolygonColor(pgPolygon.getGlobalEdgeColor());
        pgPolygonSet.setGlobalPolygonTagColor(pgPolygon.getGlobalEdgeTagColor());
        pgPolygonSet.showPolygonNormals(pgPolygon.isShowingEdgeNormals());
        pgPolygonSet.setPolygonNormals(pgPolygon.getEdgeNormals());
        pgPolygonSet.setGlobalPolygonNormalColor(pgPolygon.getGlobalEdgeNormalColor());
        pgPolygonSet.setGlobalPolygonNormalLength(pgPolygon.getGlobalEdgeNormalLength());
        pgPolygonSet.setGlobalPolygonNormalSize(pgPolygon.getGlobalEdgeNormalSize());
        pgPolygonSet.showPolygonSizes(false);
        pgPolygonSet.setGlobalPolygonSize(pgPolygon.getGlobalEdgeSize());
        return pgPolygonSet;
    }

    public boolean setClosed(int n, boolean bl) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (bl) {
            if (!this.isClosed(n)) {
                this.m_polygon[n].addEntry(this.m_polygon[n].getFirstEntry());
            }
        } else if (this.isClosed(n)) {
            this.m_polygon[n].setSize(this.m_polygon[n].getSize() - 1);
        }
        this.assureDimOfPolygons();
        return true;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public void showPolygonLabels(boolean bl) {
        this.m_bShowPolygonLabels = bl;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPolygonSet)) {
            return;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)psObject;
        this.copyPolygonSet(pgPolygonSet);
    }

    public void makeBiNormals() {
        this.makeNormals(101, 1.0);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void flipOrientation() {
        super.flipOrientation();
        int n = 0;
        while (n < this.m_numPolygons) {
            if (this.m_polygon[n] != null) {
                int n2 = this.m_polygon[n].getSize();
                this.m_polygon[n].invert(n2);
            }
            ++n;
        }
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.m_polygonNormal != null) {
            int n2 = 0;
            while (n2 < this.m_maxNumPolygons) {
                this.m_polygonNormal[n2].setSize(n);
                ++n2;
            }
        }
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowVertices = true;
        this.setGlobalVertexColor(Color.red);
        this.setGlobalVertexSize(2.0);
        this.m_dimOfPolygons = -1;
        this.setMaxNumPolygons(0);
        this.m_bShowPolygons = true;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_polygonNormal = null;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_globalPolygonNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonNormalSize.setDefValue(1.0);
        this.m_globalPolygonNormalSize.init();
        this.m_globalPolygonNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalPolygonNormalLength.setDefValue(0.5);
        this.m_globalPolygonNormalLength.init();
        this.m_globalPolygonNormalColor.setColor(Color.yellow);
        this.m_polygonColor = null;
        this.m_bShowPolygonColors = false;
        this.m_globalPolygonColor.setColor(Color.black);
        this.m_globalPolygonTagColor.setColor(Color.magenta);
        this.m_globalPolygonSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonSize.setDefValue(2.0);
        this.m_globalPolygonSize.init();
        this.m_polygonSize = null;
        this.m_bShowPolygonSizes = false;
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor.getColor();
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor.getColor();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor.setColor(color);
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor.setColor(color);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        int n = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometryIf;
        if (this.m_numPolygons == 0) {
            this.setDimOfPolygons(pgPolygonSet.m_dimOfPolygons);
        } else if (pgPolygonSet.m_dimOfPolygons != this.m_dimOfPolygons) {
            this.setDimOfPolygons(-1);
        }
        int n2 = this.m_numPolygons;
        int n3 = this.m_numPolygons + pgPolygonSet.m_numPolygons;
        this.setNumPolygons(n3);
        PiVector.copy(this.m_polygon, n2, pgPolygonSet.m_polygon, 0, pgPolygonSet.m_numPolygons);
        int n4 = 0;
        while (n4 < pgPolygonSet.m_numPolygons) {
            int n5 = pgPolygonSet.m_polygon[n4].getSize();
            this.m_polygon[n2 + n4].setSize(n5);
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n6++;
                this.m_polygon[n2 + n4].m_data[n7] = this.m_polygon[n2 + n4].m_data[n7] + n;
            }
            ++n4;
        }
        if (pgPolygonSet.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, n2, pgPolygonSet.m_polygonNormal, 0, pgPolygonSet.m_numPolygons);
        }
        Color color = this.getGlobalPolygonColor();
        Color color2 = pgPolygonSet.getGlobalPolygonColor();
        boolean bl2 = color.getRGB() != color2.getRGB() || this.hasPolygonColors() || pgPolygonSet.hasPolygonColors();
        boolean bl3 = color.getRGB() == color2.getRGB() && !this.isShowingPolygonColors() && !pgPolygonSet.isShowingPolygonColors();
        boolean bl4 = bl2 && !this.isShowingPolygonColors();
        boolean bl5 = bl = bl2 && !pgPolygonSet.isShowingPolygonColors();
        if (!bl3) {
            this.showPolygonColors(true);
        }
        if (bl2) {
            this.assurePolygonColors();
            if (bl4) {
                n4 = 0;
                while (n4 < n2) {
                    this.setPolygonColor(n4, color);
                    ++n4;
                }
            }
            if (bl) {
                n4 = n2;
                while (n4 < n3) {
                    this.setPolygonColor(n4, color2);
                    ++n4;
                }
            } else {
                PdColor.copy(this.m_polygonColor, n2, pgPolygonSet.m_polygonColor, 0, pgPolygonSet.m_numPolygons);
            }
        }
        if (pgPolygonSet.m_polygonSize != null) {
            this.assurePolygonSizes();
            this.m_polygonSize.copy(n2, pgPolygonSet.m_polygonSize, 0, pgPolygonSet.m_numPolygons);
        }
        return true;
    }

    public double getPolygonSize(int n) {
        if (this.m_polygonSize == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return this.m_globalPolygonSize.getValue();
        }
        return this.m_polygonSize.getEntry(n);
    }

    public boolean setPolygonSize(int n, double d) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (this.m_polygonSize == null || this.m_numPolygons > this.m_polygonSize.getSize()) {
            this.assurePolygonSizes();
        }
        this.m_polygonSize.setEntry(n, d);
        return true;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public boolean isShowingTaggedPolygons() {
        return this.m_bShowTaggedPolygons;
    }

    public void showTaggedPolygons(boolean bl) {
        this.m_bShowTaggedPolygons = bl;
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public void setNumPolygons(int n) {
        if (n == this.m_numPolygons) {
            return;
        }
        if (n > this.m_maxNumPolygons) {
            this.setMaxNumPolygons(n);
        } else if (n < this.m_numPolygons && this.m_dimOfPolygons == -1) {
            int n2 = n;
            while (n2 < this.m_numPolygons) {
                this.m_polygon[n2].setSize(0);
                ++n2;
            }
        }
        this.m_numPolygons = n;
    }

    public void setDimOfVertices(int n) {
        if (this.m_polygonNormal != null) {
            int n2 = 0;
            while (n2 < this.m_maxNumPolygons) {
                this.m_polygonNormal[n2].setSize(n);
                ++n2;
            }
        }
        super.setDimOfVertices(n);
    }

    public boolean hasPolygonSizes() {
        return this.m_polygonSize != null && this.m_polygonSize.getSize() == this.m_maxNumPolygons;
    }

    public int[] removeMarkedVertices() {
        int n = -1;
        int[] nArray = super.removeMarkedVertices();
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            int n3 = 0;
            int n4 = this.m_polygon[n2].getSize();
            int n5 = 0;
            while (n5 < n4) {
                if (nArray[this.m_polygon[n2].m_data[n5]] != n) {
                    this.m_polygon[n2].m_data[n3] = nArray[this.m_polygon[n2].m_data[n5]];
                    ++n3;
                }
                ++n5;
            }
            if (n3 <= 1) {
                this.m_polygon[n2].setTag(2);
            } else {
                this.m_polygon[n2].setSize(n3);
            }
            ++n2;
        }
        this.removeMarkedPolygons();
        this.assureDimOfPolygons();
        return nArray;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonColor) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonSize) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalSize) {
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2 = 1;
        int n3 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n3);
        int[] nArray = piVector.m_data;
        int n4 = 0;
        while (n4 < this.m_numPolygons) {
            n = 0;
            while (n < this.m_polygon[n4].m_data.length) {
                nArray[this.m_polygon[n4].m_data[n]] = n2;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n2) {
                nArray[n4] = n5++;
            }
            ++n4;
        }
        if (n5 == this.m_numVertices) {
            return true;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n3 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]] = this.m_vertex[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numPolygons) {
            n = 0;
            while (n < this.m_polygon[n4].m_data.length) {
                this.m_polygon[n4].m_data[n] = nArray[this.m_polygon[n4].m_data[n]];
                ++n;
            }
            ++n4;
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]] = this.m_vertexNormal[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        int n6 = this.getNumVectorFields();
        n4 = 0;
        while (n4 < n6) {
            PgVectorField pgVectorField = this.getVectorField(n4);
            if (pgVectorField.getBasedOn() != 1) {
                n = 0;
                while (n < this.m_numVertices) {
                    if (nArray[n] != n3 && nArray[n] < n) {
                        pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
                    }
                    ++n;
                }
                pgVectorField.setNumVectors(n5);
            }
            ++n4;
        }
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public void removePolygonSizes() {
        this.setPolygonSizes(null);
    }

    public boolean makeVertexColorsFromLength() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assureVertexColors();
        double d = this.getLength();
        double d2 = 0.0;
        float f = 0.0f;
        int n = 0;
        while (n < this.m_numPolygons) {
            int n2 = this.m_polygon[n].getSize();
            if (n2 != 0) {
                boolean bl = this.isClosed(n);
                if (bl) {
                    --n2;
                }
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = this.m_polygon[n].m_data[n3];
                    if (d > 1.0E-10) {
                        f = (float)(d2 / d);
                    }
                    this.setVertexColor(n4, new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
                    if (n3 + 1 < n2) {
                        int n5 = this.m_polygon[n].m_data[n3 + 1];
                        d2 += this.m_vertex[n4].dist(this.m_vertex[n5]);
                    } else if (bl) {
                        d2 += this.m_vertex[n4].dist(this.m_vertex[this.m_polygon[n].m_data[n3 + 1]]);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return true;
    }

    public void clearTagPolygon(int n, int n2) {
        if (this.m_polygon == null || n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_polygon[n].clearTag(n2);
    }

    public PiVector getPolygon(int n) {
        if (this.m_polygon == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        return this.m_polygon[n];
    }

    public void setPolygon(int n, int n2, int n3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(n + 1);
        }
        this.setSizeOfPolygon(n, 2);
        this.m_polygon[n].set(n2, n3);
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(n + 1);
        }
        this.setSizeOfPolygon(n, piVector.getSize());
        this.m_polygon[n].copy(piVector);
        return true;
    }

    public boolean makePolygonColorsFromXYZ() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n = 0;
        while (n < this.m_dim) {
            if (dArray[n] < 1.0E-10) {
                dArray[n] = 1.0;
            }
            ++n;
        }
        n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_polygon[n2].m_data), pdVectorArray[0]);
            int n3 = 0;
            while (n3 < n) {
                fArray[n3] = (float)(pdVector.m_data[n3] / dArray[n3]);
                ++n3;
            }
            if (n == 1) {
                colorArray[n2] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n == 2) {
                colorArray[n2] = new Color(fArray[0], fArray[1], 0.0f);
            } else if (n == 3) {
                colorArray[n2] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n2;
        }
        return true;
    }

    public void copyPolygonSet(PgPolygonSet pgPolygonSet) {
        this.setDimOfPolygons(pgPolygonSet.getDimOfPolygons());
        this.setNumPolygons(pgPolygonSet.getNumPolygons());
        if (this.m_dimOfPolygons == -1) {
            PiVector.adjustSizes(this.m_polygon, 0, pgPolygonSet.getPolygons(), 0, this.m_numPolygons);
        }
        PiVector.copy(this.m_polygon, 0, pgPolygonSet.getPolygons(), 0, this.m_numPolygons);
        if (pgPolygonSet.m_polygonColor != null) {
            this.assurePolygonColors();
            PdColor.copy(this.m_polygonColor, 0, pgPolygonSet.getPolygonColors(), 0, this.m_numPolygons);
        } else {
            this.m_polygonColor = null;
        }
        if (pgPolygonSet.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, 0, pgPolygonSet.getPolygonNormals(), 0, this.m_numPolygons);
        } else {
            this.m_polygonNormal = null;
        }
        if (pgPolygonSet.m_polygonSize != null) {
            this.assurePolygonSizes();
            this.m_polygonSize.copy(0, pgPolygonSet.getPolygonSizes(), 0, this.m_numPolygons);
            return;
        }
        this.m_polygonSize = null;
    }

    public boolean isClosed(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        return this.m_polygon[n].getFirstEntry() == this.m_polygon[n].getLastEntry();
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showPolygonColors(boolean bl) {
        this.m_bShowPolygonColors = bl;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_maxNumPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_maxNumPolygons);
        }
    }

    public void setPolygonColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_polygonColor = null;
            return;
        }
        if (colorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_polygonColor == null || this.m_numPolygons > this.m_polygonColor.length) {
            this.assurePolygonColors();
        }
        PdColor.copy(this.m_polygonColor, 0, colorArray, 0, this.m_numPolygons);
    }

    public void makeOffsetNormals() {
        this.makeNormals(102, 1.0);
    }

    public void makeCurvatureNormals() {
        this.makeNormals(103, 1.0);
    }

    public void setSizeOfPolygon(int n, int n2) {
        if (this.m_dimOfPolygons == n2) {
            return;
        }
        if (n < 0 || this.m_numPolygons <= n) {
            PsDebug.warning("index out of bounds, index = " + n);
            return;
        }
        if (n2 < 1) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numPolygons == 1) {
            this.setDimOfPolygons(n2);
        } else if (this.m_dimOfPolygons != -1) {
            this.setDimOfPolygons(-1);
        }
        this.m_polygon[n].setSize(n2);
    }

    public int[] removePolygon(int n) {
        this.m_polygon[n].setTag(2);
        return this.removeMarkedPolygons();
    }

    public void setTagPolygon(int n, int n2) {
        if (this.m_polygon == null || n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_polygon[n].setTag(n2);
    }

    public boolean makePolygonFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assurePolygonColors();
        int n = 0;
        while (n < this.m_numPolygons) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n2 = this.m_polygon[n].getSize();
            if (n2 != 0) {
                int n3 = 0;
                while (n3 < n2) {
                    f += (float)this.m_vertexColor[this.m_polygon[n].m_data[n3]].getRed();
                    f2 += (float)this.m_vertexColor[this.m_polygon[n].m_data[n3]].getGreen();
                    f3 += (float)this.m_vertexColor[this.m_polygon[n].m_data[n3]].getBlue();
                    ++n3;
                }
                this.setPolygonColor(n, new Color((int)(f /= (float)n2), (int)(f2 /= (float)n2), (int)(f3 /= (float)n2)));
            }
            ++n;
        }
        return true;
    }

    public boolean makeVertexFromPolygonColors() {
        if (!this.hasPolygonColors()) {
            PsDebug.warning("missing polygon colors");
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        int n = 0;
        while (n < this.m_numPolygons) {
            int n2 = this.m_polygon[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.m_polygon[n].m_data[n3];
                int[] nArray3 = nArray[n4];
                nArray3[0] = nArray3[0] + this.m_polygonColor[n].getRed();
                int[] nArray4 = nArray[n4];
                nArray4[1] = nArray4[1] + this.m_polygonColor[n].getGreen();
                int[] nArray5 = nArray[n4];
                nArray5[2] = nArray5[2] + this.m_polygonColor[n].getBlue();
                int n5 = n4;
                nArray2[n5] = nArray2[n5] + 1;
                ++n3;
            }
            ++n;
        }
        this.assureVertexColors();
        n = 0;
        while (n < this.m_numVertices) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
            } else {
                this.setVertexColor(n, Color.black);
            }
            ++n;
        }
        return true;
    }

    public boolean hasPolygonColors() {
        return this.m_polygonColor != null && this.m_polygonColor.length == this.m_maxNumPolygons;
    }

    public PgPolygonSet() {
        this(3);
    }

    public PgPolygonSet(int n) {
        super(n);
        this.setType(32);
        this.m_geomItem.addElement("Polygon");
        this.setDimOfSimplex(1);
        this.m_polygon = new PiVector[0];
        this.m_globalPolygonColor = new PdColor(PsConfig.getMessage(24075), this);
        this.m_globalPolygonTagColor = new PdColor(PsConfig.getMessage(24076), this);
        this.m_globalPolygonSize = new PuDouble(PsConfig.getMessage(24077), this);
        this.m_globalPolygonNormalLength = new PuDouble(PsConfig.getMessage(24078), this);
        this.m_globalPolygonNormalSize = new PuDouble(PsConfig.getMessage(24079), this);
        this.m_globalPolygonNormalColor = new PdColor(PsConfig.getMessage(24080), this);
        if (this.getClass() == (class$jv$geom$PgPolygonSet != null ? class$jv$geom$PgPolygonSet : (class$jv$geom$PgPolygonSet = PgPolygonSet.class$("jv.geom.PgPolygonSet")))) {
            this.init();
        }
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor.getColor();
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor.setColor(color);
    }

    public void useGlobalPolygonColor(boolean bl) {
        this.showPolygonColors(!bl);
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(82, this.isShowingPolygonLabels());
        pvGeometryIf.setState(54, this.m_bShowPolygons);
        pvGeometryIf.setState(89, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(90, this.m_bShowPolygonEndArrow);
        if (this.m_globalPolygonSize != null) {
            pvGeometryIf.setGlobalPolygonSize(this.m_globalPolygonSize.getValue());
        }
        if (this.m_globalPolygonColor != null) {
            pvGeometryIf.setGlobalPolygonColor(this.m_globalPolygonColor.getColor());
        }
        if (this.m_globalPolygonTagColor != null) {
            pvGeometryIf.setGlobalPolygonTagColor(this.m_globalPolygonTagColor.getColor());
        }
        pvGeometryIf.setDimOfPolygons(this.m_dimOfPolygons);
        pvGeometryIf.setNumPolygons(this.m_numPolygons);
        pvGeometryIf.setPolygons(this.m_polygon);
        pvGeometryIf.setPolygonColors(this.m_polygonColor);
        pvGeometryIf.setState(93, this.m_bShowPolygonColors);
        pvGeometryIf.setState(101, this.isShowingSmoothLighting());
        pvGeometryIf.setState(102, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(103, this.isShowingEdgeFromVertexColors());
        pvGeometryIf.setPolygonNormals(this.m_polygonNormal);
        pvGeometryIf.setState(64, this.m_bShowPolygonNormals);
        pvGeometryIf.setState(65, this.m_bShowPolygonNormalArrow);
        if (this.m_globalPolygonNormalSize != null) {
            pvGeometryIf.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize.getValue());
        }
        if (this.m_globalPolygonNormalLength != null) {
            pvGeometryIf.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength.getValue());
        }
        if (this.m_globalPolygonNormalColor != null) {
            pvGeometryIf.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor.getColor());
        }
        pvGeometryIf.setPolygonSizes(this.m_polygonSize);
        pvGeometryIf.setState(105, this.m_bShowPolygonSizes);
    }

    public int getPolygonWithVertex(int n) {
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            if (this.m_polygon[n2].getIndexOf(n) > -1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removePolygonColors() {
        this.setPolygonColors(null);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygonSet) || !(pgGeometry2 instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometry;
        PgPolygonSet pgPolygonSet2 = (PgPolygonSet)pgGeometry2;
        if (pgPolygonSet.m_numPolygons != pgPolygonSet2.m_numPolygons) {
            PsDebug.warning("unequal number of polygons", this);
            return false;
        }
        PgPolygonSet pgPolygonSet3 = d > 0.5 ? pgPolygonSet : pgPolygonSet2;
        this.m_bShowPolygons = pgPolygonSet3.m_bShowPolygons;
        this.m_bShowTaggedPolygons = pgPolygonSet3.m_bShowTaggedPolygons;
        this.m_bShowPolygonColors = pgPolygonSet3.m_bShowPolygonColors;
        this.m_bShowPolygonStartArrow = pgPolygonSet3.m_bShowPolygonStartArrow;
        this.m_bShowPolygonEndArrow = pgPolygonSet3.m_bShowPolygonEndArrow;
        this.m_bShowPolygonLabels = pgPolygonSet3.m_bShowPolygonLabels;
        this.m_bShowPolygonNormals = pgPolygonSet3.m_bShowPolygonNormals;
        this.m_bShowPolygonNormalArrow = pgPolygonSet3.m_bShowPolygonNormalArrow;
        this.m_globalPolygonColor.blend(d, pgPolygonSet.m_globalPolygonColor, d2, pgPolygonSet2.m_globalPolygonColor);
        this.m_globalPolygonTagColor.blend(d, pgPolygonSet.m_globalPolygonTagColor, d2, pgPolygonSet2.m_globalPolygonTagColor);
        this.m_globalPolygonSize.blend(d, pgPolygonSet.m_globalPolygonSize, d2, pgPolygonSet2.m_globalPolygonSize);
        this.m_globalPolygonNormalColor.blend(d, pgPolygonSet.m_globalPolygonNormalColor, d2, pgPolygonSet2.m_globalPolygonNormalColor);
        this.m_globalPolygonNormalLength.blend(d, pgPolygonSet.m_globalPolygonNormalLength, d2, pgPolygonSet2.m_globalPolygonNormalLength);
        this.m_globalPolygonNormalSize.blend(d, pgPolygonSet.m_globalPolygonNormalSize, d2, pgPolygonSet2.m_globalPolygonNormalSize);
        this.setNumPolygons(pgPolygonSet3.getNumPolygons());
        int n = 0;
        while (n < this.m_numPolygons) {
            this.m_polygon[n].copy(pgPolygonSet3.m_polygon[n]);
            ++n;
        }
        if (pgPolygonSet.m_polygonNormal != null && pgPolygonSet2.m_polygonNormal != null) {
            this.assurePolygonNormals();
            n = 0;
            while (n < this.m_numPolygons) {
                this.m_polygonNormal[n].blend(d, pgPolygonSet.m_polygonNormal[n], d2, pgPolygonSet2.m_polygonNormal[n]);
                this.m_polygonNormal[n].normalize();
                ++n;
            }
        } else {
            this.m_polygonNormal = null;
        }
        if (pgPolygonSet.m_polygonColor != null && pgPolygonSet2.m_polygonColor != null) {
            this.assurePolygonColors();
            n = 0;
            while (n < this.m_numPolygons) {
                this.m_polygonColor[n] = PdColor.blend(d, pgPolygonSet.m_polygonColor[n], d2, pgPolygonSet2.m_polygonColor[n]);
                ++n;
            }
        } else {
            this.m_polygonColor = null;
        }
        return true;
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength.getValue();
    }

    public void setGlobalPolygonNormalLength(double d) {
        this.m_globalPolygonNormalLength.setValue(d);
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_polygon[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_polygon[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_polygon[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_polygon[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle(pdVector, pdVector2, pdVector3);
    }

    public boolean makePolygonColorsFromLength() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assurePolygonColors();
        double d = this.getLength();
        double d2 = 0.0;
        float f = 0.0f;
        int n = 0;
        while (n < this.m_numPolygons) {
            if (d > 1.0E-10) {
                f = (float)(d2 / d);
            }
            this.setPolygonColor(n, new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
            d2 += this.getLengthOfPolygon(n);
            ++n;
        }
        return true;
    }

    public boolean applyModelingMatrix() {
        if (!this.hasModelMatrix()) {
            return false;
        }
        if (this.hasPolygonNormals()) {
            PdVector pdVector = new PdVector(3);
            PdVector pdVector2 = new PdVector(3);
            int n = 0;
            while (n < this.m_numPolygons) {
                pdVector.copyArray(this.m_polygonNormal[n]);
                pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, false);
                this.m_polygonNormal[n].copyArray(pdVector2);
                ++n;
            }
        }
        return super.applyModelingMatrix();
    }

    public int getDimOfPolygons() {
        return this.m_dimOfPolygons;
    }

    public boolean assureDimOfPolygons() {
        int n = PiVector.getSameSize(this.m_polygon, this.m_numPolygons);
        if (n != this.m_dimOfPolygons) {
            this.m_dimOfPolygons = n;
            return false;
        }
        return true;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize.getValue();
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize.getValue();
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize.setValue(d);
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(32);
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showPolygonLabels(this.isShowingPolygonLabels());
        pgJvxSrc.showTaggedPolygons(this.isShowingTaggedPolygons());
        pgJvxSrc.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        pgJvxSrc.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        pgJvxSrc.showPolygons(this.isShowingPolygons());
        pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
        pgJvxSrc.setNumPolygons(this.getNumPolygons());
        pgJvxSrc.setPolygons(this.getPolygons());
        pgJvxSrc.setGlobalPolygonColor(this.getGlobalPolygonColor());
        pgJvxSrc.setGlobalPolygonTagColor(this.getGlobalPolygonTagColor());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothEdgeColors());
        pgJvxSrc.showElementFromVertexColors(this.isShowingEdgeFromVertexColors());
        pgJvxSrc.showPolygonColors(this.isShowingPolygonColors());
        pgJvxSrc.setPolygonColors(this.getPolygonColors());
        if (this.hasPolygonNormals()) {
            pgJvxSrc.showPolygonNormals(this.isShowingPolygonNormals());
            pgJvxSrc.setPolygonNormals(this.getPolygonNormals());
        } else {
            pgJvxSrc.showPolygonNormals(false);
        }
        pgJvxSrc.showPolygonNormalArrow(this.isShowingPolygonNormalArrow());
        pgJvxSrc.setGlobalPolygonNormalColor(this.getGlobalPolygonNormalColor());
        pgJvxSrc.setGlobalPolygonNormalLength(this.getGlobalPolygonNormalLength());
        pgJvxSrc.setGlobalPolygonNormalSize(this.getGlobalPolygonNormalSize());
        if (this.hasPolygonSizes()) {
            pgJvxSrc.showPolygonSizes(this.isShowingPolygonSizes());
            pgJvxSrc.setPolygonSizes(this.getPolygonSizes());
        } else {
            pgJvxSrc.showPolygonSizes(false);
        }
        pgJvxSrc.setPolygonSizes(this.getPolygonSizes());
        pgJvxSrc.setGlobalPolygonSize(this.getGlobalPolygonSize());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showPolygonLabels(pgJvxSrc.isShowingPolygonLabels());
        this.showTaggedPolygons(pgJvxSrc.isShowingTaggedPolygons());
        this.showPolygons(pgJvxSrc.isShowingPolygons());
        this.showPolygonStartArrow(pgJvxSrc.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(pgJvxSrc.isShowingPolygonEndArrow());
        this.setNumPolygons(pgJvxSrc.getNumPolygons());
        int n = PiVector.getSameSize(pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
        this.setDimOfPolygons(n);
        this.setPolygons(pgJvxSrc.getPolygons());
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothEdgeColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showEdgeFromVertexColors(pgJvxSrc.isShowingElementFromVertexColors());
        this.setPolygonColors(pgJvxSrc.getPolygonColors());
        this.showPolygonColors(pgJvxSrc.isShowingPolygonColors());
        if (pgJvxSrc.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(pgJvxSrc.getGlobalPolygonColor());
        }
        if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(pgJvxSrc.getGlobalPolygonTagColor());
        }
        if (pgJvxSrc.getGlobalPolygonSize() != 0.0) {
            this.setGlobalPolygonSize(pgJvxSrc.getGlobalPolygonSize());
        }
        this.showPolygonNormals(pgJvxSrc.isShowingPolygonNormals());
        this.showPolygonNormalArrow(pgJvxSrc.isShowingPolygonNormalArrow());
        if (pgJvxSrc.getPolygonNormals() != null) {
            this.setPolygonNormals(pgJvxSrc.getPolygonNormals());
        }
        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
            this.setGlobalPolygonNormalColor(pgJvxSrc.getGlobalPolygonNormalColor());
        }
        if (pgJvxSrc.getGlobalPolygonNormalLength() != 0.0) {
            this.setGlobalPolygonNormalLength(pgJvxSrc.getGlobalPolygonNormalLength());
        }
        if (pgJvxSrc.getGlobalPolygonNormalSize() != 0.0) {
            this.setGlobalPolygonNormalSize(pgJvxSrc.getGlobalPolygonNormalSize());
        }
        this.showPolygonSizes(pgJvxSrc.isShowingPolygonSizes());
        this.setPolygonSizes(pgJvxSrc.getPolygonSizes());
        this.setGlobalPolygonSize(pgJvxSrc.getGlobalPolygonSize());
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize.setValue(d);
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public void showPolygons(boolean bl) {
        this.m_bShowPolygons = bl;
    }

    public int getMaxNumPolygons() {
        return this.m_maxNumPolygons;
    }

    protected void setMaxNumPolygons(int n) {
        if (this.m_maxNumPolygons == n) {
            return;
        }
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, n, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, n);
        if (this.m_polygonNormal != null) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, n, this.m_dim);
        }
        if (this.m_polygonColor != null) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, n);
        }
        this.m_maxNumPolygons = n;
        if (this.m_maxNumPolygons < this.m_numPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public void setDimOfPolygons(int n) {
        if (n == this.m_dimOfPolygons) {
            return;
        }
        if (n != -1 && n <= 0) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfPolygons = n;
        if (n == -1) {
            int n2 = this.m_numPolygons;
            while (n2 < this.m_maxNumPolygons) {
                this.m_polygon[n2].setSize(0);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.m_maxNumPolygons) {
            this.m_polygon[n3].setSize(n);
            ++n3;
        }
    }

    public int[] removeMarkedPolygons() {
        int n = 1;
        int n2 = -1;
        PiVector piVector = new PiVector(this.m_numPolygons);
        piVector.setConstant(n2);
        int[] nArray = piVector.m_data;
        int n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (!this.m_polygon[n3].hasTag(2)) {
                nArray[n3] = n;
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (nArray[n3] == n) {
                nArray[n3] = n4++;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (nArray[n3] != n2 && nArray[n3] < n3) {
                this.m_polygon[nArray[n3]].setSize(this.m_polygon[n3].getSize());
                this.m_polygon[nArray[n3]].copy(this.m_polygon[n3]);
            }
            ++n3;
        }
        if (this.m_polygonNormal != null) {
            n3 = 0;
            while (n3 < this.m_numPolygons) {
                if (nArray[n3] != n2 && nArray[n3] < n3) {
                    this.m_polygonNormal[nArray[n3]].setSize(this.m_polygonNormal[n3].getSize());
                    this.m_polygonNormal[nArray[n3]].copy(this.m_polygonNormal[n3]);
                }
                ++n3;
            }
        }
        if (this.m_polygonColor != null) {
            n3 = 0;
            while (n3 < this.m_numPolygons) {
                if (nArray[n3] != n2 && nArray[n3] < n3) {
                    this.m_polygonColor[nArray[n3]] = this.m_polygonColor[n3];
                }
                ++n3;
            }
        }
        int n5 = this.getNumVectorFields();
        n3 = 0;
        while (n3 < n5) {
            PgVectorField pgVectorField = this.getVectorField(n3);
            if (pgVectorField.getBasedOn() != 0) {
                int n6 = 0;
                while (n6 < this.m_numPolygons) {
                    if (nArray[n6] != n2 && nArray[n6] < n6) {
                        pgVectorField.setVector(nArray[n6], pgVectorField.getVector(n6));
                    }
                    ++n6;
                }
                pgVectorField.setNumVectors(n4);
            }
            ++n3;
        }
        this.setNumPolygons(n4);
        this.setMaxNumPolygons(n4);
        return nArray;
    }

    public PdVector[] getPolygonVertices(int n) {
        if (this.m_polygon == null || n < 0 || this.m_numPolygons <= n) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        if (this.m_polygon[n].getSize() == 0) {
            return null;
        }
        int n2 = this.m_polygon[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_polygon[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public boolean setPolygonVertices(int n, PdVector[] pdVectorArray) {
        int n2 = this.m_polygon[n].getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning("polygon and array have different length");
            return false;
        }
        --n2;
        while (n2 >= 0) {
            this.m_vertex[this.m_polygon[n].m_data[n2]].copy(pdVectorArray[n2]);
            --n2;
        }
        return true;
    }

    public void setPolygons(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of polygon array");
            return;
        }
        int n = piVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            int n3 = piVectorArray[n2].getSize();
            this.m_polygon[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.setDimOfPolygons(n);
        PiVector.copy(this.m_polygon, 0, piVectorArray, 0, this.m_numPolygons);
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            n += this.m_polygon[n2].getSize() - 1;
            ++n2;
        }
        int[] nArray2 = PuData.realloc(nArray, nArray.length + 1);
        nArray2[nArray.length] = n;
        return nArray2;
    }
}

