/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgMapleLoader
implements PgLoaderIf {
    protected PvDisplayOption m_displayOption;
    protected String[] m_axesLabels;
    protected String m_axesStyle;
    protected String m_lightModel;
    protected Vector m_lightColor;
    protected Vector m_lightPosition;
    protected Color m_sceneColor;
    protected double[] m_sceneOrientation;
    protected double m_sceneProjection;
    protected String m_sceneShading;
    protected String m_sceneScaling;
    protected PdVector[] m_sceneView;
    protected String m_sceneStyle;
    protected double m_sceneThickness = 0.0;
    protected String m_sceneTitle;
    protected String m_sceneTitleFont;
    protected Vector m_geomVec;
    protected Vector m_geomColor;
    protected Vector m_geomStyle;
    protected Vector m_geomThickness;
    protected Vector m_geomTitle;
    protected int m_numGeoms;
    protected int m_numKeys;
    private int m_numGeomStep;
    private Vector m_numGeomsPerStep;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;
    protected double m_transparency = -1.0;
    protected double m_roll = 0.0;

    private static int[] parse2ArrayOfDoubles(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        int n = 0;
        int n2 = 0;
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != 93) {
            streamTokenizer.nextToken();
            ++n;
            int n3 = n2;
            n2 = 0;
            while (streamTokenizer.ttype != 93) {
                ++n2;
                Double d = new Double(PgLoader.parseDouble(streamTokenizer));
                vector.addElement(d);
                streamTokenizer.nextToken();
            }
            if (n > 1 && n3 != n2) {
                throw new IOException("numVLines differ");
            }
            streamTokenizer.nextToken();
        }
        return new int[]{n, n2};
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse(BufferedReader bufferedReader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.ordinaryChar(42);
        streamTokenizer.ordinaryChar(94);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(95);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.commentChar(35);
        streamTokenizer.parseNumbers();
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.whitespaceChars(92, 92);
        streamTokenizer.quoteChar(96);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        int n = 0;
        int n2 = 0;
        this.m_sceneShading = "XYZ";
        this.m_sceneProjection = 1.0;
        try {
            block11: while (true) {
                int n3 = 0;
                block12: do {
                    switch (n3 == 0 ? streamTokenizer.nextToken() : n3) {
                        default: {
                            throw new IOException("parsing broke abnormally");
                        }
                        case -1: {
                            if (n != 0) {
                                throw new IOException("'}' missing");
                            }
                            if (n2 == 0) return true;
                            throw new IOException("']' missing");
                        }
                        case -3: {
                            if ("PLOT".equalsIgnoreCase(streamTokenizer.sval)) {
                                this.m_geomVec = this.readGraphics(streamTokenizer, 2, this.m_geomVec);
                                n3 = 44;
                                if (this.m_geomVec != null) continue block12;
                                throw new IOException("failed reading PLOT");
                            }
                            if ("PLOT3D".equalsIgnoreCase(streamTokenizer.sval)) {
                                this.m_geomVec = this.readGraphics(streamTokenizer, 3, this.m_geomVec);
                                n3 = 44;
                                if (this.m_geomVec != null) continue block12;
                                throw new IOException("failed reading PLOT3D");
                            }
                            PsDebug.warning("Unknown command:" + streamTokenizer.sval);
                            break;
                        }
                        case 123: {
                            ++n;
                            break;
                        }
                        case 125: {
                            n3 = 44;
                            if (--n >= 0) continue block12;
                            throw new IOException("More '}' than '{'");
                        }
                        case 91: {
                            ++n2;
                            break;
                        }
                        case 93: {
                            if (--n2 < 0) {
                                throw new IOException("More ']' than '['");
                            }
                        }
                        case 44: 
                        case 59: 
                    }
                    continue block11;
                } while (true);
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype);
            return false;
        }
    }

    private static double[] parseDoubleRange(StreamTokenizer streamTokenizer) throws IOException {
        double d = PgLoader.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double d2 = PgLoader.parseDouble(streamTokenizer);
        return new double[]{d, d2};
    }

    protected static boolean makePolygonColorsFromZ(PgJvxSrc pgJvxSrc, Color color, Color color2, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumPolygons();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n2);
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[n4].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n4] = PdColor.blend(1.0f - f2, color, f2, color2);
            ++n4;
        }
        return true;
    }

    private static double[][] parseView(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = null;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            dArray = PgMapleLoader.parseDoubleRange(streamTokenizer);
        } else if (streamTokenizer.sval == null || !streamTokenizer.sval.equalsIgnoreCase("DEFAULT")) {
            PsDebug.warning("error in xBnds in VIEW at" + streamTokenizer.lineno());
            return new double[][]{dArray};
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new double[][]{dArray};
        }
        double[] dArray2 = null;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            dArray2 = PgMapleLoader.parseDoubleRange(streamTokenizer);
        } else if (streamTokenizer.sval == null || !streamTokenizer.sval.equalsIgnoreCase("DEFAULT")) {
            PsDebug.warning("error in yBnds in VIEW at" + streamTokenizer.lineno());
            return new double[][]{dArray, dArray2};
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new double[][]{dArray, dArray2};
        }
        double[] dArray3 = null;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            dArray3 = PgMapleLoader.parseDoubleRange(streamTokenizer);
        } else if (streamTokenizer.sval == null || !streamTokenizer.sval.equalsIgnoreCase("DEFAULT")) {
            PsDebug.warning("error in zBnds in VIEW at" + streamTokenizer.lineno());
            return new double[][]{dArray, dArray2, dArray3};
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new double[][]{dArray, dArray2, dArray3};
        }
        PsDebug.warning("expected closing ')' in VIEW at" + streamTokenizer.lineno());
        return new double[][]{dArray, dArray2, dArray3};
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        int n2;
        Object object;
        this.m_bIsAnimation = false;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        this.m_geomVec = new Vector();
        this.m_numGeoms = 0;
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        if (this.m_numGeoms == 0) {
            PsDebug.warning("missing geometries");
            return null;
        }
        this.m_geomArr = new PgJvxSrc[this.m_numGeoms];
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = this.m_geomVec.elements();
        while (enumeration.hasMoreElements()) {
            this.m_geomArr[n4] = (PgJvxSrc)enumeration.nextElement();
            if (n3 == 0) {
                n3 = this.m_geomArr[n4].getDimOfVertices();
            } else if (n3 != this.m_geomArr[n4].getDimOfVertices()) {
                n3 = -1;
            }
            switch (this.m_geomArr[n4].getType()) {
                case 33: {
                    if (this.m_transparency != -1.0) {
                        this.m_geomArr[n4].setTransparency(this.m_transparency);
                        this.m_geomArr[n4].showTransparency(true);
                    }
                    this.m_geomArr[n4].assureNeighbours();
                    break;
                }
                case 30: {
                    this.m_geomArr[n4].showVertices(true);
                }
            }
            ++n4;
        }
        if (n3 != 2 && n3 != 3) {
            return this.m_geomArr;
        }
        this.m_displayOption = new PvDisplayOption();
        if (this.m_sceneTitle != null) {
            this.m_displayOption.setTitle(this.m_sceneTitle);
            this.m_displayOption.setTag(33);
        }
        boolean bl2 = this.m_sceneView != null;
        boolean bl3 = this.m_sceneScaling == null || this.m_sceneScaling.equalsIgnoreCase("UNCONSTRAINED");
        PdVector pdVector = new PdVector(n3);
        PdVector pdVector2 = new PdVector(n3);
        if (bl2 || bl3) {
            object = new PdVector[this.m_numGeoms];
            PdVector[] pdVectorArray = new PdVector[this.m_numGeoms];
            n2 = 0;
            if (this.m_bIsAnimation && this.m_animArr != null) {
                n4 = 0;
                while (n4 < this.m_numKeys) {
                    n = this.m_animArr[n4].length;
                    int n5 = 0;
                    while (n5 < n) {
                        PdVector[] pdVectorArray2 = this.m_animArr[n4][n5].getBounds();
                        if (pdVectorArray2 != null) {
                            object[n2] = pdVectorArray2[0];
                            pdVectorArray[n2] = pdVectorArray2[1];
                            ++n2;
                        }
                        ++n5;
                    }
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 < this.m_numGeoms) {
                    PdVector[] pdVectorArray3 = this.m_geomArr[n4].getBounds();
                    if (pdVectorArray3 != null) {
                        object[n2] = pdVectorArray3[0];
                        pdVectorArray[n2] = pdVectorArray3[1];
                        ++n2;
                    }
                    ++n4;
                }
            }
            if (n2 > 0) {
                PdVector.min(pdVector, (PdVector[])object, n2);
                PdVector.max(pdVector2, pdVectorArray, n2);
            } else {
                pdVector.setConstant(-10.0);
                pdVector2.setConstant(10.0);
            }
        }
        this.m_displayOption.setOption(35, bl3);
        this.m_displayOption.setOption(46, bl3);
        object = new PdVector(3);
        if (bl3) {
            ((PdVector)object).setConstant(1.0);
            double d = 0.0;
            n4 = 0;
            while (n4 < n3) {
                double d2 = !bl2 || this.m_sceneView[n4].getEntry(0) == Double.NEGATIVE_INFINITY ? pdVector2.m_data[n4] - pdVector.m_data[n4] : this.m_sceneView[n4].getEntry(1) - this.m_sceneView[n4].getEntry(0);
                if (Math.abs(d2) > 1.0E-10) {
                    ((PdVector)object).setEntry(n4, d2);
                }
                if (d2 > d) {
                    d = d2;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                ((PdVector)object).setEntry(n4, d / ((PdVector)object).getEntry(n4));
                ++n4;
            }
            this.m_displayOption.setBoxRatio((PdVector)object);
        } else {
            this.m_displayOption.setBoxRatio(null);
        }
        boolean bl4 = bl2;
        if (bl4) {
            n2 = 0;
            n4 = 0;
            while (n4 < n3) {
                if (this.m_sceneView[n4].getEntry(0) > pdVector.m_data[n4] || this.m_sceneView[n4].getEntry(1) < pdVector2.m_data[n4]) {
                    n2 = 1;
                } else {
                    this.m_sceneView[n4].setEntry(0, pdVector.m_data[n4]);
                    this.m_sceneView[n4].setEntry(1, pdVector2.m_data[n4]);
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                this.m_displayOption.setClipBounds(n4, this.m_sceneView[n4].m_data);
                ++n4;
            }
            this.m_displayOption.setOption(36, n2 != 0);
        }
        this.m_displayOption.setBackgroundColor(Color.white);
        this.m_displayOption.setNumCameras(1);
        if (n3 == 2) {
            this.m_displayOption.setCameraProjection(0, 1);
            this.m_displayOption.setCameraInterest(0, new PdVector(0.0, 0.0, 0.0));
            this.m_displayOption.setCameraPosition(0, new PdVector(0.0, 0.0, 1.0));
            this.m_displayOption.setCurrentCamera(1);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equalsIgnoreCase("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(6);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(6);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(3);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, true);
                this.m_displayOption.setAxesType(3);
            }
        } else if (n3 == 3) {
            PdVector pdVector3;
            double d = 0.0;
            if (this.m_sceneOrientation == null) {
                pdVector3 = new PdVector(0.5, 0.5, 0.7071);
            } else {
                pdVector3 = PgMapleLoader.getPosition(this.m_sceneOrientation[0], this.m_sceneOrientation[1]);
                if (this.m_sceneOrientation[1] == 0.0) {
                    d = 90.0 + this.m_sceneOrientation[0];
                } else if (this.m_sceneOrientation[1] == 180.0) {
                    d = 90.0 - this.m_sceneOrientation[0];
                } else if (this.m_sceneOrientation[1] < 0.0) {
                    d = 180.0;
                }
            }
            if (bl3) {
                int n6 = 0;
                do {
                    pdVector3.setEntry(n6, pdVector3.getEntry(n6) / ((PdVector)object).getEntry(n6));
                } while (++n6 < 3);
            }
            this.m_displayOption.setCameraPosition(0, pdVector3);
            this.m_displayOption.setCameraProjection(0, 0);
            this.m_displayOption.setCameraInterest(0, new PdVector(0.0, 0.0, 0.0));
            this.m_displayOption.setEnabledCameraClip(0, false);
            this.m_displayOption.setCameraFieldOfView(0, 4.0 * (this.m_sceneProjection - 1.0) * (this.m_sceneProjection - 1.0));
            this.m_displayOption.setCameraRoll(0, d);
            this.m_displayOption.setCurrentCamera(0);
            this.m_displayOption.setCameraNearClip(0, 0.0);
            this.m_displayOption.setCameraFarClip(0, 0.0);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equalsIgnoreCase("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(2);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(2);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(0);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, false);
                this.m_displayOption.setAxesType(-1);
            }
        }
        this.m_displayOption.setOption(15, false);
        int n7 = this.m_lightColor.size();
        if (n7 > 0 || this.m_lightModel != null && !this.m_lightModel.equalsIgnoreCase("none")) {
            this.m_displayOption.setLightingModel(1);
            n = 0;
            double d = 0.2;
            if (this.m_lightModel != null && !this.m_lightModel.equalsIgnoreCase("none")) {
                if (this.m_lightModel.equalsIgnoreCase("LIGHT_1")) {
                    n = 3;
                    d = 0.5;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_2")) {
                    n = 3;
                    d = 0.5;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_3")) {
                    n = 3;
                    d = 0.5;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_4")) {
                    n = 1;
                    d = 0.6;
                }
            }
            int n8 = 0;
            this.m_displayOption.setNumLights(n7 + n + 1);
            this.m_displayOption.setLightName(n8, "Ambient");
            this.m_displayOption.setLightColor(n8, Color.white);
            this.m_displayOption.setLightIntensity(n8, d);
            this.m_displayOption.setLightType(n8, 0);
            this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(90.0, 0.0));
            this.m_displayOption.setLightReference(n8, 1);
            this.m_displayOption.setLightShading(n8, 1);
            ++n8;
            if (this.m_lightModel != null && !this.m_lightModel.equalsIgnoreCase("none")) {
                if (this.m_lightModel.equalsIgnoreCase("LIGHT_1")) {
                    this.m_displayOption.setLightName(n8, "Green");
                    this.m_displayOption.setLightColor(n8, Color.green);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(90.0, -45.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    this.m_displayOption.setLightName(++n8, "Blue");
                    this.m_displayOption.setLightColor(n8, Color.blue);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(-45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    this.m_displayOption.setLightName(++n8, "Red");
                    this.m_displayOption.setLightColor(n8, Color.red);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(45.0, 90.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    ++n8;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_2")) {
                    this.m_displayOption.setLightName(n8, "Red");
                    this.m_displayOption.setLightColor(n8, Color.red);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(90.0, 45.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    this.m_displayOption.setLightName(++n8, "Green");
                    this.m_displayOption.setLightColor(n8, Color.green);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    this.m_displayOption.setLightName(++n8, "Blue");
                    this.m_displayOption.setLightColor(n8, Color.blue);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(-45.0, 90.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    ++n8;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_3")) {
                    this.m_displayOption.setLightName(n8, "Blue");
                    this.m_displayOption.setLightColor(n8, Color.blue);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    this.m_displayOption.setLightName(++n8, "Green");
                    this.m_displayOption.setLightColor(n8, Color.green);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    this.m_displayOption.setLightName(++n8, "Red");
                    this.m_displayOption.setLightColor(n8, Color.red);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(135.0, 0.0));
                    this.m_displayOption.setLightIntensity(n8, 0.9);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    ++n8;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_4")) {
                    this.m_displayOption.setLightName(n8, "Light-Grey");
                    this.m_displayOption.setLightColor(n8, Color.white);
                    this.m_displayOption.setLightPosition(n8, PgMapleLoader.getLightPosition(60.0, 85.0));
                    this.m_displayOption.setLightIntensity(n8, 0.8);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    ++n8;
                } else {
                    PsDebug.warning("unknown lighting model = " + this.m_lightModel);
                }
            }
            if (n7 > 0) {
                n4 = 0;
                while (n4 < n7) {
                    Color color = (Color)this.m_lightColor.elementAt(n4);
                    this.m_displayOption.setLightName(n8, "Light[" + n8 + "] (" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
                    this.m_displayOption.setLightColor(n8, color);
                    this.m_displayOption.setLightPosition(n8, (PdVector)this.m_lightPosition.elementAt(n4));
                    this.m_displayOption.setLightIntensity(n8, 0.8);
                    this.m_displayOption.setLightReference(n8, 1);
                    this.m_displayOption.setLightShading(n8, 1);
                    this.m_displayOption.setLightType(n8, 1);
                    ++n8;
                    ++n4;
                }
            }
        } else {
            this.m_displayOption.setLightingModel(0);
        }
        this.m_displayOption.setOption(3, true);
        this.m_displayOption.setAxesLabel(this.m_axesLabels);
        if (this.m_displayOption.getAxesType() != -1) {
            this.m_displayOption.setNumRulers(n3);
            n4 = 0;
            while (n4 < n3) {
                int n9 = n = this.m_axesLabels == null || this.m_axesLabels[n4] == null ? 0 : 1;
                if (n != 0) {
                    this.m_displayOption.setRulerName(n4, this.m_axesLabels[n4]);
                }
                this.m_displayOption.showRulerName(n4, n != 0);
                this.m_displayOption.setRulerMode(n4, 0);
                this.m_displayOption.showRuler(n4, true);
                this.m_displayOption.showRulerNumbers(n4, true);
                this.m_displayOption.showRulerHashingsNormal(n4, false);
                this.m_displayOption.showRulerHashingsUp(n4, false);
                this.m_displayOption.showRulerTicksMajor(n4, true);
                this.m_displayOption.showRulerTicksMinor(n4, true);
                ++n4;
            }
        }
        return this.m_geomArr;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgMapleLoader pgMapleLoader = new PgMapleLoader();
        PgJvxSrc[] pgJvxSrcArray = pgMapleLoader.read(bufferedReader);
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                if (pgJvxSrcArray[n] != null && pgJvxSrcArray[n].getName() == null) {
                    pgJvxSrcArray[n].setName(PsUtil.getFileBaseName(string) + "[" + n + "]");
                }
                ++n;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    public PgJvxSrc[][] getAnimations() {
        if (!this.isAnimation() || this.m_numGeomsPerStep == null) {
            return null;
        }
        int n = this.m_numGeomsPerStep.size();
        this.m_animArr = new PgJvxSrc[n][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Integer n4 = (Integer)this.m_numGeomsPerStep.elementAt(n3);
            int n5 = n4;
            this.m_animArr[n3] = new PgJvxSrc[n5];
            int n6 = 0;
            while (n6 < n5) {
                this.m_animArr[n3][n6] = (PgJvxSrc)this.m_geomVec.elementAt(n2++);
                ++n6;
            }
            ++n3;
        }
        return this.m_animArr;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.m_displayOption = pvDisplayOption;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    protected static boolean makePolygonColorsFromZHue(PgJvxSrc pgJvxSrc, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumPolygons();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        int n3 = Math.min(2, n2 - 1);
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n2);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[n4].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n4] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
            ++n4;
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        int n2;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry");
            return false;
        }
        this.m_numGeoms = pgJvxSrcArray.length;
        int n3 = 0;
        while (n3 < this.m_numGeoms) {
            if (pgJvxSrcArray[n3] == null) {
                PsDebug.warning("missing geometry[" + n3 + "]");
                return false;
            }
            ++n3;
        }
        PgJvxSrc pgJvxSrc = null;
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("# by " + PsConfig.getAuthors() + "\n");
        writer.write("#    File Format           = Maple Graphics MPL\n");
        writer.write("#    Date                  = " + new Date().toString() + "\n");
        writer.write("#    Number of Geometries  = " + this.m_numGeoms + "\n");
        int n4 = 0;
        while (n4 < this.m_numGeoms) {
            pgJvxSrc = pgJvxSrcArray[n4];
            writer.write("#    Geometry[" + String.valueOf(n4) + "]           = " + pgJvxSrc.getName() + "\n");
            n2 = pgJvxSrc.getNumVertices();
            writer.write("#    Number of Vertices    = " + n2 + "\n");
            int n5 = pgJvxSrc.getNumElements();
            if (n5 > 0) {
                writer.write("#    Number of Elements    = " + n5 + "\n");
            }
            if ((n = pgJvxSrc.getNumPolygons()) > 0) {
                writer.write("#    Number of Polygons    = " + n + "\n");
            }
            ++n4;
        }
        writer.write("# End of Header\n");
        n4 = pgJvxSrcArray[0].getDimOfVertices();
        if (n4 == 3) {
            writer.write("PLOT3D(");
        } else {
            writer.write("PLOT(");
        }
        n2 = 1;
        if (pgJvxSrcArray[0].isShowingName()) {
            writer.write("TITLE(\"" + pgJvxSrcArray[0].getName() + "\")");
            n2 = 0;
        }
        String string = null;
        n = 0;
        while (n < this.m_numGeoms) {
            pgJvxSrc = pgJvxSrcArray[n];
            if (pgJvxSrc.getDimOfVertices() != pgJvxSrcArray[0].getDimOfVertices()) {
                PsDebug.warning("found geometries with different dimension in same scene,geometries incompatible with first geometry are skipped");
            } else {
                String string2;
                int n6;
                int n7;
                int n8;
                Object object;
                if (n2 != 0) {
                    n2 = 0;
                } else {
                    writer.write(",\n");
                }
                PdVector[] pdVectorArray = pgJvxSrc.getVertices();
                String string3 = null;
                Color[] colorArray = null;
                int n9 = pgJvxSrc.getNumVertices();
                int n10 = pgJvxSrc.getNumElements();
                int n11 = pgJvxSrc.getNumPolygons();
                if (n11 > 0) {
                    writer.write("CURVES(");
                    object = pgJvxSrc.getPolygons();
                    n8 = 0;
                    while (n8 < n11) {
                        if (n8 > 0) {
                            writer.write(",\n");
                        }
                        writer.write("[");
                        n7 = object[n8].getSize();
                        n6 = 0;
                        while (n6 < n7) {
                            if (n6 > 0) {
                                writer.write(",");
                            }
                            string2 = PgMapleLoader.writeVertex(pdVectorArray[object[n8].m_data[n6]]);
                            writer.write(string2);
                            ++n6;
                        }
                        writer.write("]");
                        ++n8;
                    }
                    writer.write(",\n");
                    if (pgJvxSrc.isShowingPolygonColors()) {
                        colorArray = pgJvxSrc.getPolygonColors();
                        PgMapleLoader.writeColors(writer, colorArray, n11);
                    } else {
                        string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                        writer.write(string3);
                    }
                    if (pgJvxSrc.getGlobalPolygonSize() > 1.0) {
                        writer.write(",THICKNESS(" + (int)pgJvxSrc.getGlobalPolygonSize() + ")");
                    }
                    string = pgJvxSrc.isShowingPolygons() ? "PATCH" : "POINT";
                    if (this.m_numGeoms > 1) {
                        writer.write(",STYLE(" + string + ")");
                    }
                    writer.write(")");
                } else if (n10 > 0) {
                    writer.write("POLYGONS(");
                    object = pgJvxSrc.getElements();
                    n8 = 0;
                    while (n8 < n10) {
                        if (n8 > 0) {
                            writer.write(",\n");
                        }
                        writer.write("[");
                        n7 = object[n8].getSize();
                        n6 = 0;
                        while (n6 < n7) {
                            if (n6 > 0) {
                                writer.write(",");
                            }
                            string2 = PgMapleLoader.writeVertex(pdVectorArray[object[n8].m_data[n6]]);
                            writer.write(string2);
                            ++n6;
                        }
                        writer.write("]");
                        ++n8;
                    }
                    writer.write(",\n");
                    if (pgJvxSrc.isShowingElementColors()) {
                        colorArray = pgJvxSrc.getElementColors();
                        PgMapleLoader.writeColors(writer, colorArray, n10);
                    } else if (pgJvxSrc.isShowingElements()) {
                        string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                        writer.write(string3);
                    } else if (!pgJvxSrc.isShowingElements()) {
                        string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalEdgeColor());
                        writer.write(string3);
                    }
                    if (pgJvxSrc.getGlobalEdgeSize() > 1.0) {
                        writer.write(",THICKNESS(" + (int)pgJvxSrc.getGlobalEdgeSize() + ")");
                    }
                    string = pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingEdges() ? "PATCH" : (pgJvxSrc.isShowingElements() && !pgJvxSrc.isShowingEdges() ? "PATCHNOGRID" : (!pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingEdges() ? "LINE" : "POINT"));
                    if (this.m_numGeoms > 1) {
                        writer.write(",STYLE(" + string + ")");
                    }
                    writer.write(")");
                }
                if (n9 > 0 && pgJvxSrc.isShowingVertices()) {
                    if (n11 > 0 || n10 > 0) {
                        writer.write(",\n");
                    }
                    writer.write("POINTS(");
                    n8 = 0;
                    while (n8 < n9) {
                        if (n8 > 0) {
                            writer.write(",\n");
                        }
                        object = PgMapleLoader.writeVertex(pdVectorArray[n8]);
                        writer.write((String)object);
                        ++n8;
                    }
                    writer.write(",\n");
                    if (pgJvxSrc.isShowingVertexColors()) {
                        colorArray = pgJvxSrc.getVertexColors();
                        PgMapleLoader.writeColors(writer, colorArray, n9);
                    } else {
                        string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalVertexColor());
                        writer.write(string3);
                    }
                    if (pgJvxSrc.getGlobalVertexSize() > 1.0) {
                        writer.write(",SYMBOL(CIRCLE," + 2 * (int)pgJvxSrc.getGlobalVertexSize() + ")");
                    } else {
                        writer.write(",SYMBOL(CIRCLE)");
                    }
                    writer.write(")");
                }
            }
            ++n;
        }
        if (this.m_numGeoms == 1 && string != null) {
            writer.write(",STYLE(" + string + ")");
        }
        writer.write(",SCALING(CONSTRAINED)");
        if (n4 == 3) {
            writer.write(",LIGHTMODEL(LIGHT_3)");
        }
        writer.write(");");
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    private static String[] parseAxesLabels(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        String string = PgMapleLoader.parseString(streamTokenizer);
        streamTokenizer.nextToken();
        String string2 = PgMapleLoader.parseString(streamTokenizer);
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new String[]{string, string2};
        }
        int n = 2;
        String string3 = "";
        while (streamTokenizer.ttype == 44) {
            streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("FONT")) {
                PgMapleLoader.parseUnknown(streamTokenizer);
                streamTokenizer.nextToken();
                continue;
            }
            if (streamTokenizer.ttype == -3 && (streamTokenizer.sval.equalsIgnoreCase("DEFAULT") || streamTokenizer.sval.equalsIgnoreCase("HORIZONTAL") || streamTokenizer.sval.equalsIgnoreCase("VERTICAL"))) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                continue;
            }
            string3 = PgMapleLoader.parseString(streamTokenizer);
            ++n;
            streamTokenizer.nextToken();
        }
        if (streamTokenizer.ttype == 41) {
            if (n == 2) {
                return new String[]{string, string2};
            }
            return new String[]{string, string2, string3};
        }
        throw new IOException("unable to parse axesLabels.");
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing color");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("COLOUR(RGB,");
        stringBuffer.append(String.valueOf((float)color.getRed() / 255.0f) + ", " + String.valueOf((float)color.getGreen() / 255.0f) + ", " + String.valueOf((float)color.getBlue() / 255.0f) + ")");
        return stringBuffer.toString();
    }

    private static double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        double d;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -3) {
            d = 1000.0;
            if (streamTokenizer.sval.equalsIgnoreCase("Float")) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 45) {
                    streamTokenizer.nextToken();
                    d = -1000.0;
                }
                streamTokenizer.nextToken();
            } else {
                streamTokenizer.pushBack();
                PgMapleLoader.parseUnknown(streamTokenizer);
            }
        } else {
            streamTokenizer.pushBack();
            d = PgLoader.parseDouble(streamTokenizer);
        }
        return d;
    }

    private static String writeVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int n = pdVector.getSize();
        if (n < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("[" + String.valueOf((float)pdVector.m_data[0]));
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(",");
            if (Math.abs(pdVector.m_data[n2]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[n2]);
            } else {
                stringBuffer.append(0.0f);
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static boolean makeElementColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumElements();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assureElementColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        Color[] colorArray = pgJvxSrc.getElementColors();
        PdVector pdVector = new PdVector(n3);
        n = Math.min(n, n3);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n4 = 0;
        while (n4 < n) {
            if (dArray[n4] < 1.0E-10) {
                dArray[n4] = 1.0;
            }
            ++n4;
        }
        float[] fArray = new float[n];
        int n5 = 0;
        while (n5 < n2) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[n5].m_data);
            int n6 = 0;
            while (n6 < n) {
                float f = (float)((pdVector.m_data[n6] - pdVectorArray[0].m_data[n6]) / dArray[n6]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[n6] = f;
                ++n6;
            }
            if (n == 1) {
                colorArray[n5] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n == 2) {
                colorArray[n5] = new Color(220, 78 + (int)(fArray[0] * 172.0f), 29 + (int)(fArray[1] * 200.0f));
            } else if (n == 3) {
                colorArray[n5] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n5;
        }
        return true;
    }

    public static boolean makeEdgeColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumEdges();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n3);
        n = Math.min(n, n3 - 1);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n4 = 0;
        while (n4 < n) {
            if (dArray[n4] < 1.0E-10) {
                dArray[n4] = 1.0;
            }
            ++n4;
        }
        float[] fArray = new float[n];
        int n5 = 0;
        while (n5 < n2) {
            pdVector.blend(0.5, pdVectorArray2[piVectorArray[n5].m_data[0]], 0.5, pdVectorArray2[piVectorArray[n5].m_data[1]]);
            int n6 = 0;
            while (n6 < n) {
                float f = (float)((pdVector.m_data[n6] - pdVectorArray[0].m_data[n6]) / dArray[n6]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[n6] = f;
                ++n6;
            }
            if (n == 1) {
                colorArray[n5] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n == 2) {
                colorArray[n5] = new Color(fArray[0], fArray[1], 0.0f);
            } else if (n == 3) {
                colorArray[n5] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n5;
        }
        return true;
    }

    public static boolean makeVertexColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumVertices();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assureVertexColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        Color[] colorArray = pgJvxSrc.getVertexColors();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n4 = 0;
        while (n4 < n3) {
            if (dArray[n4] < 1.0E-10) {
                dArray[n4] = 1.0;
            }
            ++n4;
        }
        n = Math.min(n, n3);
        float[] fArray = new float[n];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                float f = (float)((pdVectorArray2[n5].m_data[n6] - pdVectorArray[0].m_data[n6]) / dArray[n6]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[n6] = f;
                ++n6;
            }
            if (n == 1) {
                colorArray[n5] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n == 2) {
                colorArray[n5] = new Color(fArray[0], fArray[1], 0.0f);
            } else if (n == 3) {
                colorArray[n5] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n5;
        }
        return true;
    }

    private static double[] parseRange(StreamTokenizer streamTokenizer) throws IOException {
        double d = PgLoader.parseDouble(streamTokenizer);
        double d2 = PgLoader.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            double d3 = PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                streamTokenizer.pushBack();
                double d4 = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                d2 = 10.0 * d3 + d4;
            } else {
                d2 = d2 == 0.0 ? 10.0 * d3 : 10.0 * d2 + d3;
            }
        } else {
            d2 *= 10.0;
        }
        streamTokenizer.pushBack();
        return new double[]{d, d2};
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    public static boolean makePolygonColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumPolygons();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n3);
        n = Math.min(n, n3);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        int n4 = 0;
        while (n4 < n) {
            if (dArray[n4] < 1.0E-10) {
                dArray[n4] = 1.0;
            }
            ++n4;
        }
        float[] fArray = new float[n];
        int n5 = 0;
        while (n5 < n2) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[n5].m_data);
            int n6 = 0;
            while (n6 < n) {
                float f = (float)((pdVector.m_data[n6] - pdVectorArray[0].m_data[n6]) / dArray[n6]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[n6] = f;
                ++n6;
            }
            if (n == 1) {
                colorArray[n5] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
            } else if (n == 2) {
                colorArray[n5] = new Color(fArray[0], fArray[1], 0.0f);
            } else if (n == 3) {
                colorArray[n5] = new Color(fArray[0], fArray[1], fArray[2]);
            }
            ++n5;
        }
        return true;
    }

    private static Color[] parseColorArray(StreamTokenizer streamTokenizer, int n) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = PgMapleLoader.parseRange(streamTokenizer);
        int n2 = (int)dArray[1];
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 91) {
            double[] dArray2 = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                dArray2[n3] = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                ++n3;
            }
            streamTokenizer.nextToken();
            String string = "";
            while (streamTokenizer.ttype != 41) {
                string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                streamTokenizer.nextToken();
            }
            if (n2 == 3) {
                return new Color[]{new Color((float)dArray2[0], (float)dArray2[1], (float)dArray2[2])};
            }
            return new Color[]{Color.white};
        }
        streamTokenizer.pushBack();
        double[] dArray3 = PgMapleLoader.parseRange(streamTokenizer);
        int n4 = (int)dArray3[1];
        streamTokenizer.nextToken();
        Color[] colorArray = new Color[n2];
        float[] fArray = new float[n4];
        streamTokenizer.nextToken();
        int n5 = 0;
        while (n5 < n2) {
            streamTokenizer.nextToken();
            int n6 = 0;
            while (n6 < n4) {
                fArray[n6] = (float)PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                ++n6;
            }
            colorArray[n5] = n4 == 3 ? new Color(fArray[0], fArray[1], fArray[2]) : Color.white;
            streamTokenizer.nextToken();
            ++n5;
        }
        streamTokenizer.nextToken();
        String string = "";
        while (streamTokenizer.ttype != 41) {
            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
            streamTokenizer.nextToken();
        }
        return colorArray;
    }

    private void addGeometry(PgJvxSrc pgJvxSrc) {
        ++this.m_numGeomStep;
        ++this.m_numGeoms;
        this.m_geomVec.addElement(pgJvxSrc);
        this.m_geomColor.setSize(this.m_numGeoms);
        this.m_geomStyle.setSize(this.m_numGeoms);
        this.m_geomThickness.setSize(this.m_numGeoms);
        this.m_geomTitle.setSize(this.m_numGeoms);
    }

    protected static boolean makeElementColorsFromZ(PgJvxSrc pgJvxSrc, Color color, Color color2, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumElements();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureElementColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        Color[] colorArray = pgJvxSrc.getElementColors();
        PdVector pdVector = new PdVector(n2);
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[n4].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n4] = PdColor.blend(1.0f - f2, color, f2, color2);
            ++n4;
        }
        return true;
    }

    public static boolean makeVertexColorsFromZ(PgJvxSrc pgJvxSrc, Color color, Color color2, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumVertices();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureVertexColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        Color[] colorArray = pgJvxSrc.getVertexColors();
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            float f2 = (float)(pdVectorArray2[n4].m_data[n3] - pdVectorArray[0].m_data[n3]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n4] = PdColor.blend(1.0f - f2, color, f2, color2);
            ++n4;
        }
        return true;
    }

    private static String parseUnknown(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 41) {
            streamTokenizer.pushBack();
        } else if (streamTokenizer.ttype != 40) {
            int n = 0;
            int n2 = 0;
            while (streamTokenizer.ttype != 44 && n >= 0 && n2 >= 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 40) {
                    ++n;
                    continue;
                }
                if (streamTokenizer.ttype == 41) {
                    --n;
                    continue;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n2;
                    continue;
                }
                if (streamTokenizer.ttype == 93) {
                    --n2;
                    continue;
                }
                if (streamTokenizer.ttype != -1) continue;
                throw new IOException("premature end of file.");
            }
            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 41 || streamTokenizer.ttype == 93) {
                streamTokenizer.pushBack();
            }
        } else {
            int n = 1;
            while (n != 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1) {
                    throw new IOException("')' missing, premature end of file.");
                }
                if (streamTokenizer.ttype == 40) {
                    ++n;
                    continue;
                }
                if (streamTokenizer.ttype == 41) {
                    --n;
                    continue;
                }
                if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 39 && streamTokenizer.ttype != -2 && streamTokenizer.ttype != 91 && streamTokenizer.ttype != 93 && streamTokenizer.ttype != 44 && streamTokenizer.ttype != 42 && streamTokenizer.ttype == 94) continue;
            }
        }
        return string;
    }

    private boolean parsePlotOptions(StreamTokenizer streamTokenizer, int n) throws IOException {
        this.m_geomColor.setSize(n + 1);
        this.m_geomStyle.setSize(n + 1);
        this.m_geomThickness.setSize(n + 1);
        this.m_geomTitle.setSize(n + 1);
        if (streamTokenizer.sval == null) {
            return false;
        }
        if ("COLOUR".equalsIgnoreCase(streamTokenizer.sval) || "COLOR".equalsIgnoreCase(streamTokenizer.sval)) {
            Color[] colorArray = this.parseColor(streamTokenizer, n);
            if (colorArray != null) {
                this.m_geomColor.setElementAt(colorArray, n);
            }
        } else if ("STYLE".equalsIgnoreCase(streamTokenizer.sval)) {
            this.m_geomStyle.setElementAt(PgMapleLoader.parseString(streamTokenizer, "STYLE"), n);
        } else if ("THICKNESS".equalsIgnoreCase(streamTokenizer.sval)) {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d = PgLoader.parseDouble(streamTokenizer);
            this.m_geomThickness.setElementAt(new Double(d), n);
            streamTokenizer.nextToken();
        } else if ("TITLE".equalsIgnoreCase(streamTokenizer.sval)) {
            streamTokenizer.nextToken();
            this.m_geomTitle.setElementAt(PgMapleLoader.parseString(streamTokenizer), n);
            streamTokenizer.nextToken();
        } else if ("SCALING".equalsIgnoreCase(streamTokenizer.sval)) {
            this.m_sceneScaling = PgMapleLoader.parseString(streamTokenizer, "SCALING");
        } else {
            return false;
        }
        streamTokenizer.nextToken();
        return true;
    }

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return true;
    }

    private static void parseLight(StreamTokenizer streamTokenizer, Vector vector, Vector vector2) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = new double[2];
        int n = 0;
        do {
            dArray[n] = PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        } while (++n < 2);
        PdVector pdVector = PgMapleLoader.getLightPosition(dArray[0], dArray[1]);
        float[] fArray = new float[3];
        int n2 = 0;
        do {
            fArray[n2] = (float)PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        } while (++n2 < 3);
        Color color = new Color(fArray[0], fArray[1], fArray[2]);
        vector2.addElement(pdVector);
        vector.addElement(color);
    }

    protected static boolean makeElementColorsFromZHue(PgJvxSrc pgJvxSrc, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumElements();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureElementColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        Color[] colorArray = pgJvxSrc.getElementColors();
        PdVector pdVector = new PdVector(n2);
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[n4].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n4] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
            ++n4;
        }
        return true;
    }

    public static boolean makeVertexColorsFromZHue(PgJvxSrc pgJvxSrc, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumVertices();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureVertexColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        Color[] colorArray = pgJvxSrc.getVertexColors();
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            float f2 = (float)(pdVectorArray2[n4].m_data[n3] - pdVectorArray[0].m_data[n3]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[n4] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
            ++n4;
        }
        return true;
    }

    private static String parseString(StreamTokenizer streamTokenizer, String string) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        String string2 = streamTokenizer.sval;
        streamTokenizer.nextToken();
        return string2;
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector pdVector = new PdVector(n);
        streamTokenizer.nextToken();
        int n2 = 0;
        while (n2 < n) {
            pdVector.m_data[n2] = PgMapleLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            ++n2;
        }
        return pdVector;
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer) throws IOException {
        int n = 10;
        int n2 = 0;
        PdVector pdVector = new PdVector(n);
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != 91) {
            if (n2 == n) {
                pdVector.setSize(n *= 2);
            }
            pdVector.m_data[n2++] = PgMapleLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        }
        pdVector.setSize(n2);
        return pdVector;
    }

    private static String parseString(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        streamTokenizer.ordinaryChar(48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != 41 && streamTokenizer.ttype != 44) {
            if (streamTokenizer.ttype == -1 || streamTokenizer.ttype == 10) {
                streamTokenizer.parseNumbers();
                throw new IOException("')' missing end of string, premature end of file.");
            }
            string = streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39 || streamTokenizer.ttype == 96 ? string + streamTokenizer.sval : (streamTokenizer.ttype == -2 ? string + Double.toString(PgLoader.parseDouble(streamTokenizer)) : (streamTokenizer.ttype == 94 ? string + "^" : (streamTokenizer.ttype == 42 ? string + "*" : (streamTokenizer.ttype == 43 ? string + "+" : (streamTokenizer.ttype == 45 ? string + "-" : (streamTokenizer.ttype == 46 ? string + "." : (streamTokenizer.ttype == 47 ? string + "/" : (streamTokenizer.ttype == 58 ? string + ":" : (streamTokenizer.ttype == 59 ? string + ";" : (streamTokenizer.ttype == 60 ? string + "<" : (streamTokenizer.ttype == 61 ? string + "=" : (streamTokenizer.ttype == 62 ? string + ">" : (streamTokenizer.ttype == 63 ? string + "?" : (streamTokenizer.ttype == 64 ? string + "@" : (streamTokenizer.ttype == 33 ? string + "!" : (streamTokenizer.ttype == 35 ? string + "#" : (streamTokenizer.ttype == 36 ? string + "$" : (streamTokenizer.ttype == 37 ? string + "%" : (streamTokenizer.ttype == 38 ? string + "&" : (streamTokenizer.ttype == 123 ? string + "{" : (streamTokenizer.ttype == 125 ? string + "}" : (streamTokenizer.ttype == 126 ? string + "~" : (streamTokenizer.ttype == 169 ? string + "\u00a9" : string + " ")))))))))))))))))))))));
            streamTokenizer.nextToken();
        }
        streamTokenizer.pushBack();
        streamTokenizer.parseNumbers();
        return string;
    }

    private static boolean writeColors(Writer writer, Color[] colorArray, int n) throws IOException {
        if (colorArray == null || colorArray.length < n) {
            PsDebug.warning("missing colors");
            return false;
        }
        writer.write("COLOUR(RGB");
        int n2 = 0;
        while (n2 < n) {
            writer.write(",\n" + String.valueOf((float)colorArray[n2].getRed() / 255.0f) + "," + String.valueOf((float)colorArray[n2].getGreen() / 255.0f) + "," + String.valueOf((float)colorArray[n2].getBlue() / 255.0f));
            ++n2;
        }
        writer.write(")");
        return true;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    private static int[] parse2ArrayOfPoints(StreamTokenizer streamTokenizer, Vector vector, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != 93) {
            streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if (streamTokenizer.ttype == 91) {
                ++n2;
                int n4 = n3;
                n3 = 0;
                streamTokenizer.nextToken();
                while (streamTokenizer.ttype != 93) {
                    PdVector pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                    vector.addElement(pdVector);
                    ++n3;
                    streamTokenizer.nextToken();
                }
                if (n2 > 1 && n4 != n3) {
                    throw new IOException("numVLines differ");
                }
            } else {
                PgMapleLoader.parseUnknown(streamTokenizer);
            }
            streamTokenizer.nextToken();
        }
        return new int[]{n2, n3};
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static PdVector getPosition(double d, double d2) {
        PdVector pdVector = new PdVector(Math.cos(d *= Math.PI / 180) * Math.sin(d2 *= Math.PI / 180), Math.sin(d) * Math.sin(d2), Math.cos(d2));
        return pdVector;
    }

    private static PdVector getLightPosition(double d, double d2) {
        PdVector pdVector = new PdVector(Math.sin(d2 *= Math.PI / 180) * Math.sin(d *= Math.PI / 180), Math.cos(d), Math.cos(d2) * Math.sin(d));
        return pdVector;
    }

    private static double[] parseOrientation(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = new double[2];
        dArray[0] = PgLoader.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        dArray[1] = PgLoader.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        return dArray;
    }

    private double parseProjection(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double d = 1.0;
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            d = PgLoader.parseDouble(streamTokenizer);
        } else if (streamTokenizer.sval != null) {
            if (streamTokenizer.sval.equalsIgnoreCase("ORTHOGONAL")) {
                d = 1.0;
            } else if (streamTokenizer.sval.equalsIgnoreCase("NORMAL")) {
                d = 0.5;
            } else if (streamTokenizer.sval.equalsIgnoreCase("FISHEYE")) {
                d = 0.0;
            }
        } else {
            PsDebug.warning("error in PROJECTION at" + streamTokenizer.lineno());
            return 1.0;
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 44) {
            this.m_sceneOrientation = new double[2];
            this.m_sceneOrientation[0] = d;
            this.m_sceneOrientation[1] = PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            d = PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        }
        return d;
    }

    private Color[] parseColor(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2;
        Color[] colorArray;
        Serializable serializable;
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        if (streamTokenizer.sval == null) {
            streamTokenizer.pushBack();
            streamTokenizer.pushBack();
            streamTokenizer.pushBack();
            PgMapleLoader.parseUnknown(streamTokenizer);
            PsDebug.warning("failed parsing color at " + streamTokenizer.lineno());
            return null;
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        if (streamTokenizer.sval.equalsIgnoreCase("RGB")) {
            streamTokenizer.nextToken();
            serializable = new PdColor();
            ((PdColor)serializable).setSize(3);
            streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if (streamTokenizer.sval != null && streamTokenizer.sval.equalsIgnoreCase("Array")) {
                colorArray = PgMapleLoader.parseColorArray(streamTokenizer, 1);
                n2 = 0;
                while (n2 < colorArray.length) {
                    vector.addElement(colorArray[n2]);
                    ++n2;
                }
                streamTokenizer.nextToken();
            } else if (streamTokenizer.ttype == -2) {
                int n3 = 3;
                n2 = 0;
                while (n2 < n3) {
                    ((PdColor)serializable).setEntry(n2, PgLoader.parseDouble(streamTokenizer));
                    streamTokenizer.nextToken();
                    ++n2;
                }
                vector.addElement(((PdColor)serializable).getColor());
                if (streamTokenizer.ttype == 44) {
                    while (streamTokenizer.ttype != 41) {
                        n2 = 0;
                        while (n2 < n3) {
                            ((PdColor)serializable).setEntry(n2, PgLoader.parseDouble(streamTokenizer));
                            streamTokenizer.nextToken();
                            ++n2;
                        }
                        vector.addElement(((PdColor)serializable).getColor());
                    }
                }
            }
        } else if (streamTokenizer.sval.equalsIgnoreCase("HUE")) {
            streamTokenizer.nextToken();
            serializable = PdColor.hsv2rgb((int)(PgLoader.parseDouble(streamTokenizer) * 255.0), 255, 255);
            streamTokenizer.nextToken();
            vector.addElement(serializable);
            if (streamTokenizer.ttype == 44) {
                while (streamTokenizer.ttype != 41) {
                    vector.addElement(PdColor.hsv2rgb((int)(PgLoader.parseDouble(streamTokenizer) * 255.0), 255, 255));
                    streamTokenizer.nextToken();
                }
            }
        } else {
            if (streamTokenizer.sval.equalsIgnoreCase("NONE") || streamTokenizer.sval.equalsIgnoreCase("XYZ") || streamTokenizer.sval.equalsIgnoreCase("XY") || streamTokenizer.sval.equalsIgnoreCase("Z") || streamTokenizer.sval.equalsIgnoreCase("ZGREYSCALE") || streamTokenizer.sval.equalsIgnoreCase("ZGRAYSCALE") || streamTokenizer.sval.equalsIgnoreCase("ZHUE") || streamTokenizer.sval.equalsIgnoreCase("XYZSHADING") || streamTokenizer.sval.equalsIgnoreCase("XYSHADING") || streamTokenizer.sval.equalsIgnoreCase("ZSHADING")) {
                if (n == -1) {
                    this.m_sceneShading = streamTokenizer.sval;
                } else {
                    this.m_geomColor.setElementAt(streamTokenizer.sval, n);
                }
                streamTokenizer.nextToken();
                return null;
            }
            PsDebug.warning("failed parse color at " + streamTokenizer.lineno(), (Object)(", unknown option " + streamTokenizer.sval));
        }
        int n4 = vector.size();
        if (n4 == 0) {
            return null;
        }
        colorArray = new Color[n4];
        n2 = 0;
        while (n2 < n4) {
            colorArray[n2] = (Color)vector.elementAt(n2);
            ++n2;
        }
        return colorArray;
    }

    protected Vector readGraphics(StreamTokenizer streamTokenizer, int n, Vector vector) throws IOException {
        Color[] colorArray;
        Object object;
        int n2;
        double[][] dArray = null;
        PgJvxSrc pgJvxSrc = null;
        String string = "";
        Vector<PdVector> vector2 = new Vector<PdVector>();
        Vector<PiVector> vector3 = new Vector<PiVector>();
        Vector<PiVector> vector4 = new Vector<PiVector>();
        this.m_geomColor = new Vector();
        this.m_geomStyle = new Vector();
        this.m_geomThickness = new Vector();
        this.m_geomTitle = new Vector();
        this.m_lightColor = new Vector();
        this.m_lightPosition = new Vector();
        int n3 = 0;
        int n4 = 0;
        do {
            int n5;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 41) {
                --n3;
                continue;
            }
            if (streamTokenizer.ttype == 40) {
                ++n3;
                continue;
            }
            if (streamTokenizer.ttype == 91) {
                ++n4;
                continue;
            }
            if (streamTokenizer.ttype == 93) {
                --n4;
                if (!this.isAnimation()) continue;
                ++this.m_numKeys;
                this.m_numGeomsPerStep.addElement(new Integer(this.m_numGeomStep));
                this.m_numGeomStep = 0;
                continue;
            }
            if (streamTokenizer.ttype == 44) continue;
            if (streamTokenizer.ttype != -3) {
                throw new IOException("Graphics primitive identifyer expected");
            }
            if ("POLYGONS".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                int n6 = 0;
                while (streamTokenizer.ttype != 41) {
                    int n7;
                    PiVector piVector;
                    PdVector pdVector;
                    streamTokenizer.nextToken();
                    streamTokenizer.pushBack();
                    if (this.parsePlotOptions(streamTokenizer, this.m_numGeoms)) continue;
                    if (streamTokenizer.ttype == 91) {
                        n2 = 0;
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 93) {
                            pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                            vector2.addElement(pdVector);
                            ++n2;
                            streamTokenizer.nextToken();
                        }
                        piVector = new PiVector(n2);
                        n7 = 0;
                        while (n7 < n2) {
                            piVector.setEntry(n7, n6 + n7);
                            ++n7;
                        }
                        n6 += n2;
                        vector3.addElement(piVector);
                    } else if ("Array".equalsIgnoreCase(streamTokenizer.sval) || "hfarray".equalsIgnoreCase(streamTokenizer.sval)) {
                        while ("Array".equalsIgnoreCase(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            n2 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 93) {
                                pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                                vector2.addElement(pdVector);
                                ++n2;
                                streamTokenizer.nextToken();
                            }
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 41) {
                                string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                                streamTokenizer.nextToken();
                            }
                            piVector = new PiVector(n2);
                            n7 = 0;
                            while (n7 < n2) {
                                piVector.setEntry(n7, n6 + n7);
                                ++n7;
                            }
                            n6 += n2;
                            vector3.addElement(piVector);
                        }
                    } else if (streamTokenizer.ttype != 44) {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                    }
                    streamTokenizer.nextToken();
                }
                if (vector3.size() == 0) continue;
                pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(33);
                pgJvxSrc.setDimOfVertices(n);
                pgJvxSrc.setNumVertices(vector2.size());
                n5 = 0;
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    pgJvxSrc.setVertex(n5++, (PdVector)enumeration.nextElement());
                }
                vector2.removeAllElements();
                pgJvxSrc.setDimOfElements(-1);
                pgJvxSrc.setNumElements(vector3.size());
                n5 = 0;
                enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    pgJvxSrc.setElement(n5++, (PiVector)enumeration.nextElement());
                }
                vector3.removeAllElements();
                this.addGeometry(pgJvxSrc);
                continue;
            }
            if ("CURVES".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                int n8 = 0;
                while (streamTokenizer.ttype != 41) {
                    int n9;
                    PiVector piVector;
                    PdVector pdVector;
                    streamTokenizer.nextToken();
                    streamTokenizer.pushBack();
                    if (this.parsePlotOptions(streamTokenizer, this.m_numGeoms)) continue;
                    if (streamTokenizer.ttype == 91) {
                        n2 = 0;
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 93) {
                            pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                            vector2.addElement(pdVector);
                            ++n2;
                            streamTokenizer.nextToken();
                        }
                        piVector = new PiVector(n2);
                        n9 = 0;
                        while (n9 < n2) {
                            piVector.setEntry(n9, n8 + n9);
                            ++n9;
                        }
                        n8 += n2;
                        vector4.addElement(piVector);
                    } else if ("Array".equalsIgnoreCase(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        n2 = 0;
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 93) {
                            pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                            vector2.addElement(pdVector);
                            ++n2;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 41) {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                        piVector = new PiVector(n2);
                        n9 = 0;
                        while (n9 < n2) {
                            piVector.setEntry(n9, n8 + n9);
                            ++n9;
                        }
                        n8 += n2;
                        vector4.addElement(piVector);
                    } else {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                    }
                    streamTokenizer.nextToken();
                }
                pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(32);
                pgJvxSrc.setDimOfVertices(n);
                pgJvxSrc.setNumVertices(vector2.size());
                n5 = 0;
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    pgJvxSrc.setVertex(n5++, (PdVector)enumeration.nextElement());
                }
                vector2.removeAllElements();
                pgJvxSrc.setDimOfPolygons(-1);
                pgJvxSrc.setNumPolygons(vector4.size());
                n5 = 0;
                enumeration = vector4.elements();
                while (enumeration.hasMoreElements()) {
                    pgJvxSrc.setPolygon(n5++, (PiVector)enumeration.nextElement());
                }
                vector4.removeAllElements();
                this.addGeometry(pgJvxSrc);
                continue;
            }
            if ("POINTS".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                while (streamTokenizer.ttype != 41) {
                    streamTokenizer.nextToken();
                    streamTokenizer.pushBack();
                    if (this.parsePlotOptions(streamTokenizer, this.m_numGeoms)) continue;
                    if (streamTokenizer.ttype == 91) {
                        PdVector pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                        vector2.addElement(pdVector);
                    } else {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                    }
                    streamTokenizer.nextToken();
                }
                pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(30);
                pgJvxSrc.setDimOfVertices(n);
                pgJvxSrc.setNumVertices(vector2.size());
                n5 = 0;
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    pgJvxSrc.setVertex(n5++, (PdVector)enumeration.nextElement());
                }
                vector2.removeAllElements();
                this.addGeometry(pgJvxSrc);
                continue;
            }
            if ("TEXT".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                PdVector pdVector = null;
                String string2 = null;
                int n10 = 1;
                n2 = 1;
                while (streamTokenizer.ttype != 41) {
                    streamTokenizer.nextToken();
                    streamTokenizer.pushBack();
                    if (this.parsePlotOptions(streamTokenizer, this.m_numGeoms)) continue;
                    if (streamTokenizer.ttype == 91) {
                        pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                        vector2.addElement(pdVector);
                        streamTokenizer.nextToken();
                        if (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39 || streamTokenizer.ttype == 96) {
                            string2 = streamTokenizer.sval;
                            pdVector.setName(string2);
                        }
                    } else if (streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39 || streamTokenizer.ttype == 96) {
                        streamTokenizer.nextToken();
                        if (pdVector != null) {
                            pdVector.setName(streamTokenizer.sval);
                        } else {
                            PsDebug.warning("text position must occur before label, line = " + streamTokenizer.lineno());
                        }
                    } else if (streamTokenizer.ttype == -3 && streamTokenizer.sval.startsWith("ALIGN")) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.sval.equalsIgnoreCase("ALIGNABOVE")) {
                            n2 = 0;
                        } else if (streamTokenizer.sval.equalsIgnoreCase("ALIGNBELOW")) {
                            n2 = 2;
                        } else if (streamTokenizer.sval.equalsIgnoreCase("ALIGNLEFT")) {
                            n10 = 2;
                        } else if (streamTokenizer.sval.equalsIgnoreCase("ALIGNRIGHT")) {
                            n10 = 0;
                        }
                    } else {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                    }
                    streamTokenizer.nextToken();
                }
                pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(30);
                pgJvxSrc.setDimOfVertices(n);
                pgJvxSrc.setNumVertices(vector2.size());
                n5 = 0;
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    pgJvxSrc.setVertex(n5++, (PdVector)enumeration.nextElement());
                }
                vector2.removeAllElements();
                if (string2 != null) {
                    pgJvxSrc.setName(string2);
                    pgJvxSrc.setLabelAttribute(0, 4, 4, n10, n2, 3);
                    if (this.m_geomColor.size() > this.m_numGeoms) {
                        enumeration = this.m_geomColor.elementAt(this.m_numGeoms);
                        object = null;
                        if (enumeration != null && enumeration instanceof Color[] && (colorArray = (Color[])enumeration).length == 1) {
                            object = colorArray[0];
                        }
                        if (object != null) {
                            pgJvxSrc.setLabelColor(5, (Color)object);
                            pgJvxSrc.setLabelColor(0, (Color)object);
                        }
                    }
                }
                pgJvxSrc.showIndices(true);
                pgJvxSrc.setGlobalVertexSize(0.0);
                this.addGeometry(pgJvxSrc);
                continue;
            }
            if ("GRID".equalsIgnoreCase(streamTokenizer.sval)) {
                int n11;
                streamTokenizer.nextToken();
                int n12 = 0;
                int n13 = 0;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                while (streamTokenizer.ttype != 41) {
                    Object[] objectArray;
                    streamTokenizer.nextToken();
                    streamTokenizer.pushBack();
                    if (this.parsePlotOptions(streamTokenizer, this.m_numGeoms)) continue;
                    if (streamTokenizer.ttype == -2) {
                        objectArray = PgMapleLoader.parseRange(streamTokenizer);
                        d = objectArray[0];
                        d2 = objectArray[1];
                        streamTokenizer.nextToken();
                        objectArray = PgMapleLoader.parseRange(streamTokenizer);
                        d3 = objectArray[0];
                        d4 = objectArray[1];
                    } else if ("Array".equalsIgnoreCase(streamTokenizer.sval) || "hfarray".equalsIgnoreCase(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        objectArray = PgMapleLoader.parse2ArrayOfDoubles(streamTokenizer, vector2);
                        if (objectArray != null) {
                            n12 = (int)objectArray[0];
                            n13 = (int)objectArray[1];
                        }
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 41) {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                    } else if (streamTokenizer.ttype == 91) {
                        objectArray = PgMapleLoader.parse2ArrayOfDoubles(streamTokenizer, vector2);
                        if (objectArray != null) {
                            n12 = (int)objectArray[0];
                            n13 = (int)objectArray[1];
                        }
                    } else {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                    }
                    streamTokenizer.nextToken();
                }
                if (n12 == 0 || n13 == 0) continue;
                n5 = 0;
                pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(33);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(n12 * n13);
                double d5 = (d2 - d) / (double)(n12 - 1);
                double d6 = (d4 - d3) / (double)(n13 - 1);
                int n14 = 0;
                while (n14 < n12) {
                    n11 = 0;
                    while (n11 < n13) {
                        Double d7 = (Double)vector2.elementAt(n5);
                        pgJvxSrc.getVertex(n5++).set(d + (double)n14 * d5, d3 + (double)n11 * d6, d7);
                        ++n11;
                    }
                    ++n14;
                }
                vector2.removeAllElements();
                pgJvxSrc.setDimOfElements(4);
                pgJvxSrc.setNumElements((n12 - 1) * (n13 - 1));
                pgJvxSrc.assureNeighbours();
                n5 = 0;
                PiVector[] piVectorArray = pgJvxSrc.getNeighbours();
                n11 = 0;
                while (n11 < n12 - 1) {
                    int n15 = 0;
                    while (n15 < n13 - 1) {
                        if (n11 < n12 - 2) {
                            piVectorArray[n5].m_data[0] = n5 + n13 - 1;
                        }
                        if (n15 < n13 - 2) {
                            piVectorArray[n5].m_data[1] = n5 + 1;
                        }
                        if (n11 > 0) {
                            piVectorArray[n5].m_data[2] = n5 - n13 + 1;
                        }
                        if (n15 > 0) {
                            piVectorArray[n5].m_data[3] = n5 - 1;
                        }
                        pgJvxSrc.getElement(n5++).set(n11 * n13 + n15, (n11 + 1) * n13 + n15, (n11 + 1) * n13 + n15 + 1, n11 * n13 + n15 + 1);
                        ++n15;
                    }
                    ++n11;
                }
                if (this.m_geomTitle.elementAt(this.m_numGeoms) == null) {
                    this.m_geomTitle.setElementAt("Grid[" + this.m_numGeoms + "]", this.m_numGeoms);
                }
                this.addGeometry(pgJvxSrc);
                continue;
            }
            if ("MESH".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                int n16 = 0;
                int n17 = 0;
                while (streamTokenizer.ttype != 41) {
                    int[] nArray;
                    streamTokenizer.nextToken();
                    streamTokenizer.pushBack();
                    if (this.parsePlotOptions(streamTokenizer, this.m_numGeoms)) continue;
                    if ("Array".equalsIgnoreCase(streamTokenizer.sval) || "hfarray".equalsIgnoreCase(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        PgMapleLoader.parseRange(streamTokenizer);
                        streamTokenizer.nextToken();
                        nArray = PgMapleLoader.parse2ArrayOfPoints(streamTokenizer, vector2, n);
                        if (nArray != null) {
                            n16 = nArray[0];
                            n17 = nArray[1];
                        }
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 41) {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                    } else if (streamTokenizer.ttype == 91) {
                        nArray = PgMapleLoader.parse2ArrayOfPoints(streamTokenizer, vector2, n);
                        if (nArray != null) {
                            n16 = nArray[0];
                            n17 = nArray[1];
                        }
                    } else {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                    }
                    streamTokenizer.nextToken();
                }
                if (n16 == 0 || n17 == 0) continue;
                pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(33);
                pgJvxSrc.setDimOfVertices(n);
                pgJvxSrc.setNumVertices(vector2.size());
                n5 = 0;
                PiVector[] piVectorArray = vector2.elements();
                while (piVectorArray.hasMoreElements()) {
                    pgJvxSrc.setVertex(n5++, (PdVector)piVectorArray.nextElement());
                }
                vector2.removeAllElements();
                pgJvxSrc.setDimOfElements(4);
                pgJvxSrc.setNumElements((n16 - 1) * (n17 - 1));
                pgJvxSrc.assureNeighbours();
                n5 = 0;
                piVectorArray = pgJvxSrc.getNeighbours();
                n2 = 0;
                while (n2 < n16 - 1) {
                    int n18 = 0;
                    while (n18 < n17 - 1) {
                        if (n2 < n16 - 2) {
                            piVectorArray[n5].m_data[0] = n5 + n17 - 1;
                        }
                        if (n18 < n17 - 2) {
                            piVectorArray[n5].m_data[1] = n5 + 1;
                        }
                        if (n2 > 0) {
                            piVectorArray[n5].m_data[2] = n5 - n17 + 1;
                        }
                        if (n18 > 0) {
                            piVectorArray[n5].m_data[3] = n5 - 1;
                        }
                        pgJvxSrc.getElement(n5++).set(n2 * n17 + n18, (n2 + 1) * n17 + n18, (n2 + 1) * n17 + n18 + 1, n2 * n17 + n18 + 1);
                        ++n18;
                    }
                    ++n2;
                }
                if (this.m_geomTitle.elementAt(this.m_numGeoms) == null) {
                    this.m_geomTitle.setElementAt("Mesh[" + this.m_numGeoms + "]", this.m_numGeoms);
                }
                this.addGeometry(pgJvxSrc);
                continue;
            }
            if ("ISOSURFACE".equalsIgnoreCase(streamTokenizer.sval)) {
                PsDebug.warning("JavaView can not parse ISOSURFACE plot yet, line = " + streamTokenizer.lineno());
                streamTokenizer.pushBack();
                string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                continue;
            }
            if ("ANIMATE".equalsIgnoreCase(streamTokenizer.sval)) {
                this.m_bIsAnimation = true;
                this.m_numGeomsPerStep = new Vector();
                continue;
            }
            if ("AXESLABELS".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_axesLabels = PgMapleLoader.parseAxesLabels(streamTokenizer);
                continue;
            }
            if ("AXESSTYLE".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_axesStyle = PgMapleLoader.parseString(streamTokenizer, "AXESSTYLE");
                continue;
            }
            if ("COLOR".equalsIgnoreCase(streamTokenizer.sval) || "COLOUR".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                Color[] colorArray2 = this.parseColor(streamTokenizer, -1);
                if (colorArray2 != null && colorArray2.length == 1) {
                    this.m_sceneColor = colorArray2[0];
                    continue;
                }
                if (colorArray2 != null) continue;
                continue;
            }
            if ("LIGHT".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                PgMapleLoader.parseLight(streamTokenizer, this.m_lightColor, this.m_lightPosition);
                continue;
            }
            if ("LIGHTMODEL".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_lightModel = PgMapleLoader.parseString(streamTokenizer, "LIGHTMODEL");
                continue;
            }
            if ("ORIENTATION".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_sceneOrientation = PgMapleLoader.parseOrientation(streamTokenizer);
                continue;
            }
            if ("PROJECTION".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_sceneProjection = this.parseProjection(streamTokenizer);
                continue;
            }
            if ("SCALING".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_sceneScaling = PgMapleLoader.parseString(streamTokenizer, "SCALING");
                continue;
            }
            if ("SHADING".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_sceneShading = PgMapleLoader.parseString(streamTokenizer, "SHADING");
                continue;
            }
            if ("STYLE".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_sceneStyle = PgMapleLoader.parseString(streamTokenizer, "STYLE");
                continue;
            }
            if ("THICKNESS".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                this.m_sceneThickness = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                continue;
            }
            if ("TITLE".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                this.m_sceneTitle = PgMapleLoader.parseString(streamTokenizer);
                streamTokenizer.nextToken();
                continue;
            }
            if ("TITLEFONT".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                this.m_sceneTitleFont = PgMapleLoader.parseString(streamTokenizer, "TITLEFONT");
                continue;
            }
            if ("TRANSPARENCY".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                this.m_transparency = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                continue;
            }
            if ("VIEW".equalsIgnoreCase(streamTokenizer.sval)) {
                streamTokenizer.pushBack();
                dArray = PgMapleLoader.parseView(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
        } while (n3 > 0);
        int n19 = vector.size();
        boolean bl = this.m_sceneShading != null;
        PdVector[] pdVectorArray = null;
        if (bl) {
            pdVectorArray = PdVector.realloc(null, 2, 3);
            pdVectorArray[0].setConstant(Double.MAX_VALUE);
            pdVectorArray[1].setConstant(Double.NEGATIVE_INFINITY);
            n2 = 0;
            int n20 = 0;
            while (n20 < n19) {
                pgJvxSrc = (PgJvxSrc)vector.elementAt(n20);
                if (pgJvxSrc != null && (object = pgJvxSrc.getAmbientBounds()) != null) {
                    pdVectorArray[0].min(object[0]);
                    pdVectorArray[1].max(object[1]);
                    ++n2;
                }
                ++n20;
            }
            if (n2 == 0) {
                bl = false;
            }
        }
        n2 = 0;
        while (n2 < n19) {
            pgJvxSrc = (PgJvxSrc)vector.elementAt(n2);
            if (pgJvxSrc != null) {
                String string3 = (String)this.m_geomTitle.elementAt(n2);
                if (string3 == null || !string3.startsWith("Mesh") && !string3.startsWith("Grid")) {
                    if (string3 != null) {
                        pgJvxSrc.showName(true);
                    } else {
                        string3 = this.m_sceneTitle != null && n19 == 1 ? this.m_sceneTitle : (pgJvxSrc.getType() == 33 ? "ElementSet[" + n2 + "]" : (pgJvxSrc.getType() == 32 ? "PolygonSet[" + n2 + "]" : (pgJvxSrc.getType() == 31 ? "Polygon[" + n2 + "]" : (pgJvxSrc.getType() == 30 ? "PointSet[" + n2 + "]" : "Geometry[" + n2 + "]"))));
                    }
                }
                pgJvxSrc.setName(string3);
                object = this.m_geomColor.elementAt(n2);
                colorArray = null;
                Color color = null;
                String string4 = null;
                if (object != null) {
                    if (object instanceof String) {
                        string4 = (String)object;
                    } else {
                        colorArray = (Color[])object;
                        if (colorArray.length == 1) {
                            color = colorArray[0];
                        }
                    }
                } else {
                    color = this.m_sceneColor;
                }
                if (string4 == null && bl && pgJvxSrc.getDimOfVertices() == 3) {
                    string4 = this.m_sceneShading;
                }
                if (colorArray != null && colorArray.length > 1) {
                    if (pgJvxSrc.getType() == 33) {
                        if (colorArray.length == pgJvxSrc.getNumVertices()) {
                            pgJvxSrc.setVertexColors(colorArray);
                            pgJvxSrc.showVertexColors(true);
                            pgJvxSrc.showElementFromVertexColors(true);
                            pgJvxSrc.showElementColors(true);
                        } else if (colorArray.length == pgJvxSrc.getNumElements()) {
                            pgJvxSrc.setElementColors(colorArray);
                            pgJvxSrc.showElementColors(true);
                        }
                    } else if (pgJvxSrc.getType() == 32) {
                        pgJvxSrc.setPolygonColors(colorArray);
                        pgJvxSrc.showPolygonColors(true);
                    } else if (pgJvxSrc.getType() == 31) {
                        pgJvxSrc.setPolygonColors(colorArray);
                        pgJvxSrc.showEdgeColors(true);
                    } else if (pgJvxSrc.getType() == 30) {
                        pgJvxSrc.setVertexColors(colorArray);
                        pgJvxSrc.showVertexColors(true);
                    }
                } else if (color != null) {
                    if (pgJvxSrc.getType() == 33) {
                        pgJvxSrc.setGlobalElementColor(color);
                    } else if (pgJvxSrc.getType() == 32) {
                        pgJvxSrc.setGlobalPolygonColor(color);
                    } else if (pgJvxSrc.getType() == 31) {
                        pgJvxSrc.setGlobalEdgeColor(color);
                    } else if (pgJvxSrc.getType() == 30) {
                        pgJvxSrc.setGlobalVertexColor(color);
                    }
                } else if (string4 != null) {
                    pgJvxSrc.showSmoothElementColors(true);
                    if (pgJvxSrc.getType() == 33) {
                        if (string4.equalsIgnoreCase("NONE")) {
                            pgJvxSrc.setGlobalElementColor(Color.white);
                            pgJvxSrc.showSmoothElementColors(false);
                        } else if (string4.equalsIgnoreCase("XYZ") || string4.equalsIgnoreCase("XYZSHADING")) {
                            PgMapleLoader.makeElementColorsFromXYZ(pgJvxSrc, 3, pdVectorArray);
                            pgJvxSrc.showElementColors(true);
                        } else if (string4.equalsIgnoreCase("XY") || string4.equalsIgnoreCase("XYSHADING")) {
                            PgMapleLoader.makeElementColorsFromXYZ(pgJvxSrc, 2, pdVectorArray);
                            pgJvxSrc.showElementColors(true);
                        } else if (string4.equalsIgnoreCase("Z") || string4.equalsIgnoreCase("ZSHADING")) {
                            PgMapleLoader.makeElementColorsFromZ(pgJvxSrc, Color.blue, Color.red, pdVectorArray);
                            pgJvxSrc.showElementColors(true);
                        } else if (string4.equalsIgnoreCase("ZHUE")) {
                            PgMapleLoader.makeElementColorsFromZHue(pgJvxSrc, pdVectorArray);
                            pgJvxSrc.showElementColors(true);
                        } else if (string4.equalsIgnoreCase("ZGREYSCALE") || string4.equalsIgnoreCase("ZGRAYSCALE")) {
                            PgMapleLoader.makeElementColorsFromZ(pgJvxSrc, Color.black, Color.white, pdVectorArray);
                            pgJvxSrc.showElementColors(true);
                        } else {
                            PsDebug.warning("Scene shading = " + string4 + " is not supported yet");
                        }
                    } else if (pgJvxSrc.getType() == 32) {
                        if (string4 == null || string4.equalsIgnoreCase("NONE")) {
                            pgJvxSrc.setGlobalPolygonColor(Color.black);
                            pgJvxSrc.showSmoothElementColors(false);
                        } else if (string4.equalsIgnoreCase("XYZ") || string4.equalsIgnoreCase("XYZSHADING")) {
                            PgMapleLoader.makePolygonColorsFromXYZ(pgJvxSrc, 3, pdVectorArray);
                            pgJvxSrc.showPolygonColors(true);
                            PgMapleLoader.makeVertexColorsFromXYZ(pgJvxSrc, 3, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("XY") || string4.equalsIgnoreCase("XYSHADING")) {
                            PgMapleLoader.makePolygonColorsFromXYZ(pgJvxSrc, 2, pdVectorArray);
                            pgJvxSrc.showPolygonColors(true);
                            PgMapleLoader.makeVertexColorsFromXYZ(pgJvxSrc, 2, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("Z") || string4.equalsIgnoreCase("ZSHADING")) {
                            PgMapleLoader.makePolygonColorsFromZ(pgJvxSrc, Color.blue, Color.red, pdVectorArray);
                            pgJvxSrc.showPolygonColors(true);
                            PgMapleLoader.makeVertexColorsFromZ(pgJvxSrc, Color.blue, Color.red, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("ZHUE")) {
                            PgMapleLoader.makePolygonColorsFromZHue(pgJvxSrc, pdVectorArray);
                            pgJvxSrc.showPolygonColors(true);
                            PgMapleLoader.makeVertexColorsFromZHue(pgJvxSrc, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("ZGREYSCALE") || string4.equalsIgnoreCase("ZGRAYSCALE")) {
                            PgMapleLoader.makePolygonColorsFromZ(pgJvxSrc, Color.black, Color.white, pdVectorArray);
                            pgJvxSrc.showPolygonColors(true);
                            PgMapleLoader.makeVertexColorsFromZ(pgJvxSrc, Color.blue, Color.red, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else {
                            PsDebug.warning("Scene shading = " + string4 + " is not supported yet");
                        }
                    } else if (pgJvxSrc.getType() == 31) {
                        PgMapleLoader.makeEdgeColorsFromXYZ(pgJvxSrc, 3, pdVectorArray);
                        pgJvxSrc.showEdgeColors(true);
                    } else if (pgJvxSrc.getType() == 30) {
                        if (string4 == null || string4.equalsIgnoreCase("NONE")) {
                            pgJvxSrc.showSmoothElementColors(false);
                        } else if (string4.equalsIgnoreCase("XYZ") || string4.equalsIgnoreCase("XYZSHADING")) {
                            PgMapleLoader.makeVertexColorsFromXYZ(pgJvxSrc, 3, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("XY") || string4.equalsIgnoreCase("XYSHADING")) {
                            PgMapleLoader.makeVertexColorsFromXYZ(pgJvxSrc, 2, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("Z") || string4.equalsIgnoreCase("ZSHADING")) {
                            PgMapleLoader.makeVertexColorsFromZ(pgJvxSrc, Color.blue, Color.red, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("ZHUE")) {
                            PgMapleLoader.makeVertexColorsFromZHue(pgJvxSrc, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else if (string4.equalsIgnoreCase("ZGREYSCALE") || string4.equalsIgnoreCase("ZGRAYSCALE")) {
                            PgMapleLoader.makeVertexColorsFromZ(pgJvxSrc, Color.black, Color.white, pdVectorArray);
                            pgJvxSrc.showElementFromVertexColors(true);
                        } else {
                            PsDebug.warning("Scene shading = " + string4 + " is not supported yet");
                        }
                    }
                }
                String string5 = (String)this.m_geomStyle.elementAt(n2);
                if (string5 == null) {
                    string5 = this.m_sceneStyle;
                }
                if (pgJvxSrc.getType() == 33) {
                    pgJvxSrc.showElements(true);
                    pgJvxSrc.showEdges(true);
                    pgJvxSrc.showVertices(false);
                    if (string5 == null || string5.equalsIgnoreCase("PATCH") || string5.equalsIgnoreCase("PATCHCONTOUR")) {
                        pgJvxSrc.showVertices(false);
                    } else if (string5 == null || string5.equalsIgnoreCase("HIDDEN")) {
                        pgJvxSrc.setGlobalElementColor(Color.white);
                        pgJvxSrc.showVertices(false);
                        if (color != null) {
                            pgJvxSrc.setGlobalEdgeColor(color);
                        }
                    } else if (string5.equalsIgnoreCase("PATCHNOGRID")) {
                        pgJvxSrc.showEdges(false);
                    } else if (string5.equalsIgnoreCase("LINE") || string5.equalsIgnoreCase("WIREFRAME") || string5.equalsIgnoreCase("CONTOUR")) {
                        pgJvxSrc.showElements(false);
                        if (color != null) {
                            pgJvxSrc.setGlobalEdgeColor(color);
                        }
                    } else if (string5.equalsIgnoreCase("POINT")) {
                        pgJvxSrc.showElements(false);
                        pgJvxSrc.showEdges(false);
                        pgJvxSrc.showVertices(true);
                        if (color != null) {
                            pgJvxSrc.setGlobalVertexColor(color);
                        }
                    }
                } else if (pgJvxSrc.getType() == 32) {
                    pgJvxSrc.showPolygons(true);
                    pgJvxSrc.showVertices(false);
                    if (string5 != null && !string5.equalsIgnoreCase("LINE") && string5.equalsIgnoreCase("POINT")) {
                        pgJvxSrc.showPolygons(false);
                        pgJvxSrc.showVertices(true);
                        if (color != null) {
                            pgJvxSrc.setGlobalVertexColor(color);
                        }
                    }
                } else if (pgJvxSrc.getType() == 31) {
                    pgJvxSrc.showPolygons(true);
                    pgJvxSrc.showVertices(false);
                    if (string5 != null && !string5.equalsIgnoreCase("LINE") && string5.equalsIgnoreCase("POINT")) {
                        pgJvxSrc.showPolygons(false);
                        pgJvxSrc.showVertices(true);
                        if (color != null) {
                            pgJvxSrc.setGlobalVertexColor(color);
                        }
                    }
                } else if (pgJvxSrc.getType() == 30) {
                    pgJvxSrc.showVertices(true);
                    if (string5 != null && !string5.equalsIgnoreCase("POINT")) {
                        pgJvxSrc.showVertices(false);
                    }
                }
                Double d = (Double)this.m_geomThickness.elementAt(n2);
                double d8 = this.m_sceneThickness;
                if (d != null) {
                    d8 = d;
                }
                if (d8 > 0.0) {
                    if (pgJvxSrc.getType() == 33) {
                        pgJvxSrc.setGlobalEdgeSize(d8);
                    } else if (pgJvxSrc.getType() == 32) {
                        pgJvxSrc.setGlobalPolygonSize(d8);
                    } else if (pgJvxSrc.getType() == 31) {
                        pgJvxSrc.setGlobalEdgeSize(d8);
                    } else if (pgJvxSrc.getType() == 30) {
                        pgJvxSrc.setGlobalVertexSize(d8);
                    }
                }
            }
            ++n2;
        }
        if (dArray != null) {
            this.m_sceneView = PdVector.realloc(null, 3, 2);
            n2 = 0;
            do {
                this.m_sceneView[n2].set(Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            } while (++n2 < 3);
            n2 = dArray.length;
            if (n2 == 1) {
                if (dArray[0] != null) {
                    this.m_sceneView[2].set((double)dArray[0][0], (double)dArray[0][1]);
                }
            } else {
                int n21 = 0;
                while (n21 < n2) {
                    if (dArray[n21] != null) {
                        this.m_sceneView[n21].set((double)dArray[n21][0], (double)dArray[n21][1]);
                    }
                    ++n21;
                }
            }
        }
        return vector;
    }
}

