/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PuData;

public final class PdColor
extends PsObject {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private static final int m_numDefColors = 3;
    protected boolean m_bHasAlpha;
    protected int m_alpha;
    protected int[] m_data;
    protected boolean m_enabled = true;

    public static int[] rgb2cmyk(int n, int n2, int n3) {
        int n4 = 255 - n;
        int n5 = 255 - n2;
        int n6 = 255 - n3;
        int n7 = Math.min(Math.min(n4, n5), n6);
        return new int[]{n4 - n7, n5 - n7, n6 - n7, n7};
    }

    public int getEntry(int n) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return 0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, int n2) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_data[n] = n2;
    }

    public void setEntry(int n, double d) {
        this.setEntry(n, (int)(255.0 * d + 0.5));
    }

    public int indexOfMax() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            if (this.m_data[n3] > n2) {
                n2 = this.m_data[n3];
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    public static Color getColorFromName(String string) {
        if (string == null || string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("darkGray") || string.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("gray") || string.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("lightGray") || string.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return Color.black;
    }

    public static void hsv2rgb(PdColor pdColor, PdColor pdColor2) {
        Color color = PdColor.hsv2rgb(pdColor2.m_data[0], pdColor2.m_data[1], pdColor2.m_data[2]);
        pdColor.setColor(color);
    }

    public static Color hsv2rgb(Color color) {
        return PdColor.hsv2rgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color hsv2rgb(int n, int n2, int n3) {
        return new Color(PdColor.hsv2rgbAsInt(n, n2, n3));
    }

    public static Color hsl2rgb(int n, int n2, int n3) {
        double d;
        double d2;
        double d3;
        double d4 = (double)n / 255.0 * 360.0;
        double d5 = (double)n2 / 255.0;
        double d6 = (double)n3 / 255.0;
        double d7 = d5 < 0.5 ? d5 * (1.0 + d6) : d5 + d6 - d5 * d6;
        double d8 = 2.0 * d5 - d7;
        if (d6 == 0.0) {
            d3 = d5;
            d2 = d5;
            d = d5;
        } else {
            d3 = PdColor.value(d8, d7, d4 + 120.0);
            d2 = PdColor.value(d8, d7, d4);
            d = PdColor.value(d8, d7, d4 - 120.0);
        }
        return new Color((int)(d3 * 255.0), (int)(d2 * 255.0), (int)(d * 255.0));
    }

    public boolean equals(Color color) {
        int n = this.m_data.length;
        if (color == null && n == 0) {
            return true;
        }
        if (color == null) {
            return false;
        }
        if (n < 3) {
            return false;
        }
        return this.getRed() == color.getRed() && this.getGreen() == color.getGreen() && this.getBlue() == color.getBlue();
    }

    public boolean equals(PdColor pdColor) {
        int n = this.m_data.length;
        if (pdColor == null && n == 0) {
            return true;
        }
        if (pdColor == null) {
            return false;
        }
        if (n != pdColor.getSize()) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != pdColor.m_data[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static PdColor copyNew(PdColor pdColor) {
        if (pdColor == null) {
            PsDebug.warning("missing argument color");
            return null;
        }
        PdColor pdColor2 = new PdColor(pdColor.getSize(), pdColor.m_bHasAlpha);
        pdColor2.copy(pdColor);
        return pdColor2;
    }

    public static PdColor[] copyNew(PdColor[] pdColorArray) {
        if (pdColorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdColor.copyNew(pdColorArray, pdColorArray.length);
    }

    public static int getDimmedColor(int[] nArray, int n) {
        int n2 = nArray[0];
        if (n <= 0) {
            return n2 << 24;
        }
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        if (n == 255) {
            return n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
        int n6 = n * n3 >> 8;
        int n7 = n * n4 >> 8;
        int n8 = n * n5 >> 8;
        if (n > 255) {
            if (n6 > 255) {
                n6 = 255;
            }
            if (n7 > 255) {
                n7 = 255;
            }
            if (n8 > 255) {
                n8 = 255;
            }
        }
        return n2 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    public static int getDimmedColor(int n, int n2) {
        if (n2 == 255) {
            return n;
        }
        int n3 = n & 0xFF000000;
        if (n2 <= 0) {
            return n3;
        }
        int n4 = n2 * (n >> 16 & 0xFF) >> 8;
        int n5 = n2 * (n >> 8 & 0xFF) >> 8;
        int n6 = n2 * (n & 0xFF) >> 8;
        if (n2 > 255) {
            if (n4 > 255) {
                n4 = 255;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n6 > 255) {
                n6 = 255;
            }
        }
        n = n3 | n4 << 16 | n5 << 8 | n6;
        return n;
    }

    public static int getDimmedColor(int n, double d) {
        if (d == 1.0) {
            return n;
        }
        int n2 = n & 0xFF000000;
        if (d <= 0.0) {
            return n2;
        }
        int n3 = (int)(d * (double)(n >> 16 & 0xFF));
        int n4 = (int)(d * (double)(n >> 8 & 0xFF));
        int n5 = (int)(d * (double)(n & 0xFF));
        if (d > 1.0) {
            if (n3 > 255) {
                n3 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            if (n5 > 255) {
                n5 = 255;
            }
        }
        n = n2 | n3 << 16 | n4 << 8 | n5;
        return n;
    }

    public static Color getDimmedColor(Color color, int n) {
        if (n == 255) {
            return color;
        }
        if (n <= 0) {
            return Color.black;
        }
        int n2 = color.getRGB();
        int n3 = n2 & 0xFF000000;
        int n4 = n * (n2 >> 16 & 0xFF) >> 8;
        int n5 = n * (n2 >> 8 & 0xFF) >> 8;
        int n6 = n * (n2 & 0xFF) >> 8;
        if ((double)n > 1.0) {
            if (n4 > 255) {
                n4 = 255;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n6 > 255) {
                n6 = 255;
            }
        }
        n2 = n3 | n4 << 16 | n5 << 8 | n6;
        return new Color(n2);
    }

    public static Color getDimmedColor(Color color, double d) {
        return PdColor.getDimmedColor(color, (int)(255.0 * d + 0.5));
    }

    public static Color getDimmedColor(Color color, double d, double d2) {
        int n = PdColor.getDimmedColor(color.getRGB(), d, d2);
        return new Color(n);
    }

    public static int getDimmedColor(int n, double d, double d2) {
        int n2 = (int)(d2 + d * (double)(n >> 16 & 0xFF));
        int n3 = (int)(d2 + d * (double)(n >> 8 & 0xFF));
        int n4 = (int)(d2 + d * (double)(n & 0xFF));
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        int n5 = n & 0xFF000000;
        n = n5 | n2 << 16 | n3 << 8 | n4;
        return n;
    }

    public static PdColor[] copyNew(PdColor[] pdColorArray, int n) {
        if (pdColorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdColor[] pdColorArray2 = new PdColor[n];
        int n2 = 0;
        while (n2 < n) {
            pdColorArray2[n2] = PdColor.copyNew(pdColorArray[n2]);
            ++n2;
        }
        return pdColorArray2;
    }

    public static Color[] copyNew(Color[] colorArray) {
        if (colorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdColor.copyNew(colorArray, colorArray.length);
    }

    public int getSize() {
        return this.m_data.length;
    }

    public void setSize(int n) {
        if (this.m_data == null || this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
    }

    public void blendBase(PdColor pdColor, double d, PdColor pdColor2) {
        this.blend(1.0, pdColor, d, pdColor2);
    }

    public static Color[] copyNew(Color[] colorArray, int n) {
        if (colorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Color[] colorArray2 = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            colorArray2[n2] = colorArray[n2];
            ++n2;
        }
        return colorArray2;
    }

    public Object clone() {
        PdColor pdColor = (PdColor)super.clone();
        if (pdColor == null) {
            return null;
        }
        pdColor.m_data = (int[])this.m_data.clone();
        return pdColor;
    }

    public boolean hasAlpha() {
        return this.m_bHasAlpha;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public static int hsv2rgbAsInt(int n, int n2, int n3) {
        int n4 = -16777216;
        if (n2 == 0) {
            return n4 | n3 << 16 | n3 << 8 | n3;
        }
        float f = (float)((double)n * 6.0 / 256.0);
        int n5 = (int)f;
        float f2 = (float)((double)(n3 * n2) / 255.0);
        int n6 = (int)((float)n3 - f2);
        int n7 = (int)((float)n3 - (f -= (float)n5) * f2);
        int n8 = (int)((double)n3 - (1.0 - (double)f) * (double)f2);
        switch (n5) {
            case 0: {
                return n4 | n3 << 16 | n8 << 8 | n6;
            }
            case 1: {
                return n4 | n7 << 16 | n3 << 8 | n6;
            }
            case 2: {
                return n4 | n6 << 16 | n3 << 8 | n8;
            }
            case 3: {
                return n4 | n6 << 16 | n7 << 8 | n3;
            }
            case 4: {
                return n4 | n8 << 16 | n6 << 8 | n3;
            }
            case 5: {
                return n4 | n3 << 16 | n6 << 8 | n7;
            }
        }
        return n4;
    }

    public int max() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] > n) {
                n = this.m_data[n2];
            }
            ++n2;
        }
        return n;
    }

    public void copy(PdColor pdColor) {
        if (pdColor == null) {
            PsDebug.warning("missing argument color");
            return;
        }
        int n = pdColor.getSize();
        if (this.m_data.length != n) {
            PsDebug.warning("argument color has different size");
            return;
        }
        this.m_bHasAlpha = pdColor.m_bHasAlpha;
        System.arraycopy(pdColor.m_data, 0, this.m_data, 0, n);
        super.copy(pdColor);
    }

    public static int getMax(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n2;
        if (n3 > n5) {
            n5 = n3;
        }
        if (n4 > n5) {
            n5 = n4;
        }
        return n5;
    }

    public void copy(int[] nArray, int n) {
        if (nArray == null) {
            PsDebug.warning("missing argument array");
            return;
        }
        if (this.m_data.length != n) {
            PsDebug.warning("missing space in destination");
            return;
        }
        System.arraycopy(this.m_data, 0, nArray, 0, n);
    }

    public void copy(double[] dArray, int n) {
        if (dArray == null) {
            PsDebug.warning("missing argument array");
            return;
        }
        if (this.m_data.length != n) {
            PsDebug.warning("missing space in destination");
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.m_data[n2] = (int)(255.0 * dArray[n2]);
            ++n2;
        }
    }

    public static boolean copy(Color[] colorArray, int n, Color[] colorArray2, int n2, int n3) {
        if (colorArray == null || colorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        if (colorArray2 == null || colorArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", colorArray2);
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            colorArray[n + n4] = colorArray2[n2 + n4];
            ++n4;
        }
        return true;
    }

    public static boolean copy(PdColor[] pdColorArray, int n, PdColor[] pdColorArray2, int n2, int n3) {
        if (pdColorArray == null || pdColorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        if (pdColorArray2 == null || pdColorArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", pdColorArray2);
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            pdColorArray[n + n4].copy(pdColorArray2[n2 + n4]);
            ++n4;
        }
        return true;
    }

    public static Color brighter(Color color) {
        int n = color.getRGB();
        int n2 = 127 + ((n >> 16 & 0xFF) >> 1);
        int n3 = 127 + ((n >> 8 & 0xFF) >> 1);
        int n4 = 127 + ((n & 0xFF) >> 1);
        return new Color(n2, n3, n4);
    }

    public static Color yiq2rgb(int n, int n2, int n3) {
        double d = (double)n / 255.0;
        double d2 = ((double)n2 / 255.0 * 2.0 - 1.0) * 0.596;
        double d3 = ((double)n3 / 255.0 * 2.0 - 1.0) * 0.522;
        double d4 = Math.min(1.0, Math.max(0.0, d + 0.956 * d2 + 0.623 * d3));
        double d5 = Math.min(1.0, Math.max(0.0, d - 0.272 * d2 - 0.648 * d3));
        double d6 = Math.min(1.0, Math.max(0.0, d - 1.105 * d2 + 0.705 * d3));
        return new Color((int)(d4 * 255.0), (int)(d5 * 255.0), (int)(d6 * 255.0));
    }

    public void init() {
        super.init();
        this.setConstant(0);
    }

    public int getGreen() {
        if (this.m_data.length < 2) {
            return 0;
        }
        return this.m_data[1];
    }

    public void setConstant(int n) {
        int n2 = 0;
        while (n2 < this.m_data.length) {
            this.m_data[n2] = n;
            ++n2;
        }
    }

    public int indexOfMin() {
        int n = 0;
        int n2 = 255;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            if (this.m_data[n3] < n2) {
                n2 = this.m_data[n3];
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    public static Color parseColor(String string) {
        if (string == null) {
            PsDebug.warning("missing color string.");
            return null;
        }
        try {
            boolean bl;
            if (string.indexOf("#") == 0) {
                if (string.length() != 7) {
                    PsDebug.warning("wrong format in color = " + string);
                    return null;
                }
                char[] cArray = string.toLowerCase().toCharArray();
                int n = PdColor.parseHex2(cArray[1], cArray[2]);
                int n2 = PdColor.parseHex2(cArray[3], cArray[4]);
                int n3 = PdColor.parseHex2(cArray[5], cArray[6]);
                if (n == -1 || n2 == -1 || n3 == -1) {
                    PsDebug.warning("wrong format in color = " + string);
                    return null;
                }
                return new Color(n, n2, n3);
            }
            char c = ' ';
            if (string.indexOf(",") != -1) {
                c = ',';
            } else if (string.indexOf(";") != -1) {
                c = ';';
            }
            boolean bl2 = bl = string.indexOf(".") == -1;
            if (bl) {
                String[] stringArray = PuString.splitString(string, c);
                int n = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                int n5 = Integer.parseInt(stringArray[2]);
                return new Color(n, n4, n5);
            }
            String[] stringArray = PuString.splitString(string, c);
            float f = Float.valueOf(stringArray[0]).floatValue();
            float f2 = Float.valueOf(stringArray[1]).floatValue();
            float f3 = Float.valueOf(stringArray[2]).floatValue();
            return new Color(f, f2, f3);
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong number format in color = " + string);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PsDebug.warning("wrong value in color = " + string);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            PsDebug.warning("wrong number of components in color = " + string);
            return null;
        }
    }

    public static Color getXORColor(Color color, Color color2, Color color3, int n) {
        if (color == null) {
            return color2;
        }
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        int n4 = Math.abs(n2 >> 16 & 255 - (n3 >> 16) & 0xFF);
        int n5 = Math.abs(n2 >> 8 & 255 - (n3 >> 8) & 0xFF);
        int n6 = Math.abs(n2 & 255 - n3 & 0xFF);
        int n7 = Math.max(Math.max(n4, n5), n6);
        if (n4 + n5 + n6 < n || 2 * n7 < n) {
            return color3;
        }
        return color2;
    }

    public static Color[] realloc(Color[] colorArray, int n) {
        if (colorArray != null && colorArray.length == n) {
            return colorArray;
        }
        Color[] colorArray2 = new Color[n];
        int n2 = 0;
        if (colorArray != null && (n2 = Math.min(colorArray.length, n)) != 0) {
            System.arraycopy(colorArray, 0, colorArray2, 0, n2);
        }
        int n3 = n2;
        while (n3 < n) {
            colorArray2[n3] = Color.black;
            ++n3;
        }
        return colorArray2;
    }

    public static PdColor[] realloc(PdColor[] pdColorArray, int n, int n2) {
        return PdColor.realloc(pdColorArray, n, n2, false);
    }

    public static PdColor[] realloc(PdColor[] pdColorArray, int n, int n2, boolean bl) {
        int n3;
        if (pdColorArray != null && pdColorArray.length == n) {
            int n4 = 0;
            while (n4 < pdColorArray.length) {
                pdColorArray[n4].enableAlpha(bl);
                pdColorArray[n4].setSize(n2);
                ++n4;
            }
            return pdColorArray;
        }
        PdColor[] pdColorArray2 = new PdColor[n];
        if (pdColorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pdColorArray.length, n);
            System.arraycopy(pdColorArray, 0, pdColorArray2, 0, n3);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (pdColorArray2[n5].m_bHasAlpha != bl) {
                pdColorArray2[n5].enableAlpha(bl);
            }
            if (pdColorArray2[n5].getSize() != n2) {
                pdColorArray2[n5].setSize(n2);
            }
            ++n5;
        }
        n5 = n3;
        while (n5 < n) {
            pdColorArray2[n5] = new PdColor(n2, bl);
            ++n5;
        }
        return pdColorArray2;
    }

    private static int parseHex2(char c, char c2) {
        int n = PdColor.convertFromHex(c);
        int n2 = PdColor.convertFromHex(c2);
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return n * 16 + n2;
    }

    public static Color rgb2hsl(int n, int n2, int n3) {
        double d;
        double d2;
        double d3 = (double)n / 255.0;
        double d4 = (double)n2 / 255.0;
        double d5 = (double)n3 / 255.0;
        double d6 = Math.min(Math.min(d3, d4), d5);
        double d7 = Math.max(Math.max(d3, d4), d5);
        double d8 = (d7 + d6) / 2.0;
        if (d7 == d6) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = d8 <= 0.5 ? (d7 - d6) / (d7 + d6) : (d7 - d6) / (2.0 - d7 - d6);
            double d9 = d7 - d6;
            d = d3 == d7 ? (d4 - d5) / d9 : (d4 == d7 ? 2.0 + (d5 - d3) / d9 : 4.0 + (d3 - d4) / d9);
            if ((d /= 6.0) < 0.0) {
                d += 1.0;
            }
        }
        return new Color((int)(d * 255.0), (int)(d8 * 255.0), (int)(d2 * 255.0));
    }

    public int getRed() {
        if (this.m_data.length < 1) {
            return 0;
        }
        return this.m_data[0];
    }

    private static double value(double d, double d2, double d3) {
        if (d3 < 0.0) {
            d3 += 360.0;
        }
        if (d3 > 360.0) {
            d3 -= 360.0;
        }
        if (d3 < 60.0) {
            return d + (d2 - d) * d3 / 60.0;
        }
        if (d3 < 180.0) {
            return d2;
        }
        if (d3 < 240.0) {
            return d + (d2 - d) * (240.0 - d3) / 60.0;
        }
        return d;
    }

    public int getBlue() {
        if (this.m_data.length < 3) {
            return 0;
        }
        return this.m_data[2];
    }

    public int getGrey() {
        if (this.m_data.length != 1) {
            return 0;
        }
        return this.m_data[0];
    }

    public int min() {
        int n = 255;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] < n) {
                n = this.m_data[n2];
            }
            ++n2;
        }
        return n;
    }

    private static int convertFromHex(char c) {
        int n = -1;
        switch (c) {
            case 'f': {
                n = 15;
                break;
            }
            case 'e': {
                n = 14;
                break;
            }
            case 'd': {
                n = 13;
                break;
            }
            case 'c': {
                n = 12;
                break;
            }
            case 'b': {
                n = 11;
                break;
            }
            case 'a': {
                n = 10;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '0': {
                n = 0;
            }
        }
        return n;
    }

    public static Color cmyk2rgb(int n, int n2, int n3, int n4) {
        int n5 = 255 - (n + n4);
        int n6 = 255 - (n2 + n4);
        int n7 = 255 - (n3 + n4);
        return new Color(n5, n7, n6);
    }

    public static int getMin(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n2;
        if (n3 < n5) {
            n5 = n3;
        }
        if (n4 < n5) {
            n5 = n4;
        }
        return n5;
    }

    public void set(int n) {
        if (this.m_data.length < 1) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return;
        }
        this.m_data[0] = n;
    }

    public void set(int n, int n2, int n3) {
        if (this.m_data.length < 3) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return;
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3);
        this.setAlpha(n4);
    }

    public void set(double d) {
        this.set((int)(255.0 * d + 0.5));
    }

    public PdColor() {
        this(3, false);
    }

    public PdColor(int n, boolean bl) {
        this.enableAlpha(bl);
        this.setSize(n);
        this.init();
    }

    public PdColor(String string, PsUpdateIf psUpdateIf) {
        this.setName(string);
        if (psUpdateIf != null) {
            this.setParent(psUpdateIf);
        }
        this.enableAlpha(false);
        this.setSize(3);
        this.init();
    }

    public Color getColor() {
        if (this.m_data.length < 3) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return null;
        }
        return new Color(this.m_data[0], this.m_data[1], this.m_data[2]);
    }

    public void setColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing aColor");
            return;
        }
        int n = color.getRGB();
        this.set(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        this.updatePanels(this);
    }

    public void set(double d, double d2, double d3) {
        this.set((int)(255.0 * d + 0.5), (int)(255.0 * d2 + 0.5), (int)(255.0 * d3 + 0.5));
    }

    public void set(double d, double d2, double d3, double d4) {
        this.set((int)(255.0 * d + 0.5), (int)(255.0 * d2 + 0.5), (int)(255.0 * d3 + 0.5));
        this.setAlpha((int)(255.0 * d4 + 0.5));
    }

    public static Color blend(double d, Color color, double d2, Color color2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        int n = color.getRGB();
        int n2 = color2.getRGB();
        int n3 = (int)(d * (double)(n >> 16 & 0xFF) + d2 * (double)(n2 >> 16 & 0xFF));
        int n4 = (int)(d * (double)(n >> 8 & 0xFF) + d2 * (double)(n2 >> 8 & 0xFF));
        int n5 = (int)(d * (double)(n & 0xFF) + d2 * (double)(n2 & 0xFF));
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return new Color(n3, n4, n5);
    }

    public void blend(double d, PdColor pdColor, double d2, PdColor pdColor2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = (int)((double)pdColor.m_data[n] * d + (double)pdColor2.m_data[n] * d2);
            this.m_data[n] = n2 <= 0 ? 0 : (n2 >= 255 ? 255 : n2);
            ++n;
        }
    }

    public static void rgb2hsv(PdColor pdColor, PdColor pdColor2) {
        int n = pdColor2.max();
        int n2 = pdColor2.min();
        pdColor.m_data[2] = n;
        pdColor.m_data[1] = n == 0 ? 0 : (int)((double)(n - n2) * 255.0 / (double)n + 0.5);
        if (pdColor.m_data[1] == 0) {
            pdColor.m_data[0] = 0;
            return;
        }
        double d = 0.0;
        double d2 = n - n2;
        d = pdColor2.m_data[0] == n ? (double)(pdColor2.m_data[1] - pdColor2.m_data[2]) / d2 : (pdColor2.m_data[1] == n ? 2.0 + (double)(pdColor2.m_data[2] - pdColor2.m_data[0]) / d2 : 4.0 + (double)(pdColor2.m_data[0] - pdColor2.m_data[1]) / d2);
        if ((d *= 60.0) < 0.0) {
            d += 360.0;
        }
        pdColor.m_data[0] = (int)d;
    }

    public int getAlpha() {
        if (!this.m_bHasAlpha) {
            return 0;
        }
        return this.m_alpha;
    }

    public void enableAlpha(boolean bl) {
        this.m_bHasAlpha = bl;
    }

    public void setAlpha(int n) {
        this.m_alpha = n;
    }

    public void setAlpha(double d) {
        this.setAlpha((int)(255.0 * d + 0.5));
    }

    public void setEnabled(boolean bl) {
        if (this.m_enabled == bl) {
            return;
        }
        this.m_enabled = bl;
        this.updatePanels(this);
    }

    public static Color rgb2yiq(int n, int n2, int n3) {
        double d = (double)n / 255.0;
        double d2 = (double)n2 / 255.0;
        double d3 = (double)n3 / 255.0;
        double d4 = 0.299 * d + 0.587 * d2 + 0.114 * d3;
        double d5 = 0.596 * d - 0.274 * d2 - 0.322 * d3;
        double d6 = 0.211 * d - 0.522 * d2 + 0.311 * d3;
        d5 = (d5 / 0.596 + 1.0) / 2.0;
        d6 = (d6 / 0.522 + 1.0) / 2.0;
        return new Color((int)(d4 * 255.0), (int)(d5 * 255.0), (int)(d6 * 255.0));
    }
}

