/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public final class PuInteger
extends PsObject {
    protected Color m_backgroundColor;
    protected Color m_backgroundColorDef;
    private int m_defValue = 0;
    private int m_defMinimum = -10;
    private int m_defMaximum = 10;
    private int m_defLineIncr = 1;
    private int m_defPageIncr = 10;
    protected int m_value = this.m_defValue;
    protected int m_minimum;
    protected int m_maximum;
    protected int m_lineIncr;
    protected int m_pageIncr;
    protected boolean m_enabled = true;
    protected boolean m_bEnabledConfigButton = true;

    public boolean isEnabledConfigButton() {
        return this.m_bEnabledConfigButton;
    }

    public void setValue(int n) {
        this.enlargeBounds(n);
        this.setValueFromPanel(n, this);
    }

    public int getValue() {
        return this.m_value;
    }

    public int getMin() {
        return this.m_minimum;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public Color getBackground() {
        return this.m_backgroundColor;
    }

    public PuInteger(String string) {
        this(string, null);
    }

    public PuInteger(String string, PsUpdateIf psUpdateIf) {
        this.setTag(4);
        this.setTag(7);
        this.setParent(psUpdateIf);
        this.setName(string);
        this.init();
    }

    public int getDefPageIncr() {
        return this.m_defPageIncr;
    }

    public void blend(double d, PuInteger puInteger, double d2, PuInteger puInteger2) {
        this.m_defValue = (int)(d * (double)puInteger.m_defValue + d2 * (double)puInteger2.m_defValue + 0.5);
        this.m_defMinimum = (int)(d * (double)puInteger.m_defMinimum + d2 * (double)puInteger2.m_defMinimum + 0.5);
        this.m_defMaximum = (int)(d * (double)puInteger.m_defMaximum + d2 * (double)puInteger2.m_defMaximum + 0.5);
        this.m_defLineIncr = (int)(d * (double)puInteger.m_defLineIncr + d2 * (double)puInteger2.m_defLineIncr + 0.5);
        this.m_defPageIncr = (int)(d * (double)puInteger.m_defPageIncr + d2 * (double)puInteger2.m_defPageIncr + 0.5);
        this.m_value = (int)(d * (double)puInteger.m_value + d2 * (double)puInteger2.m_value + 0.5);
        this.m_minimum = (int)(d * (double)puInteger.m_minimum + d2 * (double)puInteger2.m_minimum + 0.5);
        this.m_maximum = (int)(d * (double)puInteger.m_maximum + d2 * (double)puInteger2.m_maximum + 0.5);
        this.m_lineIncr = (int)(d * (double)puInteger.m_lineIncr + d2 * (double)puInteger2.m_lineIncr + 0.5);
        this.m_pageIncr = (int)(d * (double)puInteger.m_pageIncr + d2 * (double)puInteger2.m_pageIncr + 0.5);
        this.updatePanels(this);
    }

    public void setBackground(Color color) {
        this.m_backgroundColorDef = color;
        this.m_backgroundColor = color;
    }

    public void setDefBounds(int n, int n2, int n3, int n4) {
        if (n2 < n) {
            int n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n3 > n2 - n) {
            n3 = Math.max((int)((double)(n2 - n) / 100.0), 1);
        }
        if (n4 > n2 - n) {
            n4 = Math.max((int)((double)(n2 - n) / 10.0), 1);
        }
        this.m_defMinimum = n;
        this.m_defMaximum = n2;
        this.m_defLineIncr = n3;
        this.m_defPageIncr = n4;
        if (this.m_defValue < this.m_defMinimum) {
            this.m_defValue = this.m_defMinimum;
        }
        if (this.m_defValue > this.m_defMaximum) {
            this.m_defValue = this.m_defMaximum;
        }
    }

    public int enforceBounds(int n) {
        if (n < this.m_minimum) {
            n = this.m_minimum;
        }
        if (this.m_maximum < n) {
            n = this.m_maximum;
        }
        return n;
    }

    public int getDefValue() {
        return this.m_defValue;
    }

    public void setDefValue(int n) {
        if (this.m_defMinimum > n) {
            this.m_defMinimum = n;
        }
        if (this.m_defMaximum < n) {
            this.m_defMaximum = n;
        }
        this.m_defValue = n;
    }

    protected void setValueFromPanel(int n, Object object) {
        if (n < this.m_minimum) {
            n = this.m_minimum;
        } else if (this.m_maximum < n) {
            n = this.m_maximum;
        }
        if (this.m_value == n) {
            return;
        }
        this.m_value = n;
        this.updatePanels(object);
    }

    public int getDefMinimum() {
        return this.m_defMinimum;
    }

    public int getLineIncr() {
        return this.m_lineIncr;
    }

    public void copy(PuInteger puInteger) {
        super.copy(puInteger);
        this.m_defValue = puInteger.m_defValue;
        this.m_defMinimum = puInteger.m_defMinimum;
        this.m_defMaximum = puInteger.m_defMaximum;
        this.m_defLineIncr = puInteger.m_defLineIncr;
        this.m_defPageIncr = puInteger.m_defPageIncr;
        this.m_value = puInteger.m_value;
        this.m_minimum = puInteger.m_minimum;
        this.m_maximum = puInteger.m_maximum;
        this.m_lineIncr = puInteger.m_lineIncr;
        this.m_pageIncr = puInteger.m_pageIncr;
    }

    public int getMax() {
        return this.m_maximum;
    }

    public int getPageIncr() {
        return this.m_pageIncr;
    }

    public void initWithDefaults(int n, int n2, int n3, int n4, int n5) {
        this.setDefBounds(n, n2, n3, n4);
        this.setDefValue(n5);
        this.init();
    }

    private void enlargeBounds(int n) {
        if (this.m_minimum > n) {
            this.m_minimum = n;
        }
        if (this.m_maximum < n) {
            this.m_maximum = n;
        }
    }

    public void init() {
        super.init();
        this.setBounds(this.m_defMinimum, this.m_defMaximum, this.m_defLineIncr, this.m_defPageIncr);
        this.setValue(this.m_defValue);
        this.updatePanels(this);
    }

    protected void incrValue(int n) {
        this.m_value += n * this.m_lineIncr;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n2 < n) {
            int n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n3 > n2 - n) {
            n3 = Math.max((int)((double)(n2 - n) / 100.0), 1);
        }
        if (n4 > n2 - n) {
            n4 = Math.max((int)((double)(n2 - n) / 10.0), 1);
        }
        this.m_minimum = n;
        this.m_maximum = n2;
        this.m_lineIncr = n3;
        this.m_pageIncr = n4;
        this.setValue(this.enforceBounds(this.m_value));
    }

    public int getDefMaximum() {
        return this.m_defMaximum;
    }

    public void setBounds(int n, int n2) {
        this.setBounds(n, n2, this.m_defLineIncr, this.m_defPageIncr);
    }

    public void setEnabled(boolean bl) {
        if (this.m_enabled == bl) {
            return;
        }
        this.m_enabled = bl;
        this.updatePanels(this);
    }

    public int getDefLineIncr() {
        return this.m_defLineIncr;
    }

    public void setEnabledConfigButton(boolean bl) {
        this.m_bEnabledConfigButton = bl;
        this.updatePanels(this);
    }
}

