/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.Serializable;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;

public class PsPanel
extends Panel
implements PsUpdateIf,
Serializable {
    public static final String INFO_EXT = "_IP";
    public static final String INFO = "Info";
    public static final String CONFIG_EXT = "_CP";
    public static final String CONFIG = "Config";
    public static final String LABEL_EXT = "_LP";
    public static final String LABEL = "Label";
    public static final String MATERIAL_EXT = "_MP";
    public static final String MATERIAL = "Material";
    public static final String TEXTURE_EXT = "_TP";
    public static final String TEXTURE = "Texture";
    public static final String VECTOR_EXT = "_VP";
    public static final String VECTOR = "Vector";
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public static final int BORDER_SUNK = 2;
    public static final int BORDER_GROOVE = 3;
    protected int m_borderType = 0;
    protected int m_insetSizeHor = 0;
    protected int m_insetSizeVer = 0;
    protected int m_insetSizeVerExtra = 0;
    private static int m_numPanels = 0;
    protected Label m_lTitle;
    protected String m_language;
    protected PsUpdateIf m_parent;
    protected Image m_image;
    protected boolean m_bOutOfDate = false;
    protected Dimension m_preferredSize;
    protected Color m_backColor;

    public static boolean setText(Label label, String string) {
        if (label == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if (label.getText().equals(string)) {
            return false;
        }
        label.setText(string);
        return true;
    }

    private static void drawLineRect(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y);
    }

    public void drawText(Graphics graphics, Point point, String string) {
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        graphics.drawString(string, point.x, point.y);
    }

    public Insets getInsets() {
        return new Insets(this.m_insetSizeVer + this.m_insetSizeVerExtra, this.m_insetSizeHor, this.m_insetSizeVer, this.m_insetSizeHor);
    }

    public void setBorderType(int n) {
        this.m_borderType = n;
    }

    public static boolean setState(Checkbox checkbox, boolean bl) {
        if (checkbox == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (checkbox.getState() == bl) {
            return false;
        }
        checkbox.setState(bl);
        return true;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public static void drawBorder(Graphics graphics, int n, Rectangle rectangle) {
        switch (n) {
            case 1: {
                PsPanel.drawLineRect(graphics, rectangle, Color.black);
                return;
            }
            case 2: {
                PsPanel.drawSunkRect(graphics, rectangle, Color.black);
                return;
            }
            case 3: {
                PsPanel.drawGrooveRect(graphics, rectangle, Color.darkGray);
                return;
            }
        }
    }

    public static void drawBorder(Graphics graphics, int n, Rectangle rectangle, Color color) {
        switch (n) {
            case 1: {
                PsPanel.drawLineRect(graphics, rectangle, color);
                return;
            }
            case 2: {
                PsPanel.drawSunkRect(graphics, rectangle, color);
                return;
            }
            case 3: {
                PsPanel.drawGrooveRect(graphics, rectangle, color);
                return;
            }
        }
    }

    public static boolean select(Choice choice, int n) {
        if (choice == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (choice.getSelectedIndex() == n) {
            return false;
        }
        choice.select(n);
        return true;
    }

    public void drawBorder(Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle(this.getSize());
        PsPanel.drawBorder(graphics, n, rectangle);
    }

    public static void drawBorder(Component component, Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle(component.getSize());
        PsPanel.drawBorder(graphics, n, rectangle);
    }

    public boolean update(Object object) {
        if (object == this.m_parent) {
            return true;
        }
        if (object != this && object != null) {
            return false;
        }
        if (this.m_parent != null) {
            return this.m_parent.update(this);
        }
        return true;
    }

    public void addLine(int n) {
        this.add(new PsLine(n));
    }

    public void setBackColor(Color color) {
        this.m_backColor = color;
        this.setBackground(color);
    }

    public Panel addLabelComponent(String string, Component component) {
        Panel panel = new Panel(new GridLayout(1, 2));
        panel.add(new Label(string));
        panel.add(component);
        this.add(panel);
        return panel;
    }

    public void update(Graphics graphics) {
        if (this.m_image != null) {
            this.paint(graphics);
            return;
        }
        super.update(graphics);
    }

    public Label getTitle() {
        return this.m_lTitle;
    }

    public void setTitle(String string) {
        if (this.m_lTitle == null) {
            this.m_lTitle = new Label();
        }
        PsPanel.setText(this.m_lTitle, string);
        this.m_lTitle.validate();
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setLayout(null);
        }
        this.m_image = image;
    }

    public void setInsetSizeVertical(int n) {
        this.m_insetSizeVer = n;
    }

    protected static int getNumPanels() {
        return m_numPanels;
    }

    public boolean hasTitle() {
        return this.m_lTitle != null;
    }

    public void removeTitle() {
        if (!this.hasTitle()) {
            return;
        }
        this.remove(this.m_lTitle);
        this.m_lTitle = null;
    }

    private static void drawSunkRect(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color.brighter());
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public PsPanel() {
        this(new PsStackLayout(1));
    }

    public PsPanel(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
        ++m_numPanels;
        this.m_language = PsConfig.getLanguage();
        if (this.instanceOf("PsPanel")) {
            this.init();
        }
    }

    public void paint(Graphics graphics) {
        if (this.m_bOutOfDate && this.m_parent != null) {
            this.update(this.m_parent);
            this.m_bOutOfDate = false;
        }
        if (this.m_image == null) {
            super.paint(graphics);
        } else if (this.m_image != null) {
            Dimension dimension = super.getSize();
            graphics.drawImage(this.m_image, 0, 0, dimension.width, dimension.height, this);
            super.paint(graphics);
        }
        if (this.m_borderType != 0) {
            this.drawBorder(graphics, this.m_borderType);
        }
    }

    public void setVisible(boolean bl) {
        if (bl && this.m_parent != null) {
            this.update(this.m_parent);
        }
        super.setVisible(bl);
    }

    public Label addSubTitle(String string) {
        Label label = new Label(string, 0);
        label.setFont(PsConfig.getFont(3));
        this.add(label);
        return label;
    }

    public TextField addTextField(String string, int n) {
        Panel panel = new Panel(new GridLayout(1, 2));
        panel.add(new Label(string));
        TextField textField = new TextField(n);
        panel.add(textField);
        this.add(panel);
        return textField;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public Dimension getPreferredSize() {
        if (this.m_preferredSize == null) {
            return super.getPreferredSize();
        }
        return this.m_preferredSize;
    }

    public void setPreferredSize(int n, int n2) {
        this.m_preferredSize = new Dimension(n, n2);
    }

    public void setInsetSize(int n) {
        this.m_insetSizeHor = n;
        this.m_insetSizeVer = n;
    }

    public final boolean instanceOf(String string) {
        String string2 = this.getClass().getName();
        return string2.endsWith(string);
    }

    private static void drawGrooveRect(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public void init() {
    }

    public static boolean setEnabled(Component component, boolean bl) {
        if (component == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (component.isEnabled() == bl) {
            return false;
        }
        component.setEnabled(bl);
        return true;
    }

    public static boolean setSelectedCheckbox(CheckboxGroup checkboxGroup, Checkbox checkbox) {
        if (checkboxGroup == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (checkboxGroup.getSelectedCheckbox() == checkbox) {
            return false;
        }
        checkboxGroup.setSelectedCheckbox(checkbox);
        return true;
    }

    public void setOutOfDate(boolean bl) {
        this.m_bOutOfDate = bl;
    }

    public void setInsetSizeHorizontal(int n) {
        this.m_insetSizeHor = n;
    }

    public static boolean setLabel(Button button, String string) {
        if (button == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if (button.getLabel().equals(string)) {
            return false;
        }
        button.setLabel(string);
        return true;
    }

    public static boolean setLabel(Checkbox checkbox, String string) {
        if (checkbox == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if (checkbox.getLabel().equals(string)) {
            return false;
        }
        checkbox.setLabel(string);
        return true;
    }

    public static boolean setText(TextComponent textComponent, String string) {
        String string2;
        if (textComponent == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if ((string2 = textComponent.getText()) != null && string.equals(string2)) {
            if (textComponent.getPeer() != null) {
                textComponent.setCaretPosition(0);
            }
            return false;
        }
        textComponent.setText(string);
        return true;
    }

    public Label addTitle(String string) {
        this.m_lTitle = new Label(string, 0);
        this.m_lTitle.setFont(PsConfig.getFont(3));
        this.add(this.m_lTitle);
        return this.m_lTitle;
    }

    class PsLine
    extends Canvas {
        private int m_size;
        private Dimension m_dim;

        public PsLine(int n) {
            PsPanel.this.getClass();
            this.m_size = 1;
            this.m_size = n;
            this.m_dim = new Dimension(10, 10);
            this.setSize(this.m_dim);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            Dimension dimension = this.getSize();
            int n = 0;
            int n2 = 0;
            int n3 = n + dimension.width;
            int n4 = n2 + dimension.height;
            int n5 = (n2 + n4 - this.m_size) / 2;
            graphics.setColor(new Color(Math.max(color.getRed() - 64, 0), Math.max(color.getGreen() - 64, 0), Math.max(color.getBlue() - 64, 0)));
            graphics.drawLine(n + 1, n5, n3 - 1, n5);
            graphics.setColor(color);
            int n6 = 1;
            while (n6 < this.m_size) {
                graphics.drawLine(n + 1, n5 + n6, n3 - 1, n5 + n6);
                ++n6;
            }
            graphics.setColor(new Color(Math.min(color.getRed() + 32, 255), Math.min(color.getGreen() + 32, 255), Math.min(color.getBlue() + 32, 255)));
            graphics.drawLine(n + 1, n5 + this.m_size, n3 - 1, n5 + this.m_size);
            graphics.setColor(color2);
        }

        public Dimension getPreferredSize() {
            return this.m_dim;
        }

        public Dimension getMinimumSize() {
            return this.m_dim;
        }
    }
}

