/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import jv.number.PuString;

public class PsMultiLineLabel
extends Component {
    private static final int INSETS = 1;
    protected String m_label;
    protected int m_align;
    private String[] m_lines;
    private int m_previousWidth = -1;
    private boolean m_bRevalidate = false;
    private Color m_color = null;

    public PsMultiLineLabel() {
        this("");
    }

    public PsMultiLineLabel(String string) {
        this(string, 0);
    }

    public PsMultiLineLabel(String string, int n) {
        this.setText(string);
        this.setAlignment(n);
    }

    public void paint(Graphics graphics) {
        this.splitIfNecessary();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getAscent() + 1;
        int n2 = 0;
        while (n2 < this.m_lines.length) {
            int n3;
            switch (this.m_align) {
                case 1: {
                    n3 = (this.m_previousWidth - fontMetrics.stringWidth(this.m_lines[n2])) / 2;
                    break;
                }
                case 2: {
                    n3 = this.m_previousWidth - 1 - fontMetrics.stringWidth(this.m_lines[n2]);
                    break;
                }
                default: {
                    n3 = 1;
                }
            }
            if (this.m_color != null) {
                graphics.setColor(this.m_color);
            }
            graphics.setFont(this.getFont());
            graphics.drawString(this.m_lines[n2], n3, n);
            n += fontMetrics.getHeight();
            ++n2;
        }
        super.paint(graphics);
    }

    public void validate() {
        super.validate();
        this.repaint();
    }

    public Color getTextColor() {
        return this.m_color;
    }

    public void setTextColor(Color color) {
        this.m_color = color;
    }

    private boolean splitIfNecessary() {
        int n = this.getSize().width;
        if (n - 2 <= 0) {
            return false;
        }
        if (n == this.m_previousWidth && this.m_lines != null && !this.m_bRevalidate) {
            return false;
        }
        this.m_bRevalidate = false;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.m_lines = PuString.splitString(this.m_label, n - 2, fontMetrics);
        this.m_previousWidth = n;
        Component component = this;
        while (!(component.getParent() == null || component instanceof Dialog || component instanceof Frame || component instanceof Applet)) {
            component.invalidate();
            component = component.getParent();
        }
        ((Component)component).validate();
        return true;
    }

    public Dimension getPreferredSize() {
        this.splitIfNecessary();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.m_lines != null) {
            return new Dimension(0, fontMetrics.getHeight() * this.m_lines.length + fontMetrics.getDescent());
        }
        return new Dimension(0, fontMetrics.getHeight() + fontMetrics.getDescent());
    }

    public int getAlignment() {
        return this.m_align;
    }

    public void setAlignment(int n) {
        this.m_bRevalidate = true;
        this.m_align = n;
    }

    public String getText() {
        return this.m_label;
    }

    public void setText(String string) {
        this.m_bRevalidate = true;
        if (string == null) {
            this.m_label = "";
            return;
        }
        this.m_label = string;
    }
}

