/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometryIf;
import jv.project.PgGeometry_Menu;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public abstract class PgGeometry
extends PsObject
implements PgGeometryIf,
Cloneable {
    protected String m_version = "0.10";
    protected String m_versionType = "dump";
    protected String m_title;
    protected PsAuthorInfo m_authorInfo;
    protected PsGeometryInfo m_geometryInfo;
    protected int m_geomType = -1;
    protected BitSet m_state;
    protected int m_dim;
    protected int m_dimOfSimplex;
    protected boolean m_bShowing = true;
    protected boolean m_bShowTitle;
    protected boolean m_bShowName;
    protected boolean m_bShowBndBox;
    protected boolean m_bShowCenter;
    protected PdVector m_center = null;
    protected int m_ambientSpace = 3;
    protected int m_ambientProj = 0;
    protected PdMatrix m_modelMatrix = null;
    protected PdMatrix m_ambientMatrix;
    protected PdMatrix m_ambientInvMatrix;
    protected transient Hashtable m_filledMenus = null;
    protected transient Vector m_displayList = null;
    protected PiVector[] m_labelAttribute = PiVector.realloc(null, 7, 5);
    protected Color[] m_labelColor = new Color[7];
    protected PdVector m_labelSize = new PdVector(7);
    protected PiVector m_labelStyle = new PiVector(7);
    protected String[] m_labelFont = new String[7];
    protected boolean m_bInstanceSharing = false;

    public int addPolygon(PiVector piVector) {
        return -1;
    }

    public boolean hasTagPolygon(int n, int n2) {
        return false;
    }

    public Image getTextureImage() {
        return null;
    }

    public void setTextureImage(Image image) {
        PsDebug.warning("missing implementation of method in subclass.");
    }

    public void setState(int n, boolean bl) {
        if (this.m_state == null) {
            this.m_state = new BitSet(32);
        }
        if (bl) {
            this.m_state.set(n);
            return;
        }
        this.m_state.clear(n);
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        return null;
    }

    public boolean getState(int n) {
        if (this.m_state == null) {
            return false;
        }
        return this.m_state.get(n);
    }

    public PsPanel getMaterialPanel() {
        return this.assureInspector("Material", "_MP");
    }

    public boolean isShowingBndBox() {
        return this.m_bShowBndBox;
    }

    public void showBndBox(boolean bl) {
        this.m_bShowBndBox = bl;
    }

    public String getLabelFont(int n) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return null;
        }
        return this.m_labelFont[n];
    }

    public void setLabelFont(int n, String string) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return;
        }
        this.m_labelFont[n] = string;
    }

    public int getAmbientProjection() {
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        this.m_ambientProj = n;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public Vector getDisplayList() {
        return this.m_displayList;
    }

    public int addElement(PiVector piVector) {
        return -1;
    }

    public boolean hasTagElement(int n, int n2) {
        return false;
    }

    public Color getLabelColor(int n) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return null;
        }
        return this.m_labelColor[n];
    }

    public void setLabelColor(int n, Color color) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return;
        }
        this.m_labelColor[n] = color;
    }

    public boolean isVisible() {
        return this.m_bShowing;
    }

    public int addVertex(PdVector pdVector) {
        return -1;
    }

    public boolean hasTagVertex(int n, int n2) {
        return false;
    }

    public Object clone() {
        PgGeometry pgGeometry = (PgGeometry)super.clone();
        if (pgGeometry == null) {
            return null;
        }
        if (this.m_state != null) {
            pgGeometry.m_state = (BitSet)this.m_state.clone();
        }
        if (this.m_authorInfo != null) {
            pgGeometry.m_authorInfo = (PsAuthorInfo)this.m_authorInfo.clone();
        }
        if (this.m_geometryInfo != null) {
            pgGeometry.m_geometryInfo = (PsGeometryInfo)this.m_geometryInfo.clone();
        }
        if (this.m_center != null) {
            pgGeometry.m_center = (PdVector)this.m_center.clone();
        }
        if (this.m_modelMatrix != null) {
            pgGeometry.m_modelMatrix = (PdMatrix)this.m_modelMatrix.clone();
        }
        if (this.m_ambientMatrix != null) {
            pgGeometry.m_ambientMatrix = (PdMatrix)this.m_ambientMatrix.clone();
            pgGeometry.m_ambientInvMatrix = (PdMatrix)this.m_ambientInvMatrix.clone();
        }
        pgGeometry.m_filledMenus = null;
        pgGeometry.m_displayList = null;
        pgGeometry.m_labelAttribute = (PiVector[])P_Vector.clone(this.m_labelAttribute);
        pgGeometry.m_labelColor = (Color[])this.m_labelColor.clone();
        pgGeometry.m_labelSize = (PdVector)this.m_labelSize.clone();
        pgGeometry.m_labelStyle = (PiVector)this.m_labelStyle.clone();
        pgGeometry.m_labelFont = (String[])this.m_labelFont.clone();
        return pgGeometry;
    }

    public void setEnabledInstanceSharing(boolean bl) {
        this.m_bInstanceSharing = bl;
    }

    public void removeMethodMenus() {
        this.m_filledMenus = null;
    }

    public int getAmbientSpace() {
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        this.m_ambientSpace = n;
    }

    private void setDefaultAmbientSpace() {
        switch (this.m_dim) {
            default: {
                this.setAmbientSpace(3);
                break;
            }
            case 5: {
                this.setAmbientSpace(9);
                break;
            }
            case 4: {
                this.setAmbientSpace(6);
                break;
            }
            case 2: {
                this.setAmbientSpace(1);
                break;
            }
            case 1: {
                this.setAmbientSpace(0);
            }
        }
        this.setAmbientProjection(0);
    }

    public Enumeration getDisplays() {
        if (this.m_displayList == null) {
            return null;
        }
        return this.m_displayList.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGeometry ***********\n");
        stringBuffer.append("\t " + PsConfig.getMessage(33036) + " = " + this.getTitle() + "\n");
        stringBuffer.append("\t " + PsConfig.getMessage(33037) + ":\n");
        if (this.m_displayList != null) {
            int n = this.m_displayList.size();
            int n2 = 0;
            while (n2 < n) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)this.m_displayList.elementAt(n2);
                stringBuffer.append("\t\t " + PsConfig.getMessage(33038) + "[" + String.valueOf(n2) + "] = " + pvDisplayIf.getName() + "\n");
                ++n2;
            }
        } else {
            stringBuffer.append("\t\t " + PsConfig.getMessage(33039) + "\n");
        }
        stringBuffer.append("\t " + PsConfig.getMessage(33040) + ": m_dim = " + this.m_dim + "\n");
        return stringBuffer.toString();
    }

    public boolean isEnabledInstanceSharing() {
        return this.m_bInstanceSharing;
    }

    public PdMatrix getAmbientInvMatrix() {
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientInvMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientMatrix.setIdentity();
            this.m_ambientInvMatrix.setIdentity();
        }
        return this.m_ambientInvMatrix;
    }

    public PdVector getCenter() {
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        return this.m_center;
    }

    public void setCenter(PdVector pdVector) {
        if (pdVector == null) {
            this.m_center = null;
            return;
        }
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        this.m_center.copy(pdVector);
    }

    public boolean isShowingCenter() {
        return this.m_bShowCenter;
    }

    public String getTextureImageName() {
        return null;
    }

    public void setTextureImageName(String string) {
        PsDebug.warning("missing implementation of method in subclass.");
    }

    public void showCenter(boolean bl) {
        this.m_bShowCenter = bl;
    }

    public PdVector[] getAmbientBounds() {
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(this.m_dim), new PdVector(this.m_dim)};
        return pdVectorArray;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgGeometry)) {
            return;
        }
        PgGeometry pgGeometry = (PgGeometry)psObject;
        if (pgGeometry.getTitle() != null) {
            this.setTitle(pgGeometry.getTitle());
        }
        this.m_state = pgGeometry.m_state != null ? (BitSet)pgGeometry.m_state.clone() : null;
        this.setDimOfVertices(pgGeometry.getDimOfVertices());
        this.setDimOfSimplex(pgGeometry.getDimOfSimplex());
        this.setCenter(pgGeometry.m_center);
        this.m_modelMatrix = pgGeometry.m_modelMatrix != null ? (PdMatrix)pgGeometry.m_modelMatrix.clone() : null;
        if (pgGeometry.m_ambientMatrix != null) {
            this.m_ambientMatrix = (PdMatrix)pgGeometry.m_ambientMatrix.clone();
            this.m_ambientInvMatrix = (PdMatrix)pgGeometry.m_ambientInvMatrix.clone();
        } else {
            this.m_ambientMatrix = null;
            this.m_ambientInvMatrix = null;
        }
        this.m_authorInfo = pgGeometry.getAuthorInfo() != null ? (PsAuthorInfo)pgGeometry.getAuthorInfo().clone() : null;
        this.m_geometryInfo = pgGeometry.getGeometryInfo() != null ? (PsGeometryInfo)pgGeometry.getGeometryInfo().clone() : null;
        PiVector.copy(this.m_labelAttribute, 0, pgGeometry.m_labelAttribute, 0, pgGeometry.m_labelAttribute.length);
        PdColor.copy(this.m_labelColor, 0, pgGeometry.m_labelColor, 0, pgGeometry.m_labelColor.length);
        this.m_labelSize.copy(pgGeometry.m_labelSize);
        this.m_labelStyle.copy(this.m_labelStyle);
        int n = 0;
        do {
            this.m_labelFont[n] = pgGeometry.m_labelFont[n];
        } while (++n < 7);
    }

    public double getDiameter() {
        PdVector[] pdVectorArray = this.getBounds();
        if (pdVectorArray == null) {
            return 0.0;
        }
        return PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        PgGeometry pgGeometry = (PgGeometry)this.clone();
        String string = this.getName();
        if (string == null || !string.startsWith(PsConfig.getMessage(13001))) {
            string = PsConfig.getMessage(13001) + "(0) " + PsConfig.getMessage(13000) + " " + string;
        } else {
            String string2;
            int n;
            int n2 = string.indexOf("(");
            if (n2 != -1) {
                n = string.indexOf(")");
                string2 = string.substring(n2 + 1, n);
                n2 = Integer.parseInt(string2) + 1;
            }
            n = string.indexOf(" " + PsConfig.getMessage(13000) + " ");
            string2 = string.substring(n + 4, string.length());
            string = PsConfig.getMessage(13001) + "(" + n2 + ") " + PsConfig.getMessage(13000) + " " + string2;
        }
        pgGeometry.setName(string);
        return pgGeometry;
    }

    public void init() {
        super.init();
        this.m_bShowing = true;
        this.m_bShowBndBox = false;
        this.m_bShowCenter = false;
        this.m_bShowTitle = false;
    }

    public Menu fillMethodMenu(Menu menu) {
        return this.fillMethodMenu(menu, null);
    }

    public Menu fillMethodMenu(Menu menu, PvViewerIf pvViewerIf) {
        Class clazz;
        if (!this.hasTag(20)) {
            return null;
        }
        if (this.m_filledMenus == null) {
            this.m_filledMenus = new Hashtable();
        }
        PsMethodMenu psMethodMenu = null;
        if (this.m_filledMenus.containsKey(menu)) {
            psMethodMenu = (PsMethodMenu)this.m_filledMenus.get(menu);
        }
        if (psMethodMenu == null || !psMethodMenu.getLanguage().equals(PsConfig.getLanguage())) {
            String string;
            String string2;
            psMethodMenu = (PsMethodMenu)PsUtil.newInstance(this.getClass(), "_Menu");
            if (psMethodMenu == null) {
                PsDebug.warning("could not create menu");
                return null;
            }
            this.m_filledMenus.put(menu, psMethodMenu);
            if (pvViewerIf != null && psMethodMenu instanceof PgGeometry_Menu) {
                ((PgGeometry_Menu)psMethodMenu).setViewer(pvViewerIf);
            }
            psMethodMenu.init(this);
            psMethodMenu.update(this);
            clazz = this.getClass();
            PsMethodMenu psMethodMenu2 = null;
            if (PsConfig.hasArchive(1)) {
                do {
                    string2 = clazz.getName();
                    string = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                    try {
                        psMethodMenu2 = (PsMethodMenu)PsUtil.newInstance("jvx.geom." + string + "_Menu");
                    }
                    catch (SecurityException securityException) {
                        PsDebug.warning("failed with security exception,\n\t SecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
                    }
                } while (!this.fillMenuDoIt(psMethodMenu2, psMethodMenu, pvViewerIf) && (clazz = clazz.getSuperclass()) != null);
            }
            if (PsConfig.hasArchive(3)) {
                do {
                    string2 = clazz.getName();
                    string = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                    try {
                        psMethodMenu2 = (PsMethodMenu)PsUtil.newInstance("dev.geom." + string + "_Menu");
                    }
                    catch (SecurityException securityException) {
                        PsDebug.warning("failed with security exception,\n\t SecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
                    }
                } while (!this.fillMenuDoIt(psMethodMenu2, psMethodMenu, pvViewerIf) && (clazz = clazz.getSuperclass()) != null);
            }
        }
        menu.removeAll();
        clazz = psMethodMenu.elements();
        while (clazz.hasMoreElements()) {
            menu.add((MenuItem)clazz.nextElement());
        }
        return menu;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        PdMatrix pdMatrix;
        PdMatrix pdMatrix2;
        PgGeometry pgGeometry = (PgGeometry)pgGeometryIf;
        if (pgGeometry == null) {
            PsDebug.warning("missing argument.", this);
            return false;
        }
        if (this.getDimOfVertices() != pgGeometry.getDimOfVertices()) {
            PsDebug.warning("different dimension of vertices.", this);
            return false;
        }
        if (pgGeometry.hasAmbientMatrix()) {
            if (this.hasAmbientMatrix()) {
                pdMatrix2 = pgGeometry.getAmbientMatrix();
                pdMatrix = this.getAmbientInvMatrix();
                pdMatrix2.leftMult(pdMatrix);
                pgGeometry.setAmbientMatrix(pdMatrix2, pdMatrix);
            }
            pgGeometry.applyAmbientMatrix();
        }
        if (pgGeometry.hasModelMatrix()) {
            if (this.hasModelMatrix()) {
                pdMatrix2 = pgGeometry.getModelMatrix();
                pdMatrix = new PdMatrix(4);
                pdMatrix.invert34(this.m_modelMatrix);
                pdMatrix2.leftMult(pdMatrix);
                pgGeometry.setModelMatrix(pdMatrix2);
            }
            pgGeometry.applyModelingMatrix();
        }
        return true;
    }

    public PiVector getElement(int n) {
        return null;
    }

    public boolean setElement(int n, PiVector piVector) {
        return false;
    }

    public void clearTagElement(int n, int n2) {
    }

    public static PdVector getCenterOfElement(PdVector pdVector, PdVector[] pdVectorArray, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            PsDebug.warning("missing index array");
            return pdVector;
        }
        pdVector.copyArray(pdVectorArray[nArray[0]]);
        int n = 1;
        while (n < nArray.length) {
            pdVector.add(pdVectorArray[nArray[n]]);
            ++n;
        }
        pdVector.multScalar(1.0 / (double)nArray.length);
        return pdVector;
    }

    public int getDimOfVertices() {
        return this.m_dim;
    }

    protected void setDimOfVertices(int n) {
        if (this.m_dim == n) {
            return;
        }
        if (this.m_center != null) {
            this.m_center.setSize(n);
        }
        if (this.m_ambientMatrix != null) {
            this.m_ambientMatrix.setSize(n + 1, n + 1);
            this.m_ambientInvMatrix.setSize(n + 1, n + 1);
            int n2 = this.m_dim + 1;
            while (n2 < n + 1) {
                this.m_ambientMatrix.setEntry(n2, n2, 1.0);
                this.m_ambientInvMatrix.setEntry(n2, n2, 1.0);
                ++n2;
            }
        }
        this.m_dim = n;
        this.setDefaultAmbientSpace();
    }

    public boolean hasDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.contains(pvDisplayIf);
    }

    public boolean removeDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.removeElement(pvDisplayIf);
    }

    public boolean update(Object object) {
        EventListener eventListener;
        Object object2;
        if (!super.update(object)) {
            object2 = "super has returned 'false'\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = ";
            object2 = object == null ? (String)object2 + "null" : (object instanceof PsObject ? (String)object2 + object.getClass().getName() + ", name=" + ((PsObject)object).getName() : (object instanceof PsPanel ? (String)object2 + object.getClass().getName() + ", name=" + ((PsPanel)object).getName() : (String)object2 + object.getClass().getName()));
            PsDebug.warning((String)object2);
        }
        if (this.m_displayList != null) {
            object2 = this.m_displayList.elements();
            while (object2.hasMoreElements()) {
                eventListener = (PvDisplayIf)object2.nextElement();
                eventListener.update(this);
            }
        }
        if (object != null && this.m_filledMenus != null) {
            object2 = this.m_filledMenus.elements();
            while (object2.hasMoreElements()) {
                eventListener = (PsMethodMenu)object2.nextElement();
                ((PsMethodMenu)eventListener).update(this);
            }
        }
        return true;
    }

    public PiVector getLabelAttribute(int n) {
        if (n < 0 || this.m_labelAttribute.length <= n) {
            PsDebug.warning("type out of bounds, type = " + n);
            return null;
        }
        return this.m_labelAttribute[n];
    }

    public boolean setLabelAttribute(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0 || this.m_labelAttribute.length <= n) {
            PsDebug.warning("type=" + n + " out of bounds.");
            return false;
        }
        this.m_labelAttribute[n].setEntry(0, n2);
        this.m_labelAttribute[n].setEntry(1, n3);
        this.m_labelAttribute[n].setEntry(2, n4);
        this.m_labelAttribute[n].setEntry(3, n5);
        this.m_labelAttribute[n].setEntry(4, n6);
        return true;
    }

    public boolean setLabelAttribute(int n, PiVector piVector) {
        if (piVector == null || piVector.getSize() < 5) {
            PsDebug.warning("missing attribute parameter.");
            return false;
        }
        int[] nArray = piVector.getEntries();
        this.setLabelAttribute(n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
        return true;
    }

    public boolean applyAmbientMatrix() {
        return this.hasAmbientMatrix();
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public int getDimOfSimplex() {
        return this.m_dimOfSimplex;
    }

    public void setDimOfSimplex(int n) {
        this.m_dimOfSimplex = n;
    }

    public boolean isShowingTitle() {
        return this.m_bShowTitle;
    }

    public int getType() {
        return this.m_geomType;
    }

    public PiVector getPolygon(int n) {
        return null;
    }

    public boolean setPolygon(int n, PiVector piVector) {
        return false;
    }

    public void clearTagPolygon(int n, int n2) {
    }

    public void setType(int n) {
        this.m_geomType = n;
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String string) {
        this.m_versionType = string;
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(3), new PdVector(3)};
        return pdVectorArray;
    }

    public void showTitle(boolean bl) {
        this.m_bShowTitle = bl;
    }

    public boolean isShowingName() {
        return this.m_bShowName;
    }

    public PsAuthorInfo getAuthors() {
        return this.m_authorInfo;
    }

    public void setAuthors(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    public void showName(boolean bl) {
        this.m_bShowName = bl;
    }

    public PsPanel getControlPanel() {
        return this.assureInspector("Config", "_CP");
    }

    public int getLabelStyle(int n) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return 10;
        }
        return this.m_labelStyle.getEntry(n);
    }

    public boolean isConfigurable(int n) {
        return this.hasTag(n);
    }

    public int[] removePolygon(int n) {
        return null;
    }

    public void setTagPolygon(int n, int n2) {
    }

    public void setLabelStyle(int n, int n2) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return;
        }
        this.m_labelStyle.setEntry(n, n2);
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        pvGeometryIf.setDimOfVertices(this.m_dim);
        pvGeometryIf.setVisible(this.isVisible());
        pvGeometryIf.setState(69, this.m_bShowBndBox);
        pvGeometryIf.setState(70, this.m_bShowCenter);
        pvGeometryIf.setCenter(this.m_center);
        pvGeometryIf.setState(150, this.getState(150));
        pvGeometryIf.setState(151, this.getState(151));
        pvGeometryIf.setState(86, this.m_bShowName);
        pvGeometryIf.setState(87, this.m_bShowTitle);
        pvGeometryIf.setLabelAttributes(this.m_labelAttribute);
        pvGeometryIf.setLabelColors(this.m_labelColor);
        pvGeometryIf.setLabelSizes(this.m_labelSize);
        pvGeometryIf.setLabelStyles(this.m_labelStyle);
        pvGeometryIf.setLabelFonts(this.m_labelFont);
        pvGeometryIf.setAmbientSpace(this.getAmbientSpace());
        pvGeometryIf.setAmbientProjection(this.getAmbientProjection());
        pvGeometryIf.setModelMatrix(this.m_modelMatrix);
        pvGeometryIf.setAmbientMatrix(this.m_ambientMatrix, this.m_ambientInvMatrix);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        PgGeometry pgGeometry3;
        if (pgGeometry == null || pgGeometry2 == null) {
            if (pgGeometry != null) {
                this.copy(pgGeometry);
            } else if (pgGeometry2 != null) {
                this.copy(pgGeometry2);
            } else {
                PsDebug.warning("missing arguments");
            }
            return false;
        }
        PgGeometry pgGeometry4 = pgGeometry3 = d > 0.5 ? pgGeometry : pgGeometry2;
        if (pgGeometry3.m_state != null) {
            this.m_state = (BitSet)pgGeometry3.m_state.clone();
        }
        this.m_dim = pgGeometry3.m_dim;
        return true;
    }

    public int[] removeElement(int n) {
        return null;
    }

    public PdVector getVertex(int n) {
        return null;
    }

    public PsGeometryInfo getGeometryInfo() {
        return this.m_geometryInfo;
    }

    public void setGeometryInfo(PsGeometryInfo psGeometryInfo) {
        if (psGeometryInfo == null) {
            this.m_geometryInfo = null;
            return;
        }
        if (this.m_geometryInfo != null) {
            this.m_geometryInfo.copy(psGeometryInfo);
            return;
        }
        this.m_geometryInfo = (PsGeometryInfo)psGeometryInfo.clone();
    }

    public void setVisible(boolean bl) {
        this.m_bShowing = bl;
    }

    public boolean setVertex(int n, PdVector pdVector) {
        return false;
    }

    public void clearTagVertex(int n, int n2) {
    }

    public void setTagElement(int n, int n2) {
    }

    public PgGeometry() {
        Font font = PsConfig.getFont(1);
        Font font2 = PsConfig.getFont(3);
        this.setLabelAttribute(0, 0, 0, 0, 0, 1);
        this.setLabelColor(0, Color.black);
        this.setLabelSize(0, font.getSize());
        this.setLabelStyle(0, font.getStyle());
        this.setLabelAttribute(1, 4, 4, 0, 0, 1);
        this.setLabelColor(1, Color.black);
        this.setLabelSize(1, font.getSize());
        this.setLabelStyle(1, font.getStyle());
        this.setLabelAttribute(2, 4, 4, 0, 0, 1);
        this.setLabelColor(2, Color.black);
        this.setLabelSize(2, font.getSize());
        this.setLabelStyle(2, font.getStyle());
        this.setLabelAttribute(3, 0, 0, 1, 1, 1);
        this.setLabelColor(3, Color.orange);
        this.setLabelSize(3, font.getSize());
        this.setLabelStyle(3, font.getStyle());
        this.setLabelAttribute(4, 0, 0, 0, 0, 1);
        this.setLabelColor(4, Color.orange);
        this.setLabelSize(4, font.getSize());
        this.setLabelStyle(4, font.getStyle());
        this.setLabelAttribute(5, 4, 4, 0, 0, 3);
        this.setLabelColor(5, Color.black);
        this.setLabelSize(5, font2.getSize());
        this.setLabelStyle(5, font2.getStyle());
        this.setLabelAttribute(6, 4, 4, 0, 0, 3);
        this.setLabelColor(6, Color.black);
        this.setLabelSize(6, font2.getSize());
        this.setLabelStyle(6, font2.getStyle());
    }

    public PgGeometry(int n) {
        this();
        this.setDimOfVertices(n);
    }

    public double getLabelSize(int n) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return 10.0;
        }
        return this.m_labelSize.getEntry(n);
    }

    public void setLabelSize(int n, double d) {
        if (n < 0 || n >= 7) {
            PsDebug.warning("label type out of range, type = " + String.valueOf(n));
            return;
        }
        this.m_labelSize.setEntry(n, d);
    }

    public int[] removeVertex(int n) {
        return null;
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        if (psAuthorInfo == null) {
            if (this.m_authorInfo != null) {
                this.m_authorInfo.init();
            }
            return;
        }
        if (this.m_authorInfo == null) {
            this.m_authorInfo = new PsAuthorInfo();
        }
        this.m_authorInfo.copy(psAuthorInfo);
    }

    public void setTagVertex(int n, int n2) {
    }

    private boolean fillMenuDoIt(PsMethodMenu psMethodMenu, PsMethodMenu psMethodMenu2, PvViewerIf pvViewerIf) {
        if (psMethodMenu == null) {
            return false;
        }
        Enumeration enumeration = psMethodMenu2.elements();
        while (enumeration.hasMoreElements()) {
            psMethodMenu.addElement(enumeration.nextElement());
        }
        if (pvViewerIf != null && psMethodMenu instanceof PgGeometry_Menu) {
            ((PgGeometry_Menu)psMethodMenu).setViewer(pvViewerIf);
        }
        psMethodMenu.init(this);
        psMethodMenu.update(this);
        psMethodMenu2.removeAllElements();
        enumeration = psMethodMenu.elements();
        while (enumeration.hasMoreElements()) {
            psMethodMenu2.addElement(enumeration.nextElement());
        }
        return true;
    }

    public PdMatrix getModelMatrix() {
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
            this.m_modelMatrix.setIdentity();
        }
        return this.m_modelMatrix;
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            this.m_modelMatrix = null;
            return;
        }
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
        }
        this.m_modelMatrix.copy(pdMatrix);
    }

    public PdMatrix getAmbientMatrix() {
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientInvMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientMatrix.setIdentity();
            this.m_ambientInvMatrix.setIdentity();
        }
        return this.m_ambientMatrix;
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (pdMatrix == null || pdMatrix2 == null) {
            this.m_ambientMatrix = null;
            this.m_ambientInvMatrix = null;
            return;
        }
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = (PdMatrix)pdMatrix.clone();
            this.m_ambientInvMatrix = (PdMatrix)pdMatrix2.clone();
        }
        this.m_ambientMatrix.copy(pdMatrix);
        this.m_ambientInvMatrix.copy(pdMatrix2);
    }

    public boolean addDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            this.m_displayList = new Vector();
        } else if (this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display = " + pvDisplayIf.getName() + " already used.");
            return false;
        }
        this.m_displayList.addElement(pvDisplayIf);
        return true;
    }

    public boolean applyModelingMatrix() {
        return this.hasModelMatrix();
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setName(this.getName());
        pgJvxSrc.setVersion(this.getVersion());
        pgJvxSrc.setVersionType(this.getVersionType());
        pgJvxSrc.setTitle(this.getTitle());
        pgJvxSrc.setAuthorInfo(this.getAuthorInfo());
        pgJvxSrc.setGeometryInfo(this.getGeometryInfo());
        pgJvxSrc.setDimOfVertices(this.getDimOfVertices());
        pgJvxSrc.setDimOfSimplex(this.getDimOfSimplex());
        pgJvxSrc.setVisible(this.isVisible());
        pgJvxSrc.showBndBox(this.isShowingBndBox());
        pgJvxSrc.showCenter(this.isShowingCenter());
        pgJvxSrc.setCenter(this.m_center);
        pgJvxSrc.showName(this.isShowingName());
        pgJvxSrc.showTitle(this.isShowingTitle());
        PiVector.copy(pgJvxSrc.m_labelAttribute, 0, this.m_labelAttribute, 0, this.m_labelAttribute.length);
        PdColor.copy(pgJvxSrc.m_labelColor, 0, this.m_labelColor, 0, this.m_labelColor.length);
        pgJvxSrc.m_labelSize.copy(this.m_labelSize);
        pgJvxSrc.m_labelStyle.copy(this.m_labelStyle);
        int n = 0;
        do {
            pgJvxSrc.m_labelFont[n] = this.m_labelFont[n];
        } while (++n < 7);
        if (this.hasAmbientMatrix()) {
            pgJvxSrc.setAmbientMatrix(this.getAmbientMatrix(), this.getAmbientInvMatrix());
            pgJvxSrc.setAmbientProjection(this.getAmbientProjection());
            pgJvxSrc.setAmbientSpace(this.getAmbientSpace());
        } else {
            pgJvxSrc.setAmbientMatrix(null, null);
        }
        if (this.hasModelMatrix()) {
            pgJvxSrc.setModelMatrix(this.getModelMatrix());
        } else {
            pgJvxSrc.setModelMatrix(null);
        }
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        this.init();
        this.setName(pgJvxSrc.getName());
        this.setVersion(pgJvxSrc.getVersion());
        this.setVersionType(pgJvxSrc.getVersionType());
        this.setTitle(pgJvxSrc.getTitle());
        this.setAuthorInfo(pgJvxSrc.getAuthorInfo());
        this.setGeometryInfo(pgJvxSrc.getGeometryInfo());
        this.setDimOfSimplex(pgJvxSrc.getDimOfSimplex());
        this.setDimOfVertices(pgJvxSrc.getDimOfVertices());
        this.setVisible(pgJvxSrc.isVisible());
        this.showBndBox(pgJvxSrc.isShowingBndBox());
        this.showCenter(pgJvxSrc.isShowingCenter());
        this.setCenter(pgJvxSrc.m_center);
        this.showName(pgJvxSrc.isShowingName());
        this.showTitle(pgJvxSrc.isShowingTitle());
        PiVector.copy(this.m_labelAttribute, 0, pgJvxSrc.m_labelAttribute, 0, pgJvxSrc.m_labelAttribute.length);
        PdColor.copy(this.m_labelColor, 0, pgJvxSrc.m_labelColor, 0, pgJvxSrc.m_labelColor.length);
        this.m_labelSize.copy(pgJvxSrc.m_labelSize);
        this.m_labelStyle.copy(pgJvxSrc.m_labelStyle);
        int n = 0;
        do {
            this.m_labelFont[n] = pgJvxSrc.m_labelFont[n];
        } while (++n < 7);
        if (pgJvxSrc.hasAmbientMatrix()) {
            this.setAmbientMatrix(pgJvxSrc.getAmbientMatrix(), pgJvxSrc.getAmbientInvMatrix());
            this.setAmbientProjection(pgJvxSrc.getAmbientProjection());
            this.setAmbientSpace(pgJvxSrc.getAmbientSpace());
        } else {
            this.setAmbientMatrix(null, null);
        }
        if (pgJvxSrc.hasModelMatrix()) {
            this.setModelMatrix(pgJvxSrc.getModelMatrix());
            return;
        }
        this.setModelMatrix(null);
    }

    public boolean hasModelMatrix() {
        return this.m_modelMatrix != null;
    }

    public boolean hasAmbientMatrix() {
        return this.m_ambientMatrix != null;
    }

    public boolean projectFromAmbientSpace() {
        if (!this.applyAmbientMatrix()) {
            return true;
        }
        this.setAmbientMatrix(null, null);
        return true;
    }
}

