/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;

public class PjProject
extends PsObject
implements PsTimeListenerIf,
PvPickListenerIf,
PsUpdateIf {
    protected PvDisplayIf m_display;
    protected Vector m_displayList;
    protected Vector m_rootGeometry;
    protected PgGeometryIf m_geometry;
    protected PsAnimation m_anim;
    protected String[][] m_parm;
    private PvViewerIf m_viewer;
    protected boolean m_bAutoFit;
    protected boolean m_bUpdateSender;
    protected Color m_backCol = null;
    protected int m_borderType = 1;
    private static /* synthetic */ Class class$jv$project$PjProject;

    public void stop() {
        if (this.m_anim != null) {
            this.m_anim.stop();
            if (this.m_anim.hasAnimationPanel()) {
                this.m_anim.getAnimationPanel().hide();
            }
        }
        if (this.m_displayList != null) {
            Enumeration enumeration = this.getDisplays();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                if (pvDisplayIf.hasPickListener(this)) {
                    pvDisplayIf.removePickListener(this);
                }
                pvDisplayIf.stop();
            }
        }
    }

    public int getNumGeometries() {
        return this.m_rootGeometry.size();
    }

    public void setEnabledAutoFit(boolean bl) {
        this.m_bAutoFit = bl;
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        PsDebug.warning("method must be overwritten");
        return false;
    }

    public PvViewerIf getViewer() {
        return this.m_viewer;
    }

    public void setViewer(PvViewerIf pvViewerIf) {
        this.m_viewer = pvViewerIf;
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    public boolean hasDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            return false;
        }
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.contains(pvDisplayIf);
    }

    public boolean removeDisplay(PvDisplayIf pvDisplayIf) {
        if (!this.hasDisplay(pvDisplayIf)) {
            return false;
        }
        if (pvDisplayIf.hasPickListener(this)) {
            pvDisplayIf.removePickListener(this);
        }
        this.m_displayList.removeElement(pvDisplayIf);
        if (this.m_display == pvDisplayIf) {
            this.m_display = this.m_displayList.size() > 0 ? (PvDisplayIf)this.m_displayList.firstElement() : null;
        }
        return true;
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void setBackColor(Color color) {
        this.m_backCol = color;
    }

    public void start() {
        if (this.m_anim != null && this.m_anim.hasAnimationPanel()) {
            this.m_anim.getAnimationPanel().show();
        }
        if (this.isEnabledAutoFit()) {
            this.fitDisplays();
        }
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
        this.pickVertex(pgGeometryIf, n, pdVector);
    }

    public String getParameter(String string) {
        if (this.m_parm != null) {
            int n = 0;
            while (n < this.m_parm.length) {
                if (this.m_parm[n][0].equals(string.toLowerCase())) {
                    return this.m_parm[n][2].trim();
                }
                ++n;
            }
        }
        PsDebug.warning("label = " + string + " not found.");
        return null;
    }

    public void setParameter(String[][] stringArray) {
        this.m_parm = stringArray;
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
        PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
        if (pgGeometryIf != null) {
            pgGeometryIf.update(null);
        }
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
    }

    public boolean addGeometry(PgGeometryIf pgGeometryIf) {
        return this.addGeometry(pgGeometryIf, true);
    }

    public boolean addGeometry(PgGeometryIf pgGeometryIf, boolean bl) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_rootGeometry == null) {
            PsDebug.warning("missing root geometry, project was disposed.");
            return false;
        }
        if (!this.m_rootGeometry.contains(pgGeometryIf)) {
            this.m_rootGeometry.addElement(pgGeometryIf);
        }
        if (this.m_display != null && !this.m_display.containsGeometry(pgGeometryIf)) {
            this.m_display.addGeometry(pgGeometryIf);
            if (bl) {
                this.m_display.update(this.m_display);
            }
        }
        if (this.m_geometry == null) {
            this.m_geometry = pgGeometryIf;
        }
        return true;
    }

    protected boolean isUpdateSender() {
        return this.m_bUpdateSender;
    }

    public void markVertices(PvPickEvent pvPickEvent) {
        PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
        if (pgGeometryIf != null) {
            pgGeometryIf.update(null);
        }
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            PsDebug.warning("missing argument");
            return;
        }
        this.m_display = pvDisplayIf;
        if (!this.hasDisplay(pvDisplayIf)) {
            this.addDisplay(pvDisplayIf);
        }
        if (this.m_rootGeometry == null) {
            PsDebug.warning("missing root geometry, project was disposed.");
            return;
        }
        Enumeration enumeration = this.m_rootGeometry.elements();
        while (enumeration.hasMoreElements()) {
            PgGeometryIf pgGeometryIf = (PgGeometryIf)enumeration.nextElement();
            if (this.m_display.containsGeometry(pgGeometryIf)) continue;
            this.m_display.addGeometry(pgGeometryIf);
        }
        if (this.m_geometry != null) {
            this.m_display.selectGeometry(this.m_geometry);
        }
        this.m_display.addPickListener(this);
        this.m_display.update(this.m_display);
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public boolean selectDisplay(PvDisplayIf pvDisplayIf) {
        if (!this.hasDisplay(pvDisplayIf)) {
            return false;
        }
        this.m_display = pvDisplayIf;
        return true;
    }

    public void fitDisplays() {
        if (this.m_displayList == null) {
            return;
        }
        Enumeration enumeration = this.m_displayList.elements();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.fit();
            pvDisplayIf.update(null);
        }
    }

    public Enumeration getDisplays() {
        if (this.m_displayList == null) {
            return null;
        }
        return this.m_displayList.elements();
    }

    public PjProject(String string) {
        this.setTag(4);
        this.setName(string);
        this.m_rootGeometry = new Vector(1);
        this.m_bAutoFit = true;
        this.m_bUpdateSender = false;
        if (this.getClass() == (class$jv$project$PjProject != null ? class$jv$project$PjProject : (class$jv$project$PjProject = PjProject.class$("jv.project.PjProject")))) {
            this.init();
        }
    }

    public boolean isEnabledAutoFit() {
        return this.m_bAutoFit;
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_rootGeometry != null && !this.m_rootGeometry.contains(pgGeometryIf)) {
            return;
        }
        this.m_geometry = pgGeometryIf;
        if (this.m_display != null) {
            this.m_display.selectGeometry(this.m_geometry);
            this.m_display.update(this.m_display);
        }
    }

    public boolean setGeometry(PgGeometryIf pgGeometryIf) {
        return false;
    }

    public PgGeometryIf getGeometry(int n) {
        return (PgGeometryIf)this.m_rootGeometry.elementAt(n);
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeGeometries() {
        this.m_geometry = null;
        if (this.m_rootGeometry == null) {
            PsDebug.warning("missing root geometry");
            return;
        }
        if (this.m_displayList != null && this.m_displayList.size() != 0) {
            Enumeration enumeration = this.m_displayList.elements();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                Enumeration enumeration2 = this.m_rootGeometry.elements();
                while (enumeration2.hasMoreElements()) {
                    PgGeometryIf pgGeometryIf = (PgGeometryIf)enumeration2.nextElement();
                    if (!pvDisplayIf.containsGeometry(pgGeometryIf)) continue;
                    pvDisplayIf.removeGeometry(pgGeometryIf);
                }
                pvDisplayIf.update(pvDisplayIf);
            }
        }
        this.m_rootGeometry.removeAllElements();
    }

    public boolean hasAnimation() {
        return this.m_anim != null;
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
        this.pickDisplay(pvPickEvent);
    }

    public void dispose() {
        this.stop();
        if (this.m_anim != null && this.m_anim.hasAnimationPanel()) {
            this.m_anim.getAnimationPanel().dispose();
        }
        this.removeGeometries();
        this.m_display = null;
        this.m_displayList = null;
        this.m_anim = null;
    }

    protected void setUpdateSender(boolean bl) {
        this.m_bUpdateSender = bl;
    }

    public boolean addDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            this.m_displayList = new Vector();
        } else if (this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display = " + pvDisplayIf.getName() + " of display already registered.");
            return false;
        }
        this.m_displayList.addElement(pvDisplayIf);
        return true;
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void init() {
        super.init();
        if (this.m_anim != null) {
            this.m_anim.stop();
        }
    }

    public void removeGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_rootGeometry == null) {
            PsDebug.warning("missing root geometry, project was disposed.");
            return;
        }
        this.m_rootGeometry.removeElement(pgGeometryIf);
        if (this.m_display != null && this.m_display.containsGeometry(pgGeometryIf)) {
            this.m_display.removeGeometry(pgGeometryIf);
        }
        if (this.m_geometry == pgGeometryIf) {
            if (this.m_rootGeometry != null && this.m_rootGeometry.elements().hasMoreElements()) {
                this.m_geometry = (PgGeometryIf)this.m_rootGeometry.firstElement();
                this.selectGeometry(this.m_geometry);
            } else {
                this.m_geometry = null;
            }
        }
        if (this.m_display != null) {
            this.m_display.update(this.m_display);
        }
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void setBorderType(int n) {
        this.m_borderType = n;
    }
}

