/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PuData;

public final class PsAuthorInfo
extends PsObject {
    public static final int FIRST_NAME = 0;
    public static final int LAST_NAME = 1;
    public static final int ORGANIZATION = 2;
    public static final int ADDRESS = 3;
    public static final int EMAIL = 4;
    public static final int URL = 5;
    private static final int m_numCodes = 6;
    protected int m_maxNumAuthors;
    protected int m_numAuthors;
    protected int m_currAuthor;
    protected String m_profession = "Author";
    protected String[][] m_info = new String[6][];

    protected static int getNumCodes() {
        return 6;
    }

    public String toString() {
        String string = null;
        if (this.m_numAuthors == 0) {
            string = null;
        } else if (this.m_numAuthors == 1) {
            int n = 0;
            while (n < this.m_numAuthors) {
                String[] stringArray;
                string = this.m_info[0][n] + " " + this.m_info[1][n] + "\n";
                if (!PuString.isEmpty(this.m_info[2][n])) {
                    string = string + this.m_info[2][n] + "\n";
                }
                if (!PuString.isEmpty(this.m_info[3][n]) && (stringArray = PuString.splitString(this.m_info[3][n], '\n')) != null && stringArray.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        string = string + stringArray[n2] + "\n";
                        ++n2;
                    }
                }
                if (this.m_info[4][n] != null) {
                    string = string + this.m_info[4][n] + "\n";
                }
                if (this.m_info[5][n] != null) {
                    string = string + this.m_info[5][n] + "\n";
                }
                ++n;
            }
        } else if (this.m_numAuthors > 1) {
            string = "";
            int n = 0;
            while (n < this.m_numAuthors) {
                string = string + this.m_info[0][n] + " " + this.m_info[1][n] + "\n";
                ++n;
            }
        }
        if (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public PsAuthorInfo() {
        this.init();
    }

    public PsXmlNode getXmlNode() {
        PsXmlNode psXmlNode = new PsXmlNode("authors");
        int n = 0;
        while (n < this.m_numAuthors) {
            PsXmlNode psXmlNode2 = psXmlNode.addChild(this.m_profession.toLowerCase());
            psXmlNode2.addChild("firstname", this.m_info[0][n]);
            psXmlNode2.addChild("lastname", this.m_info[1][n]);
            PsXmlNode psXmlNode3 = psXmlNode2.addChild("affiliation");
            psXmlNode3.addChild("organization", this.m_info[2][n]);
            PsXmlNode psXmlNode4 = psXmlNode3.addChild("address");
            if (!PuString.isEmpty(this.m_info[3][n])) {
                String[] stringArray = PuString.splitString(this.m_info[3][n], '\n');
                if (stringArray != null && stringArray.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        psXmlNode4.addChild("line", stringArray[n2]);
                        ++n2;
                    }
                }
            } else {
                psXmlNode4.addChild("line", "");
            }
            psXmlNode2.addChild("email", this.m_info[4][n]);
            psXmlNode2.addChild("url", this.m_info[5][n]);
            ++n;
        }
        return psXmlNode;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PsAuthorInfo)) {
            return;
        }
        PsAuthorInfo psAuthorInfo = (PsAuthorInfo)psObject;
        this.m_maxNumAuthors = psAuthorInfo.m_maxNumAuthors;
        this.m_numAuthors = psAuthorInfo.m_numAuthors;
        this.m_currAuthor = psAuthorInfo.m_currAuthor;
        this.m_profession = psAuthorInfo.m_profession;
        this.m_info = PuString.clone(psAuthorInfo.m_info);
    }

    public int getSelectedAuthor() {
        return this.m_currAuthor;
    }

    public void setSelectedAuthor(int n) {
        this.m_currAuthor = n;
    }

    public String getInfo(int n, int n2) {
        if (n < 0 || this.m_numAuthors <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return null;
        }
        if (n2 < 0 || 6 <= n2) {
            PsDebug.warning("index out of range, code = " + n2);
            return null;
        }
        return this.m_info[n2][n];
    }

    public void setInfo(int n, int n2, String string) {
        if (n < 0 || this.m_numAuthors <= n) {
            PsDebug.warning("index out of range][ind = " + n);
            return;
        }
        this.m_info[n2][n] = string;
    }

    public void setXmlNode(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            PsDebug.warning("missing method argument.");
            return;
        }
        String string = psXmlNode.getType();
        if (string == null || !string.equals("authors")) {
            PsDebug.error("source node has wrong type = " + string);
            return;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, this.m_profession.toLowerCase());
        if (psXmlNodeArray != null) {
            this.setNumAuthors(psXmlNodeArray.length);
            int n = 0;
            while (n < this.m_numAuthors) {
                this.m_info[0][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "firstname");
                this.m_info[1][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "lastname");
                this.m_info[2][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "organization");
                PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "address");
                PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode2, "line");
                if (psXmlNodeArray2 == null) {
                    psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode2, "l");
                    if (psXmlNodeArray2 != null) {
                        PsDebug.warning("usage of deprecated address <l> element tag found.\n\tPlease, replace all occurrences of <l> with new tag <line>.");
                    } else {
                        PsDebug.warning("<address> element must contain at least one <line> element.");
                    }
                }
                this.m_info[3][n] = "";
                if (psXmlNodeArray2 != null && psXmlNodeArray2.length > 0) {
                    int n2 = 0;
                    while (n2 < psXmlNodeArray2.length) {
                        if (psXmlNodeArray2[n2].getContent() != null) {
                            if (!PuString.isEmpty(this.m_info[3][n])) {
                                String[] stringArray = this.m_info[3];
                                int n3 = n;
                                stringArray[n3] = stringArray[n3] + "\n";
                            }
                            String[] stringArray = this.m_info[3];
                            int n4 = n;
                            stringArray[n4] = stringArray[n4] + psXmlNodeArray2[n2].getContent();
                        }
                        ++n2;
                    }
                }
                this.m_info[4][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "email");
                this.m_info[5][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "url");
                ++n;
            }
            return;
        }
        this.setNumAuthors(0);
        PsDebug.warning("missing authors.");
    }

    public String getProfession() {
        return this.m_profession;
    }

    public void setProfession(String string) {
        this.m_profession = string;
    }

    public int getNumAuthors() {
        return this.m_numAuthors;
    }

    public void init() {
        super.init();
        this.m_maxNumAuthors = 0;
        this.m_numAuthors = 0;
        this.m_currAuthor = 0;
        int n = 0;
        do {
            this.m_info[n] = null;
        } while (++n < 6);
    }

    public Object clone() {
        PsAuthorInfo psAuthorInfo = (PsAuthorInfo)super.clone();
        if (psAuthorInfo == null) {
            return null;
        }
        if (this.m_info != null) {
            psAuthorInfo.m_info = PuString.clone(this.m_info);
        }
        return psAuthorInfo;
    }

    public void setNumAuthors(int n) {
        if (this.m_maxNumAuthors > 0 && n > this.m_maxNumAuthors) {
            n = this.m_maxNumAuthors;
        }
        if (this.m_numAuthors == n) {
            return;
        }
        this.m_numAuthors = n;
        int n2 = 0;
        do {
            this.m_info[n2] = PuData.realloc(this.m_info[n2], n);
        } while (++n2 < 6);
    }

    public int getMaxNumAuthors() {
        return this.m_maxNumAuthors;
    }

    public void setMaxNumAuthors(int n) {
        this.m_maxNumAuthors = n;
        if (this.m_maxNumAuthors > 0 && this.m_numAuthors > this.m_maxNumAuthors) {
            this.setNumAuthors(this.m_maxNumAuthors);
        }
    }
}

