/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.number.PuComplex;
import jv.number.PuString;
import jv.object.PsDebug;

public class PcMatrix
implements Serializable {
    protected int m_iSize = 0;
    protected int m_jSize = 0;
    public PuComplex[][] m_data;

    public PcMatrix leftMult(PcMatrix pcMatrix) {
        int n;
        if (pcMatrix == null || !pcMatrix.isSquare() || pcMatrix.m_iSize != this.m_iSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return null;
        }
        int n2 = pcMatrix.m_iSize;
        PuComplex[][] puComplexArray = new PuComplex[n2][this.m_jSize];
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < this.m_jSize) {
                puComplexArray[n3][n] = new PuComplex(0.0, 0.0);
                int n4 = 0;
                while (n4 < this.m_iSize) {
                    puComplexArray[n3][n].add(PuComplex.mult(pcMatrix.m_data[n3][n4], this.m_data[n4][n]));
                    ++n4;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < this.m_jSize) {
                this.m_data[n3][n] = puComplexArray[n3][n];
                ++n;
            }
            ++n3;
        }
        return this;
    }

    public PcMatrix inverse() {
        if (!this.isSquare()) {
            PsDebug.warning("Matrix must be square");
            return null;
        }
        PcMatrix pcMatrix = new PcMatrix(this.m_iSize);
        PuComplex puComplex = this.determinant();
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                double d = Math.pow(-1.0, n + n2);
                pcMatrix.m_data[n][n2] = this.minor(n2, n).mult(d).div(puComplex);
                ++n2;
            }
            ++n;
        }
        return pcMatrix;
    }

    public PcMatrix add(PcMatrix pcMatrix) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].add(pcMatrix.m_data[n][n2]);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public PcMatrix add(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].copy(pcMatrix.m_data[n][n2]);
                this.m_data[n][n2].add(pcMatrix2.m_data[n][n2]);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_data == null) {
            stringBuffer.append("\t m_data = null\n");
        } else {
            int n = 0;
            while (n < this.m_iSize) {
                stringBuffer.append("\t [" + PuString.intToString(n, 3) + "] = {");
                int n2 = 0;
                while (n2 < this.m_jSize) {
                    stringBuffer.append(" " + this.m_data[n][n2].toString());
                    ++n2;
                }
                stringBuffer.append("\n");
                ++n;
            }
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public PuComplex determinant() {
        if (!this.isSquare()) {
            PsDebug.warning("Matrix must be square");
            return null;
        }
        if (this.m_iSize == 1) {
            return new PuComplex(this.m_data[0][0]);
        }
        PuComplex puComplex = new PuComplex(0.0, 0.0);
        int n = 1;
        int n2 = 0;
        while (n2 < this.m_iSize) {
            puComplex.add(this.minor(0, n2).mult(n).mult(this.m_data[0][n2]));
            n *= -1;
            ++n2;
        }
        return puComplex;
    }

    public static PcMatrix copyNew(PcMatrix pcMatrix) {
        if (pcMatrix == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        if (pcMatrix.m_data == null) {
            PsDebug.warning("missing argument data mat.m_data", pcMatrix);
            return null;
        }
        PcMatrix pcMatrix2 = new PcMatrix(pcMatrix.m_iSize, pcMatrix.m_jSize);
        pcMatrix2.copy(pcMatrix);
        return pcMatrix2;
    }

    public static PcMatrix multNew(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        PcMatrix pcMatrix3 = new PcMatrix();
        return pcMatrix3.mult(pcMatrix, pcMatrix2);
    }

    public PcMatrix minorMatrix(int n, int n2) {
        if (n < 0 || n >= this.m_iSize || n2 < 0 || n2 >= this.m_jSize || this.m_iSize < 2 || this.m_jSize < 2) {
            PsDebug.warning("Illegal minor, row=" + n + ",col=" + n2);
            return null;
        }
        PcMatrix pcMatrix = new PcMatrix(this.m_iSize - 1, this.m_jSize - 1);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.m_iSize) {
            if (n4 != n) {
                int n5 = 0;
                int n6 = 0;
                while (n6 < this.m_jSize) {
                    if (n6 != n2) {
                        pcMatrix.m_data[n3][n5].copy(this.m_data[n4][n6]);
                        ++n5;
                    }
                    ++n6;
                }
                ++n3;
            }
            ++n4;
        }
        return pcMatrix;
    }

    public PuComplex minor(int n, int n2) {
        return this.minorMatrix(n, n2).determinant();
    }

    public PuComplex[] aEigenvector(PuComplex puComplex) {
        PuComplex[] puComplexArray = new PuComplex[2];
        PcMatrix pcMatrix = new PcMatrix(2);
        pcMatrix.m_data[0][0].copy(PuComplex.sub(this.m_data[0][0], puComplex));
        pcMatrix.m_data[0][1].copy(this.m_data[0][1]);
        pcMatrix.m_data[1][0].copy(this.m_data[1][0]);
        pcMatrix.m_data[1][1].copy(PuComplex.sub(this.m_data[1][1], puComplex));
        boolean[][] blArray = new boolean[2][2];
        boolean bl = true;
        int n = 0;
        do {
            int n2 = 0;
            do {
                if (pcMatrix.m_data[n][n2].abs() < 1.0E-10) {
                    blArray[n][n2] = true;
                    continue;
                }
                bl = false;
                blArray[n][n2] = false;
            } while (++n2 < 2);
        } while (++n < 2);
        if (bl) {
            PsDebug.warning("eigenspace=CxC, eigenvalue=" + puComplex.toString());
            puComplexArray[0] = new PuComplex(1.0, 0.0);
            puComplexArray[1] = new PuComplex(0.0, 0.0);
            return puComplexArray;
        }
        if (blArray[0][0] && blArray[1][0]) {
            PsDebug.warning("eigenspace=Cx{0}, eigenvalue=" + puComplex.toString());
            puComplexArray[0] = new PuComplex(1.0, 0.0);
            puComplexArray[1] = new PuComplex(0.0, 0.0);
            return puComplexArray;
        }
        if (blArray[0][0]) {
            pcMatrix.m_data[0][0].copy(pcMatrix.m_data[1][0]);
            pcMatrix.m_data[1][0].set(0.0, 0.0);
            PuComplex puComplex2 = new PuComplex(pcMatrix.m_data[0][1]);
            pcMatrix.m_data[0][1].copy(pcMatrix.m_data[1][1]);
            pcMatrix.m_data[1][1].copy(puComplex2);
        }
        PuComplex puComplex3 = new PuComplex();
        puComplex3.copy(pcMatrix.m_data[0][1]);
        puComplex3.mult(pcMatrix.m_data[1][0]);
        puComplex3.div(pcMatrix.m_data[0][0]);
        puComplex3.mult(-1.0);
        puComplex3.add(pcMatrix.m_data[1][1]);
        if (puComplex3.abs() > 0.001) {
            PsDebug.warning("eigenspace degenerated, eigenvalue=" + puComplex.toString() + "; botrig=" + puComplex3.toString() + "\n\t" + pcMatrix.toShortString());
            return null;
        }
        puComplexArray[0] = new PuComplex(1.0, 0.0);
        puComplexArray[1] = PuComplex.div(pcMatrix.m_data[0][0], pcMatrix.m_data[0][1]);
        puComplexArray[1].mult(-1.0);
        return puComplexArray;
    }

    public PcMatrix mult(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        if (this == pcMatrix || this == pcMatrix2) {
            PsDebug.warning("'this' must be different from argument");
            return null;
        }
        int n = pcMatrix.m_iSize;
        int n2 = pcMatrix2.m_jSize;
        int n3 = pcMatrix.m_jSize;
        if (this.m_iSize != n || this.m_jSize != n2) {
            this.setSize(n, n2);
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                this.m_data[n4][n5].set(0.0, 0.0);
                int n6 = 0;
                while (n6 < n3) {
                    this.m_data[n4][n5].add(PuComplex.mult(pcMatrix.m_data[n4][n6], pcMatrix2.m_data[n6][n5]));
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return this;
    }

    public int getJSize() {
        return this.m_jSize;
    }

    public int getSize() {
        if (this.isSquare()) {
            return this.m_iSize;
        }
        return -1;
    }

    public void setSize(int n) {
        this.setSize(n, n);
    }

    public void setSize(int n, int n2) {
        if (this.m_iSize == n && this.m_jSize == n2) {
            return;
        }
        this.m_iSize = n;
        this.m_jSize = n2;
        this.m_data = new PuComplex[this.m_iSize][this.m_jSize];
        int n3 = 0;
        while (n3 < this.m_iSize) {
            int n4 = 0;
            while (n4 < this.m_jSize) {
                this.m_data[n3][n4] = new PuComplex(0.0, 0.0);
                ++n4;
            }
            ++n3;
        }
    }

    public Object clone() {
        return PcMatrix.copyNew(this);
    }

    public PcMatrix setIdentity() {
        int n;
        int n2 = 0;
        while (n2 < this.m_iSize) {
            n = 0;
            while (n < this.m_jSize) {
                this.m_data[n2][n].set(0.0, 0.0);
                ++n;
            }
            ++n2;
        }
        n2 = Math.min(this.m_iSize, this.m_jSize);
        n = 0;
        while (n < n2) {
            this.m_data[n][n].set(1.0, 0.0);
            ++n;
        }
        return this;
    }

    public PcMatrix multScalar(PuComplex puComplex) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].mult(puComplex);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public PcMatrix multScalar(PcMatrix pcMatrix, PuComplex puComplex) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].copy(pcMatrix.m_data[n][n2]);
                this.m_data[n][n2].mult(puComplex);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public String toString() {
        int n = this.getISize();
        int n2 = this.getJSize();
        String string = "PcMatrix(" + n + "," + n2 + "){";
        int n3 = 0;
        while (n3 < n) {
            string = string + "\n";
            int n4 = 0;
            while (n4 < n2) {
                string = string + " " + this.m_data[n3][n4].toString();
                ++n4;
            }
            ++n3;
        }
        string = string + "\n}\n";
        return string;
    }

    public PcMatrix() {
        this(0);
    }

    public PcMatrix(int n) {
        this.setSize(n, n);
    }

    public PcMatrix(int n, int n2) {
        this.setSize(n, n2);
    }

    public PuComplex[] eigenvalues() {
        if (!this.isSquare() || this.m_iSize != 2) {
            PsDebug.warning("only implemented for 2x2");
            return null;
        }
        PuComplex[] puComplexArray = new PuComplex[2];
        PuComplex puComplex = new PuComplex(this.m_data[0][0]);
        puComplex.sqr();
        puComplex.add(PuComplex.sqr(this.m_data[1][1]));
        puComplex.sub(PuComplex.mult(PuComplex.mult(this.m_data[0][0], this.m_data[1][1]), 2.0));
        puComplex.div(4.0);
        puComplex.add(PuComplex.mult(this.m_data[1][0], this.m_data[0][1]));
        puComplex.sqrt();
        PuComplex puComplex2 = new PuComplex();
        puComplex2.copy(this.m_data[0][0]);
        puComplex2.add(this.m_data[1][1]);
        puComplex2.div(2.0);
        puComplexArray[0] = PuComplex.add(puComplex2, puComplex);
        puComplexArray[1] = PuComplex.sub(puComplex2, puComplex);
        return puComplexArray;
    }

    public PcMatrix transpose() {
        PuComplex puComplex = new PuComplex();
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = n + 1;
            while (n2 < this.m_jSize) {
                puComplex.copy(this.m_data[n][n2]);
                this.m_data[n][n2].copy(this.m_data[n2][n]);
                this.m_data[n2][n].copy(puComplex);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public PcMatrix sub(PcMatrix pcMatrix) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].sub(pcMatrix.m_data[n][n2]);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public PcMatrix sub(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].copy(pcMatrix.m_data[n][n2]);
                this.m_data[n][n2].sub(pcMatrix2.m_data[n][n2]);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public PcMatrix copy(PcMatrix pcMatrix) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].copy(pcMatrix.m_data[n][n2]);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public int getISize() {
        return this.m_iSize;
    }

    public PcMatrix setConstant(PuComplex puComplex) {
        int n = 0;
        while (n < this.m_iSize) {
            int n2 = 0;
            while (n2 < this.m_jSize) {
                this.m_data[n][n2].copy(puComplex);
                ++n2;
            }
            ++n;
        }
        return this;
    }

    public boolean isSquare() {
        return this.m_iSize == this.m_jSize;
    }

    public PcMatrix rightMult(PcMatrix pcMatrix) {
        int n;
        if (pcMatrix == null || !pcMatrix.isSquare() || pcMatrix.m_iSize != this.m_jSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return null;
        }
        int n2 = pcMatrix.m_jSize;
        PuComplex[][] puComplexArray = new PuComplex[this.m_iSize][n2];
        int n3 = 0;
        while (n3 < this.m_iSize) {
            n = 0;
            while (n < n2) {
                puComplexArray[n3][n] = new PuComplex(0.0, 0.0);
                int n4 = 0;
                while (n4 < this.m_jSize) {
                    puComplexArray[n3][n].add(PuComplex.mult(this.m_data[n3][n4], pcMatrix.m_data[n4][n]));
                    ++n4;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_iSize) {
            n = 0;
            while (n < n2) {
                this.m_data[n3][n] = puComplexArray[n3][n];
                ++n;
            }
            ++n3;
        }
        return this;
    }
}

